/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.sim;

import cmradar.manager.data.EnumRequirement;
import cmradar.manager.data.Meeting;
import cmradar.manager.data.NumericRequirement;
import cmradar.manager.data.Requirement;
import cmradar.manager.data.Room;
import cmradar.manager.data.RoomTemplate;
import cmradar.manager.data.SharedRoomCalendar;
import cmradar.manager.data.TimeSlot;
import cmradar.manager.sim.AgentInfo;
import cmradar.manager.sim.RequirementInfo;
import cmradar.manager.sim.SimParameters;
import cmradar.manager.sim.TestInfo;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Random;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class SharedRoomCalendarGenerator {
    static Logger logger = Logger.getLogger((String)(class$cmradar$manager$sim$HotelCalendarGenerator == null ? (class$cmradar$manager$sim$HotelCalendarGenerator = SharedRoomCalendarGenerator.class$("cmradar.manager.sim.HotelCalendarGenerator")) : class$cmradar$manager$sim$HotelCalendarGenerator).getName());
    protected HashMap meetings;
    SharedRoomCalendar calendar;
    Vector requests;
    private TimeSlot[] possibleTimes;
    Vector agents;
    Vector rooms;
    Random rand = new Random();
    int mtgIdCnt = 1;
    static String mtgIdPrefix = "";
    public static RequirementInfo[] requirementList = new RequirementInfo[]{new RequirementInfo("capacity", 5, 1200, true), new RequirementInfo("ConferenceCapacity", 5, 70, true), new RequirementInfo("ClassroomCapacity", 5, 425, true), new RequirementInfo("TheaterCapacity", 5, 800, true), new RequirementInfo("HollowSqCapacity", 5, 120, true), new RequirementInfo("UShapeCapacity", 5, 80, true), new RequirementInfo("BanquetCapacity", 5, 700, true), new RequirementInfo("ReceptionCapacity", 5, 1200, true)};
    static int NUMTRY = 3;
    public static Random durRand = new Random();
    public static final String usage = "Usage:\n\tSharedRoomCalendarGenerator\n\t   -gen in_agents in_rooms out_meetings out_sharedroomcalendar out_requests \n or \n\t   -gen in_agents in_rooms out_meetings out_sharedroomcalendar out_requests in_owners\n or \n\t   -mgen [directory-name] [N:# of requests]\n\t(Note: in -mgen mode the directory must already contains\n\t<e0.agents> file and <e0.rooms> file. \n\tRunning this will generate \n\t<N> .requests, .sharedroomcalendar, and .meetings files)";
    static /* synthetic */ Class class$cmradar$manager$sim$HotelCalendarGenerator;

    public SharedRoomCalendarGenerator() {
        this.calendar = new SharedRoomCalendar();
        this.meetings = new HashMap();
    }

    public SharedRoomCalendarGenerator(Vector vector) {
        this.calendar = new SharedRoomCalendar();
        this.meetings = new HashMap();
        for (int i = 0; i < vector.size(); ++i) {
            this.calendar.addRoom((Room)vector.get(i));
        }
    }

    public Vector getMeetings() {
        return new Vector(this.meetings.values());
    }

    public SharedRoomCalendar getCalendar() {
        return this.calendar;
    }

    public void setCalendar(SharedRoomCalendar sharedRoomCalendar) {
        this.calendar = sharedRoomCalendar;
    }

    public Vector getRequests() {
        return this.requests;
    }

    public double getDensity(Room room, TestInfo testInfo) {
        double d = testInfo.getPctFilled();
        return d;
    }

    public TimeSlot[] getPossibleTimes(TestInfo testInfo) {
        int n = testInfo.getStartHour();
        int n2 = testInfo.getEndHour();
        logger.log((Priority)Level.INFO, (Object)("start=" + n + " end=" + n2));
        int n3 = (n2 - n) * testInfo.getTestDays();
        TimeSlot[] timeSlotArray = new TimeSlot[n3];
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(new SimpleDateFormat("yyyy-MM-ddZ").parse(testInfo.getStartDate()));
        }
        catch (ParseException parseException) {
            System.err.println("Calendar Parsing failed");
            parseException.printStackTrace();
            System.exit(1);
        }
        calendar.set(11, n);
        calendar.set(12, 0);
        for (int i = 0; i < n3; ++i) {
            if (calendar.get(11) >= n2) {
                calendar.add(6, 1);
                calendar.set(11, n);
            }
            timeSlotArray[i] = new TimeSlot(calendar.getTime().getTime() / 1000L);
            calendar.add(11, 1);
        }
        return timeSlotArray;
    }

    public int chooseRandomFreeTime(String[][] stringArray, int n) {
        int n2 = 0;
        boolean bl = false;
        int n3 = -1;
        while (!bl && n2++ < NUMTRY) {
            int n4;
            n3 = Math.abs(this.rand.nextInt()) % stringArray[n].length;
            if (this.isFree(stringArray[n][n3])) {
                return n3;
            }
            if (this.rand.nextInt() % 2 == 0) {
                for (n4 = Math.min(n3 + 2, stringArray[n].length); n4 < Math.max(0, n3 - 2); --n4) {
                    if (!this.isFree(stringArray[n][n4])) continue;
                    return n4;
                }
                continue;
            }
            for (n4 = Math.max(0, n3 - 2); n4 < Math.min(n3 + 2, stringArray[n].length); ++n4) {
                if (!this.isFree(stringArray[n][n4])) continue;
                return n4;
            }
        }
        if (bl) {
            return n3;
        }
        return -1;
    }

    public int numSlotsFilled(int n, String[][] stringArray) {
        int n2 = 0;
        for (int i = 0; i < stringArray[n].length; ++i) {
            if (this.isFree(stringArray[n][i])) continue;
            ++n2;
        }
        return n2;
    }

    public boolean isFree(String string) {
        return string == null;
    }

    private void shuffleList(LinkedList linkedList) {
        for (int i = 0; i < linkedList.size(); ++i) {
            Object e = linkedList.get(i);
            int n = this.rand.nextInt(linkedList.size());
            linkedList.set(i, linkedList.get(n));
            linkedList.set(n, e);
        }
    }

    public void generateRandomCalendar(SimParameters simParameters, String string, boolean bl) {
        int n;
        int n2;
        TestInfo testInfo = simParameters.getTestInfo();
        this.agents = simParameters.getAgents();
        this.rooms = simParameters.getRooms();
        this.possibleTimes = this.getPossibleTimes(testInfo);
        String[][] stringArray = new String[this.rooms.size()][this.possibleTimes.length];
        for (n2 = 0; n2 < this.rooms.size(); ++n2) {
            for (int i = 0; i < this.possibleTimes.length; ++i) {
                stringArray[n2][i] = null;
            }
        }
        for (n2 = 0; n2 < this.rooms.size(); ++n2) {
            Room room = (Room)this.rooms.get(n2);
            n = (int)((double)this.possibleTimes.length * this.getDensity(null, testInfo));
            if (bl) {
                n = this.possibleTimes.length;
            }
            int n3 = 0;
            int n4 = n * 3;
            int n5 = 0;
            while (n3 < n) {
                if (n5 > n4) {
                    logger.log((Priority)Level.INFO, (Object)("stop app=" + (double)(n3 / n)));
                    break;
                }
                ++n5;
                int n6 = this.chooseRandomFreeTime(stringArray, n2);
                if (n6 >= this.possibleTimes.length) {
                    System.out.println("Invalid time " + n6 + " " + this.possibleTimes.length);
                    System.exit(0);
                }
                if (n6 < 0) continue;
                String string2 = null;
                int n7 = this.rand.nextInt(this.agents.size());
                string2 = ((AgentInfo)this.agents.get(n7)).getUserId();
                String string3 = ((AgentInfo)this.agents.get(n7)).getAgentType();
                boolean bl2 = false;
                n7 = this.rand.nextInt(this.agents.size() - 2);
                string2 = ((AgentInfo)this.agents.get(n7)).getUserId();
                int n8 = this.getRandomMeetingType();
                Meeting meeting = new Meeting("null", mtgIdPrefix + this.mtgIdCnt++, string2, n8, new Vector());
                meeting.addAttendant(string2);
                stringArray[n2][n6] = meeting.getMeetingId();
                TimeSlot timeSlot = new TimeSlot(this.possibleTimes[n6]);
                meeting.setTimeSlotStatus(string2, timeSlot, "confirmed");
                meeting.setDuration(timeSlot.getDurationSecond());
                this.calendar.addMeeting(room, meeting, timeSlot, true);
                this.meetings.put(meeting.getMeetingId(), meeting);
                ++n3;
            }
            logger.log((Priority)Level.INFO, (Object)("R:" + room.getRoomId() + " numToFill = " + n + " taken=" + n3));
        }
        for (n2 = 0; n2 < this.rooms.size(); ++n2) {
            Room room = (Room)this.rooms.get(n2);
            n = this.numSlotsFilled(n2, stringArray);
            double d = (double)n * 1.0 / (double)this.possibleTimes.length;
            logger.log((Priority)Level.DEBUG, (Object)("Room " + room.getRoomId() + "'s calendar is filled to pct:" + d + ", goal: " + this.getDensity(room, testInfo)));
        }
        if (string != null) {
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string + ".html"));
                bufferedWriter.write(this.writeCalendarHtml(stringArray, testInfo));
                bufferedWriter.close();
            }
            catch (Exception exception) {
                System.out.println("Error in writing calendar into html: " + exception.toString());
            }
        }
    }

    public String writeCalendarHtml(String[][] stringArray, TestInfo testInfo) {
        int n;
        int n2 = 0;
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer("<html>");
        int n4 = testInfo.getStartHour();
        int n5 = testInfo.getEndHour();
        stringBuffer.append("start=" + n4 + " end=" + n5 + "<br>\n");
        stringBuffer.append("<table border=1>\n");
        int n6 = n5 - n4;
        stringBuffer.append("<tr><td>Rooms\\Time</td>\n");
        stringBuffer.append("<td bgcolor=red>&nbsp;</td>");
        for (n = 0; n < testInfo.getTestDays(); ++n) {
            for (int i = 0; i < n6; ++i) {
                stringBuffer.append("<td>" + (i + n4) + "</td>");
            }
            stringBuffer.append("<td bgcolor=red>&nbsp;</td>");
        }
        stringBuffer.append("</tr>\n");
        for (n = 0; n < this.rooms.size(); ++n) {
            Room room = (Room)this.rooms.get(n);
            stringBuffer.append("<tr><td>" + room.getRoomId() + "</td>\n");
            for (int i = 0; i < this.possibleTimes.length; ++i) {
                if (i % n6 == 0) {
                    stringBuffer.append("<td bgcolor=red>&nbsp;</td>");
                }
                if (stringArray[n][i] == null) {
                    stringBuffer.append("<td bgcolor=green>&nbsp;</td>");
                    ++n2;
                    continue;
                }
                stringBuffer.append("<td>" + stringArray[n][i] + "</td>");
                ++n3;
            }
            stringBuffer.append("</tr>\n");
        }
        stringBuffer.append("</table>");
        stringBuffer.append("Free:" + n2 + ",taken:" + n3);
        stringBuffer.append("</html>");
        return stringBuffer.toString();
    }

    public void generateRoomRequests(SimParameters simParameters) {
        this.requests = new Vector();
        TestInfo testInfo = simParameters.getTestInfo();
        int n = testInfo.getNumNewRequests();
        String string = ((AgentInfo)this.agents.lastElement()).getUserId();
        for (int i = 0; i < n; ++i) {
            RoomTemplate roomTemplate = new RoomTemplate();
            int n2 = this.rand.nextInt(this.agents.size());
            String string2 = ((AgentInfo)this.agents.get(n2)).getUserId();
            String string3 = ((AgentInfo)this.agents.get(n2)).getAgentType();
            boolean bl = false;
            roomTemplate.initiator = string;
            roomTemplate.msgId = "NEW";
            roomTemplate.meetingId = mtgIdPrefix + this.mtgIdCnt++;
            roomTemplate.addAttendant(string2, 10.0);
            roomTemplate.setPredefinedKind(Meeting.getTypeString(this.getRandomMeetingType()));
            int n3 = this.rand.nextInt(this.possibleTimes.length);
            int n4 = durRand.nextInt(6) + 1;
            int n5 = this.possibleTimes[n3].st();
            n4 = Math.min(n4, testInfo.getEndHour() - n5);
            TimeSlot timeSlot = new TimeSlot(this.possibleTimes[n3].getStartTimeString(), n4);
            roomTemplate.addTimeSlot(timeSlot, "possible");
            roomTemplate.setDuration(3600 * n4);
            boolean[] blArray = new boolean[requirementList.length];
            for (int j = 0; j < testInfo.getRequestFieldsRequired(); ++j) {
                int n6 = this.rand.nextInt(blArray.length);
                RequirementInfo requirementInfo = requirementList[n6];
                if (blArray[n6]) continue;
                roomTemplate.requirements.add(this.generateRandomRequirement(n6));
                blArray[n6] = true;
            }
            this.requests.add(roomTemplate);
        }
    }

    private Requirement generateRandomRequirement(int n) {
        int n2;
        int n3;
        int n4;
        RequirementInfo requirementInfo = requirementList[n];
        if (requirementInfo.enumVals != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(requirementInfo.enumVals[this.rand.nextInt(requirementInfo.enumVals.length)]);
            if (arrayList.contains("AVAILABLE")) {
                arrayList.add("IN_ROOM");
            }
            return new EnumRequirement(requirementInfo.name, 0.7f, this.rand.nextFloat(), arrayList);
        }
        if (requirementInfo.max == requirementInfo.min) {
            n3 = n4 = requirementInfo.max;
            n2 = n4;
        } else {
            int n5;
            int n6 = this.rand.nextInt(requirementInfo.max - requirementInfo.min) + requirementInfo.min;
            n3 = Math.min(n6, n5 = this.rand.nextInt(requirementInfo.max - requirementInfo.min) + requirementInfo.min);
            n2 = n3 != (n4 = Math.max(n6, n5)) ? this.rand.nextInt(n4 - n3) + n3 : n3;
        }
        return new NumericRequirement(requirementInfo.name, 0.1f, this.rand.nextFloat(), n3, n4, n2);
    }

    public int getRandomMeetingType() {
        int[] nArray = new int[]{5, 4, 6};
        return nArray[this.rand.nextInt(nArray.length)];
    }

    public NumericRequirement getRandomCapacityReq() {
        int n;
        int n2 = 100;
        int n3 = 10;
        int n4 = n = this.rand.nextInt(n2 - n3) + n3;
        int n5 = n;
        NumericRequirement numericRequirement = new NumericRequirement("capacity", 0.5, 0.5, n4, n, n5);
        return numericRequirement;
    }

    public EnumRequirement getRandomProjectorReq() {
        String[] stringArray = new String[]{"STATIONARY", "MOVABLE"};
        int n = this.rand.nextInt(stringArray.length);
        if (stringArray[n].equals("NONE")) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(stringArray[n]);
        int n2 = this.rand.nextInt(10);
        double d = (double)n2 / 10.0;
        EnumRequirement enumRequirement = new EnumRequirement("projector", 1.0f, (float)d, arrayList);
        return enumRequirement;
    }

    public String getRandomRoomType() {
        String[] stringArray = new String[]{"CLASSROOM", "CONFERENCE"};
        return stringArray[this.rand.nextInt(stringArray.length)];
    }

    public static void checkFileExists(String string) {
        try {
            File file = new File(string);
            if (file.exists()) {
                System.out.println(string + " already exists.");
                System.out.println("Please remove file or specify a different output file .");
                System.exit(0);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void generatexxx(String[] stringArray) {
        if (stringArray.length < 6) {
            System.out.println(usage);
            System.exit(1);
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = "cmradar.properties";
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-mgen")) {
                try {
                    String string9 = stringArray[1];
                    String string10 = "e";
                    int n2 = Integer.parseInt(stringArray[2]);
                    String[] stringArray2 = new String[6];
                    stringArray2[0] = "-gen";
                    stringArray2[1] = string9 + File.separator + "e0.agents";
                    stringArray2[2] = string9 + File.separator + "e0.rooms";
                    for (int j = 1; j <= n2; ++j) {
                        String string11 = string10 + String.valueOf(j) + ".";
                        stringArray2[3] = string9 + File.separator + string11 + "meetings";
                        stringArray2[4] = string9 + File.separator + string11 + "sharedroomcalendar";
                        stringArray2[5] = string9 + File.separator + string11 + "requests";
                        SharedRoomCalendarGenerator.generatexxx(stringArray2);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.out.println("\n\nUSAGE: -mgen [directory-name] [N:# of requests]\n\nNote: The directory must already contains <e0.agents> file and <e0.rooms> file. Running this will generate N .requests, .sharedroomcalendar, and .meetings files");
                }
                return;
            }
            if (stringArray[i].equals("-mid") && ++i < stringArray.length) {
                mtgIdPrefix = stringArray[i];
                continue;
            }
            if (stringArray[i].equals("-agent") && ++i < stringArray.length) {
                string = stringArray[i];
                continue;
            }
            if (stringArray[i].equals("-room") && ++i < stringArray.length) {
                string2 = stringArray[i];
                continue;
            }
            if (stringArray[i].equals("-density") && ++i < stringArray.length) {
                string4 = stringArray[i];
                continue;
            }
            if (stringArray[i].equals("-owner") && ++i < stringArray.length) {
                string3 = stringArray[i];
                continue;
            }
            if (stringArray[i].equals("-discount") && ++i < stringArray.length) {
                Room.lambda = Double.parseDouble(stringArray[i]);
                continue;
            }
            if (stringArray[i].equals("-config") && ++i < stringArray.length) {
                string8 = stringArray[i];
                continue;
            }
            if (stringArray[i].equals("-mt") && ++i < stringArray.length) {
                string5 = stringArray[i];
                SharedRoomCalendarGenerator.checkFileExists(string5);
                continue;
            }
            if (stringArray[i].equals("-sc") && ++i < stringArray.length) {
                string6 = stringArray[i];
                SharedRoomCalendarGenerator.checkFileExists(string6);
                continue;
            }
            if (stringArray[i].equals("-req") && ++i < stringArray.length) {
                string7 = stringArray[i];
                SharedRoomCalendarGenerator.checkFileExists(string7);
                continue;
            }
            if (stringArray[i].equals("-hotel")) {
                bl = true;
                continue;
            }
            if (!stringArray[i].equals("-gendensity") || ++i >= stringArray.length) continue;
            bl2 = true;
            n = Integer.parseInt(stringArray[i]);
        }
        if (string == null || string2 == null || string5 == null || string6 == null || string7 == null) {
            System.out.println(usage);
            System.exit(1);
        }
        try {
            Object object;
            Object object2;
            SimParameters simParameters = new SimParameters();
            System.out.print("parsing...");
            System.out.flush();
            simParameters.parseConfigFile(string8);
            simParameters.parseAgentsFile(string);
            simParameters.parseRoomFile(string2);
            System.out.println(" done.");
            System.out.flush();
            SharedRoomCalendarGenerator sharedRoomCalendarGenerator = new SharedRoomCalendarGenerator(simParameters.getRooms());
            if (bl2) {
                simParameters.generateDensityFile(string4, n);
                System.out.println("Density file " + string4 + " was generated!");
                System.exit(0);
            }
            if (string4 != null) {
                simParameters.parseDensityFile(string4);
            }
            sharedRoomCalendarGenerator.generateRandomCalendar(simParameters, string6, false);
            System.out.println("generated shared cal...");
            sharedRoomCalendarGenerator.generateRoomRequests(simParameters);
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string5));
            for (int i = 0; i < sharedRoomCalendarGenerator.getMeetings().size(); ++i) {
                object2 = (Meeting)sharedRoomCalendarGenerator.getMeetings().get(i);
                object = ((Meeting)object2).toParseString();
                if (object == null) continue;
                bufferedWriter.write(((Meeting)object2).toParseString());
                if (i == sharedRoomCalendarGenerator.getMeetings().size() - 1) continue;
                bufferedWriter.write("---\n");
            }
            bufferedWriter.close();
            BufferedWriter bufferedWriter2 = new BufferedWriter(new FileWriter(string6));
            bufferedWriter2.write(sharedRoomCalendarGenerator.getCalendar().toParseString() + "\n");
            bufferedWriter2.close();
            object2 = sharedRoomCalendarGenerator.getCalendar();
            sharedRoomCalendarGenerator.setCalendar((SharedRoomCalendar)object2);
            object = new BufferedWriter(new FileWriter(string7));
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("(templates \n");
            for (int i = 0; i < sharedRoomCalendarGenerator.getRequests().size(); ++i) {
                RoomTemplate roomTemplate = (RoomTemplate)sharedRoomCalendarGenerator.getRequests().get(i);
                stringBuffer.append(roomTemplate.toLispList() + "\n");
            }
            stringBuffer.append(")");
            ((Writer)object).write(stringBuffer.toString());
            ((BufferedWriter)object).close();
            return;
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            System.err.println("Error generating calendars in SharedRoomCalendarGenerator. Quitting.");
            return;
        }
    }

    public void createCrisis(String string, String string2, String string3, String string4, String string5) {
        try {
            Object object;
            Object object2;
            int n;
            Object object3;
            int n2 = 6;
            int n3 = 0;
            String[] stringArray = new String[]{"2006-03-20 [07:00 -0500]", "2006-03-21 [07:00 -0500]", "2006-03-22 [07:00 -0500]", "2006-03-23 [07:00 -0500]"};
            String[] stringArray2 = new String[]{"2006-03-20 [21:00 -0500]", "2006-03-21 [21:00 -0500]", "2006-03-22 [21:00 -0500]", "2006-03-23 [21:00 -0500]"};
            Vector<Integer> vector = new Vector<Integer>();
            vector.add(new Integer(0));
            vector.add(new Integer(2));
            vector.add(new Integer(3));
            SimParameters simParameters = new SimParameters();
            simParameters.parseRoomFile(string);
            this.rooms = simParameters.getRooms();
            this.calendar = new SharedRoomCalendar();
            this.meetings = new HashMap();
            for (int i = 0; i < this.rooms.size(); ++i) {
                this.calendar.addRoom((Room)this.rooms.get(i));
            }
            Object object4 = this.rooms.elements();
            while (object4.hasMoreElements()) {
                object3 = (Room)object4.nextElement();
                for (n = 0; n < stringArray.length; ++n) {
                    object2 = string2 + n3++;
                    if (vector.contains(new Integer(n)) && ((Room)object3).getBuilding().equals(string5)) {
                        object2 = "__UNAVAILABLE__" + (String)object2;
                    }
                    object = new Meeting(string3, (String)object2, string3, n2, new Vector());
                    ((Meeting)object).addAttendant(string3);
                    TimeSlot timeSlot = new TimeSlot(stringArray[n], stringArray2[n]);
                    ((Meeting)object).setTimeSlotStatus(string3, timeSlot, "confirmed");
                    TimeSlot timeSlot2 = ((Meeting)object).getConfirmedTimeSlot();
                    if (timeSlot2 == null) {
                        System.out.println("no confirmed slot?" + object.toString());
                    }
                    this.calendar.addMeeting((Room)object3, (Meeting)object, timeSlot, true);
                    this.meetings.put(((Meeting)object).getMeetingId(), object);
                }
            }
            object4 = new BufferedWriter(new FileWriter(string4 + ".sharedroomcalendar"));
            ((Writer)object4).write(this.getCalendar().toParseString() + "\n");
            ((BufferedWriter)object4).close();
            object3 = new BufferedWriter(new FileWriter(string4 + ".meetings"));
            for (n = 0; n < this.getMeetings().size(); ++n) {
                object2 = (Meeting)this.getMeetings().get(n);
                object = ((Meeting)object2).toParseString(0L);
                if (object == null) continue;
                ((Writer)object3).write(((Meeting)object2).toParseString());
                if (n == this.getMeetings().size() - 1) continue;
                ((Writer)object3).write("---\n");
            }
            ((BufferedWriter)object3).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray[0].equals("-crisis")) {
            SharedRoomCalendarGenerator sharedRoomCalendarGenerator = new SharedRoomCalendarGenerator();
            sharedRoomCalendarGenerator.createCrisis("conference.rooms", "conf", "Randal", stringArray[1], stringArray[2]);
        } else {
            SharedRoomCalendarGenerator.generatexxx(stringArray);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

