/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.neg;

import cmradar.manager.data.Meeting;
import cmradar.manager.data.Room;
import cmradar.manager.data.RoomTemplate;
import cmradar.manager.data.SharedRoomCalendar;
import cmradar.manager.data.Template;
import cmradar.manager.data.TimeSlot;
import cmradar.manager.ext.Learner;
import cmradar.manager.neg.AbstractRoomNegotiator;
import cmradar.manager.neg.MutableNegotiationLog;
import cmradar.manager.neg.RankLog;
import cmradar.manager.neg.RoomNegotiationLogEntry;
import cmradar.manager.sched.Scheduler;
import cmradar.manager.sim.MessageCommunicator;
import cmradar.manager.sim.RSimulator;
import cmradar.manager.sim.SimParameters;
import cmradar.manager.sim.Utility;
import cmradar.manager.sys.RManagerIO;
import cmradar.manager.sys.SchedulerInvoker;
import edu.cmu.cs.radar.integ.ICMRadarRequires;
import edu.cmu.cs.radar.integ.IRadarServices;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class RoomNegotiator
extends AbstractRoomNegotiator {
    HashMap reqMap = new HashMap();
    RoomTemplate request = null;
    String requestId;
    int iteration = 1;
    SimpleDateFormat sfd = new SimpleDateFormat("MMMd-kk:mm:ss");
    Date modifiedDate = new Date();
    double threshold = 0.0;
    int numOptions = 10;
    long waitTime = 20L;
    static Logger logger = Logger.getLogger((String)(class$cmradar$manager$neg$RoomNegotiator == null ? (class$cmradar$manager$neg$RoomNegotiator = RoomNegotiator.class$("cmradar.manager.neg.RoomNegotiator")) : class$cmradar$manager$neg$RoomNegotiator).getName());
    RankLog rLogger;
    IRadarServices _radar;
    static /* synthetic */ Class class$cmradar$manager$neg$RoomNegotiator;

    public RoomNegotiator(RManagerIO rManagerIO, String string, String string2, Scheduler scheduler, MessageCommunicator messageCommunicator) {
        super(rManagerIO, string, string2, scheduler, messageCommunicator);
        String string3 = RSimulator.REQUEST_DIR + File.separator + this.myUserId + ".traininglog";
        this.negLogger = new MutableNegotiationLog(string3);
        String string4 = RSimulator.REQUEST_DIR + File.separator + this.myUserId + "-rank.traininglog";
        this.rLogger = new RankLog(string4);
        this.iWantToLog = true;
    }

    public void setSharedRCal(SharedRoomCalendar sharedRoomCalendar) {
        this.sharedRCal = sharedRoomCalendar;
        this.rLogger.setSharedCalendar(sharedRoomCalendar);
        this.initializeScheduler();
    }

    public void setRadarHandle(IRadarServices iRadarServices) {
        this._radar = iRadarServices;
    }

    public void set_threshold(double d) {
        this.threshold = d;
    }

    private void reset() {
        this.request = null;
        this.openMeetings = new Vector();
    }

    public void setNumOptions(int n) {
        this.numOptions = n;
    }

    public boolean isRequestActive() {
        return this.request != null;
    }

    public void printOptionsErrorandExit(String string) {
        System.out.println("Bad options to RoomNegotiator!");
        System.out.println("Given option string: " + string);
        System.out.println("\n\nOption: threshold -- (double) priority below which to not ask for room\n");
        System.out.println("Exiting...");
        System.exit(0);
    }

    public void setOptions(String string) {
        if (string.equals("")) {
            return;
        }
        String[] stringArray = string.split(":");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("=");
            if (stringArray2.length != 2) {
                this.printOptionsErrorandExit(string);
            }
            if (stringArray2[0].equals("threshold")) {
                try {
                    this.set_threshold(new Double(stringArray2[1]));
                }
                catch (NumberFormatException numberFormatException) {
                    this.printOptionsErrorandExit(string);
                }
                continue;
            }
            if (stringArray2[0].equals("prob")) {
                this.threshold = new Double(stringArray2[1]);
                continue;
            }
            this.printOptionsErrorandExit(string);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void receive_message(Template template, String string) {
        RoomTemplate roomTemplate = (RoomTemplate)template;
        if (RSimulator.debugmode) {
            Utility.waitForKey(true);
        }
        if (this.request == null) {
            if (roomTemplate.getMeetingId().equals("nil")) {
                this.ioManager.writeLine("received obsolete response message from " + string + "... ignore...");
                return;
            }
            this.handleNewRequest(roomTemplate);
        } else {
            this.handleOwnerResponse(roomTemplate, string);
        }
        if (RSimulator.debugmode) {
            Utility.waitForKey(true);
        }
    }

    public void updateWaitTime(long l) {
        System.out.println("!!!IMPLEMENT update wait time model... inst=" + l);
    }

    private boolean getMoreOptionsFromOzone(RoomTemplate roomTemplate) {
        TimeSlot timeSlot;
        int n;
        int n2;
        int n3;
        logger.log((Priority)Level.DEBUG, (Object)("Get more options from Ozone: " + roomTemplate.getMeetingId()));
        RoomTemplate roomTemplate2 = (RoomTemplate)this.reqMap.get(roomTemplate.getMeetingId());
        if (roomTemplate2 == null) {
            logger.log((Priority)Level.ERROR, (Object)("request not found! " + roomTemplate.getMeetingId()));
            System.exit(0);
        }
        if ((n3 = this.numOptions - (n2 = this.request.getFailedRooms().size())) <= 0) {
            return false;
        }
        Vector vector = this.ozone.processRoomRequest(roomTemplate2, n3);
        if (vector.size() == 0) {
            this.ioManager.writeLine("\n");
            this.ioManager.writeLine("I (" + this.myUserId + ") got no options from scheduler: \n\n");
            if (this.ov != null) {
                this.ov.appendMsg("No options from scheduler. The probability of getting a room is too low to try.");
            }
            logger.log((Priority)Level.INFO, (Object)"No options from scheduler. The probability of getting a room is too low to try.");
            return false;
        }
        RoomTemplate roomTemplate3 = (RoomTemplate)vector.get(0);
        Vector vector2 = roomTemplate3.getTimeSlotsFromStatus("pending");
        this.request.clearTimeSlots();
        for (n = 0; n < vector2.size(); ++n) {
            timeSlot = (TimeSlot)vector2.get(n);
            this.request.addTimeSlot(timeSlot, "possible");
        }
        vector2 = this.request.getTimeSlotsFromStatus("possible");
        this.ioManager.writeLine(" -> Scheduler found the following [" + vector2.size() + "] options for " + this.request.getMeetingId() + "(" + this.request.duration / 3600.0 + "hrs)" + ":");
        logger.log((Priority)Level.INFO, (Object)(" -> Scheduler found the following [" + vector2.size() + "] options for " + this.request.getMeetingId() + "(" + this.request.duration / 3600.0 + "hrs)" + ":"));
        for (n = 0; n < vector2.size(); ++n) {
            Room room;
            timeSlot = (TimeSlot)vector2.get(n);
            Vector vector3 = this.getAllOwnersFromTimeRoom(timeSlot, room = this.sharedRCal.getRoomFromId(timeSlot.location));
            if (vector3.contains(this.myUserId)) {
                logger.log((Priority)Level.ERROR, (Object)("this is my meeting!!!!! " + timeSlot.location));
                continue;
            }
            String string = "";
            Enumeration enumeration = vector3.elements();
            while (enumeration.hasMoreElements()) {
                string = string + " " + (String)enumeration.nextElement();
            }
            logger.log((Priority)Level.DEBUG, (Object)("   * room " + timeSlot.location + "@" + timeSlot.startTime + " with priority " + timeSlot.priority + " (owner " + string + ")"));
        }
        logger.log((Priority)Level.DEBUG, (Object)("***options(" + this.request.duration / 3600.0 + "hrs) = " + vector2.size()));
        if (vector2.size() == 0) {
            ((RSimulator)this.mComm).incrNoop();
            logger.log((Priority)Level.DEBUG, (Object)("NO OPTIONS? " + this.request));
        }
        return true;
    }

    private void handleNewRequest(RoomTemplate roomTemplate) {
        int n;
        this.reqMap.put(roomTemplate.getMeetingId(), roomTemplate);
        this.request = new RoomTemplate(roomTemplate);
        this.sharedRCal.removeMeeting(this.request.getMeetingId());
        this.request.clearTimeSlots();
        this.request.resetRoomOwners();
        this.requestId = this.request.getMeetingId();
        this.iteration = 1;
        this.openMeetings.add(this.request);
        this.ioManager.writeLine("\n");
        this.ioManager.writeLine("  -> Looking for room with the following requirements:");
        Object object = roomTemplate.getTimeSlots().iterator();
        while (object.hasNext()) {
            TimeSlot timeSlot = (TimeSlot)object.next();
            this.ioManager.writeLine("Time: " + timeSlot.getStartTimeString() + " - " + timeSlot.getFinishTimeString());
        }
        this.ioManager.writeLine("Duration:\t" + roomTemplate.duration / 3600.0);
        object = roomTemplate.getRequirements();
        for (n = 0; n < ((ArrayList)object).size(); ++n) {
            this.ioManager.writeLine("   " + ((ArrayList)object).get(n).toString());
        }
        this.ioManager.writeLine("\n");
        if (this.ov != null) {
            this.ov.appendMsg("  -> Looking for room with the following requirements:");
            this.ov.appendMsg("Duration:\t" + roomTemplate.duration / 3600.0);
            for (n = 0; n < ((ArrayList)object).size(); ++n) {
                this.ov.appendMsg("   " + ((ArrayList)object).get(n).toString());
            }
            this.ov.appendMsg("\n");
        }
        this.getMoreOptionsFromOzone(this.request);
        this.findRoom();
    }

    private void addLogEntry(TimeSlot timeSlot, String string) {
        RoomNegotiationLogEntry roomNegotiationLogEntry = new RoomNegotiationLogEntry();
        LinkedList linkedList = this.sharedRCal.getMeetings(timeSlot, string);
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            Meeting meeting = (Meeting)iterator.next();
            roomNegotiationLogEntry.setRequestId(this.requestId + "-" + this.iteration++);
            roomNegotiationLogEntry.setNegId(this.requestId);
            roomNegotiationLogEntry.setRoomId(timeSlot.location);
            roomNegotiationLogEntry.setOwnerId(string);
            roomNegotiationLogEntry.setCurrMeetingId(meeting.getMeetingId());
            roomNegotiationLogEntry.setCurrMeetingType(meeting.getTypeString());
            roomNegotiationLogEntry.setNewMeetingId(this.request.getMeetingId());
            roomNegotiationLogEntry.setNewMeetingType(this.request.getPredefinedKind());
            boolean bl = !timeSlot.getStatus().equals("impossible");
            roomNegotiationLogEntry.setResponse(bl);
            this.negLogger.addEntry(roomNegotiationLogEntry);
        }
    }

    public void logLastCalendar() {
        try {
            this.rLogger.writeLog();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            logger.log((Priority)Level.ERROR, (Object)"fail to log");
        }
    }

    public void processResult(String string, Room room, TimeSlot timeSlot, int n) {
        Object object;
        logger.log((Priority)Level.INFO, (Object)("**** Process result: " + string + " " + ICMRadarRequires.Reservation.getStringStatus((int)n) + " room=" + (room == null ? "null" : room.getRoomId())));
        this.reqMap.remove(string);
        if (n != 2) {
            if (room.isHotel()) {
                this.sharedRCal.updateTrueStatus(string, room.getId(), timeSlot.getDay(), n != 2 ? Learner.FREE : Learner.TAKEN);
                try {
                    this.rLogger.writeLog(timeSlot);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    logger.log((Priority)Level.ERROR, (Object)"fail to log");
                }
            }
            this.request.setStatus(timeSlot, "confirmed");
            object = new Meeting(this.myUserId, this.request);
            ((Meeting)object).setTimeSlotStatus(this.myUserId, timeSlot, "confirmed");
            ((Meeting)object).setStatus("confirmed");
            boolean bl = this.sharedRCal.confirmMeeting(room, (Meeting)object, timeSlot, true);
            if (!bl) {
                logger.log((Priority)Level.ERROR, (Object)("Could not add meeting [" + ((Meeting)object).getMeetingId() + "] to shared room calendar at time " + timeSlot.toParseString()));
            }
            this.ozone.processRoomRequest(this.request, 1);
            this.sharedRCal.writeToFile(SimParameters.outCalendarsFile);
            ((Meeting)object).writeToFile(SimParameters.outMeetingsFile, true);
            ((Meeting)object).appendTrueStatusFile();
        }
        ((RSimulator)this.mComm).incrCount(n);
        object = timeSlot == null ? null : this.sharedRCal.getRoomFromId(timeSlot.location);
        ICMRadarRequires.Reservation reservation = this.request.makeReservation(n, (Room)object);
        if (this._radar != null) {
            this.ioManager.writeLine("foundRoom: " + reservation + "\n");
            ((RSimulator)this.mComm).saveStat();
            this._radar.foundRoom(reservation);
        }
        this.reset();
    }

    private void handleOwnerResponse(RoomTemplate roomTemplate, String string) {
        Object object;
        Iterator iterator;
        Object object2;
        TimeSlot timeSlot;
        int n;
        Vector vector = roomTemplate.getTimeSlots();
        if (vector.size() != 1) {
            System.out.println("Multiple timeslots in owner response.");
            System.exit(0);
        }
        TimeSlot timeSlot2 = (TimeSlot)vector.elementAt(0);
        logger.log((Priority)Level.DEBUG, (Object)("handleOwnerResponse:" + string + " " + timeSlot2.toParseString() + " " + timeSlot2.getStatus()));
        String string2 = timeSlot2.location;
        String string3 = string2 + "-" + String.valueOf(timeSlot2.st());
        Room room = this.sharedRCal.getRoomFromId(timeSlot2.location);
        if (this.request.isFailedRoom(string3)) {
            boolean bl = roomTemplate.getTimeSlotsFromStatus("possible").size() > 0;
            ((RSimulator)this.mComm).incrLocalRequests(bl);
            logger.log((Priority)Level.DEBUG, (Object)("Obsolete reponse ignored..." + string3 + " sender=" + string));
            return;
        }
        this.request.incrOwnerResponse(string3);
        int n2 = 0;
        try {
            n2 = this.request.getNumOwnersToWait(string3);
        }
        catch (Exception exception) {
            logger.log((Priority)Level.DEBUG, (Object)"request was reset....finished?");
            return;
        }
        boolean bl = n2 == 0;
        logger.log((Priority)Level.DEBUG, (Object)(string3 + ":numToWait = " + n2 + " <<<<<<<<<<<<<<<<<<<< "));
        boolean bl2 = false;
        this.ioManager.writeLine("\n");
        this.ioManager.writeLine(" -> Response received from " + string);
        Vector vector2 = roomTemplate.getTimeSlotsFromStatus("impossible");
        for (n = 0; n < vector2.size(); ++n) {
            timeSlot = (TimeSlot)vector2.get(n);
            this.ioManager.writeLine("   * request for room " + timeSlot.location + " was denied.");
            if (this.ov != null) {
                this.ov.setRequestStatus(string, 3);
            }
            if (room.isHotel()) {
                logger.log((Priority)Level.DEBUG, (Object)(">>>>>>RoomNeg: ext room " + room.getRoomId() + " was taken. confirmation/update sent to ozone"));
                object2 = this.sharedRCal.getMeetings(timeSlot, string);
                iterator = ((AbstractSequentialList)object2).iterator();
                while (iterator.hasNext()) {
                    object = (Meeting)iterator.next();
                    ((Meeting)object).setStatus("confirmed");
                    RoomTemplate roomTemplate2 = ((Meeting)object).toRoomTemplate();
                    this.ozone.processRoomRequest(roomTemplate2, 1);
                }
                iterator = timeSlot.getDay();
                logger.log((Priority)Level.DEBUG, (Object)(" updateEvidence: " + iterator + " " + room.getRoomId() + " taken"));
                object = this.sharedRCal.updateEvidence((String)((Object)iterator), room.getRoomId(), Learner.TAKEN);
                logger.log((Priority)Level.DEBUG, (Object)(" updateEvidence: " + iterator + " " + room.getRoomId() + " taken DONE"));
                ((SchedulerInvoker)this.ozone).updateAvailabilityList((HashMap)object, (String)((Object)iterator));
                bl2 = true;
                ((RSimulator)this.mComm).incrExternalRequests(false);
            } else {
                logger.log((Priority)Level.DEBUG, (Object)("LOCAL ROOM LOG: " + string + " room=" + room + ":h=" + room.isHotel()));
                this.addLogEntry(timeSlot, string);
                ((RSimulator)this.mComm).incrLocalRequests(false);
            }
            this.request.addFailedRoom(string3);
            this.request.setStatus(timeSlot, "impossible");
            logger.log((Priority)Level.DEBUG, (Object)("** " + this.request.getMeetingId() + ":Option " + string3 + " failed ... ]]]]]]]]]]]]]]]] s=" + timeSlot.getStatus()));
        }
        if (bl2) {
            logger.log((Priority)Level.DEBUG, (Object)"*** GET MORE OPTION AFTER UPDATE ****");
            this.getMoreOptionsFromOzone(this.request);
            this.findRoom();
            return;
        }
        vector2 = roomTemplate.getTimeSlotsFromStatus("possible");
        for (n = 0; n < vector2.size(); ++n) {
            timeSlot = (TimeSlot)vector2.get(n);
            logger.log((Priority)Level.DEBUG, (Object)("   * request for room " + timeSlot.location + " was accepted. hotel=?" + room.isHotel() + " sender=" + string));
            if (this.ov != null) {
                this.ov.setRequestStatus(string, 2);
            }
            this.request.setStatus(timeSlot, "pending");
            if (room.isHotel()) {
                object2 = this.sharedRCal.getMeetings(timeSlot, string);
                iterator = ((AbstractSequentialList)object2).iterator();
                while (iterator.hasNext()) {
                    object = (Meeting)iterator.next();
                    this.sharedRCal.removeMeeting(room, (Meeting)object);
                }
                ((RSimulator)this.mComm).incrExternalRequests(true);
                continue;
            }
            logger.log((Priority)Level.DEBUG, (Object)("LOCAL ROOM LOG: " + string + " room=" + room + ":h=" + room.isHotel()));
            this.addLogEntry(timeSlot, string);
            ((RSimulator)this.mComm).incrLocalRequests(true);
        }
        int n3 = 0;
        Vector vector3 = this.request.getTimeSlotsFromStatus("pending");
        if (n3 < vector3.size()) {
            object2 = (TimeSlot)vector3.get(n3);
            iterator = this.sharedRCal.getRoomFromId(((TimeSlot)object2).location);
            if (bl) {
                object = this.meetingsForTime((TimeSlot)object2, (Room)((Object)iterator));
                for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                    Meeting meeting = (Meeting)((ArrayList)object).get(i);
                    this.sharedRCal.removeMeeting((Room)((Object)iterator), meeting);
                }
                this.processResult(this.request.getMeetingId(), room, (TimeSlot)object2, ((Room)((Object)iterator)).isHotel() ? 3 : 1);
            }
            return;
        }
        this.findRoom();
    }

    protected void findRoom() {
        TimeSlot timeSlot = this.request.getHighestPriorityTimeSlot("possible", this.threshold);
        if (timeSlot == null) {
            this.processResult(this.request.getMeetingId(), null, this.request.getHighestPriorityTimeSlot("impossible"), 2);
            return;
        }
        logger.log((Priority)Level.DEBUG, (Object)("findRoom()" + this.request.getMeetingId() + " TRYING " + timeSlot + " " + timeSlot.location + " " + "<<<<<<<<\n"));
        Room room = this.sharedRCal.getRoomFromId(timeSlot.location);
        if (room.isHotel()) {
            String string = room.getAgentName();
            logger.log((Priority)Level.INFO, (Object)("***TRY Hotel room:" + room.getRoomId() + " <<<<<<<<<<"));
            RoomTemplate roomTemplate = new RoomTemplate();
            roomTemplate.clearTimeSlots();
            roomTemplate.setPredefinedKind(this.request.getPredefinedKind());
            roomTemplate.addTimeSlot(timeSlot, "possible");
            String string2 = timeSlot.location + "-" + String.valueOf(timeSlot.st());
            this.request.setNumOwnersToWait(string2, 1);
            ((RSimulator)this.mComm).incrExternalRequests();
            this.mComm.sendMessage(roomTemplate.toLispList(), this.myUserId, string);
            return;
        }
        ArrayList arrayList = this.meetingsForTime(timeSlot, room);
        if (arrayList.size() == 0) {
            this.processResult(this.request.getMeetingId(), room, timeSlot, 0);
            return;
        }
        String string = timeSlot.location + "-" + String.valueOf(timeSlot.st());
        this.request.setNumOwnersToWait(string, arrayList.size());
        logger.log((Priority)Level.DEBUG, (Object)("local room bumping " + arrayList.size() + " mtgs"));
        for (int i = 0; i < arrayList.size(); ++i) {
            Meeting meeting = (Meeting)arrayList.get(i);
            String string3 = meeting.getInitiator();
            logger.log((Priority)Level.INFO, (Object)("TRY local " + string3 + " <<<<<<<<<<<<<"));
            if (string3.equals(this.myUserId)) {
                logger.log((Priority)Level.ERROR, (Object)("STILL initiator is myself??????????????????????? " + string3.equals(this.myUserId)));
                continue;
            }
            this.ioManager.writeLine("\n");
            this.ioManager.writeLine("  -> Requesting...");
            this.ioManager.writeLine("   * room " + timeSlot.location + " from owner " + string3);
            this.ioManager.writeLine("\n");
            ++SchedulerInvoker.RADAR_BUMPING_COUNT;
            if (this.ov != null) {
                this.ov.appendMsg("Requesting a room " + timeSlot.location + " from owner " + string3);
                this.ov.setRequestStatus(string3, 1);
            }
            RoomTemplate roomTemplate = new RoomTemplate();
            roomTemplate.clearTimeSlots();
            roomTemplate.setPredefinedKind(this.request.getPredefinedKind());
            roomTemplate.addTimeSlot(timeSlot, "possible");
            ((RSimulator)this.mComm).incrLocalRequests();
            this.mComm.sendMessage(roomTemplate.toLispList(), this.myUserId, string3);
        }
    }

    protected ArrayList meetingsForTime(TimeSlot timeSlot, Room room) {
        ArrayList arrayList = new ArrayList();
        LinkedList linkedList = this.sharedRCal.getMeetings(room, timeSlot);
        for (int i = 0; i < linkedList.size(); ++i) {
            Meeting meeting = (Meeting)linkedList.get(i);
            arrayList.add(linkedList.get(i));
        }
        return arrayList;
    }

    protected String getOwnerFromTimeRoom(TimeSlot timeSlot, Room room) {
        ArrayList arrayList = this.meetingsForTime(timeSlot, room);
        if (arrayList.size() == 0) {
            return null;
        }
        Meeting meeting = (Meeting)arrayList.get(0);
        String string = meeting.getInitiator();
        return string;
    }

    protected Vector getAllOwnersFromTimeRoom(TimeSlot timeSlot, Room room) {
        Vector<String> vector = new Vector<String>();
        ArrayList arrayList = this.meetingsForTime(timeSlot, room);
        for (int i = 0; i < arrayList.size(); ++i) {
            Meeting meeting = (Meeting)arrayList.get(i);
            String string = meeting.getInitiator();
            vector.add(string);
        }
        return vector;
    }

    public void finish() {
        if (this.iWantToLog) {
            try {
                logger.log((Priority)Level.DEBUG, (Object)"Writing log file...");
                this.negLogger.writeLog();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("Error writing log file...");
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

