/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.ext;

import cmradar.manager.data.Room;
import cmradar.manager.ext.ValuedObject;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

class RUser {
    static Logger logger = Logger.getLogger((String)(class$cmradar$manager$ext$RUser == null ? (class$cmradar$manager$ext$RUser = RUser.class$("cmradar.manager.ext.RUser")) : class$cmradar$manager$ext$RUser).getName());
    int id;
    HashMap weightH;
    Vector pref;
    int type;
    static Random rType = new Random();
    public static final int LINEAR = 0;
    public static final int EXPO = 1;
    public static final int COS = 2;
    public static final int SIN = 3;
    public static final int UNIF = 4;
    public static final int SZ = 5;
    public static final int MIXED = -3;
    public static final double DONTCARE = 0.5;
    public static final int SELF = 0;
    public static final int AVAIL = 1;
    public static final int COMB = 2;
    public static final int RAND = 3;
    public static final int[] strategies = new int[]{0, 1, 2, 3};
    public static final String[] strategynames = new String[]{"SELF", "AVAIL", "COMB", "RAND"};
    public double[] avgQ = new double[]{0.0, 0.0, 0.0, 0.0};
    public double[] avgNT = new double[]{0.0, 0.0, 0.0, 0.0};
    public double[] avgR = new double[]{0.0, 0.0, 0.0, 0.0};
    static /* synthetic */ Class class$cmradar$manager$ext$RUser;

    public RUser(int n, Vector vector) {
        this.id = n;
        this.pref = vector;
    }

    public RUser(RUser rUser) {
        this.id = rUser.id;
        this.type = rUser.type;
        this.pref = new Vector(rUser.pref);
        this.weightH = new HashMap(rUser.weightH);
    }

    public RUser(int n, HashMap hashMap, Random random) {
        double d;
        Object k;
        this.id = n;
        double d2 = 0.0;
        this.type = rType.nextInt(5);
        this.weightH = new HashMap(hashMap);
        Iterator iterator = this.weightH.keySet().iterator();
        while (iterator.hasNext()) {
            k = iterator.next();
            d = random.nextDouble();
            this.weightH.put(k, new Double(d));
            d2 += d;
        }
        iterator = this.weightH.keySet().iterator();
        while (iterator.hasNext()) {
            k = iterator.next();
            d = (Double)this.weightH.get(k);
            this.weightH.put(k, new Double(d / d2));
        }
    }

    public RUser(int n, int n2, Random random) {
        this.id = n;
        double d = 0.0;
        this.type = rType.nextInt(5);
        this.weightH = new HashMap();
        for (int i = 0; i < n2; ++i) {
            double d2 = random.nextDouble();
            this.weightH.put(String.valueOf(i), new Double(d2));
            d += d2;
        }
        Iterator iterator = this.weightH.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            double d3 = (Double)this.weightH.get(k);
            this.weightH.put(k, new Double(d3 / d));
        }
    }

    public RUser(int n, int n2, HashMap hashMap) {
        this.id = n;
        this.type = n2;
        this.weightH = hashMap;
    }

    public RUser(int n) {
        double d = 1.0 / (double)n;
        this.weightH = new HashMap();
        for (int i = 0; i < n; ++i) {
            this.weightH.put(String.valueOf(i), new Double(d));
        }
    }

    public int getId() {
        return this.id;
    }

    public void mean(double d) {
        for (int i = 0; i < strategies.length; ++i) {
            this.avgQ[i] = this.avgQ[i] / d;
            this.avgNT[i] = this.avgNT[i] / d;
            this.avgR[i] = this.avgR[i] / d;
        }
    }

    public void clearStat() {
        for (int i = 0; i < strategies.length; ++i) {
            this.avgQ[i] = 0.0;
            this.avgNT[i] = 0.0;
            this.avgR[i] = 0.0;
        }
    }

    public String toString() {
        String string = "id:" + this.id + "(" + this.getTypeName() + ")";
        return string;
    }

    public String getTypeName() {
        switch (this.type) {
            case 3: {
                return "Sin";
            }
            case 2: {
                return "Cos";
            }
            case 1: {
                return "Exp";
            }
            case 4: {
                return "Uni";
            }
        }
        return "Lin";
    }

    public double getWeight(String string) {
        try {
            double d = (Double)this.weightH.get(string);
            return d;
        }
        catch (Exception exception) {
            logger.log((Priority)Level.ERROR, (Object)("feature [" + string + "] not found in user " + this.id + " wH=" + this.weightH));
            exception.printStackTrace();
            System.exit(0);
            return -1.0;
        }
    }

    public double eval(Room room) {
        HashMap hashMap = room.getFeatures();
        double d = 0.0;
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            double d2 = room.normalizeFeature(string);
            d += this.getWeight(string) * this.getUtility(d2);
        }
        return d;
    }

    public double getUtility(double d) {
        double d2 = 0.0;
        switch (this.type) {
            case 1: {
                d2 = Math.exp(d) / 3.0;
                break;
            }
            case 3: {
                d2 = Math.sin(d);
                break;
            }
            case 2: {
                d2 = Math.cos(d);
                break;
            }
            case 4: {
                d2 = 0.5;
                break;
            }
            default: {
                d2 = d;
            }
        }
        return d2;
    }

    public Vector sortRooms(Vector vector) {
        this.pref = new Vector();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Room room = (Room)enumeration.nextElement();
            ValuedObject valuedObject = new ValuedObject(room.getId(), room.getRoomId(), this.eval(room));
            this.pref.add(valuedObject);
        }
        Collections.sort(this.pref, Collections.reverseOrder());
        return this.pref;
    }

    public Vector getSortedRooms() {
        return this.pref;
    }

    public static Vector generateRandomUsers(int n, int n2) {
        Vector<RUser> vector = new Vector<RUser>();
        Random random = new Random();
        for (int i = 0; i < n; ++i) {
            RUser rUser = new RUser(i, n2, random);
            vector.add(rUser);
        }
        return vector;
    }

    public static Vector generateRandomUsers(int n, HashMap hashMap) {
        Vector<RUser> vector = new Vector<RUser>();
        Random random = new Random();
        for (int i = 0; i < n; ++i) {
            RUser rUser = new RUser(i, hashMap, random);
            vector.add(rUser);
        }
        return vector;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

