/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.email.parse;

import cmradar.manager.email.parse.Matchable;
import cmradar.manager.email.parse.NumMatcher;
import cmradar.manager.email.parse.ParseException;
import cmradar.manager.email.parse.RegexMatcher;
import cmradar.manager.email.parse.StringSetMatcher;
import cmradar.manager.email.parse.Token;
import java.util.LinkedList;

public class Parser {
    private LinkedList tokList;
    private int curLine = 0;
    private int curChar = 0;

    public Parser(LinkedList linkedList) {
        this.tokList = (LinkedList)linkedList.clone();
    }

    public LinkedList filterUntil(Matchable matchable, Matchable matchable2) {
        LinkedList<Token> linkedList = new LinkedList<Token>();
        if (this.tokList.isEmpty()) {
            return linkedList;
        }
        Token token = (Token)this.tokList.removeFirst();
        this.curLine = token.getLineIndex();
        this.curChar = token.getCharIndex();
        while (!matchable2.matches(token)) {
            if (matchable.matches(token)) {
                linkedList.addLast(token);
            }
            if (this.tokList.isEmpty()) {
                throw new ParseException(matchable.example(), token.toString(), token.getLineIndex(), token.getCharIndex());
            }
            token = (Token)this.tokList.removeFirst();
            this.curLine = token.getLineIndex();
            this.curChar = token.getCharIndex();
        }
        return linkedList;
    }

    public LinkedList filterWhile(Matchable matchable) {
        LinkedList linkedList = new LinkedList();
        while (!this.tokList.isEmpty() && matchable.matches((Token)this.tokList.getFirst())) {
            linkedList.addLast(this.tokList.removeFirst());
        }
        return linkedList;
    }

    public Token nextToken(Matchable matchable) {
        if (this.tokList.isEmpty()) {
            throw new ParseException(matchable.example(), "End of file", this.curLine, this.curChar);
        }
        Token token = (Token)this.tokList.getFirst();
        if (matchable.matches(token)) {
            this.tokList.removeFirst();
            this.curLine = token.getLineIndex();
            this.curChar = token.getCharIndex();
            return token;
        }
        throw new ParseException(matchable.example(), token.toString(), this.curLine, this.curChar);
    }

    public boolean headMatches(Matchable matchable) {
        if (this.tokList.isEmpty()) {
            return false;
        }
        Token token = (Token)this.tokList.getFirst();
        return matchable.matches(token);
    }

    public boolean hasTokens() {
        return !this.tokList.isEmpty();
    }

    public int getCharIndex() {
        return this.curChar;
    }

    public int getLineIndex() {
        return this.curLine;
    }

    public int nextInt() {
        return Integer.parseInt(this.nextToken(new NumMatcher(Integer.MIN_VALUE, Integer.MAX_VALUE)).toString());
    }

    public int nextInt(int n, int n2) {
        return Integer.parseInt(this.nextToken(new NumMatcher(n, n2)).toString());
    }

    public String nextString(String string) {
        return this.nextToken(new RegexMatcher("[^\\n]+", string)).toString();
    }

    public String nextEnum(String[] stringArray) {
        StringSetMatcher stringSetMatcher = new StringSetMatcher();
        for (int i = 0; i < stringArray.length; ++i) {
            stringSetMatcher.add(stringArray[i]);
        }
        return this.nextToken(stringSetMatcher).toString();
    }
}

