/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.email;

import cmradar.manager.data.Template;
import cmradar.manager.data.TimeSlot;
import cmradar.manager.email.parse.AcceptMatcher;
import cmradar.manager.email.parse.EOLMatcher;
import cmradar.manager.email.parse.Lexer;
import cmradar.manager.email.parse.OrMatcher;
import cmradar.manager.email.parse.ParseException;
import cmradar.manager.email.parse.Parser;
import cmradar.manager.email.parse.RegexMatcher;
import cmradar.manager.email.parse.RejectMatcher;
import cmradar.manager.email.parse.SetMatcher;
import cmradar.manager.email.parse.StringMatcher;
import cmradar.manager.email.parse.Token;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.Random;

public class EmailParser {
    private static final String attendeesFieldLabel = "attendees:";
    private static final String timeFieldLabel = "time:";
    private static final String textFieldLabel = "text:";
    private static final String meetingIdFieldLabel = "meetingid:";

    private static LinkedList parseAttendeeList(Parser parser) {
        LinkedList<String> linkedList = new LinkedList<String>();
        String string = "(\\p{Alnum}|\\+)+@\\p{Alnum}+(\\.\\p{Alnum}+)*";
        RegexMatcher regexMatcher = new RegexMatcher(string, "<email address>");
        StringMatcher stringMatcher = new StringMatcher(",");
        Token token = parser.nextToken(regexMatcher);
        while (parser.headMatches(stringMatcher)) {
            parser.nextToken(stringMatcher);
            linkedList.addLast(token.toString());
            token = parser.nextToken(regexMatcher);
        }
        linkedList.addLast(token.toString());
        return linkedList;
    }

    public static TimeSlot parseTimeSlot(Parser parser) throws java.text.ParseException {
        System.out.println("emailparser.parsets() no longer used");
        System.exit(0);
        return null;
    }

    private static LinkedList parseTimeSlotList(Parser parser) throws java.text.ParseException {
        LinkedList<TimeSlot> linkedList = new LinkedList<TimeSlot>();
        StringMatcher stringMatcher = new StringMatcher("or");
        TimeSlot timeSlot = EmailParser.parseTimeSlot(parser);
        while (parser.headMatches(stringMatcher)) {
            parser.nextToken(stringMatcher);
            linkedList.addLast(timeSlot);
            timeSlot = EmailParser.parseTimeSlot(parser);
        }
        linkedList.addLast(timeSlot);
        return linkedList;
    }

    private static Template parseInitiationRequest(Parser parser) throws java.text.ParseException {
        Object object;
        Object object2;
        Template template = new Template();
        LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = new LinkedList();
        LinkedList linkedList3 = new LinkedList();
        String string = "";
        OrMatcher orMatcher = new OrMatcher(new EOLMatcher(), new RegexMatcher(">*", "should never be seen"));
        StringMatcher stringMatcher = new StringMatcher(attendeesFieldLabel);
        StringMatcher stringMatcher2 = new StringMatcher(timeFieldLabel);
        StringMatcher stringMatcher3 = new StringMatcher(textFieldLabel);
        StringMatcher stringMatcher4 = new StringMatcher("</template>");
        SetMatcher setMatcher = new SetMatcher();
        setMatcher.addMatcher(stringMatcher);
        setMatcher.addMatcher(stringMatcher2);
        setMatcher.addMatcher(stringMatcher3);
        parser.filterWhile(orMatcher);
        while (!parser.headMatches(stringMatcher4)) {
            object2 = parser.nextToken(setMatcher);
            object = object2.toString();
            if (((String)object).equals(attendeesFieldLabel)) {
                linkedList.addAll(EmailParser.parseAttendeeList(parser));
            } else if (((String)object).equals(timeFieldLabel)) {
                linkedList2.addAll(EmailParser.parseTimeSlotList(parser));
            } else if (((String)object).equals(textFieldLabel)) {
                string = parser.nextToken(new AcceptMatcher()).toString();
                setMatcher.removeMatcher(stringMatcher3);
            }
            parser.filterWhile(orMatcher);
        }
        template.meetingId = new Integer(new Random().nextInt(1000)).toString();
        object2 = linkedList.iterator();
        while (object2.hasNext()) {
            template.addAttendant(object2.next().toString(), 1.0);
        }
        object2 = linkedList2.iterator();
        while (object2.hasNext()) {
            object = (TimeSlot)object2.next();
            template.addTimeSlot((TimeSlot)object, "pending");
        }
        template.addPurpose("null", string, "null");
        return template;
    }

    private static Template parseInitiationResponse(Parser parser) throws java.text.ParseException {
        TimeSlot timeSlot;
        Object object;
        Object object2;
        String string = "";
        LinkedList<TimeSlot> linkedList = new LinkedList<TimeSlot>();
        LinkedList<TimeSlot> linkedList2 = new LinkedList<TimeSlot>();
        OrMatcher orMatcher = new OrMatcher(new EOLMatcher(), new RegexMatcher(">*", "should never be seen"));
        StringMatcher stringMatcher = new StringMatcher("</template>");
        OrMatcher orMatcher2 = new OrMatcher(new StringMatcher("OK"), new StringMatcher("NOTOK"));
        StringMatcher stringMatcher2 = new StringMatcher(timeFieldLabel);
        StringMatcher stringMatcher3 = new StringMatcher(meetingIdFieldLabel);
        SetMatcher setMatcher = new SetMatcher();
        setMatcher.addMatcher(stringMatcher2);
        setMatcher.addMatcher(stringMatcher3);
        parser.filterWhile(orMatcher);
        while (!parser.headMatches(stringMatcher)) {
            object2 = parser.nextToken(setMatcher);
            object = object2.toString();
            if (((String)object).equals(meetingIdFieldLabel)) {
                string = parser.nextToken(new RegexMatcher("[^\\n]+", "<meeting id>")).toString();
                setMatcher.removeMatcher(stringMatcher3);
            } else {
                timeSlot = EmailParser.parseTimeSlot(parser);
                Token token = parser.nextToken(orMatcher2);
                if (token.toString().equals("OK")) {
                    linkedList.add(timeSlot);
                } else {
                    linkedList2.add(timeSlot);
                }
            }
            parser.filterWhile(orMatcher);
        }
        object2 = new Template();
        ((Template)object2).meetingId = string;
        object = linkedList.iterator();
        while (object.hasNext()) {
            timeSlot = (TimeSlot)object.next();
            ((Template)object2).addTimeSlot(timeSlot, "pending");
        }
        object = linkedList2.iterator();
        while (object.hasNext()) {
            timeSlot = (TimeSlot)object.next();
            ((Template)object2).addTimeSlot(timeSlot, "impossible");
        }
        return object2;
    }

    public static Template parse(String string) {
        Lexer lexer = new Lexer('#', " \r\t\n\f", ",\\");
        LinkedList linkedList = null;
        try {
            linkedList = lexer.lex(new BufferedReader(new StringReader(string)));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.out.println("Error lexing token stream.");
            System.exit(-1);
        }
        Parser parser = new Parser(linkedList);
        try {
            parser.filterUntil(new RejectMatcher(), new StringMatcher("<template>"));
            parser.filterUntil(new RejectMatcher(), new StringMatcher("command"));
            Token token = parser.nextToken(new OrMatcher(new StringMatcher("initiate-meeting"), new StringMatcher("initiate-meeting-reply")));
            if (token.toString().equals("initiate-meeting")) {
                return EmailParser.parseInitiationRequest(parser);
            }
            if (token.toString().equals("initiate-meeting-reply")) {
                return EmailParser.parseInitiationResponse(parser);
            }
        }
        catch (ParseException parseException) {
            System.out.println("Error parsing email. Expected " + parseException.getExpectedString() + ", but found " + parseException.getFoundString() + " at line " + parseException.getLineIndex() + " character " + parseException.getCharIndex() + ".");
            parseException.printStackTrace();
        }
        catch (java.text.ParseException parseException) {
            System.out.println("Invalid date at line " + parser.getLineIndex() + " character " + parser.getCharIndex());
            parseException.printStackTrace();
        }
        return null;
    }

    public static void main(String[] stringArray) {
        String string = "blah blah blah.\nfoobarbaz\n<template>\ncommand initiate-meeting\n>>> > attendees: mmv@cs.cmu.edu, sfs@cs.cmu.edu, jeanoh@cs.cmu.edu\n>> attendees: aleffert@andrew.cmu.edu, pmodi@cs.cmu.edu\n>>> time: 02.02.2005 11:12 to 12:34 or 02.02.2005 3:56 to 4:08\n\n\n> time: 02.02.2005 13:00 to 14:12\n\n\ntext: \"We need to discuss the next steps for the project!\"\n</template>\n";
        String string2 = "Arbitrary text foo.\nmore stuff\n<template>\ncommand initiate-meeting-reply\nmeetingid: 343523\ntime: 02.02.2005 11:00 to 12:00 OK\ntime: 02.02.2005 3:00 to 4:00 NOTOK\n</template>\n";
        EmailParser.parse(string);
        EmailParser.parse(string2);
    }
}

