/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.data;

import cmradar.manager.data.RoomTemplate;
import cmradar.manager.data.Template;
import cmradar.manager.data.TimeSlot;
import cmradar.manager.sim.SimParameters;
import cmradar.manager.sim.Utility;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class Meeting {
    public String myUserId;
    public String meetingId;
    public String initiator;
    public int weight;
    public static final int SEMINAR = 4;
    public static final int CLASS = 5;
    public static final int CONFERENCE = 6;
    public static final int UNKNOWN_MTG = -1;
    public static final int CORRUPTED = -2;
    public static int RED = 100;
    public static int YELLOW = 99;
    public int type = YELLOW;
    public String description;
    public String status;
    Vector attendants;
    TimeSlot preferredSlot;
    HashMap timeSlotStatus;
    public String bumpedBy = "";
    public Vector bumped;
    public Vector tabooTimes = new Vector();
    public ArrayList requirements;
    double duration = 0.0;
    String[] l = new String[]{"Class", "Lecture", "Teaching"};
    public int label = 0;
    HashMap responseBits = new HashMap();

    public Meeting(String string, String string2, String string3, int n, Vector vector) {
        this.myUserId = string;
        this.meetingId = string2;
        this.initiator = string3;
        this.type = n;
        this.weight = 1;
        this.status = "possible";
        this.attendants = vector;
        this.timeSlotStatus = new HashMap();
        this.bumped = new Vector();
        this.preferredSlot = new TimeSlot();
        this.requirements = new ArrayList();
    }

    public Meeting(String string, String string2, String string3, int n, int n2, Vector vector) {
        this(string, string2, string3, n, vector);
        this.weight = n2;
    }

    public Meeting(String string, String string2, String string3, int n, Vector vector, ArrayList arrayList) {
        this(string, string2, string3, n, vector);
        this.requirements = arrayList;
    }

    public Meeting(String string, String string2, String string3, int n, Vector vector, String string4) {
        this(string, string2, string3, n, vector);
        this.status = string4;
    }

    public Meeting(String string, String string2, String string3, int n, Vector vector, ArrayList arrayList, String string4) {
        this(string, string2, string3, n, vector, arrayList);
        this.status = string4;
    }

    public Meeting(String string, Template template) {
        this(string, template.getMeetingId(), template.getInitiator(), Meeting.typeStringToInt(template.getPredefinedKind()), template.getAttendantIds());
        this.description = template.getDescription();
        this.duration = template.getDuration();
        Vector vector = template.getTimeSlots();
        if (vector.size() > 0) {
            this.preferredSlot = new TimeSlot((TimeSlot)vector.elementAt(0));
            this.preferredSlot.setEST(this.preferredSlot.getStartTimeString());
            this.preferredSlot.setLFT(this.preferredSlot.getFinishTimeString());
        }
        this.requirements = template instanceof RoomTemplate ? ((RoomTemplate)template).requirements : new ArrayList();
    }

    public Meeting(Meeting meeting) {
        this(meeting.myUserId, meeting.meetingId, meeting.initiator, meeting.type, meeting.attendants);
        this.preferredSlot = meeting.preferredSlot;
        this.tabooTimes = meeting.tabooTimes;
        this.requirements = meeting.requirements;
    }

    public void setTimeSlot(TimeSlot timeSlot) {
        timeSlot.setStatus(this.status);
        this.preferredSlot = timeSlot;
        this.timeSlotStatus.put(timeSlot, this.status);
    }

    public void setType(int n) {
        this.type = n;
    }

    public void setUserId(String string) {
        this.myUserId = string;
    }

    public void setMeetingId(String string) {
        this.meetingId = string;
    }

    public void setPreferredSlot(TimeSlot timeSlot) {
        this.preferredSlot = timeSlot;
    }

    public TimeSlot getPreferredSlot() {
        return this.preferredSlot;
    }

    public void setStatus(String string) {
        this.status = string;
    }

    public String getStatus() {
        return this.status;
    }

    public void setRequirements(ArrayList arrayList) {
        this.requirements = arrayList;
    }

    public ArrayList getRequirements() {
        return this.requirements;
    }

    public boolean isBumped() {
        return this.status == "bumped";
    }

    public boolean isConfirmed() {
        return this.status == "confirmed";
    }

    public boolean isPending() {
        return this.status == "pending";
    }

    public boolean isPossible() {
        return this.status == "possible";
    }

    public void setConfirmed() {
        this.status = "confirmed";
    }

    public void setPending() {
        this.status = "pending";
    }

    public void setInitiator(String string) {
        this.initiator = string;
    }

    public String getInitiator() {
        return this.initiator;
    }

    public String getMeetingId() {
        return this.meetingId;
    }

    public String getDescription() {
        return this.description;
    }

    public int getWeight() {
        return this.weight;
    }

    public Vector getAttendantIds() {
        return this.attendants;
    }

    public int getNumAttendants() {
        return this.attendants.size();
    }

    public void addAttendant(String string) {
        for (int i = 0; i < this.attendants.size(); ++i) {
            if (!((String)this.attendants.get(i)).equals(string)) continue;
            return;
        }
        this.attendants.add(string);
    }

    public boolean isAttendant(String string) {
        for (int i = 0; i < this.attendants.size(); ++i) {
            if (!((String)this.attendants.get(i)).equals(string)) continue;
            return true;
        }
        return false;
    }

    public void deleteAttendant(String string) {
        for (int i = 0; i < this.attendants.size(); ++i) {
            if (!this.attendants.get(i).equals(string)) continue;
            Iterator iterator = this.timeSlotStatus.keySet().iterator();
            while (iterator.hasNext()) {
                ((HashMap)this.timeSlotStatus.get(iterator.next())).put(string, null);
            }
            this.attendants.remove(i);
            return;
        }
    }

    public String timeSlotStatusToPrettyString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.timeSlotStatus.keySet().iterator();
        while (iterator.hasNext()) {
            TimeSlot timeSlot = (TimeSlot)iterator.next();
            stringBuffer.append(timeSlot.toPrettyString() + ": \n");
            for (int i = 0; i < this.attendants.size(); ++i) {
                String string = (String)this.attendants.elementAt(i);
                String string2 = this.getTimeSlotStatus(string, timeSlot);
                stringBuffer.append("  " + string + " " + string2 + "\n");
            }
        }
        return stringBuffer.toString();
    }

    public void clearTimeSlots() {
        this.timeSlotStatus = new HashMap();
    }

    public void clearPendingTimeSlots() {
        this.timeSlotStatus = new HashMap();
    }

    public String getTimeSlotStatus(String string, TimeSlot timeSlot) {
        HashMap hashMap = (HashMap)this.timeSlotStatus.get(timeSlot);
        if (hashMap != null) {
            return (String)hashMap.get(string);
        }
        return "unknown";
    }

    public void setTimeSlotStatus(TimeSlot timeSlot, String string) {
        timeSlot.setStatus(string);
        Iterator iterator = this.getAttendantIds().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            this.setTimeSlotStatus(string2, timeSlot, string);
        }
    }

    public void setTimeSlotStatus(String string, TimeSlot timeSlot, String string2) {
        HashMap hashMap;
        timeSlot.setStatus(string2);
        if (this.timeSlotStatus.containsKey(timeSlot)) {
            hashMap = (HashMap)this.timeSlotStatus.get(timeSlot);
        } else {
            hashMap = new HashMap();
            for (int i = 0; i < this.attendants.size(); ++i) {
                String string3 = (String)this.attendants.elementAt(i);
                hashMap.put(string3, "unknown");
            }
            this.timeSlotStatus.put(timeSlot, hashMap);
        }
        hashMap.put(string, string2);
    }

    public Vector getUnion(String string) {
        Vector<TimeSlot> vector = new Vector<TimeSlot>();
        Iterator iterator = this.timeSlotStatus.keySet().iterator();
        block0: while (iterator.hasNext()) {
            TimeSlot timeSlot = (TimeSlot)iterator.next();
            boolean bl = true;
            for (int i = 0; i < this.attendants.size(); ++i) {
                String string2;
                String string3 = (String)this.attendants.elementAt(i);
                if (this.myUserId.equals(string3) || !string.equals(string2 = this.getTimeSlotStatus(string3, timeSlot))) continue;
                vector.add(timeSlot);
                continue block0;
            }
        }
        return vector;
    }

    public Vector getAllImpossibleUnion() {
        return this.getUnion("impossible");
    }

    public Vector getIntersection(String string) {
        Vector<TimeSlot> vector = new Vector<TimeSlot>();
        Iterator iterator = this.timeSlotStatus.keySet().iterator();
        while (iterator.hasNext()) {
            TimeSlot timeSlot = (TimeSlot)iterator.next();
            boolean bl = true;
            for (int i = 0; i < this.attendants.size(); ++i) {
                String string2;
                String string3 = (String)this.attendants.elementAt(i);
                if (this.myUserId.equals(string3) || string.equals(string2 = this.getTimeSlotStatus(string3, timeSlot))) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            vector.add(timeSlot);
        }
        return vector;
    }

    public TimeSlot getOneIntersection(String string) {
        Vector vector = this.getIntersection(string);
        if (vector.size() > 0) {
            return (TimeSlot)vector.elementAt(0);
        }
        return null;
    }

    public TimeSlot getPossibleIntersection() {
        return this.getOneIntersection("possible");
    }

    public TimeSlot getPendingIntersection() {
        return this.getOneIntersection("pending");
    }

    public Vector getAllPendingIntersection() {
        return this.getIntersection("pending");
    }

    public Vector getAllPossibleIntersection() {
        return this.getIntersection("possible");
    }

    public String displayString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getMeetingId());
        Vector vector = this.getAttendantIds();
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = (String)vector.elementAt(i);
            if (string2.equals(string)) continue;
            stringBuffer.append(", " + string2);
        }
        return stringBuffer.toString();
    }

    public Vector getTimeSlots() {
        Vector<TimeSlot> vector = new Vector<TimeSlot>();
        Iterator iterator = this.timeSlotStatus.keySet().iterator();
        while (iterator.hasNext()) {
            vector.add((TimeSlot)iterator.next());
        }
        return vector;
    }

    public Vector getTimeSlotsFromStatus(String string) {
        Vector<TimeSlot> vector = new Vector<TimeSlot>();
        Vector vector2 = this.getTimeSlots();
        for (int i = 0; i < vector2.size(); ++i) {
            TimeSlot timeSlot = (TimeSlot)vector2.elementAt(i);
            if (!timeSlot.getStatus().equalsIgnoreCase(string)) continue;
            vector.add(timeSlot);
        }
        return vector;
    }

    public Vector getImpossibleTimeSlots() {
        return this.getTimeSlotsFromStatus("impossible");
    }

    public Vector getPossibleTimeSlots() {
        return this.getTimeSlotsFromStatus("possible");
    }

    public Vector getPendingTimeSlots() {
        return this.getTimeSlotsFromStatus("pending");
    }

    public TimeSlot getConfirmedTimeSlot() {
        Vector vector = this.getTimeSlotsFromStatus("confirmed");
        if (vector.size() > 1) {
            System.out.println("Meeting.java: More than one confirmed timeslot!");
            System.out.println(" Seems like an error...");
            System.out.println(this.timeSlotStatusToPrettyString());
            Utility.waitForKey(true);
        }
        if (vector.size() == 1) {
            return (TimeSlot)vector.elementAt(0);
        }
        return null;
    }

    public TimeSlot getBumpedTimeSlot() {
        Vector vector = this.getTimeSlotsFromStatus("bumped");
        if (vector.size() > 1) {
            System.out.println("Meeting.java: More than one bumped timeslot!");
            System.out.println(" Seems like an error...exiting...");
            System.exit(0);
        }
        if (vector.size() == 1) {
            return (TimeSlot)vector.elementAt(0);
        }
        return null;
    }

    public String toLispList() {
        return this.toTemplate().toLispList();
    }

    public Template toTemplate() {
        Template template = new Template();
        template.meetingId = this.meetingId;
        template.initiator = this.initiator;
        for (int i = 0; i < this.attendants.size(); ++i) {
            String string = (String)this.attendants.get(i);
            template.addAttendant(string, 1.0);
        }
        Vector vector = this.getTimeSlots();
        for (int i = 0; i < vector.size(); ++i) {
            TimeSlot timeSlot = (TimeSlot)vector.elementAt(i);
            template.addTimeSlot(timeSlot, this.getTimeSlotStatus(this.myUserId, timeSlot));
        }
        template.addPurpose(this.getTypeString(), this.getDescription(), "nil");
        return template;
    }

    public RoomTemplate toRoomTemplate() {
        RoomTemplate roomTemplate = new RoomTemplate();
        roomTemplate.meetingId = this.meetingId;
        roomTemplate.initiator = this.initiator;
        roomTemplate.duration = this.duration;
        for (int i = 0; i < this.attendants.size(); ++i) {
            String string = (String)this.attendants.get(i);
            roomTemplate.addAttendant(string, 1.0);
        }
        Iterator iterator = this.timeSlotStatus.keySet().iterator();
        while (iterator.hasNext()) {
            roomTemplate.addTimeSlot((TimeSlot)iterator.next(), this.status);
        }
        roomTemplate.addPurpose(this.getTypeString(), this.getDescription(), "nil");
        return roomTemplate;
    }

    public String toParseString() {
        return this.toParseString(3600L);
    }

    public double getDuration() {
        return this.duration;
    }

    public void setDuration(double d) {
        this.duration = d;
    }

    public String toParseString(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        TimeSlot timeSlot = this.getConfirmedTimeSlot();
        stringBuffer.append("Id\t" + this.getMeetingId() + "\n");
        stringBuffer.append("Initiator\t" + this.getInitiator() + "\n");
        stringBuffer.append("Duration\t" + String.valueOf((int)this.duration) + "\n");
        stringBuffer.append("Type\t" + this.getTypeString() + "\n");
        stringBuffer.append("Weight\t" + this.getWeight() + "\n");
        stringBuffer.append("Attendants\t");
        Vector vector = this.getAttendantIds();
        for (int i = 0; i < vector.size() - 1; ++i) {
            String string = (String)vector.elementAt(i);
            stringBuffer.append(string + ",10,");
        }
        if (vector.size() > 0) {
            String string = (String)vector.lastElement();
            stringBuffer.append(string + ",10");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public void writeToFile(String string, boolean bl) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string, bl));
            bufferedWriter.write("---\n");
            bufferedWriter.write(this.toParseString());
            bufferedWriter.close();
        }
        catch (Exception exception) {
            System.out.println("Error in Meeting.writeToFile(" + string + "): " + exception.toString());
            exception.printStackTrace();
        }
    }

    public void appendTrueStatusFile() {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(SimParameters.trueStatusFile, true));
            bufferedWriter.write(this.meetingId + " " + this.status + "\n");
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            System.err.println("SharedRoomCalendar.writeToFile(): Error writing to file: " + SimParameters.trueStatusFile);
        }
    }

    public static int typeStringToInt(String string) {
        if (string.equals(":red")) {
            return RED;
        }
        if (string.equals(":yellow")) {
            return YELLOW;
        }
        if (string.equals("nil")) {
            return YELLOW;
        }
        if (string.equalsIgnoreCase("class")) {
            return 5;
        }
        if (string.equalsIgnoreCase("seminar")) {
            return 4;
        }
        if (string.equalsIgnoreCase("conference")) {
            return 6;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public String getTypeString() {
        return Meeting.getTypeString(this.type);
    }

    public static String getTypeString(int n) {
        if (n == RED) {
            return ":red";
        }
        if (n == YELLOW) {
            return ":yellow";
        }
        if (n == 5) {
            return "class";
        }
        if (n == 6) {
            return "conference";
        }
        if (n == 4) {
            return "seminar";
        }
        if (n == -2) {
            return "corrupted";
        }
        return String.valueOf(n);
    }

    public Color getColor() {
        if (this.type == RED) {
            return Color.red;
        }
        if (this.type == YELLOW) {
            Color color = Color.yellow;
            return color;
        }
        return Color.white;
    }

    public String getMeetingLabel() {
        return this.getMeetingId();
    }

    public void clearResponseBits() {
        this.responseBits = new HashMap();
    }

    public void setResponseBit(String string, TimeSlot timeSlot) {
        if (this.responseBits.containsKey(timeSlot)) {
            HashMap hashMap = (HashMap)this.responseBits.get(timeSlot);
            hashMap.put(string, new Boolean(true));
        }
    }

    public void addResponseBit(String string, TimeSlot timeSlot) {
        if (this.responseBits.containsKey(timeSlot)) {
            HashMap hashMap = (HashMap)this.responseBits.get(timeSlot);
            hashMap.put(string, new Boolean(false));
        } else {
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            hashMap.put(string, new Boolean(false));
            this.responseBits.put(timeSlot, hashMap);
        }
    }

    public boolean allResponseBitsSet() {
        Iterator iterator = this.responseBits.keySet().iterator();
        while (iterator.hasNext()) {
            TimeSlot timeSlot = (TimeSlot)iterator.next();
            HashMap hashMap = (HashMap)this.responseBits.get(timeSlot);
            Iterator iterator2 = hashMap.keySet().iterator();
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                Boolean bl = (Boolean)hashMap.get(string);
                if (bl.booleanValue()) continue;
                return false;
            }
        }
        return true;
    }
}

