% Starter Code for Q1.1 HW4 

close all;
clear all;
randn('seed', 0);
rand('seed', 0);

% Toy Problem 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Problem data
f = @(t) -2*t + 5*t.^2 + sin(5*t) + 25;
% Training set
XTrain = [0.1; 0.4; 0.6; 0.9];
YTrain = f(XTrain); 

% TODO: Write function to choose hyper parameters for your kernel here.
hyperParams = chooseHyperParams(XTrain, YTrain);

% Now obtain the predictions at the test points
XTest = linspace(0,1,100)';
YTest = f(XTest);
% TODO: Write function to implement GP Regression here.
[postMean, postVar] = GPRegression(XTrain, YTrain, XTest, hyperParams);

% Draw Samples
numSamples = 100;
% TODO: Write function to draw samples from a GP here.
samples = GPDrawSamples(postMean, postVar, numSamples);

% Plot the samples, the predictions and the truth
figure; hold on,
for i = 1:numSamples
  plot(XTest, samples(i, :), 'm');
end
plot(XTest, postMean, 'b', 'Linewidth', 3);
plot(XTest, YTest, 'g', 'Linewidth', 3);
plot(XTrain, YTrain, 'kx', 'MarkerSize', 10, 'Linewidth', 3);

% Print out errors
fprintf('Error: %.4f\n', sqrt(mean( (postMean - YTest).^2)) );

% Print out the predictions
postMean(1:5),
postVar(1:5, 1:5),


% CCPP Dataset
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
load('ccpp.mat');
hyperParams = chooseHyperParams(XTrain, YTrain);
[postMean, postVar] = GPRegression(XTrain, YTrain, XTest, hyperParams);
fprintf('Error: %0.4f\n', sqrt(mean((postMean-YTest).^2)) );

% Print out the predictions
postMean(1:5),
postVar(1:5, 1:5),

