function [postMean, postVar] = GPRegression(XTrain, YTrain, XTest, hyperParams)

  % prelims
  h = hyperParams.h;
  sigma = hyperParams.sigma;
  L = hyperParams.L;
  alpha = hyperParams.alpha;
  eta = hyperParams.eta;
  priorMean = hyperParams.priorMean;

  % Obtain the predictions
  y = YTrain - priorMean;
  Ktrte = GaussKernel(XTrain, XTest, sigma, h);
  Ktete = GaussKernel(XTest, XTest, sigma, h);
  Ktete(1:5, 1:5),
  v = L \ Ktrte;
  postMean = priorMean + Ktrte' * alpha;
  postVar = Ktete - v' * v;

end

