function samples = GPDrawSamples(mu, K, numSamples)
% A function for drawing samples from a Gaussian Process
% V is a num_samples x m matrix, each row corresponding to a sample

  num_pts = size(mu,1);

  L = stableCholesky(K);
  Z = randn(num_pts, numSamples);
  samples = real(bsxfun(@plus, L*Z, mu))';

end
