function [ samples ] = metropolis( x0, mu, burnin, nsamples, sigma )
%METROPOLIS 
%   Proposal distribution is Gaussian
% bimodal distribution is N(-\mu,1) + N(\mu,1).
% proposal distribution q(.|x) = N(x,sigma^2)

x = x0;
samples = zeros(nsamples,1);

for t=1:burnin + nsamples
xtmp = normrnd(x, sigma^2);

%z = exp(0.5 *( (abs(x) -mu)^2 - (abs(xtmp) -mu)^2 )) * ...
%    (1+exp(-2*mu*abs(xtmp))) / (1+exp(-2*mu*abs(x)));
ztmp = normpdf(xtmp,mu,1) + normpdf(xtmp,-mu,1);
z = normpdf(x,mu,1) + normpdf(x,-mu,1);
acceptance = min(1,ztmp/z);
if( rand() <= acceptance )
  x = xtmp;
end 
if( t > burnin )
  samples(t-burnin) = x;
end

end

