function [ samples ] = gibbs( x, z0, mu0, burnin, nsamples )
%GIBBS Gibbs sampler for Gaussian Mixture model

% x : nx2, z0:nx1, mu0:Kx2

n = size(z0,1);
K = size(mu0,1);

z = z0;
mu = mu0;

samples = zeros(nsamples, n+2*K);
for t=1:burnin + nsamples
    
    fprintf('t=%d\n', t);
    % sample z_i's
    % p(z_i=k|rest) \propto exp( -(\mu_k - x_i)^2/2 )

    for i=1:n            
        weights = exp(- 0.5 * sum(( repmat(x(i,:),K,1) - mu ) .^2,2) );
        z(i) = randsample(K,1,true,weights);
    end

    % sample mu_k's
    % p(mu_k=u|rest) \propto N( 1/(1+nk) \sum_{j:z_j = k} x_j, 1/(1+nk) I)
    for k=1:K
        points_in_cluster = find(z == k);
        nk = length(points_in_cluster);
        cluster_mean = sum( x(points_in_cluster,:), 1 ) ./ (1+nk);
        cluster_sigma = sqrt(1/(1+nk));
        mu(k,:) = mvnrnd(cluster_mean, cluster_sigma^2 * eye(2));
    end
    

if( t > burnin )
  samples(t-burnin, :) = [z; mu(:)]';
end

end

