function [prob, alpha] = fwd( prior, P, E, o )
%% Computes prob = P(o)
% alpha(k,t) = P(x_1,x_2,...,x_t, y_t = k)

T = numel(o);
S = numel(prior);
alpha = zeros(S, T);

alpha(:,1) = prior .* E(:, o(1));

for t=2:T
    alpha(:,t) = E(:,o(t)) .* ( P' * alpha(:,t-1));    
end

prob = sum(alpha(:,T));

end

% To run
% load('params_viterbi.mat')
% [prob, alpha] = fwd(prior, transition, emission, observations);
