#!/usr/bin/python
################################################################################
# [Your Name]
# CS 15-745
################################################################################
import os
import sys
from sys import stderr
from pprint import pprint

def die(msg):
    stderr.write(msg + "\n")
    sys.exit(1)

def main():
    # Read the filenames from the command line.
    ArgNames = "InPuz OutSol SatExec TempToSat TempFromSat"
    if len(sys.argv) < 6:
        die("Usage: " + sys.argv[0] + " " + ArgNames + "\n")
    filenames = dict(zip(ArgNames.split(), sys.argv[1:]))

    # Read the puzzle
    InPuz = open(filenames['InPuz'], "r")
    board = []  # board[r][c] will hold the number in row r, column c.
    for line in InPuz:
        board.append([int(x) for x in line.split()])
    bsize = len(board)
    for row in board: assert(len(row) == bsize)
    #pprint(board)

    # Write the SAT problem in DIMACS
    TempToSat = open(filenames['TempToSat'], "w")
    # TODO: Delete the below dummy statement and write the code to generate
    # a CNF encoding of the Sudoku puzzle in DIMACS format.
    TempToSat.write(
        """
        p cnf 4 5
        1 0 
        2 -3 0
        -4 -1 0
        -1 -2 3 4 0
        -2 4 0
        """
    )
    TempToSat.close()

    # Execute MiniSAT
    if (os.path.exists(filenames['TempFromSat'])):
        os.system("rm " + filenames['TempFromSat'])
    os.system(
        "bash -c '" +
        " ".join([filenames[x] for x in ['SatExec','TempToSat','TempFromSat']])
        + " &> minisat.log'"
    )

    # Read the solution from MiniSAT
    if (not os.path.exists(filenames['TempFromSat'])):
        print "Error: No output from MiniSAT!"
        os.system("cat minisat.log")
        sys.exit(1)
    TempFromSat = open(filenames['TempFromSat'], "r")
    ans = TempFromSat.readline()
    if (ans != "SAT\n"):
        die("Unsatisfiable: ")
    SolnVals = [int(x) for x in TempFromSat.readline().split()]
    # TODO: Update the board based on the solution generated by MiniSAT.

    # Write the solution
    OutSol = open(filenames['OutSol'], "w")
    for row in board:
        OutSol.write(" ".join(str(x) for x in row) + "\n")
    OutSol.close()

main()
