(setf *sinetab* (build-harmonic 1.0 4096))
(setf *sinetab* (list *sinetab* (hz-to-step 1) T))

(setf *sawtab* (pwlvr -1 1 1))		; eh, creepy way to get 2205 samples.
(setf *sawtab* (list *sawtab* (hz-to-step 1) T))

(setf *tritab* (pwlvr -1 0.5 1 0.5 -1))
(setf *tritab* (list *tritab* (hz-to-step 1) T))

(setf *idshape*  (pwlvr -1 2 1 .01 1))	            ; identity
(setf *stepshape* (seq (const -1) (const 1 1.01)))  ; hard step at zero

;;; arithmetic

(setf Pi 3.14159265358979)

(defun square (x) (* x x))
(defun sinh (x) (* 0.5 (- (exp x) (exp (- x)))))

;;; predicates

(defun neq (a b) (not (eq a b)))

;;; strings

; to list of characters
(defun string-to-list (str)
  (let ((lis nil)
	(len (length str)))
    (dotimes (i len) (setq lis (cons (char str (- len i 1)) lis)))
    lis))

;(string-to-list "abc")

;;; lists


;;; association lists

; puke if not found
(defun loud-assoc (key alist)
  (let ((ass (assoc key alist)))
    (if ass ass (break (strcat "loud-assoc on " (symbol-name key))))))

; destructive alist functions: get, put, and delete.
(defun aget (alist key) (cadr (loud-assoc key alist)))
(defun aput (alist key val)
  (let* ((ass (assoc key alist)))
    (if ass (rplacd ass (list val))
            (nconc alist (list (list key val))))))
(defun adel (alist key) (delete alist (assoc key alist)))

;;; operations on sounds

(defun diff (x y) (sum x (prod -1 y)))

; compare-shape is a shape table -- origin 1.
(defun compare (x y &optional (compare-shape *stepshape*))
  (let ((xydiff (diff x y)))
    (shape xydiff compare-shape 1)))

(defun s-length (snd)
  (let* ((maxsamples 1234567)
	 (samples (snd-length snd maxsamples)))
	(if (eq samples maxsamples) 
	    (break "s-length")
	    samples)))

(defun s-duration (snd)
  (/ (s-length snd) (snd-srate snd)))

;;; control

(defun exp-dec (hold halfdec length)
  (let* ((target (expt 0.5 (/ length halfdec)))
	 (expenv (pwev 1 hold 1 length target)))
	expenv)
)

;;; oscs

(defun osc-saw (hz) (hzosc hz *sawtab*))
(defun osc-tri (hz) (hzosc hz *tritab*))

; bias is [-1, 1] pulse width.  sound or scalar.
; hz is a sound.
(defun osc-pulse (hz bias &optional (compare-shape *stepshape*))
  (compare bias (osc-tri hz) compare-shape))

; hz is a scalar.
(defun osc-pulse-dur (hz bias dur &optional (compare-shape *stepshape*))
  (compare bias (osc-tri (const hz dur)) compare-shape))

;;; transformations and behaviors

