% test eubsync8.

clear;

global fsync tsync nsync;
global f_nom;
f_nom = 44100;
fsync = 1;
tsync = 1;
nsync = f_nom;

net_jit = 200e-6;

if (0)	% test
	driftmode = 999;
	net_rt = 0.001;		ns_sm_err = 0.5/f_nom;
	Kp = 0.10 / f_nom;	Ki = 0.01 / f_nom;	
	yKp = 0.05;		yKi = 0.0005;
	yover = 1;
	hours = 10/60;
	
	drive8(hours, 1, driftmode, Kp, Ki, yKp, yKi, yover, net_rt, net_jit, ns_sm_err);
end;

if (0)	% test w/o synthclock
	driftmode = 1;
	net_rt = 0.001;		ns_sm_err = 0.5/f_nom;
	Kp = 0.10 / f_nom;	Ki = 0.01 / f_nom;	
	hours = 10/60;
	
	drive8(hours, 0, driftmode, Kp, Ki, 0, 0, 0, net_rt, net_jit, ns_sm_err);
end;

	% real stuff

nosyn = 1;

if (nosyn)	% no synthclock.  low sample noise.
	driftmode = 2;
	net_rt = 0.001;		ns_sm_err = 0.5/f_nom;
	Kp = 0.10 / f_nom;	Ki = 0.01 / f_nom;	
	yKp = 0.05;		yKi = 0.0005;
	yover = 1;
	hours = 24;
	
	drive8(hours, 0, driftmode, Kp, Ki, yKp, yKi, yover, net_rt, net_jit, ns_sm_err);
end;

if (nosyn)	% no synthclock.  high sample noise.
	driftmode = 2;
	net_rt = 0.001;		ns_sm_err = 0.005;
	Kp = 0.10 / f_nom;	Ki = 0.01 / f_nom;	
	yKp = 0.05;		yKi = 0.0005;
	yover = 1;
	hours = 24;
	
	drive8(hours, 0, driftmode, Kp, Ki, yKp, yKi, yover, net_rt, net_jit, ns_sm_err);
end;

if (0)	% synthclock 20.  high sample noise.
	driftmode = 2;
	net_rt = 0.001;		ns_sm_err = 0.005;
	Kp = 0.10 / f_nom;	Ki = 0.01 / f_nom;	
	yKp = 0.05;		yKi = 0.0005;
	yover = 20;
	hours = 24;
	
	drive8(hours, 1, driftmode, Kp, Ki, yKp, yKi, yover, net_rt, net_jit, ns_sm_err);
end;

if (0)	% synthclock 20, low yK.  high sample noise.
	driftmode = 0;
	net_rt = 0.001;		ns_sm_err = 0.005;
	Kp = 0.10 / f_nom;	Ki = 0.01 / f_nom;	
	yKp = 0.02;		yKi = 0.0002;
	yover = 10;
	hours = 1/6;
	
	drive8(hours, 1, driftmode, Kp, Ki, yKp, yKi, yover, net_rt, net_jit, ns_sm_err);
end;
