function [tm, tm_sp, ps_ctrl] = eubsync8(fm, fs, fym, fys, ns_sm_err, net_roundtrip, net_jitter, Kp, Ki, yover, yKp, yKi)
%
% PI control for master/slave synchronization problem.
% run w/ script8.m
% for args and return values, see listing of variables below.
%
% changes from 7: runs s-c tracker yover times per sync step.
%
% changes from 6: sample-clock tracker from clocktrack6 merged in.
%
% changes from 5: smoothing cleaned out.
% sim includes both fm and fs drift.
%

%global yum ytm nm nm_mm nm_mp yem yiem;
%global yus yts ns ns_sm ns_sp yes yies;
%global tm_mm tm_mp tm_sm;
%global ts_sm ts_sp;

% variables:
% psync		period between synchronizations
% tsync		times at which synchronizations happen
% 
% tm 		master time
% tm_mm			tm as measured by master
% tm_sm			tm as measured by slave
% tm_sm_err			error for this measurement (secs)
% tm_sp			tm as predicted by slave
% d_tm_sp			derivative of tm_sp
% dd_tm_sp			second derivative of tm_sp
% tm_true_err	slave's true timing error: tm minus tm_sp
% tm_sp_err	slave's measured timing error: tm_sm minus tm_sp
% i_tm_sp_err		integral of tm_sp_err
% 
% fs		slave frequency
% ns		slave sample count
% ns_sm			ns as measured by slave
% ns_sm_err			error in this measurement (secs)
%
% ps_ctrl	slave sample period, generated by PI controller.
% Kp		weight of tm_sp_err in updating ps_ctrl
% Ki		weight of i_tm_sp_err

% initialize simulation
global f_nom fsync;

ns = 0;			% slave sample count

% init sync code 

I = length(fs);

z = zeros(1, I);
tsync = z;
tm = z;
tm_sm = z;
ps_ctrl = z;
tm_sp = z;
d_tm_sp = z;
dd_tm_sp = z;
tm_sp_err = z;
i_tm_sp_err = z;

ps_ctrl(1) = 1 / f_nom;			% initial value
if (Ki > 0)
	i_tm_sp_err(1) = 1/(f_nom*Ki);		% um...
	% for no glitch, seems necessary to start off w/ _asymptotic_ value.
	% 1/fnom = ps_ctrl(i) = Kp * tm_sp_err(i) + Ki * i_tm_sp_err(i)
	% tm_sp_err(inf) = 0
	% 1/fnom = Ki * i_tm_sp_err(inf)
	% i_tm_sp_err(inf) = 1/(fnom*Ki)
else
	i_tm_sp_err(1) = 0;			% whatever
end;

[yum ytm nm nm_mm nm_mp yem yiem] = clocktrack6init(I, f_nom, yKi);
[yus yts ns ns_sm ns_sp yes yies] = clocktrack6init(I, f_nom, yKi);

for i = 2:I
	psync = 1/fsync;

% clocktrack: step the crystals, take measurements.

	% copy values in
	ytm0 = ytm(i-1);	nm0 = nm(i-1);	nm_mm0 = nm_mm(i-1);
	nm_mp0 = nm_mp(i-1);	yum0 = yum(i-1);	yiem0 = yiem(i-1);
	yts0 = yts(i-1);	ns0 = ns(i-1);	ns_sm0 = ns_sm(i-1);
	ns_sp0 = ns_sp(i-1);	yus0 = yus(i-1);	yies0 = yies(i-1);

	% iterate
	for iy = 1:yover
		% master
		nm_mm_err = ns_sm_err;
		[yum0 ytm0 nm0 nm_mm0 nm_mp0 yem0 yiem0] = clocktrack6(f_nom, psync/yover, fym(i), fm(i), ytm0, nm0, nm_mm0, nm_mp0, nm_mm_err*f_nom, yum0, yiem0, yKp, yKi);

		% slave
		[yus0 yts0 ns0 ns_sm0 ns_sp0 yes0 yies0] = clocktrack6(f_nom, psync/yover, fys(i), fs(i), yts0, ns0, ns_sm0, ns_sp0, ns_sm_err*f_nom, yus0, yies0, yKp, yKi);
	end
	% copy values out
	ytm(i) = ytm0;	nm(i) = nm0;	nm_mm(i) = nm_mm0;	yem(i) = yem0;
	nm_mp(i) = nm_mp0;	yum(i) = yum0;	yiem(i) = yiem0;
	yts(i) = yts0;	ns(i) = ns0;	ns_sm(i) = ns_sm0;	yes(i) = yes0;
	ns_sp(i) = ns_sp0;	yus(i) = yus0;	yies(i) = yies0;

	tm(i) = nm(i) / f_nom;

% measurements of time
	tm_mm(i) = nm_mm(i) / f_nom;
	tm_mp(i) = nm_mp(i) / f_nom;

	% network jitter:
	network_err = net_jitter * randu(-1,1);
	% slave's ratio-error in predicting its sample clock:
	slave_sample_clock_err = f_nom./yus(i) - fys(i);
	% slave's consequent mismeasurement of net roundtrip interval:
	interval_err = net_roundtrip * slave_sample_clock_err;
	tm_sm(i) = tm_mp(i) + network_err + interval_err;

% make a prediction
	incr_ns_sp = ns_sp(i) - ns_sp(i-1);
	incr_tm_sp = incr_ns_sp * ps_ctrl(i-1);
	% advance prediction of master time
	tm_sp(i) = tm_sp(i-1) + incr_tm_sp;

% control ps_ctrl
	tm_sp_err(i) = tm_sm(i) - tm_sp(i);			% error
	i_tm_sp_err(i) = i_tm_sp_err(i-1) + tm_sp_err(i);	% integrate it
	ps_ctrl(i) = Kp * tm_sp_err(i) + Ki * i_tm_sp_err(i);	% PI

% get sim data out
	tm_true_err(i) = tm(i) - tm_sp(i);
end

%	[u(n) tc(n) ts(n) ts_o(n) ts_p(n) e(n) ie(n)] = clocktrack6(fs_nom, dt, fc(n), fs(n), tc(n-1), ts(n-1), ts_o(n-1), ts_p(n-1), err_ts, u(n-1), ie(n-1), Kp, Ki);

%	[yum(i) ytm(i) nm(i) nm_mm(i) nm_mp(i) yem(i) iyem(i)] = clocktrack6(f_nom, psync, fc(i), fs(i), ytm(i-1), nm(i-1), nm_mm(i-1), nm_mp(i-1), err_ts, yum(i-1), yiem(i-1), yKp, yKi);
% 	master:
% fs_nom = f_nom, dt = psync
% fc = fym, fs = fm
% tc = ytm, ts = nm, ts_o = nm_mm, ts_p = nm_mp
% err_ts = err_nm_mm
% u = yum, e = yem, ie = yiem
% Kp = yKp, Ki = yKi

%	[yus(i) yts(i) ns(i) ns_sm(i) ns_sp(i) yes(i) yies(i)] = clocktrack6(f_nom, psync, fys(i), fs(i), yts(i-1), ns(i-1), ns_sm(i-1), ns_sp(i-1), err_ns_sm, yus(i-1), yies(i-1), yKp, yKi);
% 	slave:
% fs_nom = f_nom, dt = psync
% fc = fys, fs = fs
% tc = yts, ts = ns, ts_o = ns_sm, ts_p = ns_sp
% err_ts = err_ns_sm
% u = yus, e = yes, ie = yies
% Kp = yKp, Ki = yKi
