function [tm, tm_sp, ps_ctrl] = eubsync6(fm, fs, tm_sm_err, ns_sm_err, Kp, Ki)
%
% changes from 5: smoothing cleaned out.
% sim includes both fm and fs drift.
% deferred to 7: sample-clock tracker from clocktrack6 merged in.
%
% PI control for master/slave synchronization problem.
% run w/ script6.m
% for args and return values, see listing of variables below.
%
% bugfix: master now has error reading its sample count -- ns_sm_err reused.
% is_ctrl has been renamed ps_ctrl -- p for sample _p_eriod.
% and dtsync has been renamed psync, sync period.
%

% variables:
% psync		period between synchronizations
% tsync		times at which synchronizations happen
% 
% tm 		master time
% tm_mm			tm as measured by master
% tm_sm			tm as measured by slave
% tm_sm_err			error for this measurement (secs)
% tm_sp			tm as predicted by slave
% d_tm_sp			derivative of tm_sp
% dd_tm_sp			second derivative of tm_sp
% tm_true_err	slave's true timing error: tm minus tm_sp
% tm_sp_err	slave's measured timing error: tm_sm minus tm_sp
% i_tm_sp_err		integral of tm_sp_err
% 
% fs		slave frequency
% ns		slave sample count
% ns_sm			ns as measured by slave
% ns_sm_err			error in this measurement (secs)
%
% ps_ctrl	slave sample period, generated by PI controller.
% Kp		weight of tm_sp_err in updating ps_ctrl
% Ki		weight of i_tm_sp_err

% initialize simulation
global f_nom fsync;

ns = 0;			% slave sample count

% init sync code 

I = length(fs);

z = zeros(1, I);
tsync = z;
tm = z;
tm_sm = z;
nm = z;
ns = z;
ns_sm = z;
ps_ctrl = z;
tm_sp = z;
d_tm_sp = z;
dd_tm_sp = z;
tm_sp_err = z;
i_tm_sp_err = z;

ps_ctrl(1) = 1 / f_nom;			% initial value
if (Ki > 0)
	i_tm_sp_err(1) = 1/(f_nom*Ki);		% um...
	% for no glitch, seems necessary to start off w/ _asymptotic_ value.
	% 1/fnom = ps_ctrl(i) = Kp * tm_sp_err(i) + Ki * i_tm_sp_err(i)
	% tm_sp_err(inf) = 0
	% 1/fnom = Ki * i_tm_sp_err(inf)
	% i_tm_sp_err(inf) = 1/(fnom*Ki)
else
	i_tm_sp_err(1) = 0;			% whatever
end;

for i=2:I

% step the crystals
	psync = 1/fsync;
	incr_nm = psync*fm(i);
	incr_ns = psync*fs(i);
	nm(i) = nm(i-1) + incr_nm;
	ns(i) = ns(i-1) + incr_ns;
	tm(i) = nm(i) / f_nom;

% measurements
	ns_sm(i) = ns(i) + randu(-1,1) * ns_sm_err*f_nom;
	nm_mm_err = ns_sm_err;
	nm_mm(i) = nm(i) + randu(-1,1) * nm_mm_err*f_nom;
	tm_mm(i) = nm_mm(i) / f_nom;
	tm_sm(i) = tm_mm(i) + randu(-1,1)*tm_sm_err + randu(-1,1)*ns_sm_err;

% make a prediction
	ns_sm_increment = ns_sm(i) - ns_sm(i-1);
	tm_sp_increment = ns_sm_increment * ps_ctrl(i-1);
	% advance prediction of master time
	tm_sp(i) = tm_sp(i-1) + tm_sp_increment;

% control ps_ctrl
	tm_sp_err(i) = tm_sm(i) - tm_sp(i);			% error
	i_tm_sp_err(i) = i_tm_sp_err(i-1) + tm_sp_err(i);	% integrate it
	ps_ctrl(i) = Kp * tm_sp_err(i) + Ki * i_tm_sp_err(i);	% PI

% get sim data out
	tm_true_err(i) = tm(i) - tm_sp(i);
end

% tc = nmc, ts = nm, 

%	[u(n) tc(n) ts(n) ts_o(n) ts_p(n) e(n) ie(n)] = clocktrack6(fs_nom, dt, fc(n), fs(n), tc(n-1), ts(n-1), ts_o(n-1), ts_p(n-1), err_ts, u(n-1), ie(n-1), Kp, Ki);
