function drive8(hours, synthclock, driftmode, Kp, Ki, yKp, yKi, yover, net_roundtrip, net_jitter, sample_err)
% drive eubsync8 and eubsync8notrack

global fsync tsync nsync;
global f_nom;

	% build clock-frequency traces

f_dev_ppm = 100;
f_dev = f_dev_ppm/1e6;
fmul = 1 + f_dev;
f_hi = f_nom * fmul;
f_lo = f_nom / fmul;
fy_nom = 1;
fy_hi = fy_nom * fmul;
fy_lo = fy_nom / fmul;

if (driftmode == 0)
	% constant
	N = 600;
	fm  = constvec(f_nom, N);
	fs  = constvec(f_nom, N);
	fym = constvec(fy_nom, N);
	fys = constvec(fy_nom, N);
elseif (driftmode == 1)
	N = 600;
	fm = [constvec(f_nom, N/3) constvec(f_lo, 2*N/3)];
	fs = [constvec(f_nom, 2*N/3) constvec(f_lo, N/3)];
	fym = [constvec(fy_nom, N/2) constvec(fy_lo, N/2)];
	fys = [constvec(fy_nom, N/5) constvec(fy_lo, 4*N/5)];
elseif (driftmode == 2)
	N = 3600;
	fm = constvec(f_nom, N) + f_dev * oscsin(2/N, N);
	fs = constvec(f_nom, N) + f_dev * oscsin(3/N, N, 0.25);
	fym = constvec(fy_nom, N) + f_dev * oscsin(4/N, N);
	fys = constvec(fy_nom, N) + f_dev * oscsin(2/N, N, 0.6);
elseif (driftmode == 999)
	N = 600;
	fm = [constvec(f_nom, N/3) constvec(f_lo, 2*N/3)];
	fs  = constvec(f_nom, N);
	fym = constvec(fy_nom, N);
	fys = constvec(fy_nom, N);
else
	error('unknown driftmode');
end

	% run simulation

reps = 60*60*hours / length(fs);
if (reps == 0)
	error('uh, reps == 0.');
end

devmin = 0;  devmax = 0;
psmin = 9e9;  psmax = 0;
for r = 1:reps
	if (synthclock == 1)
		[tm, tm_sp, ps_ctrl] = eubsync8(fm, fs, fym, fys, sample_err, net_roundtrip, net_jitter, Kp, Ki, yover, yKp, yKi);
	else
		[tm, tm_sp, ps_ctrl] = eubsync6(fm, fs, net_jitter, sample_err, Kp, Ki);
	end
	tm_true_err = tm - tm_sp;
	devmin = min(devmin, min(tm_true_err));
	devmax = max(devmax, max(tm_true_err));
	psmin  = min(psmin, min(ps_ctrl));
	psmax  = max(psmax, max(ps_ctrl));
end;

	% report results

plot(tm_true_err);  shg;

fdevlo = (1/psmax - f_nom) / f_nom * 1e6;
fdevhi = (1/psmin - f_nom) / f_nom * 1e6;

fprintf('net_roundtrip = %g, net_jitter = %g, sample_err = %g, synthclock = %d\n', net_roundtrip, net_jitter, sample_err, synthclock);
fprintf('Kp = %g / f_nom, Ki = %g / f_nom.  ', Kp*f_nom, Ki*f_nom);
fprintf('yKp = %g, yKi = %g.  driftmode %d.\n', yKp, yKi, driftmode);
fprintf('%g hours, yover = %d: time [%g, %g] msec, freq [%g, %g] ppm.\n\n', hours, yover, 1000*devmin, 1000*devmax, fdevlo, fdevhi);
