function [u, tc, ts, ts_o, ts_p, e, ie] = clocktrack6(f_nom, dt, fc, fs, tc0, ts0, ts_o0, ts_p0, err_ts, u0, ie0, Kp, Ki)
%
% tracks a noisy sample clock, estimating with a clean cycle clock.
% performs one step.
% 	in: 			XXX wrong
% time step,
% sample clock frequency,
% cycle clock frequency,
% sample clock time,
% cycle clock time,
% error in observing ts,
% integrated error,
% controller coefficients.
%	out:
% control signal,
% new sample clock time,
% new cycle clock time,
% new integrated error.


incr_ts = dt * fs;
incr_tc = dt * fc;
ts = ts0 + incr_ts;
tc = tc0 + incr_tc;
ts_o = ts + randu(-1,1) * err_ts;

ts_p = ts_p0 + incr_tc * u0;
e = ts_o - ts_p;
ie = ie0 + e;

u = Kp * e + Ki * ie;


%incr_ts = dt / fs;
%incr_tc = dt / fc;
%ts = ts0 + incr_ts;
%tc = tc0 + incr_tc;
%ts_o = ts + randu(-1,1) * err_ts;
%
%ts_p = ts_p0 + incr_tc * u0;
%e = ts_o - ts_p;
%ie = ie0 + e;
%
%u = Kp * e + Ki * ie;
