import numpy as np
import matplotlib.pyplot as plt

plt.rc('text', usetex=True)
plt.rc('font', family='serif')
import seaborn as sns

sns.set()

# values were manually calculated for simplicity, see the paper for relevant equations.
x1 = np.array([0.5, 0.6934, 0.7632, 0.81035, 0.8454, 0.8727, 0.8944, 0.912, 0.9263, 0.9381, 0.948, 0.9561, 0.963,
               0.9687, 0.9735, 0.9776, 0.981, 0.9839, 0.9864, 0.9884, 0.9902, 0.9917, 0.9929, 0.994, 0.9949, 0.9963,
               0.9969, 0.9973, 0.9978, 0.9981])
x2 = np.array([0.5, 0.667, 0.7, 0.747, 0.796, 0.804, 0.840, 0.850, 0.868, 0.889, 0.893, 0.910, 0.915, 0.924, 0.935,
               0.937, 0.947, 0.95, 0.955, 0.961, 0.962, 0.968, 0.969, 0.972, 0.976, 0.977, 0.98, 0.981, 0.983, 0.985,
               0.986])

tiers1 = np.array([0, 6, 19, 34, 48, 62, 76, 90, 105, 119, 133])
tiers2 = np.array([0, 11, 34, 59, 86, 113, 140, 168, 195, 223, 251])

f = plt.figure()
plt.subplot(1, 2, 1)
plt.plot(np.arange(30), x1[:30], label='KL-Divergence Dual Upper Bound')
plt.plot(np.arange(30), x2[:30], label='Discrete Upper Bound (Tight)')
plt.title(r'Minimum Margin $p$ to Certify Robustness at $r$ Flips')
plt.xlabel('r')
plt.ylabel('p')
plt.legend()
plt.subplot(1,2,2)
plt.plot(np.arange(11), tiers1, label='KL-Divergence Dual')
plt.plot(np.arange(11), tiers2, label='Discrete')
plt.title(r'Number of Label Flips Certifiably Robust at Margin $p$')
plt.xlabel('$-\log_{10}(1-p)$')
plt.ylabel('Label Flips')
plt.legend()
plt.show()
plt.tight_layout()
f.savefig('plots/duality_gap.pdf', bbox_inches='tight')