import numpy as np
from sklearn.linear_model import LogisticRegression

X_train = np.load('data/multiclass_cifar/cifar_multiclass_train_features1k.npy')
y_train = np.load('data/multiclass_cifar/cifar_multiclass_train_y.npy')

X_test = np.load('data/multiclass_cifar/cifar_multiclass_test_features1k.npy')
y_test = np.load('data/multiclass_cifar/cifar_multiclass_test_y.npy')

print(X_train.shape, X_test.shape)

clf = LogisticRegression(multi_class='ovr', solver='lbfgs', max_iter=1000).fit(X_train, y_train)
print(clf.score(X_test, y_test))