import com.wolfram.jlink._


object Test {
  def main(args: Array[String]) {

    println("hello world")

    val ex: Expr = new Expr(Expr.SYMBOL,"testing")
    val ex2: Expr = new Expr(new Expr(Expr.SYMBOL, "Divide"),
                             List(new Expr(Expr.INTEGER, "20"),
                                  new Expr(Expr.INTEGER, "8")).toArray
                             )
    val ex3: String = "Reduce[Exists[x, a x^2 + b x + c == 0 ], {a,b,c}, Reals]"

 
    println(ex)
    println(ex2)

    val mathkernel = 
      {
        val mk = System.getenv("MATHKERNEL")
        if (mk == null) 
           {throw new Error("please set the MATHKERNEL variable")}
          else mk
      }

    val linkCall = 
        "-linkmode launch -linkname '" + 
         mathkernel +
        " -mathlink'"

    println("linkCall = " + linkCall)

//    System.setProperty("com.wolfram.jlink.libdir", 
//      "/Applications/Mathematica.app/SystemFiles/Links/JLink/SystemFiles/Libraries/MacOSX-x86-64")

    
    println("creating mathlink.")
    val link = MathLinkFactory.createKernelLink(linkCall);
    println("created.")

    link.connect()

    link.discardAnswer()

    link.newPacket()
    link.evaluate("1+1")

    link.waitForAnswer()

    link.abortEvaluation()


    val result = link.getExpr();


 

    println("result = " + result)


    link.newPacket()
    link.evaluate("0")
    link.discardAnswer()



//    link.waitForAnswer()
//    val abortRes = link.getExpr()

//    println("abortRes = " + abortRes)

    link.newPacket()
    link.evaluate(ex2)

    link.waitForAnswer()

    val result2 = link.getExpr();


    println("result = " + result2)




    link.newPacket()
    link.evaluate(ex3)

    link.waitForAnswer()


    val result3:Expr = link.getExpr();


    println("result = " + result3)

   link.newPacket()
    link.evaluate(ex3)

    link.waitForAnswer()


    val result4:Expr = link.getExpr();


    println("result = " + result4)

//    println("result = True :" + (result3 == new Expr(Expr.SYMBOL, "True")))



    println("goodbye world")
  }

}
