package banyan
  
import com.zink.scala.fly._
import com.zink.scala.fly.kit._

// Companion object generates the static member space
object MemoTreeNode {
  private val space = FlyFinder.find() match{
    case Some(fly) => fly
    case None => {
      System.err.println("Failed to find a Fly server.")
      throw new RuntimeException()
    }
  }
  private val forever = 10000000 //XXX hack....
}

@serializable
abstract class MemoTreeNode(pt: NodeID, k:Any) extends TreeNode(pt){
  // Implementor should define the key to be whatever data a node carries
  // around -- probably a subproblem -- by which to index values in Fly.
  val key = k

  private class FlyEntry(var id:NodeID, var key:Any, var stat:Status, var result:Option[Any]) 
  { }

/* XXX doesn't actually make sense to override this...
  override
  protected [banyan] final def childReturnedAux
                               (childID:NodeID, childValue:Any):Unit = {
    val template = new FlyEntry(childID, null, null, null)
    MemoTreeNode.space.take (template, 0L) match{
      case None => MemoTreeNode.space.write
    }
    super.childReturnedAux(childID, childValue)
  }
*/

  override
  final def returnNode(v: Any): Unit = {
    val template = new FlyEntry(this.nodeID, null, null, null)
    MemoTreeNode.space.take(template, 0L) match{
      case None => 
      {
        val entry = new FlyEntry(this.nodeID, this.key, Returned(), Some(v))
        MemoTreeNode.space.write (entry, MemoTreeNode.forever)
      }
      case Some(e) =>
      {
        e.stat = Returned()
        e.result = Some(v)
        MemoTreeNode.space.write (e, MemoTreeNode.forever)
      }
    }
    super.returnNode(v)
  }


  /*
  *  New method for adding MemoTreeNode children.
  *  Returns the value of any nodes that match the key;
  *  otherwise adds the children in the usual way.
  */
  def newChild(child: MemoTreeNode): Unit = {

    def addIt() = {
        val entry = new FlyEntry(child.nodeID, child.key, Working(), None)
        MemoTreeNode.space.write(entry, MemoTreeNode.forever)
        super.newChild(child)
      }

    val template = new FlyEntry(null, child.key, Returned(), null)
    MemoTreeNode.space.read(template, 0L) match {
      case Some(e) => e.result match {
          //If the key is already in the space with a return value, just
          //send it back immediately.
          case Some(v) => childReturned(this.childIDtoInt(child.nodeID), v)
          case None => addIt() // should never happen
        }
      case _ => addIt()
      } //end read match
    } //end def newChild
} // end class MemoTreeNode


