import scala.actors._
import scala.actors.Actor._
import scala.actors.remote.RemoteActor
import scala.actors.remote.RemoteActor._
import scala.actors.remote._



class ServerClass extends Actor {

  def doSomething() = {
    println("doing something")
  }

  def act() = {

    alive(9010)
    register('server, self)
    loop {
      react {
        case 'PRINT => 
          println("printing!")
        case 'EXIT =>
          println("exiting")
        exit
        case (t: TestObject) =>
          println("testObject: " + t)
          t.s = "different!"
        case 'request =>
          sender ! 'ack
        case msg =>
          println("message: " + msg )

      }
    }


  }


}



object Server  {

  def main(args: Array[String]) {
    val s = new ServerClass
    s.start

  }
}
