import numpy as np
import pickle


with open("domainArchs.pkl",'rb') as f:
    genuine = pickle.load(f)

counts = {}
maxcounts = {}
for da in genuine:
    tmp_count = 1
    last_dom = ''
    for d in da:
        if d == last_dom:
            tmp_count += 1
        else:
            counts.setdefault(last_dom,0)
            if tmp_count >=2:
                counts[last_dom]+= tmp_count
            maxcounts.setdefault(last_dom,0)
            if tmp_count > maxcounts[last_dom]:
                maxcounts[last_dom] = tmp_count
            tmp_count = 1
            last_dom = d
    counts.setdefault(d,0)
    if tmp_count >=2:
        counts[d] += tmp_count
    maxcounts.setdefault(d,0)
    if tmp_count>maxcounts[d]:
        maxcounts[d] = tmp_count


sorted_dict = {k: v for k, v in sorted(counts.items(), key=lambda item: item[1])}
sorted_keys = list(sorted_dict.keys())[::-1][:10]
for d in sorted_keys:
    print("%s\t%d\t%d" % (d,counts[d],maxcounts[d]))
