import numpy as np
import matplotlib.pyplot as plt
import sys

import matplotlib.pylab as pylab
from matplotlib import gridspec
from matplotlib.legend_handler import HandlerLineCollection, HandlerTuple


tsize = 14.5
params = {'legend.fontsize': tsize,
         'axes.labelsize': tsize,
         'axes.titlesize':tsize,}
pylab.rcParams.update(params)

plt.rc('axes', titlesize=tsize)     # fontsize of the axes title
plt.rc('axes', labelsize=tsize)    # fontsize of the x and y labels
plt.rc('legend', fontsize=tsize)    # legend fontsize
plt.rc('text', usetex=True)
plt.rc('legend', frameon=False)
plt.rcParams["font.family"] = "Times New Roman"




genuinelength_fish = np.loadtxt("fish_genuine_addk.txt")
genuinelength_fly = np.loadtxt("fly_new_genuine_len.txt")
genuinelength_cnidaria = np.loadtxt("cnidaria_genuine_len.txt")
genuinelength_ape = np.loadtxt("/Users/xiaoyuecui/DurandLabProj/simulator/BeforeYangyi/ape_test/formatted/rawDomainArchLength.txt")

fishmean = np.mean(genuinelength_fish)
flymean = np.mean(genuinelength_fly)
cnidariamean = np.mean(genuinelength_cnidaria)
apemean = np.mean(genuinelength_ape)



lset = [7500,10000,15000,17500,20000,50000,70000,100000,140000,200000,400000,800000,1600000,3200000,6400000,12800000]
labelset = ['7.5k','10k','15k','17.5k','20k','50k','70k','100k','140k','200k','400k','800k','1.6M','3.2M','6.4M','12.8M']

lsetsub = [7500,400000,800000,1600000,3200000,6400000,12800000]
labelsetsub = ['7.5k','400k','800k','1.6M','3.2M','6.4M','12.8M']

full_data_fish = np.zeros((len(lset),8985))
full_data_fly = np.zeros((len(lset),5483))
full_data_ape =np.zeros((len(lset),7144))
full_data_cnidaria=np.zeros((len(lset),6271))

for i in range(len(lset)):
    l = lset[i]
    data = np.loadtxt("fish_full_len_addk/"+str(l)+".txt")
    full_data_fish[i,:] = data
    data = np.loadtxt("fly_full_len_addk/"+str(l)+".txt")
    full_data_fly[i,:] = data
    data =np.loadtxt("ape_full_len_addk/"+str(l)+".txt")
    full_data_ape[i,:]=data
    data = np.loadtxt("cnidaria_full_len_addk/"+str(l)+".txt")
    full_data_cnidaria[i,:] = data


#

plt.plot(lset,np.mean(full_data_ape,axis=1),label='Primate',marker='o',color='#375E97')
plt.plot(lset,np.mean(full_data_fish,axis=1),label='Fish',marker='o',color='#FB6542')
plt.plot(lset,np.mean(full_data_fly,axis=1),label='Drosophila',marker='o',color='#FFBB00')
plt.plot(lset,np.mean(full_data_cnidaria,axis=1),label='Cnidaria',marker='o',color='#3F681C')


print(np.std(full_data_fly,axis=1))

xmin, xmax, ymin, ymax = plt.axis()
xmin = 0
xmax = 12800000
plt.hlines(fishmean,xmin,xmax,color='#FB6542')
plt.hlines(flymean,0,12800000,color='#FFBB00')
plt.hlines(cnidariamean,0,12800000,color='#3F681C')
plt.hlines(apemean,0,12800000,color='#375E97')
#plt.plot(lset,np.mean(full_data_fish,axis=1),label='fish',marker='o')
#plt.plot(lset,np.mean(full_data_fish,axis=1),label='fish',marker='o')
plt.xticks(ticks=lsetsub,labels=labelsetsub,rotation=60)
#plt.xticks(ticks=lset[:10],labels=labelset[:10],rotation=45)
plt.ylabel('Mean domain architecture length')
plt.xlabel("Chain length")
plt.legend()


plt.tight_layout()
#plt.show()
plt.savefig('DAlength_curves.ps',dpi=1200, bbox_inches = "tight")
