import numpy as np
import pickle
import matplotlib.pyplot as plt
from matplotlib.patches import Patch
with open("ins_pos.pkl",'rb') as f:
    posi = pickle.load(f)
with open("del_pos.pkl",'rb') as f:
    posd = pickle.load(f)

import matplotlib.pylab as pylab

tsize = 12
params = {'legend.fontsize': tsize,
         'axes.labelsize': tsize,
         'axes.titlesize':tsize,
         'xtick.labelsize':tsize,}
pylab.rcParams.update(params)
plt.rc('text', usetex=True)
plt.rc('legend', frameon=False)
plt.rcParams["font.family"] = "Times New Roman"

fig,axs = plt.subplots(3,2)



len3ins = posi[2]
len3insinter = {}
len3insinter[1] = len3ins[1]
len3insinter[3] = len3ins[2]
len3insinter[5] = len3ins[3]
len3insinter[7] = len3ins[4]
p1=axs[0,0].bar(len3insinter.keys(),list(len3insinter.values())/np.sum(list(len3insinter.values())))


len3del = posd[4]
len3delinter = {}
len3delinter[2] = len3del[1]
len3delinter[4] = len3del[2]
len3delinter[6] = len3del[3]

twin00 = axs[0,0].twinx()
p2=twin00.bar(len3delinter.keys(),list(len3delinter.values())/np.sum(list(len3delinter.values())),color='red')
axs[0,0].set_xticks([1,2,3,4,5,6,7])
axs[0,0].set_xticklabels([1,1,2,2,3,3,4])
labels = axs[0,0].get_yticklabels()
for label in labels:
    label.set_fontweight('bold')
labels = twin00.get_yticklabels()
for label in labels:
    label.set_fontweight('bold')
twin00.spines['left'].set_color('#1f77b4')
twin00.spines['right'].set_color('red')
twin00.tick_params(axis='y',colors='red')
axs[0,0].tick_params(axis='y',colors='#1f77b4')


axs[0,0].set_title("DA length=3")



## DA 4

len4ins = posi[3]
len4insinter = {}
len4insinter[1] = len4ins[1]
len4insinter[3] = len4ins[2]
len4insinter[5] = len4ins[3]
len4insinter[7] = len4ins[4]
len4insinter[9] = len4ins[5]
axs[0,1].bar(len4insinter.keys(),list(len4insinter.values())/np.sum(list(len4insinter.values())))


len4del = posd[5]
len4delinter = {}
len4delinter[2] = len4del[1]
len4delinter[4] = len4del[2]
len4delinter[6] = len4del[3]
len4delinter[8] = len4del[4]

twin01 = axs[0,1].twinx()
twin01.bar(len4delinter.keys(),list(len4delinter.values())/np.sum(list(len4delinter.values())),color='red')
axs[0,1].set_xticks([1,2,3,4,5,6,7,8,9])
axs[0,1].set_xticklabels([1,1,2,2,3,3,4,4,5])
axs[0,1].set_title("DA length=4")

labels = axs[0,1].get_yticklabels()
for label in labels:
    label.set_fontweight('bold')
labels = twin01.get_yticklabels()
for label in labels:
    label.set_fontweight('bold')
twin01.spines['left'].set_color('#1f77b4')
twin01.spines['right'].set_color('red')
twin01.tick_params(axis='y',colors='red')
axs[0,1].tick_params(axis='y',colors='#1f77b4')

# DA 5
len5ins = posi[4]
len5insinter = {}
len5insinter[1] = len5ins[1]
len5insinter[3] = len5ins[2]
len5insinter[5] = len5ins[3]
len5insinter[7] = len5ins[4]
len5insinter[9] = len5ins[5]
len5insinter[11] = len5ins[6]
axs[1,0].bar(len5insinter.keys(),list(len5insinter.values())/np.sum(list(len5insinter.values())))


len5del = posd[6]
len5delinter = {}
len5delinter[2] = len5del[1]
len5delinter[4] = len5del[2]
len5delinter[6] = len5del[3]
len5delinter[8] = len5del[4]
len5delinter[10] = len5del[5]

twin10 = axs[1,0].twinx()
twin10.bar(len5delinter.keys(),list(len5delinter.values())/np.sum(list(len5delinter.values())),color='red')
axs[1,0].set_xticks([1,2,3,4,5,6,7,8,9,10,11])
axs[1,0].set_xticklabels([1,1,2,2,3,3,4,4,5,5,6])
axs[1,0].set_title("DA length=5")


labels = axs[1,0].get_yticklabels()
for label in labels:
    label.set_fontweight('bold')
labels = twin10.get_yticklabels()
for label in labels:
    label.set_fontweight('bold')
twin10.spines['left'].set_color('#1f77b4')
twin10.spines['right'].set_color('red')
twin10.tick_params(axis='y',colors='red')
axs[1,0].tick_params(axis='y',colors='#1f77b4')

# DA 6

len6ins = posi[5]
len6insinter = {}
len6insinter[1] = len6ins[1]
len6insinter[3] = len6ins[2]
len6insinter[5] = len6ins[3]
len6insinter[7] = len6ins[4]
len6insinter[9] = len6ins[5]
len6insinter[11] = len6ins[6]
len6insinter[13] = len6ins[7]
axs[1,1].bar(len6insinter.keys(),list(len6insinter.values())/np.sum(list(len6insinter.values())))


len6del = posd[7]
len6delinter = {}
len6delinter[2] = len6del[1]
len6delinter[4] = len6del[2]
len6delinter[6] = len6del[3]
len6delinter[8] = len6del[4]
len6delinter[10] = len6del[5]
len6delinter[12] = len6del[6]

twin11 = axs[1,1].twinx()
twin11.bar(len6delinter.keys(),list(len6delinter.values())/np.sum(list(len6delinter.values())),color='red')
axs[1,1].set_xticks([1,2,3,4,5,6,7,8,9,10,11,12,13])
axs[1,1].set_xticklabels([1,1,2,2,3,3,4,4,5,5,6,6,7])
axs[1,1].set_title("DA length=6")

labels = axs[1,1].get_yticklabels()
for label in labels:
    label.set_fontweight('bold')
labels = twin11.get_yticklabels()
for label in labels:
    label.set_fontweight('bold')
twin11.spines['left'].set_color('#1f77b4')
twin11.spines['right'].set_color('red')
twin11.tick_params(axis='y',colors='red')
axs[1,1].tick_params(axis='y',colors='#1f77b4')

#DA 7
len7ins = posi[6]
len7insinter = {}
for i in range(8):
    len7insinter[i*2+1]=len7ins[i+1]

axs[2,0].bar(len7insinter.keys(),list(len7insinter.values())/np.sum(list(len7insinter.values())))


len7del = posd[8]
len7delinter = {}
for i in range(1,8,1):
    len7delinter[i*2]=len7del[i]

twin20 = axs[2,0].twinx()
twin20.bar(len7delinter.keys(),list(len7delinter.values())/np.sum(list(len7delinter.values())),color='red')
axs[2,0].set_xticks([1,2,3,4,5,6,7,8,9,10,11,12,13,14,15])
axs[2,0].set_xticklabels([1,1,2,2,3,3,4,4,5,5,6,6,7,7,8])
axs[2,0].set_title("DA length=7")

labels = axs[2,0].get_yticklabels()
for label in labels:
    label.set_fontweight('bold')
labels = twin20.get_yticklabels()
for label in labels:
    label.set_fontweight('bold')
twin20.spines['left'].set_color('#1f77b4')
twin20.spines['right'].set_color('red')
twin20.tick_params(axis='y',colors='red')
axs[2,0].tick_params(axis='y',colors='#1f77b4')

# DA 8
len8ins = posi[7]
len8insinter = {}
for i in range(9):
    len8insinter[i*2+1]=len8ins[i+1]

axs[2,1].bar(len8insinter.keys(),list(len8insinter.values())/np.sum(list(len8insinter.values())))


len8del = posd[9]
len8delinter = {}
for i in range(1,9,1):
    len8delinter[i*2]=len8del[i]

twin21 = axs[2,1].twinx()
twin21.bar(len8delinter.keys(),list(len8delinter.values())/np.sum(list(len8delinter.values())),color='red')
axs[2,1].set_xticks([1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17])
axs[2,1].set_xticklabels([1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9])
axs[2,1].set_title("DA length=8")

labels = axs[2,1].get_yticklabels()
for label in labels:
    label.set_fontweight('bold')
labels = twin21.get_yticklabels()
for label in labels:
    label.set_fontweight('bold')
twin21.spines['left'].set_color('#1f77b4')
twin21.spines['right'].set_color('red')
twin21.tick_params(axis='y',colors='red')
axs[2,1].tick_params(axis='y',colors='#1f77b4')

legend_elements=[Patch(label='Insertion'),Patch(facecolor='red',edgecolor='red',label='Deletion')]
#twin00.legend(handles=legend_elements,loc='lower left')

#plt.tick_params(labelcolor='none', which='both', top=False, bottom=False, left=False, right=False)
#fig.supxlabel('Accepted event position',fontsize=tsize)
#fig.supylabel('Frequency',fontsize=tsize)

# ext=[]
# for j in range(4):
#     ext.append([axs[0,j].get_window_extent().x0, axs[0,j].get_window_extent().width ])
#
# inv = fig.transFigure.inverted()
# width_left = ext[0][0]+(ext[1][0]+ext[1][1]-ext[0][0])/2.
# left_center = inv.transform( (width_left, 1) )
# width_right = ext[2][0]+(ext[3][0]+ext[3][1]-ext[2][0])/2.
# right_center = inv.transform( (width_right, 1) )

plt.tight_layout()
#plt.show()
plt.savefig('histogram_EventPosition.ps',dpi=1200, bbox_inches = "tight")
