import numpy as np
import matplotlib.pyplot as plt
import sys
from matplotlib import gridspec

plt.rc('text', usetex=True)
plt.rc('legend', frameon=False)
plt.rcParams["font.family"] = "Times New Roman"
genuinelength = np.loadtxt("cnidaria_genuine_len.txt")
gmean = np.mean(genuinelength)

lset = [7500,10000,15000,17500,20000,50000,70000,100000,140000,200000,400000,800000,1600000,3200000,6400000,12800000]
lsetd = ['7.5K','10K','15K','17.5K','20K','50K','70K','100K','140K','200K','400K','800K','1.6M','3.2M','6.4M','12.8M','genuine']
full_data = np.zeros((len(lset)+1,6271))
compact_data = np.zeros((len(lset),6271))

for i in range(len(lset)):
    l = lset[i]
    data = np.loadtxt("cnidaria_full_len_addk/"+str(l)+".txt")
    full_data[i,:] = data
    data2 = np.loadtxt("cnidaria_compact_len_addk/"+str(l)+".txt")
    compact_data[i,:] = data2
full_data[-1,:] = genuinelength

seq_full_data = [full_data[i,:] for i in range(len(lset)+1)]

fig = plt.figure(figsize=(5,6))

gs=gridspec.GridSpec(3,1)

ax1= fig.add_subplot(gs[0,:])
ax2= fig.add_subplot(gs[1:,:])




# flierprops = dict(marker='o', markerfacecolor='r', markersize=12,
#                   linestyle='none', markeredgecolor='g')
#flierprops = dict(markersize=3)
#ax2.boxplot(seq_full_data,widths=0.7,flierprops=flierprops,zorder=-1)
medianprops = dict(color="black")

ax2.boxplot(seq_full_data,widths=0.7,zorder=-1,medianprops=medianprops,whiskerprops=dict(linestyle='--'))
ax2.set_xticklabels(lsetd,rotation=45,ha="right")
# for i in range(len(lset)):
#     maxcompact = np.max(compact_data[i,:])
#     ax2.scatter(i+1,maxcompact,color="lightgreen",zorder=1)
#axs[0].boxplot(seq_full_data)
ax2.set_ylim(-6.2, 260)
ax1.boxplot(seq_full_data,widths=0.7,medianprops=medianprops,whiskerprops=dict(linestyle='dashed'),showfliers=False)
ax1.set_ylim(0.8,7.2)
ax1.set_yticks([1,2,3,4,5,6,7])

xlim = ax1.get_xlim()
ax1.hlines(gmean,xlim[0],xlim[1],color='black')
ax1.scatter(np.arange(1,len(lset)+2,1),np.mean(full_data,axis=1),color="red",marker='o')
ax1.set_ylabel('Length\nZoom')
ax2.set_ylabel('Domain architecture length')
ax2.set_xlabel('Chain length')
ax1.set_xticks([])
#ax1.set_title("Cnidaria")
plt.subplots_adjust(wspace=0, hspace=0)
plt.tight_layout()
#plt.show()
plt.savefig('boxplot_DAlengths_cnidaria.ps',dpi=1200, bbox_inches = "tight")
