import matplotlib.pyplot as plt
import numpy as np
import matplotlib.pylab as pylab
from matplotlib import gridspec
from matplotlib.legend_handler import HandlerLineCollection, HandlerTuple

tsize = 14.5
params = {'legend.fontsize': tsize,
         'axes.labelsize': tsize,
         'axes.titlesize':tsize,}
pylab.rcParams.update(params)

plt.rc('axes', titlesize=tsize)     # fontsize of the axes title
plt.rc('axes', labelsize=tsize)    # fontsize of the x and y labels
plt.rc('legend', fontsize=tsize)    # legend fontsize
plt.rc('text', usetex=True)
plt.rc('legend', frameon=False)
plt.rcParams["font.family"] = "Times New Roman"

fig, ax = plt.subplots()
fig.subplots_adjust(right=0.75)

twin1 = ax.twinx()
twin2 = ax.twinx()

# Offset the right spine of twin2.  The ticks and label have already been
# placed on the right by twinx above.
twin2.spines.right.set_position(("axes", 1.2))

insrate = np.array([0.000891963,
0.000832149,
0.00078472,
0.000772729,
0.000755506,
0.00069135,
0.000677273,
0.000661797,
0.000654623,
0.000645101,
0.000631615,
0.000625938,
0.000623453,
0.000620519,
0.000620827,
0.000620762])

delrate = np.array([0.608122183,
0.626432059,
0.654689966,
0.663731357,
0.670956778,
0.695324265,
0.699037589,
0.701583675,
0.706466504,
0.704975706,
0.702204944,
0.701460193,
0.701866214,
0.700427532,
0.701358915,
0.701748753])

eventrate = np.array([1.662977659,
1.506751938,
1.358033441,
1.31742125,
1.272966203,
1.126195008,
1.093739639,
1.067799372,
1.049284212,
1.034462566,
1.017711648,
1.00921923,
1.00459195,
1.002274348,
1.00111518,
1.000561234])

lset = [7500,10000,15000,17500,20000,50000,70000,100000,140000,200000,400000,800000,1600000,3200000,6400000,12800000]

chain_length = ['7.5K',
'10K',
'15K',
'17.5K',
'20K',
'50K',
'70K',
'100K',
'140K',
'200K',
'400K',
'800K',
'1.6M',
'3.2M',
'6.2M',
'12.8M']
ratio=1/eventrate

nexp = len(chain_length)
ms=3
p1,=ax.plot(lset,insrate,'b-',marker='o',ms=ms)
p2, = twin1.plot(lset,delrate,'r-',marker='o',ms=ms)
p3, = twin2.plot(lset,ratio,color='black',marker='o',ms=ms)

ax.set_xlabel('Chain length')
ax.set_ylabel('Insertion acceptance rate')
twin1.set_ylabel('Deletion acceptance rate')
twin2.set_ylabel('Accepted deletions/insertions')


ax.yaxis.label.set_color(p1.get_color())
twin1.yaxis.label.set_color(p2.get_color())
twin2.yaxis.label.set_color(p3.get_color())

tkw = dict(size=4, width=1.5)
ax.tick_params(axis='y', colors=p1.get_color(), **tkw)
ax.ticklabel_format(style='scientific')
twin1.tick_params(axis='y', colors=p2.get_color(), **tkw)
twin2.tick_params(axis='y', colors=p3.get_color(), **tkw)
ax.ticklabel_format(axis="y", style="sci", scilimits=(0,0))
figalset = [7500,800000,1600000,3200000,6400000,12800000]
figalabelset = ['7.5K','800K','1.6M','3.2M','6.4M','12.8M']
ax.set_xticks(figalset)
ax.set_xticklabels(figalabelset,rotation=60)

#ax.legend(handles=[p1, p2, p3])

plt.tight_layout()
#plt.show()
plt.savefig('eventRate.ps',dpi=1200, bbox_inches = "tight")
