import numpy as np
import matplotlib.pyplot as plt
import sys

import matplotlib.pylab as pylab
from matplotlib import gridspec
from matplotlib.legend_handler import HandlerLineCollection, HandlerTuple


tsize = 14.5
params = {'legend.fontsize': tsize,
         'axes.labelsize': tsize,
         'axes.titlesize':tsize,}
pylab.rcParams.update(params)

plt.rc('axes', titlesize=tsize)     # fontsize of the axes title
plt.rc('axes', labelsize=tsize)    # fontsize of the x and y labels
plt.rc('legend', fontsize=tsize)    # legend fontsize
plt.rc('text', usetex=True)
plt.rc('legend', frameon=False)
plt.rcParams["font.family"] = "Times New Roman"




data_2 = np.load("shrink_factors_2_chain_thin.npy")
data_5 = np.load("shrink_factors_5_chain_thin.npy")
data_10 = np.load("shrink_factors_10_chain_thin.npy")
data_50 = np.load("shrink_factors_50_chain_thin.npy")

intervals1 = np.arange(200,3200000,200)



plt.plot(intervals1,data_2,label="2 chains")
plt.plot(intervals1,data_5,label="5 chains")
plt.plot(intervals1,data_10,label="10 chains")
plt.plot(intervals1,data_50,label="50 chains")
xmin,xmax,ymin,ymax = plt.axis()
plt.hlines(1.1,0,3200000,color='black',zorder=100,label='Shrink factor = 1.1')
plt.ticklabel_format(style='sci')


plt.xticks([0,1000000,2000000,3000000],['0','1M','2M','3M'],rotation=45,ha="right")
plt.ylabel("Shrink factor")
plt.xlabel("Chain length")
plt.legend()
plt.tight_layout()
#plt.show()
plt.savefig('Gelman.ps',dpi=1200, bbox_inches = "tight")
