import os

def checkDir(path):
    """
    Ensure that the directory at the path exists; if not, create it.
    """
    if not os.path.exists(path):
        os.mkdir(path)

def saveFigure(fig, path, size=(6,4)):
    """
    Save a matplotlib figure as a PNG file.

    fig: matplotlib Figure object
    path: where to save the file + the filename (.png automatically
          appended)
    size: tuple, (x,y) size of the image in inches    
    """
    fig.set_size_inches(size[0], size[1])
    with open(path+'.png', 'wb') as f:
        fig.savefig(f, format='png', dpi=200)
