def measureSuccessFrequency(da, ev, burn=0):
    """
    Measure the success frequency of the simualtion.  Optionally, use
    a burn-in period, before which the data is ignored.

    da = domain architecture history
    ev = event history
    burn = the amount of time/branchLength to ignore
    """
    if burn != 0: # short-circuit for the default
        timeFilt = lambda e: burn < e[0]
        ev = list(filter(timeFilt, ev))
        da = da[-1*(len(ev)+1):]
        
    iSucc = 0 # insertion successes
    dSucc = 0 # deletion successes
    for i in range(len(ev)):
        if len(da[i]) != len(da[i+1]):
            if ev[i][1] == 'ins':
                iSucc += 1
            elif ev[i][1] in ['del', 'ext']:
                dSucc += 1
    return iSucc/len(ev), dSucc/len(ev)
