import argparse
import os
import sys

sys.path.append(os.path.dirname(os.path.realpath(__file__)) + "/lib")
from Parsing import ExperimentJSON
from Simulation.Results import ResultsReader, CustomCSVWriter


def parseArgs():
    """
    Parse command-line arguments.
    """
    parser = argparse.ArgumentParser(description="Format the results of domain architecture simulations.")
    parser.add_argument('expType', action='store', type=str, choices=['normal', 'batch'],
                        help="The experiment type")
    parser.add_argument('path', action='store', type=str,
                        help="The path to the root of the experiment directory.")
    return parser.parse_args()

if __name__ == "__main__":
    args = parseArgs()

    # Get directories
    dirs = []
    if args.expType == "normal":
        dirs.append(args.path+'/output')
    elif args.expType == "batch":
        for fName in os.listdir(args.path):
            if fName.startswith('output_'):
                dirs.append("{}/{}".format(args.path,fName))
    # Collect aggregate stats and experiment descriptors
    results = []
    for d in dirs:
        print("Retrieving results from "+d)
        aggResults = ResultsReader.readSimulation("{}/aggregate.txt".format(d))
        expDesc = ExperimentJSON.getExperimentDescriptor("{}/experiment.txt".format(d))
        results.append( (expDesc, aggResults) )

    # Flatten aggregate statistics
    for exp, ag in results:
        for key in list(ag.keys()):
            if isinstance(ag[key], dict):
                for subkey in ag[key]:
                    newkey = "{} {}".format(key, subkey)
                    ag[newkey] = ag[key][subkey]
                del ag[key]

    ########## Write to CSV ##########

    # Compose header keys
    aggHeader = ["success freq insert",
                 "success freq delete",
                 "final length max",
                 "final length median",
                 "final length mean",
                 "final length min",
                 "final length std dev",
                 "final length std err",
                 "insert rate max",
                 "insert rate median",
                 "insert rate mean",
                 "insert rate min",
                 "insert rate std dev",
                 "insert rate std err",
                 "delete rate max",
                 "delete rate median",
                 "delete rate mean",
                 "delete rate min",
                 "delete rate std dev",
                 "delete rate std err",
                 "% extinct",
                 "% starting domains retained",
                 "generations max",
                 "generations median",
                 "generations mean",
                 "generations min",
                 "generations std dev",
                 "generations std err",
                 "extinction times max",
                 "extinction times median",
                 "extinction times min",
                 "extinction times std dev",
                 "extinction times std err",
                 "generations to extinction max",
                 "generations to extinction median",
                 "generations to extinction mean",
                 "generations to extinction min",
                 "generations to extinction std dev",
                 "generations to extinction std err"]
    argHeader = ["branchLength",
                 "lambda",
                 "model",
                 "extinction",
                 "replicates",
                 "startDomains",
                 "dataPath"]

    # Open CSV and write header
    print("Writing formatted results...")
    csv = CustomCSVWriter(args.path+"/formatted.csv", aggHeader + argHeader)

    # Write rows of stat and arguments
    for expDesc, aggStats in results:
        temp = dict(expDesc, **aggStats)
        csv.writeRow(temp)

    print("Done")
