open import lib.Id
open Id
open import lib.Nat
open Nat

module lib.SumsProds where

  data Fin : Nat.Nat -> Set where
    Fz : {n : Nat.Nat} -> Fin (Nat.S n)
    Fs : {n : Nat.Nat} -> Fin n -> Fin (Nat.S n)

  -- FIXME : relate to Sigma k.Lt k n 

  module Sums where

    module SumsOP where
      data Void : Set where
  
      data Either (a : Set) (b : Set) : Set where
        Inl : a -> Either a b
        Inr : b -> Either a b
  
      data Maybe (a : Set) : Set where
        Some : a -> Maybe a
        None : Maybe a

      data Bool : Set where
        True : Bool
        False : Bool
  
      if_/_then_else : (p : Bool -> Set) -> (b : Bool) -> p True -> p False -> p b
      if _ / True then b1 else b2 = b1
      if _ / False then b1 else b2 = b2
     
      -- FIXME: better way than copying?
      if1_/_then_else : (p : Bool -> Set1) -> (b : Bool) -> p True -> p False -> p b
      if1 _ / True then b1 else b2 = b1
      if1 _ / False then b1 else b2 = b2
     
      data Check : Bool -> Set where
        OK : Check True
      
      · : Check True
      · = OK 
      
      _andalso_ : Bool -> Bool -> Bool 
      b1 andalso b2 = if (\_ -> Bool) / b1 then b2 else False
      
      _orelse_ : Bool -> Bool -> Bool 
      b1 orelse b2 = if (\_ -> Bool) / b1 then True else b2
      
      {-# BUILTIN BOOL  Bool  #-}
      {-# BUILTIN TRUE  True  #-}
      {-# BUILTIN FALSE False #-}
    
    open SumsOP public
  
    abort : {A : Set} -> Void -> A
    abort () 
    
    join1 : {a : Set} -> Maybe a -> Maybe a -> Maybe a
    join1 (Some x) _ = Some x
    join1 None     b = b
    
    join2 : {a : Set} -> Maybe a -> Maybe a -> Maybe a
    join2 _   (Some y) = Some y
    join2 a   None     = a
     
  module Prods where

    module ProdsOP where
      data Unit : Set where
        <> : Unit
  
      data Σ {a : Set} (b : a -> Set) : Set where
        _,_ : (x : a) -> (b x) -> Σ b
      
      infixr 0 _,_
      
      _×_ : Set -> Set -> Set
      a × b = Σ (\ (_ : a) -> b)

      infixr 10 _×_

      fst : {a : _} {b : a -> Set} -> Σ (\ (x : a) -> b x) -> a
      fst (x , y) = x
       
      snd : {a : _} {b : a -> Set } (p : Σ {a} b) -> (b (fst p))
      snd (x , y) = y

    open ProdsOP public

    split : {A : Set} {B : A -> Set} {C : Σ B -> Set}
            (p : Σ B) 
            -> ((x : A) (y : B x) -> C (x , y)) 
            -> C p
    split (x , y) f = f x y
    
    module Eta where
           
       Σ-eta+ : forall {A B} 
                {C : Σ B -> Set}
                {ctxt : (p : Σ {A} B) -> C p}
                (p : Σ B)
                -> Id (ctxt p) (split {A}{B}{C} p (\ x y -> ctxt (x , y)))
       Σ-eta+ (x , y) = Refl
    
       Σ-eta- : {A : Set} {B : A -> Set} (x : Σ (\(x : A) -> B x)) -> Id x (fst x , snd x)
       Σ-eta- (x , y) = Refl
       
       -- ENH: would be prettier with heterogeneous equality 
       Σ-ext- : {A : _} {B : A -> Set} {x y : Σ (\ (x : A) -> B x)} 
             -> (p1 : Id (fst x) (fst y))
             -> (p2 : Id {(B (fst x))} (snd x) (subst B (sym p1) (snd y)))
             -> Id x y
       Σ-ext- {A} {B} {(xf , xs)} {yf , ys} p1 p2 = id2 (sym p1) id0
         where id0 : Id {A × (B xf)} (xf , xs) (yf , subst B (sym p1) ys)
               id0 = substeqeq {_} {_} {\f ->  (f , xs)} {\f -> (f , subst B (sym p1) ys)}
                     (\x' -> substeq (\s -> x' , s) p2)
                     p1
       
               id1 : forall {xf xs ys} ->
                     Id {Σ (\_ -> (B xf))} (xf , xs) (xf , ys) ->
                     Id {Σ B} (xf , xs) (xf , ys)
               id1 Refl = Refl
       
               id2 : forall {xf yf xs ys} (p : Id yf xf) ->
                     Id {A × (B xf)} (xf , xs) (yf , subst B p ys)
                     -> Id {Σ B} (xf , xs) (yf , ys)
               id2 Refl p = id1 p 