{-# OPTIONS --no-termination-check #-}
-- FIXME: These theorems are proved by the same loop as
--        identity.  We could get them to termination check
--        by making the subformula metric explicit.

-- Companion code to
--    Focusing on Binding and Computation
--    Daniel R. Licata, Noam Zeilberger, Robert Harper

open import lib.Prelude
open import focbind.Language
open import focbind.Sugar
open import focbind.StructuralGamma
open import focbind.rulestruct.Subord
open import focbind.rulestruct.NSDiff
open import focbind.rulestruct.CISEmbed
open import focbind.rulestruct.Transport
open List using (_++_)
open Not

module focbind.rulestruct.Weaken where

module Weaken (InΣ : Types.Rule -> Set) where

  open Focus(InΣ)
  open StructuralGamma(InΣ)
  open Sugar(InΣ)
  open Subord(InΣ)
  open Rels
  open RelLemmas
  module NS =  NSDiff(InΣ)
  module T = Transport(InΣ)
  open CISEmbed(InΣ)

  open List.SW
  open List.InLists

  mutual
    cpat : (Γ : UCtx) {Ψ Ψ' : List Types.Rule} {Δ : LCtx} {A+ : Pos} -> EmbC.R (< Ψ' > A+) (< Ψ > A+) -> CPat Δ (< Ψ > A+) 
         -> Σ \ Δ' -> (Δ :: Γ) ⊢ Asms Δ' × CPat Δ' (< Ψ' > A+)
    cpat Γ em Cx⁻ = _ , Sub (Val⁻ ((\{Δ'} {γ'} d' -> Lf (List.SW.sS (List.SW.s0 i0)) (ncont _ (monoC em (\x -> uninsub↓ x)) d'))) E:: E[]) , Cx⁻  
    cpat Γ em Cx⁺ = _ , Sub (Vx⁺ (List.SW.s0 i0)  E:: E[]) , Cx⁺
    cpat Γ em C<> = _ , Sub E[] , C<>
    cpat Γ em (Cpair c1 c2) with cpat Γ (monoC em (\x -> (fst (uninsub* x)))) c1 |  cpat Γ (monoC em (\x -> (snd (uninsub* x)))) c2 
    ...                      | (_ , s1 , c1') | (_ , s2 , c2') = _ , (append-⊢ s1 s2) , Cpair c1' c2'
    cpat Γ em (Cinl p) with cpat Γ (monoC em (\x -> (fst (uninsub+ x)))) p 
    ...                | _ , s , p' = _ , s , Cinl p' 
    cpat Γ em (Cinr p) with cpat Γ (monoC em (\x -> (snd (uninsub+ x)))) p 
    ...                | _ , s , p' = _ , s , Cinr p' 
    cpat Γ em (Cbox c) = _ , Ids List.SW.s0 , Cbox c
    cpat Γ {Ψ} {Ψ'} {_} {R ⇒ A+} (EmbC.I em) (Cλ c) with 
           cpat Γ (EmbC.I (keepΨ {_} {_} {Ψ'} {Ψ} (< R :: Ψ' > A+) (monoΨ (< Ψ' > (R ⇒ A+)) (< R :: Ψ' > A+) em uninsub⇒))) c
    ... | _ , emd , c' = _ , emd , Cλ c'
    cpat Γ {Ψ} {Ψ'} em (Cc c cs) with cpats Γ {< Ψ > _} {< Ψ' > _} (embedargs {Ψ'} {Ψ} em (Inr c)) cs 
    ...                           | _ , sub , cs' = _ , sub , Cc c cs' 
    cpat Γ {Ψ} {Ψ'} em (Cv u cs) with cpats Γ {< Ψ > _} {< Ψ' > _} (embedargs {Ψ'} {Ψ} em (Inl (embedC⊆ em u))) cs 
    ...                  | _ , emd , cs' = _ , emd , Cv (embedC⊆ em u) cs' 

    cpats : (Γ : UCtx) {Cs Cs' : _} {Δ : LCtx} -> EmbedCs Cs' Cs -> CPats Δ Cs 
          -> Σ \ Δ' -> (Δ :: Γ) ⊢ Asms Δ' × CPats Δ' Cs'
    cpats Γ {Ψ , []} {Ψ' , []} E2[] C[] = _ , Sub E[] , C[] 
    cpats Γ {Ψ , A :: As} {Ψ' , .A :: As'} ((Refl , em) E2:: ecs) (c C: cs) with cpat Γ em c | cpats Γ {Ψ , As} {Ψ' , As'} ecs cs 
    ...                                 | _ , s1 , c' | _ , s2 , cs' 
       = _ , append-⊢ s1 s2 , c' C: cs'
    cpats Γ {_ , [] } {_ , _ :: _ } () _ 
    cpats Γ {_ , _ :: _ } {_ , [] } () _ 

    ncont : (Γ : UCtx) {Ψ Ψ' : List Types.Rule} {Δ' : LCtx} {A- : Neg} {γ' : Conc} 
          -> EmbC.R (< Ψ' > A-) (< Ψ > A-) -> DPat Δ' (< Ψ' > A-) γ'
          -> (Δ' :: Γ) ⊢ LFoc (< Ψ > A-) γ'
    ncont Γ diff d' with dpat Γ diff d'
    ...              | ( _ , _ ,  σ , k+ , d) = Cont⁻ d σ k+

    dpat : (Γ : UCtx) {Ψ Ψ' : List Types.Rule} {Δ' : LCtx} {A- : Neg} {γ' : Conc} 
         -> EmbC.R (< Ψ' > A-) (< Ψ > A-) -> DPat Δ' (< Ψ' > A-) γ'
         -> Σ \ Δ -> Σ \ γ -> ((Δ' :: Γ) ⊢ Asms Δ) × ((Δ' :: Γ) ⊢ LInv γ γ') × DPat Δ (< Ψ > A-) γ
    dpat Γ {Ψ} {Ψ'} {A- = (A+ → B-)} (EmbC.I emΨ) (Dapp {.Ψ'} {Δ1} {Δ2} c d) 
      with T.cpat Γ {Ψ'} {Ψ} (NS.DiffC.I (List.CondDiff.fromOPE (List.CondOPE.weaken-embed (\{_} a -> fst (uninsub→ a)) emΨ)) 
                          (List.CondDiff.fromOPE (List.CondOPE.weaken-embed (\{_} a -> fst (uninsub→ (insub-respects-⊆ a (embedC⊆ (EmbC.I emΨ))))) emΨ))) c 
         | dpat Γ {Ψ} {Ψ'} (monoC (EmbC.I emΨ) (\{_} a -> snd (uninsub→ a))) d
    ...  | _ , σ1 , c1 
         | _ , _ , σ2 , k+ , d2 = _ , _ , append-⊢ σ1 σ2 , WeakenΓ.weaken f  k+ , (Dapp c1 d2)
       where 
         f : {α : Hyp} -> α ∈∈ (Δ2 :: Γ) -> α ∈∈ ((Δ2 ++ Δ1) :: Γ)
         f (List.SW.s0 i) = s0 (List.In.iswapapp Δ2 Δ1 (List.In.iSmany Δ2 Δ1 i))
         f (List.SW.sS s) = (List.SW.sS s)
    dpat _ df De⁻ = _ , _ , Sub E[] , Ke⁻ , De⁻
    dpat Γ df De⁺ = _ , _ , Sub E[] , Cont⁺ (\{Δ} p -> Rf (pval _ (monoC df uninsub↑) p)) , De⁺
    dpat Γ df (Dfst d) with dpat Γ (monoC df (\x -> fst (uninsub& x))) d
    ...                   | _ , _ , σ , k+ , d' = _ , _ , σ , k+ , (Dfst d')
    dpat Γ df (Dsnd d) with dpat Γ (monoC df (\x -> snd (uninsub& x))) d
    ...                   | _ , _ , σ , k+ , d' = _ , _ , σ , k+ , (Dsnd d')
    dpat Γ {Ψ} {Ψ'} {_} {R ∧ A+} (EmbC.I em) (Dunpack d) with 
          dpat Γ (EmbC.I (keepΨ {_} {_} {Ψ'} {Ψ} (< R :: Ψ' > A+) (monoΨ (< Ψ' > (R ∧ A+)) (< R :: Ψ' > A+) em uninsub∧))) d
    ... | _ , _ , σ , k+ , d' = _ , _ , σ , k+ , Dunpack d'
    dpat Γ em (Dundia d) = _ , _ , Ids List.SW.s0 , ke , Dundia d
    dpat Γ df (Dcur d) with dpat Γ (monoC df (\x -> fst (uninsub∀W x))) d
    ...                   | _ , _ , σ , k+ , d' = _ , _ , σ , k+ , (Dcur d')
    dpat Γ df (Dextend i d) with dpat Γ (monoC df (\x -> snd (uninsub∀W x) i)) d
    ...                      | _ , _ , σ , k+ , d' = _ , _ , σ , k+ , (Dextend i d')

    pval : (Γ : UCtx) {Ψ Ψ' : List Types.Rule} {Δ : LCtx} {A+ : Pos} 
          -> EmbC.R (< Ψ' > A+) (< Ψ > A+) -> CPat Δ (< Ψ > A+)
          -> (Δ :: Γ) ⊢ RFoc (< Ψ' > A+)
    pval Γ df c with cpat Γ df c 
    ...          | ( _ , σ' , c') = Val⁺ c' σ'

  wk+ : forall {A+ Ψ R} -> (head R ≥C A+ ∈ (R :: Ψ)) -> [] ⊢ RInv ((< Ψ > (A+ → ↑ (R ⇒ A+))) true⁻)
  wk+ {A+} {Ψ} {R} ns = Val⁻ wk+* where
    wk+* : forall {Δ γ} -> DPat Δ (< Ψ > (A+ → ↑ (R ⇒ A+))) γ -> (Δ :: []) ⊢ Neu γ
    wk+* (Dapp p De⁺) with cpat [] (EmbC.I (skipΨ (< R :: Ψ > A+) (embedΨid (< R :: Ψ > A+) Ψ) ns)) p
    ...                  | _ , σ , p' = Rf (Val⁺ (Cλ p') σ)
    
