{-# OPTIONS --no-termination-check #-}
-- FIXME: These theorems are proved by the same loop as
--        identity.  We could get them to termination check
--        by making the subformula metric explicit.

-- Companion code to
--    Focusing on Binding and Computation
--    Daniel R. Licata, Noam Zeilberger, Robert Harper

open import lib.Prelude
open import focbind.Language
open import focbind.Sugar
open import focbind.StructuralGamma
open import focbind.rulestruct.Subord
open import focbind.rulestruct.NSDiff
open List using (_++_)
open Not

module focbind.rulestruct.Transport where

module Transport (InΣ : Types.Rule -> Set) where

  open Focus(InΣ)
  open StructuralGamma(InΣ)
  open Sugar(InΣ)
  open Subord(InΣ)
  open Rels
  open NSDiff(InΣ)

  open List.SW
  open List.InLists
  
  mustkeep : forall {As Ψ Ψ' D} 
           -> DiffC.R (< Ψ > (D⁺ D)) (< Ψ' > (D⁺ D)) -> (D ⇐ As ∈ Ψ) -> (D ⇐ As ∈ Ψ')
  mustkeep (DiffC.I em em') u = mustkeep' em u where
    mustkeep' : forall {As Ψ Ψ1 Ψ' D} 
              -> DiffΨ (< Ψ > (D⁺ D)) Ψ1 Ψ' -> (D ⇐ As ∈ Ψ1) -> (D ⇐ As ∈ Ψ')
    mustkeep' Done () 
    mustkeep' (Keep em) i0 = i0
    mustkeep' (Keep em) (iS u) = iS (mustkeep' em u)
    mustkeep' (Skip em sub) (iS u) = mustkeep' em u 
    mustkeep' {As} (Skip _  sub) i0 with sub (subD {As} (Inl Refl))
    ...                                | () 
    mustkeep' (Add em ns) i = iS (mustkeep' em i)
  
  mutual
    cpats : (Γ : UCtx) {Cs Cs' : _} {Δ : LCtx} -> DiffCs Cs Cs' -> CPats Δ Cs 
          -> Σ \ Δ' -> (Δ :: Γ) ⊢ Asms Δ' × CPats Δ' Cs'
    cpats Γ {Ψ , []} {Ψ' , []} E2[] C[] = _ , Sub E[] , C[] 
    cpats Γ {Ψ , A :: As} {Ψ' , .A :: As'} ((Refl , em) E2:: ecs) (c C: cs) with cpat Γ em c | cpats Γ {Ψ , As} {Ψ' , As'} ecs cs 
    ...                                 | _ , s1 , c' | _ , s2 , cs' 
       = _ , append-⊢ s1 s2 , c' C: cs'
    cpats Γ {_ , [] } {_ , _ :: _ } () _ 
    cpats Γ {_ , _ :: _ } {_ , [] } () _ 
  
    cpat : (Γ : UCtx) {Ψ Ψ' : List Types.Rule} {Δ : LCtx} {A+ : Pos} -> DiffC.R (< Ψ > A+) (< Ψ' > A+) -> CPat Δ (< Ψ > A+) 
         -> Σ \ Δ' -> (Δ :: Γ) ⊢ Asms Δ' × CPat Δ' (< Ψ' > A+)
    cpat Γ em Cx⁻ = _ , Sub (Val⁻ (\{Δ'} {γ'} d' -> Lf (List.SW.sS (List.SW.s0 i0)) (ncont _ (amC em (\lta -> sub↓ lta) (\lta -> sub↓ lta)) d')) E:: E[]) , Cx⁻  
    cpat Γ em Cx⁺ = _ , Sub (Vx⁺ (List.SW.s0 i0)  E:: E[]) , Cx⁺
    cpat Γ em C<> = _ , Sub E[] , C<>
    cpat Γ em (Cpair c1 c2) with cpat Γ (amC em (\lta -> sub* (Inl lta)) (\lta -> sub* (Inl lta))) c1 |  cpat Γ (amC em (\lta -> sub* (Inr lta)) (\lta -> sub* (Inr lta))) c2 
    ...                      | (_ , s1 , c1') | (_ , s2 , c2') = _ , (append-⊢ s1 s2) , Cpair c1' c2'
    cpat Γ em (Cinl p) with cpat Γ (amC em (\lta -> sub+ (Inl lta)) (\lta -> sub+ (Inl lta))) p 
    ...                | _ , s , p' = _ , s , Cinl p' 
    cpat Γ em (Cinr p) with cpat Γ (amC em (\lta -> sub+ (Inr lta)) (\lta -> sub+ (Inr lta))) p 
    ...                | _ , s , p' = _ , s , Cinr p' 
    cpat Γ em (Cbox c) = _ , Ids List.SW.s0 , Cbox c
    cpat Γ {Ψ} {Ψ'} {_} {R ⇒ A+} (DiffC.I em em') (Cλ c) with 
          cpat Γ (DiffC.I (keepΨ {_} {_} {Ψ} {Ψ'} (< R :: Ψ > A+) (amΨ (< Ψ > (R ⇒ A+)) (< R :: Ψ > A+) em (\lta -> sub⇒ lta)))
                        (keepΨ {_} {_} {Ψ} {Ψ'} (< R :: Ψ' > A+) (amΨ (< Ψ' > (R ⇒ A+)) (< R :: Ψ' > A+) em' (\lta -> sub⇒ lta)))) c
    ... | _ , emd , c' = _ , emd , Cλ c'
    cpat Γ {Ψ} {Ψ'} em (Cc c cs) with cpats Γ {< Ψ > _} {< Ψ' > _} (diffargs {Ψ} {Ψ'} em (Inr c) (Inr c)) cs 
    ...                           | _ , sub , cs' = _ , sub , Cc c cs' 
    cpat Γ {Ψ} {Ψ'} em (Cv u cs) with cpats Γ {< Ψ > _} {< Ψ' > _} (diffargs {Ψ} {Ψ'} em (Inl u) (Inl (mustkeep em u))) cs 
    ...                  | _ , emd , cs' = _ , emd , Cv (mustkeep em u) cs' 

    dpat : (Γ : UCtx) {Ψ Ψ' : List Types.Rule} {Δ' : LCtx} {A- : Neg} {γ' : Conc} 
         -> DiffC.R (< Ψ > A-) (< Ψ' > A-) -> DPat Δ' (< Ψ' > A-) γ'
         -> Σ \ Δ -> Σ \ γ -> ((Δ' :: Γ) ⊢ Asms Δ) × ((Δ' :: Γ) ⊢ LInv γ γ') × DPat Δ (< Ψ > A-) γ
    dpat _ df De⁻ = _ , _ , Sub E[] , Ke⁻ , De⁻
    dpat Γ df De⁺ = _ , _ , Sub E[] , Cont⁺ (\{Δ} p -> Rf (pval _ (amC df (\x -> sub↑ x) (\x -> sub↑ x)) p)) , De⁺
    dpat Γ df (Dapp {_} {Δ1} {Δ2} c d) with cpat Γ (amC (diffCsym df) (\x -> sub→ (Inl x)) (\x -> sub→ (Inl x))) c 
                            | dpat Γ (amC df (\x -> sub→ (Inr x)) (\x -> sub→ (Inr x))) d
    ...                     | _ , σ1 , c1 | _ , _ , σ2 , k+ , d2 = _ , _ , append-⊢ σ1 σ2 , WeakenΓ.weaken f  k+ , (Dapp c1 d2)
      where f : {α : Hyp} -> α ∈∈ (Δ2 :: Γ) -> α ∈∈ ((Δ2 ++ Δ1) :: Γ)
            f (List.SW.s0 i) = s0 (List.In.iswapapp Δ2 Δ1 (List.In.iSmany Δ2 Δ1 i))
            f (List.SW.sS s) = (List.SW.sS s)
    dpat Γ df (Dfst d) with dpat Γ (amC df (\x -> sub& (Inl x)) (\x -> sub& (Inl x))) d
    ...                   | _ , _ , σ , k+ , d' = _ , _ , σ , k+ , (Dfst d')
    dpat Γ df (Dsnd d) with dpat Γ (amC df (\x -> sub& (Inr x)) (\x -> sub& (Inr x))) d
    ...                   | _ , _ , σ , k+ , d' = _ , _ , σ , k+ , (Dsnd d')
    dpat Γ {Ψ} {Ψ'} {_} {R ∧ A+} (DiffC.I em em') (Dunpack d) with 
          dpat Γ (DiffC.I (keepΨ {_} {_} {Ψ} {Ψ'} (< R :: Ψ > A+) (amΨ (< Ψ > (R ∧ A+)) (< R :: Ψ > A+) em (\lta -> sub∧ lta)))
                        (keepΨ {_} {_} {Ψ} {Ψ'} (< R :: Ψ' > A+) (amΨ (< Ψ' > (R ∧ A+)) (< R :: Ψ' > A+) em' (\lta -> sub∧ lta)))) d
    ... | _ , _ , σ , k+ , d' = _ , _ , σ , k+ , Dunpack d'
    dpat Γ em (Dundia d) = _ , _ , Ids List.SW.s0 , ke , Dundia d
    dpat Γ df (Dcur d) with dpat Γ (amC df (\x -> sub∀Wcur x) (\x -> sub∀Wcur x)) d
    ...                   | _ , _ , σ , k+ , d' = _ , _ , σ , k+ , (Dcur d')
    dpat Γ df (Dextend i d) with dpat Γ (amC df (\x -> sub∀Wextend i x) (\x -> sub∀Wextend i x)) d
    ...                      | _ , _ , σ , k+ , d' = _ , _ , σ , k+ , (Dextend i d')

    pval : (Γ : UCtx) {Ψ Ψ' : List Types.Rule} {Δ : LCtx} {A+ : Pos} 
          -> DiffC.R (< Ψ > A+) (< Ψ' > A+) -> CPat Δ (< Ψ > A+)
          -> (Δ :: Γ) ⊢ RFoc (< Ψ' > A+)
    pval Γ df c with cpat Γ df c 
    ...          | ( _ , σ' , c') = Val⁺ c' σ'

    ncont : (Γ : UCtx) {Ψ Ψ' : List Types.Rule} {Δ' : LCtx} {A- : Neg} {γ' : Conc} 
          -> DiffC.R (< Ψ > A-) (< Ψ' > A-) -> DPat Δ' (< Ψ' > A-) γ'
          -> (Δ' :: Γ) ⊢ LFoc (< Ψ > A-) γ'
    -- termination checks if you break the cycle here
    ncont Γ diff d' with dpat Γ diff d'
    ...              | ( _ , _ ,  σ , k+ , d) = Cont⁻ d σ k+

  str+ : forall {A+ Ψ R} -> ¬ (head R ≤ A+ ∈ (R :: Ψ)) -> [] ⊢ RInv ((< Ψ > ((R ⇒ A+) → ↑ A+)) true⁻)
  str+ {A+} {Ψ} {R} ns = Val⁻ str+* where
    str+* : forall {Δ γ} -> DPat Δ (< Ψ > ((R ⇒ A+) → ↑ A+)) γ -> (Δ :: []) ⊢ Neu γ
    str+* (Dapp (Cλ p) De⁺) = Rf (pval _ (DiffC.I (skipΨ (< R :: Ψ > A+) (diffΨrefl (< R :: Ψ > A+) Ψ) ns)
                                                  (skipΨ (< Ψ > A+) (diffΨrefl (< Ψ > A+) Ψ) (RelLemmas.notsub-respects-⊆ ns iS))) p)

--   str- : forall {A- Ψ R} -> ¬ (head R ≤ A- ∈ (R :: Ψ)) -> [] ⊢ RInv ((< Ψ > ((R ⇒ ↓ A-) → A-)) true⁻)
--   str- {A- } {Ψ} {R} ns = Val⁻ str-* where
--         str-* : forall {Δ γ} -> DPat Δ (< Ψ > ((R ⇒ ↓ A-) → A-)) γ -> (Δ :: []) ⊢ Neu γ
--         str-* (Dapp {._} {.Δ2} (Cλ Cx⁻) d) = Lf (s0 (List.In.iSmany _ Δ2 i0)) {! !} 
