{-# OPTIONS --no-termination-check #-}
-- FIXME: These theorems are proved by the same loop as
--        identity.  We could get them to termination check
--        by making the subformula metric explicit.

-- Companion code to
--    Focusing on Binding and Computation
--    Daniel R. Licata, Noam Zeilberger, Robert Harper

open import lib.Prelude
open import focbind.Language
open import focbind.Sugar
open import focbind.StructuralGamma
open import focbind.rulestruct.Subord
open import focbind.rulestruct.Weaken
open import focbind.rulestruct.Transport
open import focbind.rulestruct.CISEmbed
open import focbind.rulestruct.NSDiff
open List using (_++_)
open Not

module focbind.rulestruct.Subst where

module Subst (InΣ : Types.Rule -> Set) where
  
  open Focus(InΣ)
  open Sugar(InΣ)
  open Subord(InΣ)
  open StructuralGamma(InΣ)
  module W = Weaken(InΣ)
  module T = Transport(InΣ)
  
  open Rels
  open RelLemmas
  module CIS = CISEmbed(InΣ)
  module NS = NSDiff(InΣ)

  open List.InLists
  open List.SW

  mutual

    dpat : (Γ : UCtx) {Ψ : RCtx} {Δ0 : LCtx} {Δ : LCtx} {D : Atom} {A- : Neg} {γ : Conc}
        -> (i : ((D ⇐ []) ∈ Ψ)) 
        -> CPat Δ0 (< List.In.remove Ψ i > D⁺ D)
        -> DPat Δ (< List.In.remove Ψ i > A-) γ
        -> D ≥C A- ∈ Ψ
        -> bindsof A- ≥C (D⁺ D) ∈ Ψ
        -> Σ \Δ' -> Σ \γ' -> DPat Δ' (< Ψ > A-) γ' × ((Δ :: Δ0 :: Γ) ⊢ Asms Δ') × ((Δ :: Δ0 :: Γ) ⊢ LInv γ' γ)
    dpat _ _ _  De⁻ _ _ = _ , _ , De⁻ , Sub E[] , Ke⁻ 
    dpat Γ i c0 De⁺ (insub↑ ins) bnd = _ , _ , De⁺ , Sub E[] , Cont⁺ (\{Δnew} p -> Rf (WeakenΓ.weaken wkn (pval _ i c0 p ins (\{R1} {Ψ'} binds ew -> bnd (binds↑ binds) (List.EW.mapew binds↑ ew)))))
      where
      wkn : forall {Δnew Δ0} -> ({a : Contexts.Hyp} -> _∈∈_ a (_::_ (Δnew ++ Δ0) (Δnew :: Γ))
                                   -> _∈∈_ a (_::_ Δnew (_::_ [] (_::_ Δ0 Γ))))
      wkn {Δnew} {Δ0} (s0 i) with List.In.splitappend Δnew Δ0 i
      ...           | Inl i1 = s0 i1
      ...           | Inr i2 = sS (sS (s0 i2))
      wkn (sS (s0 i)) = s0 i
      wkn (sS (sS s)) = sS (sS (sS s)) 

    dpat Γ { Ψ } {Δ0} {A- = (A+ → B-)} i p0 (Dapp {.(List.In.remove Ψ i)}  {Δ1} {Δ2} c d) (insub→ isa isb) bnds 
      with T.cpat Γ { (List.In.remove Ψ i) } { Ψ } (NS.DiffC.I (List.CondDiff.fromRemove i (notsub-respects-⊆ isa (\{_} -> List.Subset.⊆remove i))) (List.CondDiff.fromRemove i isa)) c
         | dpat Γ i p0 d isb (\{R1} {Ψ'} bnd ew -> bnds (binds→ bnd) (List.EW.mapew binds→ ew))
    ... | (_ , σ1 , c') | (_ , _ , d' , σ2 , k+)  =  _ , _ , Dapp c' d' , WeakenΓ.weaken wkn σ1 +s+ WeakenΓ.weaken f σ2 , WeakenΓ.weaken f k+ where 
         f : {Δ1 Δ2 : LCtx} { Γ : UCtx} -> {α : Hyp} -> α ∈∈ (Δ2 :: Γ) -> α ∈∈ ((Δ2 ++ Δ1) :: Γ)
         f {Δ1}{Δ2} i = List.Subsets.⊆SSlast-append-right {_} {Δ2} {Δ1} i
         wkn : {α : Hyp} -> α ∈∈ (Δ1 :: Γ) -> α ∈∈ ((Δ2 ++ Δ1) :: Δ0 :: Γ)
         wkn (s0 i) = s0 (List.In.iSmany Δ1 Δ2 i) 
         wkn (sS s) = sS (sS s)
    dpat Γ i p0 (Dfst d) (insub& isa isb) bnds 
      with dpat Γ i p0 d isa (\{R1} {Ψ'} bnd ew -> bnds (binds& (Inl bnd)) (List.EW.mapew (\x -> binds& (Inl x)) ew))
    ... | (_ , _ , d' , σ2 , k+)  =  _ , _ , Dfst d' , σ2 , k+ 
    dpat Γ i p0 (Dsnd d) (insub& isa isb) bnds 
      with dpat Γ i p0 d isb (\{R1} {Ψ'} bnd ew -> bnds (binds& (Inr bnd)) (List.EW.mapew (\x -> binds& (Inr x)) ew))
    ... | (_ , _ , d' , σ2 , k+)  =  _ , _ , Dsnd d' , σ2 , k+ 
    dpat Γ {Ψ} {Δ} {Δ0} {D = D} i p0 (Dunpack{New ⇐ As} p) (insub∧ insub) birrel with 
      (W.cpat Γ
              {(List.In.remove Ψ i)} 
              (CIS.EmbC.I (CIS.skipΨ (< (New ⇐ As) :: (List.In.remove Ψ i) > D⁺ D) 
                                   (CIS.embedΨid (< (New ⇐ As) :: (List.In.remove Ψ i) > D⁺ D) (List.In.remove Ψ i))
                                   (insub-respects-⊆
                                     (birrel (binds∧ (Inl Refl)) (binds∧ (Inl Refl) E:: E[])) (List.Subset.⊆remove (iS i)))))  
              p0)
    ... | _ , σ0 , wp0 with dpat Γ (iS i) wp0 p insub (\{R1} {R2} binds -> \binds2 -> Id.subst (\l -> head R1 ≥C D⁺ D ∈ l)
                                                                                       (List.append-assoc {_} {R2} {(New ⇐ As) :: []} {Ψ})
                                                                                       (birrel {R1} {R2 ++ (New ⇐ As) :: []} (binds∧ (Inr binds))
                                                                                        (List.EW.appendew (List.EW.mapew (\x -> binds∧ (Inr x)) binds2)
                                                                                         (binds∧ (Inl Refl) E:: E[])))) 
    ...                      | _ , _ , d' , σ' , k+ = _ , _ , Dunpack d' 
                                                        , SubstΓ.subst (iS (iS i0)) (WeakenΓ.weaken sS σ0) (WeakenΓ.weaken wkn σ') 
                                                        , SubstΓ.subst (iS (iS i0)) (WeakenΓ.weaken sS σ0) (WeakenΓ.weaken wkn k+) where
      wkn : forall {Δa} -> List.Subsets._⊆SS_ (Δ0 :: Δa :: Γ) (Δ0 :: Δ :: Δa :: Γ) 
      wkn (s0 i) = s0 i 
      wkn (sS s) = sS (sS s)
    dpat Γ i p0 (Dundia d) _ _ = _ , _ , Dundia d , Ids List.SW.s0 , ke 
    dpat Γ i p0 (Dcur d) (insub∀W isa _) bnds 
      with dpat Γ i p0 d isa (\{R1} {Ψ'} bnd ew -> bnds (binds∀Wcur bnd) (List.EW.mapew (\x -> binds∀Wcur x) ew))
    ... | (_ , _ , d' , σ2 , k+)  =  _ , _ , Dcur d' , σ2 , k+ 
    dpat Γ i p0 (Dextend r d) (insub∀W _ is) bnds 
      with dpat Γ i p0 d (is r) (\{R1} {Ψ'} bnd ew -> bnds (binds∀Wextend r bnd) (List.EW.mapew (\x -> binds∀Wextend r x) ew))
    ... | (_ , _ , d' , σ2 , k+)  =  _ , _ , Dextend r d' , σ2 , k+ 

    cpat : (Γ : UCtx) {Ψ : RCtx} {Δ0 : LCtx} {Δ : LCtx} {D : Atom} {A+ : Pos} 
        -> (i : ((D ⇐ []) ∈ Ψ)) 
        -> CPat Δ0 (< List.In.remove Ψ i > D⁺ D)
        -> CPat Δ (< Ψ > A+) 
        -> D ≥C A+ ∈ Ψ
        -> bindsof A+ ≥C (D⁺ D) ∈ Ψ
        -> (Σ \ Δ' -> ((Δ ++ Δ0) :: Γ ⊢ Asms Δ') × CPat Δ' (< List.In.remove Ψ i > A+))
    cpat Γ i c0 Cx⁺ _ _  = 
      (_ , Sub (Vx⁺ (List.SW.s0 i0) E:: E[]) , Cx⁺)
    cpat Γ { Ψ } {Δ0} {A+ = ↓ A- } i p0 Cx⁻ (insub↓ insub) birrel = 
        ((< List.In.remove Ψ i > A-) true⁻) :: [] , 
        Sub (Val⁻ (\{Δ'} {γ'} d' -> Lf (List.SW.sS (List.SW.s0 i0))
                                       (WeakenΓ.weaken (\{a} i -> wkn {Δ'} {Δ0} i) (ncont _ i p0 d' insub (\{R} {Ψ'} bnd ew -> birrel (binds↓ bnd) (List.EW.mapew binds↓ ew)))))
                                    E:: E[]) ,
        Cx⁻ where
      wkn : forall {Δ' Δ0 α} -> ({a : Contexts.Hyp} -> _∈∈_ a (_::_ Δ' (_::_ Δ0 (Δ' :: Γ)))
                                    -> _∈∈_ a (_::_ Δ' (_::_ (_::_ α Δ0) Γ)))
      wkn (List.SW.s0 i) = s0 i 
      wkn (List.SW.sS (List.SW.s0 i)) = sS (s0 (iS i))
      wkn (List.SW.sS (List.SW.sS (s0 i))) = s0 i
      wkn (List.SW.sS (List.SW.sS (sS s))) = sS (sS s)

    cpat Γ i c0 C<> _ _ = ([] , Sub E[] , C<>)
    cpat Γ i p0 (Cinl p) (insub+ l r) birrel with (cpat Γ i p0 p l (\{Ψ'} bindA ew -> birrel (binds+ (Inl bindA)) (List.EW.mapew (\x -> binds+ (Inl x)) ew)))
    ...                  | (Δ' , (ew' , p')) = Δ' , (ew' , Cinl p')
    cpat Γ i p0 (Cinr p) (insub+ l r) birrel with (cpat Γ i p0 p r (\{Ψ'} bindA ew -> birrel (binds+ (Inr bindA)) (List.EW.mapew (\x -> binds+ (Inr x)) ew)))
    ...                  | (Δ' , (ew' , p')) = Δ' , (ew' , Cinr p')
    cpat Γ {Δ0 = Δ0} i p0 (Cpair {Δ1} {Δ2} p1 p2) (insub* i1 i2) birrel 
      with (cpat Γ i p0 p1 i1 (\{Ψ'} bind ew -> birrel (binds* (Inl bind)) (List.EW.mapew (\x -> binds* (Inl x)) ew)))
         | (cpat Γ i p0 p2 i2 (\{Ψ'} bind ew -> birrel (binds* (Inr bind)) (List.EW.mapew (\x -> binds* (Inr x)) ew)))
    ... | (_ , σ1 , p1') | (_ , σ2 , p2') = _ , WeakenΓ.weaken
                                                 (\{a} i ->
                                                    List.Subsets.⊆SSlast-append-left-left {_} {Δ0} {Δ1} {Δ2} {Γ} i)
                                                 σ1
                                                 +s+
                                                 WeakenΓ.weaken
                                                 (\{a} i ->
                                                    List.Subsets.⊆SSlast-append-left-right {_} {Δ0} {Δ2} {Δ1} {Γ} i)
                                                 σ2 , Cpair p1' p2'
    cpat Γ {Ψ} {Δ} {Δ0} {D = D} i p0 (Cλ{New ⇐ As} p) (insub⇒ insub) birrel with 
      (W.cpat Γ
              {(List.In.remove Ψ i)} 
              (CIS.EmbC.I (CIS.skipΨ (< (New ⇐ As) :: (List.In.remove Ψ i) > D⁺ D) 
                                   (CIS.embedΨid (< (New ⇐ As) :: (List.In.remove Ψ i) > D⁺ D) (List.In.remove Ψ i))
                                   (insub-respects-⊆
                                     (birrel (binds⇒ (Inl Refl)) (binds⇒ (Inl Refl) E:: E[])) (List.Subset.⊆remove (iS i)))))
              p0)
    ... | _ , σ0 , wp0 with cpat Γ (iS i) wp0 p insub (\{R1} {R2} binds -> \binds2 -> Id.subst (\l -> head R1 ≥C D⁺ D ∈ l)
                                                                                       (List.append-assoc {_} {R2} {(New ⇐ As) :: []} {Ψ})
                                                                                       (birrel {R1} {R2 ++ (New ⇐ As) :: []} (binds⇒ (Inr binds))
                                                                                        (List.EW.appendew (List.EW.mapew (\x -> binds⇒ (Inr x)) binds2)
                                                                                         (binds⇒ (Inl Refl) E:: E[])))) 
    ...                      | _ , σ , p' = _ , SubstΓ.subst (iS i0) (WeakenΓ.weaken (\{a} i -> List.Subsets.⊆SSlast-append-left {_}{Δ0}{Δ} i) σ0 
                                                                     +s+ 
                                                                     Ids (\{a} x -> s0 (List.In.iSmany-right Δ0 Δ x)))
                                                                     (WeakenΓ.weaken sS σ) 
                                              , Cλ p'
    cpat Γ i p0 (Cc c ps) (insubD is) bnd with 
      cpats Γ i p0 ps (is (Inr c)) 
        (List.EW.fromall (\{A+} i {R1} {Ψ'} binds ewbinds -> bnd {R1} {Ψ'} (bindsD (Inr c , List.SW.fromin i binds)) 
                                                                (List.EW.mapew (\{R2} abinds -> bindsD (Inr c , List.SW.fromin i abinds)) ewbinds))) 
    ...                   | Δ' , (σ , ps') = (Δ' , (σ , Cc c ps'))
    cpat Γ {Δ = Δ} i p0 (Cv i' ps) (insubD is) bnd with List.In.indeq i i' 
    ... | Inl Refl = _ , Ids (\{_} x -> List.SW.s0 (List.In.iSmany _ Δ x)) , p0
    ... | Inr i'WithNewType with
      cpats Γ i p0 ps (is (Inl i')) 
        (List.EW.fromall (\{A+} i {R1} {Ψ'} binds ewbinds -> bnd {R1} {Ψ'} (bindsD (Inl i' , List.SW.fromin i binds)) 
                                                                (List.EW.mapew (\{R2} abinds -> bindsD (Inl i' , List.SW.fromin i abinds)) ewbinds))) 
    ...                   | Δ' , (σ , ps') = _ , σ , Cv i'WithNewType ps'
  
    cpat Γ {Δ0 = Δ0} {Δ = Δ} i p0 (Cbox p) _ _ = (_ , Ids (\x -> List.SW.s0 (List.In.iswapapp Δ Δ0 (List.In.iSmany _ Δ0 x))) , Cbox p)

    cpats : (Γ : UCtx) {Ψ : RCtx} {Δ0 : LCtx} {Δ : LCtx} {D : Atom} {As+ : List Pos} 
        -> (i : ((D ⇐ []) ∈ Ψ)) 
        -> CPat Δ0 (< List.In.remove Ψ i > D⁺ D)
        -> CPats Δ (< Ψ > As+) 
        -> Everywhere (\A+ -> D ≥C A+ ∈ Ψ) As+
        -> Everywhere (\A+ -> bindsof A+ ≥C (D⁺ D) ∈ Ψ) As+
        -> (Σ \ Δ' -> ((Δ ++ Δ0) :: Γ ⊢ Asms Δ') × CPats Δ' (< List.In.remove Ψ i > As+))
    cpats Γ _ _ C[] E[] E[] = _ , Sub E[] , C[]
    cpats Γ {Δ0 = Δ0} i p0 (_C:_ {Δ1} {Δ2} c cs) (is E:: iss) (bnd E:: bnds) 
          with cpat Γ i p0 c is bnd | cpats Γ i p0 cs iss bnds
    ...      | _ , s1 , c' | _ , s2 , cs' 
        = _ , WeakenΓ.weaken (\{a} i ->
                                 List.Subsets.⊆SSlast-append-left-left {_} {Δ0} {Δ1} {Δ2} {Γ} i) s1 +s+
               WeakenΓ.weaken (\{a} i ->
                                 List.Subsets.⊆SSlast-append-left-right {_} {Δ0} {Δ2} {Δ1} {Γ} i) s2 , c' C: cs'

    ncont : (Γ : UCtx) {Ψ : RCtx} {Δ0 : LCtx} {Δ : LCtx} {D : Atom} {A- : Neg} {γ : Conc}
        -> (i : ((D ⇐ []) ∈ Ψ)) 
        -> CPat Δ0 (< List.In.remove Ψ i > D⁺ D)
        -> DPat Δ (< List.In.remove Ψ i > A-) γ
        -> D ≥C A- ∈ Ψ
        -> bindsof A- ≥C (D⁺ D) ∈ Ψ
        -> (Δ :: Δ0 :: Γ) ⊢ LFoc (< Ψ > A-) γ
    ncont Γ i c0 d is bs with dpat Γ i c0 d is bs
    ...                     | (_ , _ , d' , σ , k+) = Cont⁻ d' σ k+
    

    pval : (Γ : UCtx) {Ψ : RCtx} {Δ0 : LCtx} {Δ : LCtx} {D : Atom} {A+ : Pos} 
        -> (i : ((D ⇐ []) ∈ Ψ)) 
        -> CPat Δ0 (< List.In.remove Ψ i > D⁺ D)
        -> CPat Δ (< Ψ > A+) 
        -> D ≥C A+ ∈ Ψ
        -> bindsof A+ ≥C (D⁺ D) ∈ Ψ
        -> (Δ ++ Δ0) :: Γ ⊢ RFoc (< List.In.remove Ψ i > A+)
    pval Γ i c0 c is bnds with cpat Γ i c0 c is bnds
    ... | ( _ , σ , c') = Val⁺ c' σ
 

  apply : {Γ : UCtx} {Ψ : RCtx} {D : Atom} {A+ : Pos} 
      -> D ≥C A+ ∈ ((D ⇐ []) :: Ψ)
      -> bindsof A+ ≥C (D⁺ D) ∈ ((D ⇐ []) :: Ψ)
      -> Γ ⊢ RInv ((< Ψ > ((((D ⇐ []) ⇒ A+) * (D⁺ D)) → ↑ A+)) true⁻)
  apply {Γ} {Ψ} {D} {A+} ins bnd = Val⁻ apply* where
    apply* : forall {Δ γ} -> DPat Δ (< Ψ > ((((D ⇐ []) ⇒ A+) * (D⁺ D) ) → ↑ A+)) γ -> (Δ :: Γ) ⊢ Neu γ
    apply* (Dapp (Cpair{Δ1} {Δ2} (Cλ p) p0) De⁺) = WeakenΓ.weaken (List.Subsets.⊆SSlast (List.In.iswapapp Δ2 Δ1)) (Rf (pval Γ i0 p0 p ins bnd))
