-- Companion code to ~
--    Focusing on Binding and Computation
--    Daniel R. Licata, Noam Zeilberger, Robert Harper

open import lib.Prelude
open import focbind.Language
open List using (_++_)
open Not

module focbind.rulestruct.Subord where

module Subord (InΣ : Types.Rule -> Set) where
  
  open Focus(InΣ) 
    
  module Rels where
    data _≤_∈_ : {K : Kind} -> Atom -> Type K -> RCtx -> Set where
      -- Pos
      sub↓ : forall {A- P Ψ} -> P ≤ A- ∈ Ψ -> P ≤ (↓ A-) ∈ Ψ 
      sub* : forall {P A+ B+ Ψ} -> Either (P ≤ A+ ∈ Ψ) (P ≤ B+ ∈ Ψ) -> P ≤ (A+ * B+) ∈ Ψ 
      sub+ : forall {P A+ B+ Ψ} -> Either (P ≤ A+ ∈ Ψ) (P ≤ B+ ∈ Ψ) -> P ≤ (A+ + B+) ∈ Ψ 
      sub⇒ : forall {P A+ Ψ R} -> P ≤ A+ ∈ (R :: Ψ) -> P ≤ (R ⇒ A+) ∈ Ψ
      sub□  : forall {P A+ Ψ } -> P ≤ A+ ∈ [] -> P ≤ (□ A+) ∈ Ψ
      subD  : forall {As Ψ P Q} ->
              Either (Id P Q)
                     (Either (Q ⇐ As ∈ Ψ) (InΣ (Q ⇐ As)) 
                      × List.SW.Somewhere (\A+ -> P ≤ A+ ∈ Ψ) As)
            -> P ≤ (D⁺ Q) ∈ Ψ
      -- Neg
      sub↑  : forall {P A+ Ψ } -> P ≤ A+ ∈ Ψ -> P ≤ (↑ A+) ∈ Ψ 
      sub→  : forall {P A+ B- Ψ} -> Either (P ≤ A+ ∈ Ψ) (P ≤ B- ∈ Ψ) -> P ≤ (A+ → B-) ∈ Ψ 
      sub&  : forall {P A- B- Ψ } -> Either (P ≤ A- ∈ Ψ) (P ≤ B- ∈ Ψ) -> P ≤ (A- & B-) ∈ Ψ 
      sub∧  : forall {P A- Ψ R } -> P ≤ A- ∈ (R :: Ψ) -> P ≤ (R ∧ A-) ∈ Ψ
      sub◇  : forall {P A- Ψ } -> P ≤ A- ∈ [] -> P ≤ (◇ A-) ∈ Ψ
      -- kind of a cheat?  you might end up with multiple copies of some subset of the rules in Ψ';
      -- but it should suffice to check all of them once
      sub∀Wcur : forall {Ψ' P A- Ψ} -> (P ≤ A- ∈ Ψ) -> P ≤ (∀W Ψ' A-) ∈ Ψ
      sub∀Wextend : forall {R Ψ' P A- Ψ} -> (R ∈ Ψ') -> (P ≤ (R ∧ (∀W Ψ' A-)) ∈ Ψ) -> P ≤ (∀W Ψ' A-) ∈ Ψ
  
    _≤T_ : forall {K1 K2} -> C (Type K1) -> C (Type K2) -> Set 
    CA ≤T CA' = ({P : Atom} -> P ≤ (snd CA) ∈ (fst CA) -> P ≤ (snd CA') ∈ (fst CA')) 
    
    -- P doesn't appear in the domain of a computational arrow
    -- FIXME : is there a way to specify this inductively instead of coinductively?
    codata _≥C_∈_ : {K : Kind} -> Atom -> Type K -> RCtx -> Set where
      insubX⁺ : forall {x P Ψ} -> P ≥C (X⁺ x) ∈ Ψ 
      insub↓ : forall {A- P Ψ} -> P ≥C A- ∈ Ψ -> P ≥C (↓ A-) ∈ Ψ 
      insub0⁺ : forall {P Ψ} -> P ≥C 0⁺ ∈ Ψ 
      insub1⁺ : forall {P Ψ} -> P ≥C 1⁺ ∈ Ψ 
      insub* : forall {P A+ B+ Ψ} -> (P ≥C A+ ∈ Ψ) -> (P ≥C B+ ∈ Ψ) -> P ≥C (A+ * B+) ∈ Ψ 
      insub+ : forall {P A+ B+ Ψ} -> (P ≥C A+ ∈ Ψ) ->  (P ≥C B+ ∈ Ψ) -> P ≥C (A+ + B+) ∈ Ψ 
      insub⇒ : forall {P A+ Ψ R} -> P ≥C A+ ∈ (R :: Ψ) -> P ≥C (R ⇒ A+) ∈ Ψ
      insub□  : forall {P A+ Ψ } -> P ≥C A+ ∈ [] -> P ≥C (□ A+) ∈ Ψ
      insubD  : forall {Ψ P Q} ->
                  (forall {As} -> 
                    Either (Q ⇐ As ∈ Ψ) (InΣ (Q ⇐ As)) 
                      -> List.Everywhere (\A+ -> P ≥C A+ ∈ Ψ) As)
            -> P ≥C (D⁺ Q) ∈ Ψ
    
      insubX⁻ : forall {x P Ψ} -> P ≥C (X⁻ x) ∈ Ψ 
      insub↑  : forall {P A+ Ψ } -> P ≥C A+ ∈ Ψ -> P ≥C (↑ A+) ∈ Ψ 
      insub→ : forall {P A+ B- Ψ} 
              -> ¬ (P ≤ A+ ∈ Ψ)  
              -> P ≥C B- ∈ Ψ -> P ≥C (A+ → B-) ∈ Ψ 
      insub&  : forall {P A- B- Ψ } -> (P ≥C A- ∈ Ψ) -> (P ≥C B- ∈ Ψ) -> P ≥C (A- & B-) ∈ Ψ 
      insub⊤ : forall {P Ψ} -> P ≥C ⊤ ∈ Ψ 
      insub∧  : forall {P A- Ψ R } -> P ≥C A- ∈ (R :: Ψ) -> P ≥C (R ∧ A-) ∈ Ψ
      insub◇  : forall {P A- Ψ } -> P ≥C A- ∈ [] -> P ≥C (◇ A-) ∈ Ψ
      insub∀W  : forall {Ψ' P A- Ψ} -> P ≥C A- ∈ Ψ -> ({R : Rule} -> R ∈ Ψ' -> P ≥C (R ∧ (∀W Ψ' A-)) ∈ Ψ)
                -> P ≥C (∀W Ψ' A-) ∈ Ψ
  
    _≥CT_ : forall {K1 K2} -> C (Type K1) -> C (Type K2) -> Set 
    CA ≥CT CA' = ({P : Atom} -> P ≥C (snd CA) ∈ (fst CA) -> P ≥C (snd CA') ∈ (fst CA')) 
      
    -- a pattern for A binds a rule with conclusion P
    data _binds_∈_ : {K : Kind} -> Type K -> Rule -> RCtx -> Set where
      binds* : forall {P A+ B+ Ψ} -> Either (A+ binds P ∈ Ψ) (B+ binds P ∈ Ψ) -> (A+ * B+) binds P ∈ Ψ 
      binds+ : forall {P A+ B+ Ψ} -> Either (A+ binds P ∈ Ψ) (B+ binds P ∈ Ψ) -> (A+ + B+) binds P ∈ Ψ 
      binds⇒ : forall {P A+ Ψ Q} 
              -> Either (Id P Q)
                        (A+ binds P ∈ (Q :: Ψ))
              -> (Q ⇒ A+) binds P ∈ Ψ
      binds□  : forall {P A+ Ψ} -> A+ binds P ∈ [] -> (□ A+) binds P ∈ Ψ
      bindsD  : forall {Ψ P Q As} 
              -> Either (Q ⇐ As ∈ Ψ) (InΣ (Q ⇐ As)) 
                 × (List.SW.Somewhere (\A+ -> A+ binds P ∈ Ψ) As)
              -> (D⁺ Q) binds P ∈ Ψ
      binds↓  : forall {Ψ A- P} -> A- binds P ∈ Ψ -> (↓ A- binds P ∈ Ψ)
      binds↑  : forall {Ψ A P} -> A binds P ∈ Ψ -> (↑ A binds P ∈ Ψ)
      -- don't need a premise for A here?
      binds→ : forall {P A B Ψ} -> (B binds P ∈ Ψ) -> (A → B) binds P ∈ Ψ 
      binds& : forall {P A B Ψ} -> Either (A binds P ∈ Ψ) (B binds P ∈ Ψ) -> (A & B) binds P ∈ Ψ 
      binds∧ : forall {P A Ψ Q} 
              -> Either (Id P Q)
                        (A binds P ∈ (Q :: Ψ))
              -> (Q ∧ A) binds P ∈ Ψ
      binds◇  : forall {P A Ψ} -> A binds P ∈ [] -> (◇ A) binds P ∈ Ψ
      binds∀Wcur : forall {P A Ψ Ψ'} -> (A binds P ∈ Ψ) -> (∀W Ψ' A) binds P ∈ Ψ
      binds∀Wextend : forall {R P A Ψ Ψ'} -> (R ∈ Ψ') -> ((R ∧ ∀W Ψ' A) binds P ∈ Ψ) -> (∀W Ψ' A) binds P ∈ Ψ

    -- everything bound by A+ is computationally insubordinate to B+
    bindsof_≥C_∈_ : {K : Kind} -> Type K -> Pos -> RCtx -> Set
    bindsof A+ ≥C B+ ∈ Ψ = ({R1 : Rule} {Ψ' : List Rule} 
                            -> A+ binds R1 ∈ Ψ -> Everywhere (\R2 -> A+ binds R2 ∈ Ψ) Ψ' 
                            -> (head R1) ≥C B+ ∈ (Ψ' ++ Ψ))

  open Rels

  module RelLemmas where
    -- contrapositive
    cp≤ : {K K' : Kind} (C1 : C (Type K)) (C2 : C (Type K')) {P : Atom}
              -> C1 ≤T C2 -> ¬ (P ≤ (snd C2) ∈ (fst C2)) -> ¬ (P ≤ (snd C1) ∈ (fst C1))
    cp≤ _ _ le notc2 c1 = notc2 (le c1)

    uninsub* : forall {P A+ B+ Ψ} -> P ≥C (A+ * B+) ∈ Ψ -> (P ≥C A+ ∈ Ψ) × (P ≥C B+ ∈ Ψ)
    uninsub* (insub* a b) = a , b
    uninsub+ : forall {P A+ B+ Ψ} -> P ≥C (A+ + B+) ∈ Ψ -> (P ≥C A+ ∈ Ψ) × (P ≥C B+ ∈ Ψ)
    uninsub+ (insub+ a b) = a , b
    uninsub⇒ : forall {P A+ Ψ R} -> P ≥C (R ⇒ A+) ∈ Ψ -> P ≥C A+ ∈ (R :: Ψ) 
    uninsub⇒ (insub⇒ a) = a 
    uninsub↓ : forall {A- P Ψ} -> P ≥C (↓ A-) ∈ Ψ -> P ≥C A- ∈ Ψ 
    uninsub↓ (insub↓ a) = a 
    uninsubD  : forall {Ψ P Q} 
            -> P ≥C (D⁺ Q) ∈ Ψ
            -> (forall {As} -> Either (Q ⇐ As ∈ Ψ) (InΣ (Q ⇐ As)) -> List.Everywhere (\A+ -> P ≥C A+ ∈ Ψ) As)
    uninsubD (insubD a) = a
    uninsub→ : forall {P A+ B- Ψ} -> P ≥C (A+ → B-) ∈ Ψ -> (¬ (P ≤ A+ ∈ Ψ)) × (P ≥C B- ∈ Ψ)
    uninsub→ (insub→ a b) = a , b
    uninsub↑ : forall {A- P Ψ} -> P ≥C (↑ A-) ∈ Ψ -> P ≥C A- ∈ Ψ 
    uninsub↑ (insub↑ a) = a 
    uninsub& : forall {P A& B& Ψ} -> P ≥C (A& & B&) ∈ Ψ -> (P ≥C A& ∈ Ψ) × (P ≥C B& ∈ Ψ)
    uninsub& (insub& a b) = a , b
    uninsub∧ : forall {P A+ Ψ R} -> P ≥C (R ∧ A+) ∈ Ψ -> P ≥C A+ ∈ (R :: Ψ) 
    uninsub∧ (insub∧ a) = a 
    uninsub∀W  : forall {Ψ' P A- Ψ} -> P ≥C (∀W Ψ' A-) ∈ Ψ
                -> P ≥C A- ∈ Ψ × ({R : Rule} -> R ∈ Ψ' -> P ≥C (R ∧ (∀W Ψ' A-)) ∈ Ψ)
    uninsub∀W (insub∀W a b) = a , \{_} -> b

    --   decide : {K : Kind} {P : Atom} {A- : Type K} {Ψ : RCtx} -> Decidable (P ≤ A- ∈ Ψ)
    --   decide = {! !} 

    open List.Subset
    open List.SW

    mutual    
      sub-respects-⊆ : forall {K P Ψ Ψ'} {A : Type K} -> P ≤ A ∈ Ψ -> Ψ ⊆ Ψ' -> P ≤ A ∈ Ψ'
      sub-respects-⊆ (sub↓ s) ss = sub↓ (sub-respects-⊆ s ss)
      sub-respects-⊆ (sub* (Inl s)) ss = sub* (Inl (sub-respects-⊆ s ss))
      sub-respects-⊆ (sub* (Inr s)) ss = sub* (Inr (sub-respects-⊆ s ss))
      sub-respects-⊆ (sub+ (Inl s)) ss = sub+ (Inl (sub-respects-⊆ s ss))
      sub-respects-⊆ (sub+ (Inr s)) ss = sub+ (Inr (sub-respects-⊆ s ss))
      sub-respects-⊆ (sub⇒ s) ss = sub⇒ (sub-respects-⊆ s (⊆-::-cong ss))
      sub-respects-⊆ (sub□ s) _ = sub□ s
      sub-respects-⊆ (subD {As} (Inl Refl)) _ = (subD {As} (Inl Refl))
      sub-respects-⊆ (subD (Inr (Inr c , s))) ss = (subD (Inr (Inr c , mapsw' s ss))) 
      sub-respects-⊆ (subD (Inr (Inl v , s))) ss = (subD (Inr (Inl (ss v) , mapsw' s ss))) 
      sub-respects-⊆ (sub↑ s) ss = sub↑ (sub-respects-⊆ s ss)
      sub-respects-⊆ (sub& (Inl s)) ss = sub& (Inl (sub-respects-⊆ s ss))
      sub-respects-⊆ (sub& (Inr s)) ss = sub& (Inr (sub-respects-⊆ s ss))
      sub-respects-⊆ (sub→ (Inl s)) ss = sub→ (Inl (sub-respects-⊆ s ss))
      sub-respects-⊆ (sub→ (Inr s)) ss = sub→ (Inr (sub-respects-⊆ s ss))
      sub-respects-⊆ (sub∧ s) ss = sub∧ (sub-respects-⊆ s (⊆-::-cong ss))
      sub-respects-⊆ (sub◇ s) _ = sub◇ s
      sub-respects-⊆ (sub∀Wcur s) ss = sub∀Wcur (sub-respects-⊆ s ss)
      sub-respects-⊆ (sub∀Wextend i s) ss = sub∀Wextend i (sub-respects-⊆ s ss)
    
      -- inlined so the termination checker is happy
      mapsw' : forall {Ψ Ψ' P} {As : List Pos} -> Somewhere (\A -> (P ≤ A ∈ Ψ)) As -> Ψ ⊆ Ψ' -> Somewhere (\A -> (P ≤ A ∈ Ψ')) As
      mapsw' (s0 pf) ss = s0 (sub-respects-⊆ pf ss)
      mapsw' (sS s) ss = sS (mapsw' s ss)

    sub-respects-≡ : forall {K P Ψ Ψ'} {A : Type K} -> P ≤ A ∈ Ψ -> Ψ ≡set Ψ' -> P ≤ A ∈ Ψ'
    sub-respects-≡ a (x , _ ) = sub-respects-⊆ a x

    notsub-respects-⊆ : forall {K P Ψ Ψ'} {A : Type K} -> ¬ (P ≤ A ∈ Ψ) -> Ψ' ⊆ Ψ -> ¬ (P ≤ A ∈ Ψ')
    notsub-respects-⊆ neg p z = neg (sub-respects-⊆ z p)

    mutual    
      insub-respects-⊆ : forall {K P Ψ Ψ'} {A : Type K} -> P ≥C A ∈ Ψ -> Ψ' ⊆ Ψ -> P ≥C A ∈ Ψ'
      insub-respects-⊆ insubX⁺ _ ~ insubX⁺
      insub-respects-⊆ insubX⁻ _ ~ insubX⁻
      insub-respects-⊆ (insub↓ s) ss ~ insub↓ (insub-respects-⊆ s ss)
      insub-respects-⊆ (insub↑ s) ss ~ insub↑ (insub-respects-⊆ s ss)
      insub-respects-⊆ insub0⁺ _ ~ insub0⁺
      insub-respects-⊆ insub1⁺ _ ~ insub1⁺
      insub-respects-⊆ insub⊤ _ ~ insub⊤
      insub-respects-⊆ (insub* s1 s2) ss ~ insub* (insub-respects-⊆ s1 ss) (insub-respects-⊆ s2 ss)
      insub-respects-⊆ (insub+ s1 s2) ss ~ insub+ (insub-respects-⊆ s1 ss) (insub-respects-⊆ s2 ss)
      insub-respects-⊆ (insub& s1 s2) ss ~ insub& (insub-respects-⊆ s1 ss) (insub-respects-⊆ s2 ss)
      insub-respects-⊆ (insub→ s1 s2) ss ~ insub→ (notsub-respects-⊆ s1 ss) (insub-respects-⊆ s2 ss)
      insub-respects-⊆ (insub⇒ s) ss ~ insub⇒ (insub-respects-⊆ s (⊆-::-cong ss))
      insub-respects-⊆ (insub∧ s) ss ~ insub∧ (insub-respects-⊆ s (⊆-::-cong ss))
      insub-respects-⊆ (insub□ s) _ ~ insub□ s
      insub-respects-⊆ (insub◇ s) _ ~ insub◇ s
      insub-respects-⊆ (insub∀W s1 s2) ss ~ insub∀W (insub-respects-⊆ s1 ss) (\{_} i -> insub-respects-⊆ (s2 i) ss)
      insub-respects-⊆ (insubD f) ss ~ insubD (\{_} eth -> mapew' (f (cast ss eth)) ss) where
        cast : forall {Ψ Ψ' Q As} -> Ψ' ⊆ Ψ -> Either (Q ⇐ As ∈ Ψ') (InΣ (Q ⇐ As)) -> Either (Q ⇐ As ∈ Ψ) (InΣ (Q ⇐ As))
        cast ss (Inl v) ~ Inl (ss v)
        cast _ (Inr v) ~ Inr v

      -- inlined for the termination checker
      mapew' : forall {Ψ Ψ' P} {As : List Pos} -> Everywhere (\A -> (P ≥C A ∈ Ψ)) As -> Ψ' ⊆ Ψ -> Everywhere (\A -> (P ≥C A ∈ Ψ')) As
      mapew'  E[] _ ~ E[]
      mapew' (_E::_ h t) ss ~ _E::_ (insub-respects-⊆ h ss) (mapew' t ss)

    insub-respects-≡ : forall {K P Ψ Ψ'} {A : Type K} -> P ≥C A ∈ Ψ -> Ψ ≡set Ψ' -> P ≥C A ∈ Ψ'
    insub-respects-≡ a (_ , x ) = insub-respects-⊆ a x
