-- Companion code to
--    Focusing on Binding and Computation
--    Daniel R. Licata, Noam Zeilberger, Robert Harper

open import lib.Prelude
open import focbind.Language
open import focbind.rulestruct.Subord
open List using (_++_)
open Not

module focbind.rulestruct.NSDiff where

-- contexts differ by insubordinate things
module NSDiff(InΣ : Types.Rule -> Set) where

  open Focus(InΣ) 
  open Subord(InΣ)
  open Rels
  open RelLemmas

  module RelC2 (RelCtx :{K : Kind} (C : C (Type K)) -> RCtx -> RCtx -> Set) where
    data R {K : Kind} : C (Type K) -> C (Type K) -> Set where
         I : {A : Type K} -> {Ψ : RCtx} {Ψ' : RCtx} 
           -> RelCtx (< Ψ > A) Ψ Ψ' 
           -> RelCtx (< Ψ' > A) Ψ Ψ'
           -> R (< Ψ > A) (< Ψ' > A)

  open List.CondDiff public

  DP : {K : Kind} (C : C (Type K)) -> Rule -> Set 
  DP C R = ¬ (head R ≤ (snd C) ∈ (fst C))

  DiffΨ : {K : Kind} (C : C (Type K)) -> RCtx -> RCtx -> Set 
  DiffΨ C Ψ1 Ψ2 = List.CondDiff.Diff (DP C) Ψ1 Ψ2

  -- wrappers to help unification:

  diffΨrefl : forall {K} (CA : C (Type K)) (Ψ : RCtx) -> DiffΨ CA Ψ Ψ 
  diffΨrefl CA Ψ = List.CondDiff.drefl Ψ

  _compΨ_ : {K : Kind} {C : C (Type K)} {Ψ1 Ψ2 Ψ3 : RCtx} -> DiffΨ C Ψ2 Ψ3 -> DiffΨ C Ψ1 Ψ2 -> DiffΨ C Ψ1 Ψ3
  _compΨ_ em1 em2 = List.CondDiff._dtrans_ em1 em2
  
  skipΨ : {K : Kind} {a : Rule} {l : RCtx} {l' : RCtx} (C : C (Type K))
         -> DiffΨ C l l'  ->   DP C a
         -> DiffΨ C (a :: l) l'
  skipΨ _ em pf = Skip em pf

  keepΨ : forall {K a l l'} -> (C : C (Type K)) -> DiffΨ C l l' -> DiffΨ C (a :: l) (a :: l')
  keepΨ _ em = Keep em

  -- anti-monotone
  amΨ : {K1 K2 : Kind} (C1 : C (Type K1)) (C2 : C (Type K2)) {Ψ Ψ' : RCtx}
            -> DiffΨ C1 Ψ Ψ' -> C2 ≤T C1 -> DiffΨ C2 Ψ Ψ'
  amΨ C1 C2 (Skip f sub) le = Skip (amΨ C1 C2 f le) (cp≤ C2 C1 le sub)
  amΨ C1 C2 (Keep f) le = Keep (amΨ C1 C2 f le)
  amΨ C1 C2 (Add f sub) le = Add (amΨ C1 C2 f le) (cp≤ C2 C1 le sub)
  amΨ _ _ Done _ = Done

  module DiffC = RelC2 (DiffΨ)

  amC : forall {Ψ Ψ' K K'} {A : Type K} {A' : Type K'} 
      -> DiffC.R (< Ψ > A) (< Ψ' > A) 
      -> (< Ψ > A') ≤T (< Ψ > A)
      -> (< Ψ' > A') ≤T (< Ψ' > A)
      -> DiffC.R (< Ψ > A') (< Ψ' > A') 
  amC {Ψ} {Ψ'} {_} {_} {A} {A'} (DiffC.I d d') le le' = 
    DiffC.I (amΨ (< Ψ > A) (< Ψ > A') d le) (amΨ (< Ψ' > A) (< Ψ' > A') d' le')

  diffCrefl : {K : Kind} (C : C (Type K)) -> DiffC.R C C
  diffCrefl (Ψ , A ) = DiffC.I (diffΨrefl (< Ψ > A) Ψ) (diffΨrefl (< Ψ > A) Ψ)

  diffCsym : forall {Ψ Ψ' K} {A : Type K} 
           -> DiffC.R (< Ψ > A) (< Ψ' > A) 
           -> DiffC.R (< Ψ' > A) (< Ψ > A) 
  diffCsym (DiffC.I a b) = DiffC.I (dsym b) (dsym a)

  open List.EW2 public

  DiffCs : C (List Pos) -> C (List Pos) -> Set 
  DiffCs Cs Cs' = Everywhere2 (\A A' -> Id A A' × DiffC.R (< (fst Cs) > A) (< (fst Cs') > A')) (snd Cs) (snd Cs') 

  diffargs : forall {Ψ Ψ' As D} 
            -> DiffC.R (< Ψ > (D⁺ D)) (< Ψ' > (D⁺ D))
            -> Either ((D ⇐ As) ∈ Ψ) (InΣ (D ⇐ As))
            -> Either ((D ⇐ As) ∈ Ψ') (InΣ (D ⇐ As))
            -> DiffCs (< Ψ > As) (< Ψ' > As)
  diffargs {Ψ} {Ψ'} {As} {D} em cv cv' = emb (ew (\x -> x)) (ew' (\x -> x))  where
    -- FIXME: abstract
    ew : forall {As0} -> List.Subset._⊆_ As0 As 
       -> List.Everywhere (\ A+ -> (< Ψ > A+) ≤T (< Ψ > (D⁺ D))) As0
    ew {[]} _ = E[] 
    ew {A0 :: As0} subset = (\{p} subA0 -> subD (Inr (cv , 
                                                  List.SW.fromin (subset i0) subA0))) 
                            E::
                            (ew {As0} (\i -> subset (iS i))) 
    ew' : forall {As0} -> List.Subset._⊆_ As0 As 
       -> List.Everywhere (\ A+ -> (< Ψ' > A+) ≤T (< Ψ' > (D⁺ D))) As0
    ew' {[]} _ = E[] 
    ew' {A0 :: As0} subset = (\{p} subA0 -> subD (Inr (cv' , 
                                                  List.SW.fromin (subset i0) subA0))) 
                            E::
                            (ew' {As0} (\i -> subset (iS i))) 
    emb : forall {As0} 
        -> List.Everywhere (\ A+ -> (< Ψ > A+) ≤T (< Ψ > (D⁺ D))) As0
        -> List.Everywhere (\ A+ -> (< Ψ' > A+) ≤T (< Ψ' > (D⁺ D))) As0
        -> DiffCs (< Ψ > As0) (< Ψ' > As0)
    emb E[] E[] = E2[]
    emb (pf E:: ew) (pf' E:: ew') = (Refl , amC em pf pf') E2:: emb ew ew'

