-- Companion code to
--    Focusing on Binding and Computation
--    Daniel R. Licata, Noam Zeilberger, Robert Harper

open import lib.Prelude
open import focbind.Language
open import focbind.rulestruct.Subord
open List using (_++_)
open Not

-- FIXME: abstract this and NSDiff

module focbind.rulestruct.CISEmbed where

-- embedding from one context another,
-- dropping only computationally insubordinate things

module CISEmbed(InΣ : Types.Rule -> Set) where

  open Focus(InΣ) 
  open Subord(InΣ)
  open Rels
  open RelLemmas

  module RelC (RelCtx :{K : Kind} (C : C (Type K)) -> RCtx -> RCtx -> Set) where
    data R {K : Kind} : C (Type K) -> C (Type K) -> Set where
         I : {A : Type K} -> {Ψ : RCtx} {Ψ' : RCtx} 
           -> RelCtx (< Ψ > A) Ψ Ψ' -- relative to the left-hand one, because it's the bigger one
           -> R (< Ψ > A) (< Ψ' > A)

  open List.CondOPE public

  EmP : {K : Kind} (C : C (Type K)) -> Rule -> Set 
  EmP C R = (head R ≥C (snd C) ∈ (fst C))

  -- Ψ2 is a subset of Ψ1, and you only drop insubord things
  EmbedΨ : {K : Kind} (C : C (Type K)) -> RCtx -> RCtx -> Set 
  EmbedΨ C Ψ1 Ψ2 = List.CondOPE.Embed (EmP C) Ψ1 Ψ2

  -- wrappers to help unification:

  embedΨid : forall {K} (CA : C (Type K)) (Ψ : RCtx) -> EmbedΨ CA Ψ Ψ 
  embedΨid CA Ψ = List.CondOPE.embedid Ψ

  _compΨ_ : {K : Kind} {C : C (Type K)} {Ψ1 Ψ2 Ψ3 : RCtx} -> EmbedΨ C Ψ2 Ψ3 -> EmbedΨ C Ψ1 Ψ2 -> EmbedΨ C Ψ1 Ψ3
  _compΨ_ em1 em2 = List.CondOPE._comp_ em1 em2

  embedΨ⊆ : forall {K} (C : C (Type K)) -> {Ψ Ψ' : RCtx} -> EmbedΨ C Ψ Ψ' -> List.Subset._⊆_ Ψ' Ψ
  embedΨ⊆ _ em = List.CondOPE.embed⊆ em

  skipΨ : {K : Kind} {a : Rule} {l : RCtx} {l' : RCtx} (C : C (Type K))
         -> EmbedΨ C l l'  ->   EmP C a
         -> EmbedΨ C (a :: l) l'
  skipΨ _ em pf = Skip em pf

  keepΨ : forall {K a l l'} -> (C : C (Type K)) -> EmbedΨ C l l' -> EmbedΨ C (a :: l) (a :: l')
  keepΨ _ em = Keep em

  module EmbC = RelC (EmbedΨ)

  open List.EW2 public

  EmbedCs : C (List Pos) -> C (List Pos) -> Set 
  EmbedCs Cs Cs' = Everywhere2 (\A A' -> Id A A' × EmbC.R (< (fst Cs) > A) (< (fst Cs') > A')) (snd Cs) (snd Cs') 

  monoΨ : {K1 K2 : Kind} (C1 : C (Type K1)) (C2 : C (Type K2)) {Ψ Ψ' : RCtx}
       -> EmbedΨ C1 Ψ Ψ' -> C1 ≥CT C2 -> EmbedΨ C2 Ψ Ψ'
  monoΨ C1 C2 (Skip f sub) le = Skip (monoΨ C1 C2 f le) (le sub)
  monoΨ C1 C2 (Keep f) le = Keep (monoΨ C1 C2 f le)
  monoΨ _ _ Done _ = Done

  monoC : forall {Ψ Ψ' K K'} {A : Type K} {A' : Type K'} 
      -> EmbC.R (< Ψ > A) (< Ψ' > A) 
      -> (< Ψ > A) ≥CT (< Ψ > A')
      -> EmbC.R (< Ψ > A') (< Ψ' > A') 
  monoC {Ψ} {Ψ'} {_} {_} {A} {A'} (EmbC.I em) le = EmbC.I (monoΨ (< Ψ > A) (< Ψ > A') em le) 

  embedC⊆ : forall {K} {A : (Type K)} -> {Ψ Ψ' : RCtx} -> EmbC.R (< Ψ > A) (< Ψ' > A) 
          -> List.Subset._⊆_ Ψ' Ψ
  embedC⊆ {K} {A} {Ψ} (EmbC.I emb) = embedΨ⊆ (< Ψ > A)  emb

  embedargs : forall {Ψ Ψ' As D} 
            -> EmbC.R (< Ψ > (D⁺ D)) (< Ψ' > (D⁺ D))
            -> Either ((D ⇐ As) ∈ Ψ) (InΣ (D ⇐ As))
             -> EmbedCs (< Ψ > As) (< Ψ' > As)
  embedargs {Ψ} {Ψ'} {As} {D} em cv = emb (ew (\x -> x)) where
    -- FIXME: write some map-like things to make this more concise
    ew : forall {As0} -> List.Subset._⊆_ As0 As 
       -> List.Everywhere (\ A+ -> (< Ψ > (D⁺ D)) ≥CT (< Ψ > A+)) As0
    ew {[]} _ = E[] 
    ew {A0 :: As0} subset = (\{P} x -> List.EW.there (uninsubD x cv) (subset i0))
                            E::
                            (ew {As0} (\i -> subset (iS i))) 
    emb : forall {As0} 
        -> List.Everywhere (\ A+ -> (< Ψ > (D⁺ D))  ≥CT (< Ψ > A+)) As0
        -> EmbedCs (< Ψ > As0) (< Ψ' > As0)
    emb E[] = E2[]
    emb (pf E:: ew) = (Refl , monoC em (\{P} gt -> pf gt)) E2:: emb ew
