-- Companion code to
--    Focusing on Binding and Computation
--    Daniel R. Licata, Noam Zeilberger, Robert Harper

open import lib.Prelude
open List using (_++_)  
open List.InLists
open List.Subsets
open List.Subset
open List.SW
open List.In

open import focbind.Language
open import focbind.StructuralGamma 

module focbind.Sugar where

module Sugar (InΣ : Types.Rule -> Set) where

  open Focus (InΣ)
  open StructuralGamma (InΣ)

  append-⊢ : forall {Γ Δ1 Δ2 Δ1' Δ2'} 
           -> (Δ1 :: Γ) ⊢ Asms Δ1' 
           -> (Δ2 :: Γ) ⊢ Asms Δ2' 
           -> (Δ2 ++  Δ1) :: Γ ⊢ Asms (Δ2' ++  Δ1')
  append-⊢ {Γ} {Δ1} {Δ2} σ1 σ2 = WeakenΓ.weaken (\{a} i -> ⊆SSlast-append-left {_} {Δ2} {Δ1} i) σ1 +s+ 
                                  WeakenΓ.weaken (\{a} i -> ⊆SSlast-append-right {_} {Δ2} {Δ1} i) σ2

  casev_of_ : forall {Γ C+ γ} -> Γ ⊢ RFoc C+ -> Γ ⊢ LInv (C+ true⁺) γ -> Γ ⊢ Neu γ
  casev v of c = Cut⁺ v c

  casee_of_ : forall {Γ γ0 γ} -> Γ ⊢ Neu γ0 -> Γ ⊢ LInv γ0 γ -> Γ ⊢ Neu γ
  casee e of c = EK⁺ e c

  case_of_ : forall {Γ C+ γ} -> Γ ⊢ Neu (C+ true⁺) -> ({ Δ : LCtx} -> CPat Δ C+ -> Δ :: Γ ⊢ Neu γ) -> Γ ⊢ Neu γ
  case e of m = EK⁺ e (Cont⁺ m)

  σe : (Γ : UCtx) -> Γ ⊢ Asms []
  σe Γ = Sub E[]

  σid : { Γ : UCtx } { Δ : LCtx } -> (Δ :: Γ) ⊢ Asms Δ 
  σid = Ids List.SW.s0 

  σid2 : { Γ : UCtx } { Δ1 : LCtx } { Δ2 : LCtx} -> (Δ2 :: Δ1 :: Γ) ⊢ Asms (Δ2 ++ Δ1)
  σid2 { Γ } { Δ1 } { Δ2 } = Ids inp where
    inp : {H : Hyp} -> (H ∈ (Δ2 ++ Δ1)) -> (H ∈∈ (Δ2 :: Δ1 :: Γ))
    inp inapp with List.In.splitappend Δ2 Δ1 inapp 
    ...          | Inl in2  = List.SW.s0 in2
    ...          | Inr in1  = List.SW.sS (List.SW.s0 in1)

  ke : {γ : Conc} {Γ : UCtx} -> Γ ⊢ LInv γ γ
  ke {_ atom⁻} = Ke⁻
  ke {_ true⁺} = Ke⁺

  -- explict, for when we want to name the context
  cont⁺e : { Γ : UCtx} {C+ : C Pos} { γ : Conc }
      -> ((Δ : LCtx) -> CPat Δ C+ -> (Δ :: Γ) ⊢ Neu γ)
      -> Γ ⊢ LInv (C+ true⁺) γ
  cont⁺e f = Cont⁺ (\p -> f _ p)

  rfv : forall {Γ C+ Δ} -> CPat Δ C+ -> Γ ⊢ Asms Δ -> Γ ⊢ Neu (C+ true⁺)
  rfv p σ = Rf (Val⁺ p σ)
        
  cont⁻i : forall { γ Γ C- Δ} -> DPat Δ C- γ -> Γ ⊢ Asms Δ -> Γ ⊢ LFoc C- γ
  cont⁻i {(_ true⁺)} k σ = Cont⁻ k σ Ke⁺
  cont⁻i {(_ atom⁻)} k σ = Cont⁻ k σ Ke⁻

  MetaFn⁻ : UCtx -> C Neg -> Set
  MetaFn⁻ Γ C- = { Δ : LCtx } { γ : Conc } -> (DPat Δ C- γ ) -> Δ :: Γ ⊢ Neu γ

  MetaFn⁺ : UCtx -> C Pos -> Conc -> Set
  MetaFn⁺ Γ C+ γ = { Δ : LCtx } -> (CPat Δ C+) -> Δ :: Γ ⊢ Neu γ

  -- tactic that inverts the negative parts for you
  IMetaFn⁻ : UCtx -> RCtx -> Neg -> Set
  IMetaFn⁻ Γ Ψ (↑ A+) = Γ ⊢ Neu ((< Ψ > A+) true⁺)
  IMetaFn⁻ Γ Ψ (A+ → B-) = {Δ1 : LCtx} -> CPat Δ1 (< Ψ > A+) -> IMetaFn⁻ (Δ1 :: Γ) Ψ B-
  IMetaFn⁻ Γ Ψ (Types.X⁻ y) = Γ ⊢ Neu (y atom⁻)
  IMetaFn⁻ Γ Ψ (Types._∧_ R A-) = IMetaFn⁻ Γ (R :: Ψ) A-
  IMetaFn⁻ Γ Ψ Types.⊤ = Unit
  IMetaFn⁻ Γ Ψ (Types._&_ y y') = MetaFn⁻ Γ (< Ψ > (Types._&_ y y'))
  IMetaFn⁻ Γ Ψ (Types.◇ y) = IMetaFn⁻ Γ [] y
  IMetaFn⁻ Γ Ψ (Types.∀W R A-) = {Ψ' : RCtx} -> (Ψ' ⊆ R) -> IMetaFn⁻ Γ (List.appendmayber Ψ' Ψ) A-

  pack : forall {Γ Ψ} -> (A : Neg) -> IMetaFn⁻ Γ Ψ A -> MetaFn⁻ Γ (< Ψ > A)
  pack (↑ A+) f De⁺ = WeakenΓ.weaken sS f 
  pack (A+ → B-) f (Dapp c d) = WeakenΓ.weaken wkn (pack B- (f c) d) 
    where wkn : {Δ2 : LCtx} {Δ1 : LCtx} {Γ : UCtx} -> (Δ2 :: Δ1 :: Γ) ⊆SS ((Δ2 ++ Δ1) :: Γ)
          wkn {Δ2} {Δ1} (s0 i) = s0 (iSmany-right Δ2 Δ1 i)
          wkn {Δ2} {Δ1} (sS (s0 i)) = s0 (iSmany Δ1 Δ2 i)
          wkn (sS (sS i)) = sS i
  pack (Types.X⁻ y) f De⁻ = WeakenΓ.weaken sS f
  pack (Types._∧_ R B-) f (Dunpack d) = pack B- f d
  pack Types.⊤ f () 
  pack (Types._&_ y y') f p = f p
  pack (Types.◇ y) f (Dundia p) = pack y f p
  pack {Γ} (Types.∀W Rs A-) f (Dcur d) = pack A- (Id.subst (\l -> IMetaFn⁻ Γ l A-)
                                                   (List.appendmayber-is-append [] _) (f {[]} (\{_} -> ⊆[]))) d
  pack {Γ} (Types.∀W Rs A-) f (Dextend{Ψ}{R} i (Dunpack d)) = 
   pack (∀W Rs A-)
    (\{Ψ'} -> \(sub : Ψ' ⊆ Rs) -> Id.subst (\l -> IMetaFn⁻ Γ l A-)
                                   (List.append-assoc {_} {Ψ'} {[ R ]} {Ψ})
                                   (Id.subst (\l -> IMetaFn⁻ Γ l A-)
                                    (List.appendmayber-is-append (Ψ' ++ [ R ]) Ψ)
                                    (f {Ψ' ++ [ R ]} (⊆both sub (\{_} -> ⊆single i)))))
    d 

  ival⁻ : forall {Γ Ψ A} -> IMetaFn⁻ Γ Ψ A -> Γ ⊢ RInv ((< Ψ > A) true⁻)
  ival⁻ f = Val⁻ (pack _ f)