-- Companion code to
--    Focusing on Binding and Computation
--    Daniel R. Licata, Noam Zeilberger, Robert Harper

open import lib.Prelude
open import focbind.Language
open List using (_++_)

module focbind.StructuralGamma where

module StructuralGamma(InΣ : Types.Rule -> Set) where
  open Focus(InΣ)

  _U⊆_ : UCtx -> UCtx -> Set
  Γ U⊆ Γ' = List.Subsets._⊆SS_ Γ Γ'

  _L⊆_ : LCtx -> LCtx -> Set
  Δ L⊆ Δ' = List.Subset._⊆_ Δ Δ'

  _LU⊆_ : LCtx -> UCtx -> Set
  Δ LU⊆ Γ = List.Subsets._⊆LS_ Δ Γ
 
  module WeakenΓ where

    weaken : { Γ Γ' : UCtx } { J : Judge }
             -> Γ U⊆ Γ' -> Γ ⊢ J -> Γ' ⊢ J
    weaken wv (Val⁺ p σ) = Val⁺ p (weaken wv σ)

    weaken wv (Val⁻ δ) = Val⁻ (\k -> weaken (List.Subsets.shiftwv wv _) (δ k))
    weaken wv (Vx⁺ x) = (Vx⁺ (wv x))
    weaken wv (Vx⁻ x) = (Vx⁻ (wv x))
    weaken wv (Vfix t) = (Vfix (weaken (List.Subsets.shiftwv wv _ ) t))

    weaken wv (Rf v) = Rf (weaken wv v)
    weaken wv (Lf x s) = Lf (wv x) (weaken wv s)
    weaken wv (Cut⁻ t s) = Cut⁻ (weaken wv t) (weaken wv s)
    weaken wv (Cut⁺ v c) = Cut⁺ (weaken wv v) (weaken wv c)
    weaken wv (EK⁺ e c) = EK⁺ (weaken wv e) (weaken wv c)

    weaken wv (Cont⁻ k σ c) = Cont⁻ k (weaken wv σ) (weaken wv c)
    weaken wv (K⁻K⁺ s c) = K⁻K⁺ (weaken wv s) (weaken wv c)

    weaken wv Ke⁻ = Ke⁻
    weaken wv (Cont⁺ φ) = Cont⁺ (\p -> weaken (List.Subsets.shiftwv wv _ ) (φ p))
    weaken wv (K⁺K⁺ c1 c2) = K⁺K⁺ (weaken wv c1) (weaken wv c2)
    weaken wv Ke⁺ = Ke⁺

    weaken {Γ} {Γ'} wv (Sub vars) = Sub (mapew  vars) where
      -- termination
      mapew : {Δ : LCtx} -> Everywhere (\ α -> Γ ⊢ RInv α) Δ -> Everywhere (\ α -> Γ' ⊢ RInv α) Δ
      mapew E[] = E[]
      mapew (_E::_ h t) = _E::_ ((weaken wv) h) (mapew t)
    weaken wv (Ids inΓ) = Ids (\h -> wv (inΓ h))
    weaken wc (σ1 +s+ σ2) = (weaken wc σ1) +s+ (weaken wc σ2)

  module SubstΓ where

    open List.In 
    open List.InLists

    Vx : forall {α Γ} -> α ∈∈ Γ -> Γ ⊢ RInv α
    Vx {_ atom⁺} i = Vx⁺ i
    Vx {_ true⁻} i = Vx⁻ i

    normalizeσ : forall {Γ Δ} -> Γ ⊢ Asms Δ -> Everywhere (\ α -> Γ ⊢ RInv α) Δ
    normalizeσ (Sub x) = x 
    normalizeσ (σ1 +s+ σ2) = List.EW.appendew (normalizeσ σ2) (normalizeσ σ1)
    normalizeσ (Ids subset) = List.EW.fromall (\{a} x -> Vx (subset x))

    subvar : forall { Γ Δ α} -> (i : Δ ∈ Γ) -> (Γ - i) ⊢ Asms Δ -> (α ∈∈ Γ) -> (Γ - i) ⊢ RInv α
    subvar x0 σ0 y with List.SW.here? x0 y
    ... | Inl newy = List.EW.there (normalizeσ σ0) newy
    ... | Inr newy = Vx newy 

    subst : forall { Γ Δ J } -> (i : Δ ∈ Γ) -> (Γ - i) ⊢ Asms Δ -> Γ ⊢ J -> (Γ - i) ⊢ J
    subst x0 σ0 (Val⁺ p σ) = Val⁺ p (subst x0 σ0 σ) 
    subst x0 σ0 (Cont⁺ f) = Cont⁺ (\p -> subst (iS x0) (WeakenΓ.weaken List.SW.sS σ0) (f p))
    subst x0 σ0 Focus.Ke⁻ = Ke⁻
    subst x0 σ0 Focus.Ke⁺ = Ke⁺
    subst x0 σ0 (Focus.K⁺K⁺ y y') = K⁺K⁺ (subst x0 σ0 y) (subst x0 σ0 y')
    subst x0 σ0 (Focus.Cont⁻ y y' y0) = Cont⁻ y (subst x0 σ0 y') (subst x0 σ0 y0)
    subst x0 σ0 (Focus.K⁻K⁺ y y') = K⁻K⁺ (subst x0 σ0 y) (subst x0 σ0 y')
    subst x0 σ0 (Focus.Vx⁺ y) = subvar x0 σ0 y
    subst x0 σ0 (Focus.Val⁻ y) = Val⁻ (\p -> subst (iS x0) (WeakenΓ.weaken List.SW.sS σ0) (y p))
    subst x0 σ0 (Focus.Vx⁻ y) = subvar x0 σ0 y
    subst x0 σ0 (Focus.Vfix y) = Vfix (subst (iS x0) (WeakenΓ.weaken List.SW.sS σ0) y)
    subst x0 σ0 (Focus.Rf y) = Rf (subst x0 σ0 y)
    subst x0 σ0 (Focus.Lf y y') = Cut⁻ (subvar x0 σ0 y) (subst x0 σ0 y')
    subst x0 σ0 (Focus.Cut⁻ y y') = Cut⁻ (subst x0 σ0 y) (subst x0 σ0 y')
    subst x0 σ0 (Focus.Cut⁺ y y') = Cut⁺ (subst x0 σ0 y) (subst x0 σ0 y')
    subst x0 σ0 (Focus.EK⁺ y y') = EK⁺ (subst x0 σ0 y) (subst x0 σ0 y')
    subst {Γ} x0 σ0 (Focus.Sub y) = Sub (mapew y) where
      -- termination
      mapew : {Δ : LCtx} -> Everywhere (\ α -> Γ ⊢ RInv α) Δ -> Everywhere (\ α -> (Γ - x0) ⊢ RInv α) Δ
      mapew E[] = E[]
      mapew (_E::_ h t) = _E::_ (subst x0 σ0 h) (mapew t)
    subst x0 σ0 (Focus.Ids y) = Sub (List.EW.fromall (\{a} x -> subvar x0 σ0 (y x)))
    subst x0 σ0 (Focus._+s+_ y y') = subst x0 σ0 y +s+ subst x0 σ0 y'

