-- Companion code to
--    Focusing on Binding and Computation
--    Daniel R. Licata, Noam Zeilberger, Robert Harper

open import lib.Prelude
open List.In
open List using (_++_)
open List.Subset

open import focbind.Language
open import focbind.Sugar
open import focbind.StructuralGamma
open import focbind.rulestruct.Subst
open import focbind.rulestruct.Subord

module focbind.Examples where

module Signat where
  module ItWouldBeNiceIfAgdaHadLocalOrShadowing where
    open Types
    open Contexts

    nat = D⁺ "nat"

    exp = D⁺ "exp"

    ari = D⁺ "ari"

    sem = D⁺ "sem"
    ssem = ↓ (↑ sem)
    neu = D⁺ "neu"
    
    data theΣ : Rule -> Set where
      -- nat
      Zero : theΣ (ax "nat")
      Succ : theΣ ("nat" ⇐ [ nat ])

      -- exp
      Lam : theΣ ("exp" ⇐ [ (ax "exp") ⇒ exp ])
      App : theΣ ("exp" ⇐ (exp :: exp :: []))

      -- ari
      Num   : theΣ ("ari" ⇐ [ nat ])
      Binop : theΣ ("ari" ⇐ (ari :: (↓ (nat → nat → ↑ nat) :: (ari :: []))))
      Let   : theΣ ("ari" ⇐ (ari :: (ax "ari" ⇒ ari) :: []))

      -- sem
      SLam  : theΣ ("sem" ⇐ [ (ax "neu") ⇒ ↓ (ssem → ↑ sem) ])
      SNeu  : theΣ ("sem" ⇐ [ neu ])
      -- neu
      NApp  : theΣ ("neu" ⇐ (neu :: sem :: []))

  open ItWouldBeNiceIfAgdaHadLocalOrShadowing public

  -- more convenient ways to build terms
  open Focus(theΣ)
  cZero : { Ψ : RCtx } -> CPat [] (< Ψ > nat)
  cZero = (Cc Zero C[])

  cSucc : { Δ : LCtx } { Ψ : RCtx } -> CPat Δ (< Ψ > nat) -> CPat Δ (< Ψ > nat)
  cSucc p = (Cc Succ (p C: C[]))

  cLam : { Δ : LCtx } { Ψ : RCtx } -> CPat Δ (< Ψ > (ax "exp") ⇒ exp) -> CPat Δ (< Ψ > exp)
  cLam p = (Cc Lam (p C: C[]))

  cApp : { Δ1 : LCtx } { Δ2 : LCtx } { Ψ : RCtx } -> CPat Δ1 (< Ψ > exp) -> CPat Δ2 (< Ψ > exp) -> CPat (Δ2 ++ Δ1) (< Ψ > exp)
  cApp p1 p2 = (Cc App (p1 C: (p2 C: C[])))

module Code where 
  
  open Signat
  open Focus(theΣ)
  open StructuralGamma(theΣ)
  module SubstΨ = Subst(theΣ)
  module Subordin = Subord(theΣ)
  open Subordin.Rels
  open Sugar(theΣ)
  module IL = List.In
  module LT = List
  open List.SW
  open List.InLists using (_∈∈_)

  -- Note: not using the combinators above so it looks more like the paper

  module Plus where
    add1 : { Γ : UCtx} -> Γ ⊢ RInv ((< [] > (nat → ↑ nat)) true⁻)
    -- these need to be eta-expanded to get the implicit args right
    add1 { Γ } = ival⁻ (\{_} -> add1*) where
      add1* : IMetaFn⁻ Γ [] (nat → ↑ nat)
      add1* p = rfv (cSucc p) σid 
  
    plus : { Γ : UCtx} -> Γ ⊢ RInv ((< [] > (nat → nat → ↑ nat)) true⁻)
    plus { Γ }= ival⁻ (\{_} x {_} y -> plus* x y) where
      plus* : IMetaFn⁻ Γ [] (nat → nat → ↑ nat)
      plus* (Cc Zero C[]) p2 = rfv p2 σid 
      plus* (Cc Succ (p C: C[])) p2 = 
          case (plus* p p2) of \n -> Cut⁻ add1 (cont⁻i (Dapp n De⁺) σid)
      plus* (Cv () _) _

  module CV where
    private
        cv* : {Γ : UCtx} -> IMetaFn⁻ Γ [] (∀W [ ax "exp" ] (exp → ◇ (↑ nat)))
        cv* s (Cv u ps) = rfv (cSucc cZero) (σe _)
        cv* s (Cc App (_C:_ {Δ1} p1 (_C:_ {Δ2} p2 C[]))) = 
            let -- weaken both inductive calls to (Δ2 ++ Δ2) :: Γ
                wc1 = WeakenΓ.weaken (List.Subsets.⊆SSlast-append-left {_} {Δ2} {Δ1})  (cv* s p1) 
                wc2 = WeakenΓ.weaken (List.Subsets.⊆SSlast-append-right {_} {Δ2} {Δ1}) (cv* s p2) 
            in case wc1 of \n1 -> 
                    let -- weaken the 2nd inductive call to Δn1 :: (Δ2 ++ Δ1) :: Γ
                        wc2' = WeakenΓ.weaken sS wc2 
                    in case wc2' of \n2 -> 
                        Cut⁻ Plus.plus (cont⁻i (Dapp n1 (Dapp n2 De⁺)) σid2)
        cv* s (Cc Lam (Cλ p C: C[])) =  cv* (\{_} -> ⊆both (⊆single i0) s) p 

    cv : { Γ : UCtx} -> Γ ⊢ RInv ((< [] > (exp → ↑ nat)) true⁻)
    cv { Γ } = ival⁻ (\{_} -> cv* (\{_} -> List.Subset.⊆[]))

    -- better type:
    cvbetter : { Γ : UCtx} -> Γ ⊢ RInv ((< [] > ∀W [ ax "exp" ] (exp → ◇ (↑ nat))) true⁻)
    cvbetter { Γ } = ival⁻ (\{_} s {_} -> cv* {_} {_} (\{_} -> s {_}))

  module Red where

    module Apply where
      insub : {Ψ : RCtx} -> Ψ ⊆ [ ax "exp" ] -> "exp" ≥C exp ∈ Ψ
      insub {Ψ} s ~ insubD f where 
        f : ({As : List Pos} ->
                Either ("exp" ⇐ As ∈ Ψ)
                       (theΣ ("exp" ⇐ As)) ->
             Everywhere (\A+ -> "exp" ≥C A+ ∈ Ψ) As)
        f (Inl x) with s x
        ...          | i0 ~ E[]
        ...          | iS ()
        f (Inr Lam) ~ insub⇒ (insub (\{_} -> ⊆both (⊆single i0) s)) E:: E[] 
        f (Inr App) ~ insub s E:: insub s E:: E[]
  
      bindsareexp : {Ψ : RCtx} {R : Rule} -> Ψ ⊆ [ ax "exp" ] -> exp binds R ∈ Ψ -> R ∈ [ (ax "exp") ]
      bindsareexp s (bindsD (Inl x , sw)) with s x 
      bindsareexp s (bindsD (Inl x , ()))    | i0
      ...                              | iS ()
      bindsareexp s (bindsD (Inr App , (s0 P))) = bindsareexp s P
      bindsareexp s (bindsD (Inr App , (sS (s0 P)))) = bindsareexp s P
      bindsareexp _ (bindsD (Inr App , (sS (sS ()))))
      bindsareexp s (bindsD (Inr Lam , (s0 (binds⇒ (Inr p))))) = bindsareexp (\{_} -> ⊆both (⊆single i0) s) p       
      bindsareexp s (bindsD (Inr Lam , (s0 (binds⇒ (Inl Refl))))) = i0
      bindsareexp _ (bindsD (Inr Lam , (sS ())))
  
      bindsin : {Ψ : RCtx} -> Ψ ⊆ [ ax "exp" ] -> bindsof exp ≥C exp ∈ Ψ
      bindsin s bin ew with bindsareexp s bin | List.EW.mapew (bindsareexp s) ew
      ...                 | i0                | ew'  =  insub (\{_} -> ⊆both (List.EW.there ew') s) 
      ...                 | iS ()             | _
  
      apply : {Γ : UCtx} {Ψ : RCtx} 
        -> Ψ ⊆ [ ax "exp" ] 
        -> Γ ⊢ RInv ((< Ψ > ((((ax "exp") ⇒ exp) * exp) → ↑ exp)) true⁻)
      apply s = SubstΨ.apply (insub (\{_} -> ⊆both (⊆single i0) s)) (bindsin (\{_} -> ⊆both (⊆single i0) s))

    red : { Γ : UCtx} -> Γ ⊢ RInv ((< [] > ∀W [ ax "exp"] (exp → ↑ (exp + 1⁺))) true⁻)
    red { Γ } = ival⁻ (\{_} s {_} -> red* {_} {_} (\{_} -> s {_})) where
      red* : {Γ : UCtx} -> IMetaFn⁻ Γ [] (∀W [ ax "exp"] (exp → ↑ (exp + 1⁺)))
      red* _ (Cv i _ ) = rfv (Cinr C<>) (σe _)
      red* { Γ } { Ψ } s (Cc Lam ((Cλ p) C: C[])) = 
        case red* (\{_} -> ⊆both (⊆single i0) s) p of br where
          br : { Γ : UCtx} -> MetaFn⁺ Γ (< (("exp" ⇐ []) :: Ψ) > exp + 1⁺) ((< Ψ > exp + 1⁺) true⁺)
          br (Cinr C<>) = rfv (Cinr C<>) (σe _)
          br (Cinl pbody') = rfv (Cinl (cLam (Cλ pbody'))) σid
      red* s (Cc App ((Cc Lam (body C: C[])) C: (arg C: C[]))) =
         Cut⁻ (Apply.apply s) (Cont⁻ (Dapp (Cpair body arg) De⁺) σid (Cont⁺ (\p -> rfv (Cinl p) σid)))
      red* { Γ } { Ψ } s (Cc App (_C:_ { Δ1 } p1 (_C:_ { Δ2 } p2 C[]))) = 
        case wp1o of br1 where
          wp1o = WeakenΓ.weaken (List.Subsets.⊆SSlast-append-left {_} {Δ2} {Δ1})  (red* s p1)
          br1 : MetaFn⁺ ((Δ2 ++ Δ1) :: Γ) (< Ψ > exp + 1⁺) ((< Ψ > exp + 1⁺) true⁺)
          br1 {Δp1o} (Cinl p1') = rfv (Cinl (cApp p1' p2 )) (Ids sub) where
            sub : (Δ2 ++ Δp1o) LU⊆ (Δp1o :: (Δ2 ++ Δ1) :: Γ) 
            sub = List.Subsets.⊆LSappend (\x -> sS (s0 (List.Subset.⊆append-right Δ1 (List.Subset.⊆refl {_} {Δ2}) x)))
                                         (\infirst -> s0 infirst) 
          br1 (Cinr C<>) = case wp2o' of br2 where
            wp2o  = WeakenΓ.weaken (List.Subsets.⊆SSlast-append-right {_} {Δ2} {Δ1}) (red* s p2)
            wp2o' = WeakenΓ.weaken sS wp2o 
          
            br2 : MetaFn⁺ ([] :: ((Δ2 ++ Δ1) :: Γ)) (< Ψ > exp + 1⁺) ((< Ψ > exp + 1⁺) true⁺)
            br2 (Cinr C<>) = rfv (Cinr C<>) (σe _)
            br2 { Δp2o} (Cinl p2') = rfv (Cinl (cApp p1 p2')) (Ids sub) where
              sub : (Δp2o ++ Δ1) LU⊆ (Δp2o :: ([] :: ((Δ2 ++ Δ1) :: Γ)))
              sub = List.Subsets.⊆LSappend (\infirst -> s0 infirst) 
                                           (\x -> sS (sS (s0 (List.Subset.⊆append-left Δ2 List.Subset.⊆refl x))))

  module Eval where

    module Apply where
      contra : {As : List Pos} -> ("nat" ⇐ As ∈ [ ax "ari" ]) -> Void
      contra (iS ())

      open Not

      insubnat : {Ψ : RCtx} -> Ψ ⊆ [ ax "ari" ] -> ¬ ("ari" ≤ nat ∈ Ψ)
      insubnat _ (subD (Inl ()))
      insubnat {Ψ} s (subD (Inr (Inl x , sw)))  = contra (s x)
      insubnat {Ψ} s (subD (Inr (Inr Zero , ()))) 
      insubnat {Ψ} s (subD (Inr (Inr Succ , (s0 p)))) = insubnat s p
      insubnat {Ψ} s (subD (Inr (Inr Succ , (sS ())))) 

      cinsubnat : {Ψ : RCtx} -> Ψ ⊆ [ ax "ari" ] -> "ari" ≥C nat ∈ Ψ
      cinsubnat {Ψ} s ~ insubD f where 
        f : ({As : List Pos} ->
                Either ("nat" ⇐ As ∈ Ψ)
                       (theΣ ("nat" ⇐ As)) ->
             Everywhere (\A+ -> "ari" ≥C A+ ∈ Ψ) As)
        f (Inl x) ~ Sums.abort (contra (s x))
        f (Inr Zero) ~ E[]
        f (Inr Succ) ~ cinsubnat s E:: E[]

      cinsubari : {Ψ : RCtx} -> Ψ ⊆ [ ax "ari" ] -> "ari" ≥C ari ∈ Ψ
      cinsubari {Ψ} s ~ insubD f where 
        f : ({As : List Pos} ->
                Either ("ari" ⇐ As ∈ Ψ)
                       (theΣ ("ari" ⇐ As)) ->
             Everywhere (\A+ -> "ari" ≥C A+ ∈ Ψ) As)
        f (Inl x) with s x
        ...          | i0 ~ E[]
        ...          | iS ()
        f (Inr Num) ~ cinsubnat s E:: E[]
        f (Inr Binop) ~ cinsubari s E:: insub↓ (insub→ (insubnat s) (insub→ (insubnat s) (insub↑ (cinsubnat s)))) E:: cinsubari s E:: E[]
        f (Inr Let) ~ cinsubari s E::
                       insub⇒ (cinsubari (\{_} -> ⊆both (⊆single i0) s)) E:: E[]

      natnobinds :  {Ψ : RCtx} {R : Rule} -> Ψ ⊆ [ ax "ari" ] -> nat binds R ∈ Ψ -> Void
      natnobinds s (bindsD (Inl x , sw)) with s x
      ...                                   | iS ()
      natnobinds s (bindsD (Inr Zero , ()))
      natnobinds s (bindsD (Inr Succ , (sS ())))
      natnobinds s (bindsD (Inr Succ , (s0 p))) = natnobinds s p

      bindsareari : {Ψ : RCtx} {R : Rule} -> Ψ ⊆ [ ax "ari" ] -> ari binds R ∈ Ψ -> R ∈ [ (ax "ari") ]
      bindsareari s (bindsD (Inl x , sw)) with s x 
      bindsareari s (bindsD (Inl x , ()))    | i0
      ...                                    | iS ()
      bindsareari s (bindsD (Inr Num , (s0 p))) = Sums.abort (natnobinds s p)
      bindsareari s (bindsD (Inr Num , (sS ())))
      bindsareari s (bindsD (Inr Binop , (s0 P))) = bindsareari s P
      bindsareari s (bindsD (Inr Binop , (sS (s0 (binds↓ (binds→ (binds→ (binds↑ p)))))))) = Sums.abort (natnobinds s p)
      bindsareari s (bindsD (Inr Binop , (sS (sS (s0 P))))) = bindsareari s P
      bindsareari _ (bindsD (Inr Binop , (sS (sS (sS ())))))
      bindsareari s (bindsD (Inr Let , (s0 P))) = bindsareari s P
      bindsareari s (bindsD (Inr Let , (sS (s0 (binds⇒ (Inr p)))))) = bindsareari (\{_} -> ⊆both (⊆single i0) s) p       
      bindsareari s (bindsD (Inr Let , (sS (s0 (binds⇒ (Inl Refl)))))) = i0
      bindsareari _ (bindsD (Inr Let , (sS (sS ()))))

      bindsin : {Ψ : RCtx} -> Ψ ⊆ [ ax "ari" ] -> bindsof ari ≥C ari ∈ Ψ
      bindsin s bin ew with bindsareari s bin | List.EW.mapew (bindsareari s) ew
      ...                 | i0                | ew'  =  cinsubari (\{_} -> ⊆both (List.EW.there ew') s) 
      ...                 | iS ()             | _

      apply : {Γ : UCtx} 
        -> Γ ⊢ RInv ((< [] > ((((ax "ari") ⇒ ari) * ari) → ↑ ari)) true⁻)
      apply = SubstΨ.apply (cinsubari (⊆single i0)) (bindsin (\{_} -> ⊆single i0)) 


    evalHyp = ((< [] > ari → ↑ nat) true⁻)

    eval : {Γ : UCtx} -> Γ ⊢ RInv evalHyp
    eval { Γ } = Vfix (ival⁻ (\{_} -> eval*)) where
      eval* : IMetaFn⁻ ([ evalHyp ] :: Γ) [] (ari → ↑ nat)
      eval* (Cc Num (n C: C[])) = rfv n σid
      eval* (Cc Binop (_C:_ {Δ1} e1 (Cx⁻ C: (_C:_ {Δ2} e2 C[])))) = 
        Lf (sS (s0 i0)) (Cont⁻ (Dapp e1 De⁺) (Ids sub1)
           (cont⁺e (\ Δ1' -> \n1 -> Lf (sS (sS (s0 i0))) (Cont⁻ (Dapp e2 De⁺) (Ids sub2)  
               (cont⁺e (\ Δ2' -> \n2 -> Lf (sS (sS (s0 f))) (cont⁻i (Dapp n1 (Dapp n2 De⁺)) (Ids sub3)))))))) 
        where f : {H : Hyp} -> H ∈ ((Δ2 ++ (H :: [])) ++ Δ1)
              f = IL.iswapapp _ Δ1 (IL.iSmany _ Δ1 (IL.iSmany _ Δ2 i0))
              sub1 : forall {H Γ} -> Δ1 LU⊆ ((Δ2 ++ (H :: [])) ++ Δ1) :: Γ
              sub1 {H} inΔ1 = s0 (IL.iSmany _ (Δ2 ++ (H :: [])) inΔ1) 
              sub2 : forall {H Δ1' Γ} -> Δ2 LU⊆ (Δ1' :: (((Δ2 ++ (H :: [])) ++ Δ1) :: Γ))
              sub2 {H} {Δ1'} inΔ2 = sS (s0 (IL.iSmany-right _ Δ1 (IL.iSmany-right Δ2 (H :: []) inΔ2)))
              sub3 : forall {Γ Δ2' Δ1'} -> (Δ2' ++ Δ1') LU⊆ (Δ2' :: Δ1' :: Γ)
              sub3 {_} {Δ2'} = List.Subsets.⊆LSappend s0 (\{_} x -> sS (s0 x))
      eval* (Cc Let (_C:_ {Δ1} arg (_C:_ {Δ2} body C[]))) = 
        Cut⁻ Apply.apply
         (Cont⁻ (Dapp (Cpair body arg) De⁺)
                (Ids (\{_} i -> s0 (iswapapp Δ2 Δ1 i)))
                (Cont⁺ (\p -> Lf (sS (sS (s0 i0))) (cont⁻i (Dapp p De⁺) σid))))
      eval* (Cv () _)

  module Distrib where
  
    pair1 : {Γ : UCtx} 
            -> Γ ⊢ RInv ((< [] > ((ax "exp" ⇒ (exp * exp)) → ↑ ((ax "exp" ⇒ exp) * (ax "exp" ⇒ exp)))) true⁻)
    pair1 {Γ} = Val⁻ pair1* where
      pair1* : MetaFn⁻ Γ (< [] > ((ax "exp" ⇒ (exp * exp)) → ↑ ((ax "exp" ⇒ exp) * (ax "exp" ⇒ exp))))
      pair1* (Dapp (Cλ (Cpair p1 p2)) De⁺) = Rf (Val⁺ (Cpair (Cλ p1) (Cλ p2)) σid) 

    pair2 : {Γ : UCtx}
            -> Γ ⊢ RInv ((< [] > (((ax "exp" ⇒ exp) * (ax "exp" ⇒ exp)) → ↑ (ax "exp" ⇒ (exp * exp)))) true⁻)
    pair2 {Γ} = Val⁻ pair2* where
      pair2* : MetaFn⁻ Γ (< [] > (((ax "exp" ⇒ exp) * (ax "exp" ⇒ exp)) → ↑ (ax "exp" ⇒ (exp * exp))))
      pair2* (Dapp (Cpair (Cλ p1) (Cλ p2)) De⁺) = Rf (Val⁺ (Cλ (Cpair p1 p2)) σid)

  module NBE where