\ignore{
\begin{code}
open import lib.Prelude
open List.In
open List.InLists
open List.SW
open List using (_++_)  

module foc.posdep.IntuitSimple where

module Types where
\end{code}}

\subsubsection{Types}

The syntax of types is a straightforward inductive definition:

\begin{code}
 Atom : Set 
 Atom = String

 mutual
  data Type⁺ : Set where
    X⁺  : Atom -> Type⁺ 
    ↓   : Type⁻ -> Type⁺ 
    1⁺  : Type⁺
    _*_ : Type⁺ -> Type⁺ -> Type⁺
    0⁺  : Type⁺
    _+_ : Type⁺ -> Type⁺ -> Type⁺

  data Type⁻ : Set where
    X⁻   : Atom -> Type⁻
    ↑    : Type⁺ -> Type⁻
    _→_  : Type⁺ -> Type⁻ -> Type⁻
    ⊤  : Type⁻
    _&_  : Type⁻ -> Type⁻ -> Type⁻
\end{code}

Using an underscore in a name is Agda syntax for mixfix operators; e.g.,
\ttt{\&} can be used infix.

\ignore{
\begin{code} 
module Pats where

 open Types public
\end{code}}

\subsubsection{Patterns}

On paper, we tacitly included negative types and atoms into the sum type
α; in Agda, we must give injections:

\begin{code}
 ----  α
 data Hyp : Set where
   _true⁻ : Type⁻ -> Hyp
   _atom⁺ : Atom -> Hyp

 ---- Δ
 Ctx = List Hyp

 ---- γ
 data Conc : Set where
   _true⁺ : Type⁺ -> Conc
   _atom⁻ : Atom -> Conc
\end{code}

Constructor patterns are represented by an indexed inductive definition,
indexed by the context \ttt{Δ} and the type \ttt{A⁺}.  We write \ttt{[]}
for the empty list, \ttt{++} for append, and \ttt{[ x ]} for the
singleton list.

\begin{code}
 data _⊩_ : Ctx -> Type⁺ -> Set where
   Cx⁺ : forall {X} -> [ X atom⁺ ] ⊩ (X⁺ X)
   Cx⁻ : forall {A⁻} -> [ A⁻ true⁻ ] ⊩ (↓ A⁻)
   C<> : [] ⊩ 1⁺
   Cpair : forall {Δ₁ Δ₂ A⁺ B⁺} 
         -> Δ₁ ⊩ A⁺  ->  Δ₂ ⊩ B⁺
         -> (Δ₂ ++ Δ₁) ⊩ (A⁺ * B⁺)
   Cinl : forall {Δ A⁺ B⁺} 
        -> Δ ⊩ A⁺ 
        -> Δ ⊩ (A⁺ + B⁺)
   Cinr : forall {Δ A⁺ B⁺} 
        -> Δ ⊩ B⁺ 
        -> Δ ⊩ (A⁺ + B⁺)

 data _⊩_>_ : Ctx -> Type⁻ -> Conc -> Set where
   De⁻  : forall {X} -> [] ⊩ (X⁻ X) > (X atom⁻)
   De⁺  : forall {A⁺} -> [] ⊩ (↑ A⁺) > (A⁺ true⁺)
   Dapp : forall {Δ1 Δ2 A⁺ B⁻ γ} 
        -> Δ1 ⊩ A⁺  ->  Δ2 ⊩ B⁻ > γ 
        -> (Δ2 ++ Δ1) ⊩ (A⁺ → B⁻) > γ
   Dfst : forall {Δ A⁻ B⁻ γ}
        -> Δ ⊩ A⁻ > γ  
        -> Δ ⊩ (A⁻ & B⁻) > γ
   Dsnd : forall {Δ A⁻ B⁻ γ}
        -> Δ ⊩ B⁻ > γ
        -> Δ ⊩ (A⁻ & B⁻) > γ
\end{code}

The Agda syntax for dependent functions may be unfamiliar to some
readers: A dependent function is written \ttt{(x : A) -> B}, but
the \ttt{->} between successive arguments can be elided, writing, for
example,
\ttt{(x : A) (y : B) -> C}.  Replacing the parentheses with curly-braces, as
in \ttt{\{x : A\} -> B}, notates an implicit argument, whose application
will be inferred by unification.  The syntax \ttt{forall \{x1 ... xn\}
-> A} allows the types of the variables to be elided; it is equivalent
to writing \ttt{\{x1 : \_\} ... \{xn : \_\} -> A}.  For example, a
typical application of \ttt{Dapp} would have the form \ttt{(Dapp c d)}
where \ttt{c} is a constructor pattern and \ttt{d} is a destructor
pattern; the contexts and types are inferred.  A function can be
explicitly applied to implicit arguments by enclosing the arguments in
curly-braces; e.g., \ttt{(Dapp \{Δ\} \{Δ'\} c d)}.  

\ignore{
\begin{code}
module Focus where
 open Pats public
\end{code}}

\subsubsection{Focusing Judgements}

Next, we define the focusing judgements in Figure \ref{fig:foc-simple}.
It is convenient to define a sum type \ttt{FocJudg} and then define one
datatype \ttt{Γ ⊢ J}, rather than giving six separate datatypes.
Additionally, we use the auxiliary types \ttt{α ∈ Δ} for list
membership, \ttt{α ∈∈ Γ} for membership in some list in Γ, and we write
\ttt{::} for consing onto a list.

The focusing judgements are defined by an iterated inductive definition;
note the higher-order premises of \ttt{Cont⁺} and \ttt{Val⁻} and
\ttt{Sub}.

\begin{figure}
\begin{code}
 ---- Γ
 CtxCtx : Set
 CtxCtx = List Ctx

 data FocJudg : Set where
   RFoc : Type⁺ -> FocJudg
   LInv : Conc -> Conc -> FocJudg
   LFoc : Type⁻ -> Conc -> FocJudg
   RInv : Hyp -> FocJudg
   Neu : Conc -> FocJudg
   Asms : Ctx -> FocJudg

 data _⊢_ :  CtxCtx -> FocJudg -> Set where
   ---- positive values (v+)
   Val⁺ : forall {Γ Δ C⁺}
        -> Δ ⊩ C⁺ -> Γ ⊢ Asms Δ 
        -> Γ ⊢ RFoc C⁺
   ---- positive continuations (k+)
   Ke⁻    : forall {Γ X} 
          -> Γ ⊢ LInv (X atom⁻) (X atom⁻)
   Cont⁺  : forall {Γ γ C⁺}
          -> ({Δ : Ctx} -> Δ ⊩ C⁺ -> Δ :: Γ ⊢ Neu γ) 
          -> Γ ⊢ LInv (C⁺ true⁺) γ
   ---- negative continuations (k-)
   Cont⁻ : forall {Δ A⁻ γ₀ γ Γ} 
         -> Δ ⊩ A⁻ > γ₀ -> Γ ⊢ Asms Δ -> Γ ⊢ LInv γ₀ γ 
         -> Γ ⊢ LFoc A⁻ γ
   ---- negative values (v-)
   Vx⁺ : forall {Γ X} 
       -> (X atom⁺) ∈∈ Γ -> Γ ⊢ RInv (X atom⁺)
   Val⁻ : forall {Γ C⁻} 
        -> ({Δ : Ctx}{γ : Conc} 
            -> Δ ⊩ C⁻ > γ ->  Δ :: Γ ⊢ Neu γ) 
        -> Γ ⊢ RInv (C⁻ true⁻)
   ---- expressions (e)
   R : forall {Γ C⁺}
     -> Γ ⊢ RFoc C⁺ 
     -> Γ ⊢ Neu (C⁺ true⁺)
   L : forall {Γ C⁻ γ} 
     -> ((C⁻ true⁻) ∈∈ Γ)   ->  Γ ⊢ LFoc C⁻ γ
     -> Γ ⊢ Neu γ
   ---- substitutions (σ)
   Sub  : forall {Γ Δ} 
        -> ({α : Hyp} -> α ∈ Δ -> Γ ⊢ RInv α)
        -> Γ ⊢ Asms Δ
\end{code}
\caption{Focusing judgements for simple types}
\label{fig:foc-simple}
\end{figure}

\subsubsection{Examples}

The first of the derived rules suggested above is implemented as
follows:

\begin{code}
 ex1 : forall {Γ A1⁺ A2⁺} 
     -> ([] :: Γ) ⊢ Neu (A1⁺ true⁺) 
     -> ([] :: Γ) ⊢ Neu (A2⁺ true⁺)
     -> Γ ⊢ RInv ( ((↑ A1⁺) & (↑ A2⁺)) true⁻)
 ex1 {Γ} {A1⁺} {A2⁺} e1 e2 = Val⁻ ex1* where
   ex1* : {Δ : Ctx}{γ : Conc} 
        -> Δ ⊩ ((↑ A1⁺) & (↑ A2⁺)) > γ 
        -> (Δ :: Γ) ⊢ Neu γ
   ex1* (Dfst De⁺) = e1
   ex1* (Dsnd De⁺) = e2
\end{code}
%
A lazy pair is implemented by pattern-matching against the projections
and satisfying the two possible observations.  This is implemented by
the Agda function \ttt{ex1*}, which pattern-matches on the destructor
pattern datatype.  A few details deserve comment: First, we require the
given expressions \ttt{e1} and
\ttt{e2} to be in context \ttt{[] :: Γ} to avoid the need to call a
weakening lemma.  Second, the curly-braces surrounding the three
arguments to \ttt{ex1} are Agda syntax for matching on implicit
arguments.  

The second derived rule is implemented as follows:

\begin{code}
 ex2 : forall {Γ A1⁻ A2⁻ B⁺} 
     -> ([ A1⁻ true⁻ ] :: Γ) ⊢ Neu (B⁺ true⁺) 
     -> ([ A2⁻ true⁻ ] :: Γ) ⊢ Neu (B⁺ true⁺)
     -> Γ ⊢ RInv (( ((↓ A1⁻) + (↓ A2⁻)) → (↑ B⁺))  true⁻)
 ex2 {Γ} {A1⁻} {A2⁻} {B⁺} e1 e2 = Val⁻ ex2* where
   ex2* : {Δ : Ctx}{γ : Conc} 
        -> Δ ⊩ (((↓ A1⁻) + (↓ A2⁻)) → (↑ B⁺)) > γ 
        -> (Δ :: Γ) ⊢ Neu γ
   ex2* (Dapp (Cinl Cx⁻) De⁺) = e1
   ex2* (Dapp (Cinr Cx⁻) De⁺) = e2
\end{code}
%
A function of type \ttt{(((↓ A1⁻) + (↓ A2⁻)) → (↑ B⁺))} is implemented
by pattern-matching against its destructor patterns, of which there is
one, \ttt{Dapp}, and then further pattern-matching against the
constructor patterns for the argument; there are two in this example.
