
\subsection{Derived Forms}

First, we define some derived forms that will make writing the examples
easier.

\ignore{
\begin{code}
open import lib.Prelude
open List.In
open List.InLists
open List.SW
open List using (_++_)  
open import foc.posdep.Intuit
open import foc.posdep.IntuitProperties

module foc.posdep.IntuitExamples where

module Derived where
 open Focus public
 open Properties public
 open Properties.SimpleIdent public
 open Properties.Subtyping public
 open Properties.Cut public

 _+s+_ : forall {Γ Δ1 Δ2} 
       -> Γ ⊢ Asms Δ1 
       -> Γ ⊢ Asms Δ2 
       -> Γ ⊢ Asms (Δ2 ++ Δ1)
 _+s+_ {_} {Δ1} {Δ2} (Sub f1) (Sub f2) = Sub (\x -> Sums.case (splitappend Δ2 Δ1 x) f2 f1)

 casev_of_ : forall {Γ K γ} {C+ : Type⁺ K} -> Γ ⊢ RFoc C+ -> Γ ⊢ LInv (C+ true⁺) γ -> Γ ⊢ Neu γ
 casev v of c = Cut⁺ v c

 casee_of_ : forall {Γ γ0 γ} -> Γ ⊢ Neu γ0 -> Γ ⊢ LInv γ0 γ -> Γ ⊢ Neu γ
 casee e of c = EK⁺ e c

 --   σid2 : { Γ : UCtx } { Δ1 : LCtx } { Δ2 : LCtx} -> (Δ2 :: Δ1 :: Γ) ⊢ Asms (Δ2 ++ Δ1)
 --   σid2 { Γ } { Δ1 } { Δ2 } = Ids inp where
 --     inp : {H : Hyp} -> (H ∈ (Δ2 ++ Δ1)) -> (H ∈∈ (Δ2 :: Δ1 :: Γ))
 --     inp inapp with List.In.splitappend Δ2 Δ1 inapp 
 --     ...          | Inl in2  = List.SW.s0 in2
 --     ...          | Inr in1  = List.SW.sS (List.SW.s0 in1)

 -- explict, for when we want to name the context
 cont⁺e : {K : PKind} { Γ : CtxCtx} {C+ : Type⁺ K} { γ : Conc }
     -> ((Δ : Ctx) -> Δ ⊩ C+ -> (Δ :: Γ) ⊢ Neu γ)
     -> Γ ⊢ LInv (C+ true⁺) γ
 cont⁺e f = Cont⁺ (\p -> f _ p)

 cont⁻i : forall { γ Γ C- Δ} -> Δ ⊩ C- > γ -> Γ ⊢ Asms Δ -> Γ ⊢ LFoc C- γ
 cont⁻i {(_ true⁺)} k σ = Cont⁻ k σ Ke⁺
 cont⁻i {(_ atom⁻)} k σ = Cont⁻ k σ Ke⁻

 MetaFn⁻ : CtxCtx -> Type⁻ -> Set
 MetaFn⁻ Γ C- = { Δ : Ctx } { γ : Conc } -> (Δ ⊩ C- > γ ) -> Δ :: Γ ⊢ Neu γ

 MetaFn⁺ : {K : PKind} -> CtxCtx -> Type⁺ K -> Conc -> Set
 MetaFn⁺ Γ C+ γ = { Δ : Ctx } -> (Δ ⊩ C+) -> Δ :: Γ ⊢ Neu γ
\end{code}
}

We define shorthands for case-analyzing an expression with a positive
continuation, and for right-focusing on a value:

\begin{code}
 case_of_ : forall {Γ γ} {C+ : Type⁺ Pos} 
          -> Γ ⊢ Neu (C+ true⁺) 
          -> ({Δ : Ctx} -> Δ ⊩ C+ -> Δ :: Γ ⊢ Neu γ) 
          -> Γ ⊢ Neu γ
 case e of k⁺ = EK⁺ e (Cont⁺ k⁺)

 rfv : forall {Γ K Δ} {C⁺ : Type⁺ K} 
     -> Δ ⊩ C⁺ -> Γ ⊢ Asms Δ 
     -> Γ ⊢ Neu (C⁺ true⁺)
 rfv c σ = R (Val⁺ c σ)
\end{code}

We define utilities for creating common substitutions (definitions
elided):

\begin{code}
 σe : (Γ : CtxCtx) -> Γ ⊢ Asms []
\end{code}
\ignore{
\begin{code}
 σe Γ = Sub (\ {_} -> List.EW.there {_} {\ x -> Γ ⊢ RInv x} E[])
\end{code}
}

\begin{code}
 σid : forall {Γ Δ} -> (Δ :: Γ) ⊢ Asms Δ 
\end{code}
\ignore{
\begin{code}
 σid = Ids List.SW.s0 
\end{code}
}

\begin{code}
 σ1 : forall {Γ α} -> Γ ⊢ RInv α -> Γ ⊢ Asms [ α ]
\end{code}
\ignore{
\begin{code}
 σ1 {Γ} v⁻ = Sub (List.EW.there {_} {\x -> Γ ⊢ RInv x} (v⁻ E:: E[]))
\end{code}
}

The meta-functions necessary for introducing a negative value have type:

\smallskip
\verb|  {Δ:Ctx}{γ:Conc} -> Δ ⊩ A⁻ > γ -> (Δ :: Γ) ⊢ γ|
\smallskip

\noindent
It is convenient to define a short-hand for matching on destructor
patterns. For example, for the type \ttt{(A⁺ → B⁺ → ↑ C⁺)}, we will
write an Agda function that takes two constructor patterns, one for
\ttt{A⁺} and one for \ttt{B⁺}, rather than a function taking both
constructor patterns packed as a destructor pattern.  The Agda type of
these convenient meta-functions is defined by induction on negative
types:

\begin{code}
 IMetaFn⁻ : CtxCtx -> Type⁻ -> Set
 IMetaFn⁻ Γ (↑ A⁺) = Γ ⊢ Neu (A⁺ true⁺)
 IMetaFn⁻ Γ (A⁺ → B⁻) = 
   {Δ : Ctx} -> Δ ⊩ A⁺ -> IMetaFn⁻ (Δ :: Γ) B⁻
 IMetaFn⁻ Γ (Π⁻ A⁺ τ⁻) = (p : [] ⊩ A⁺) -> IMetaFn⁻ Γ (τ⁻ p)
 IMetaFn⁻ Γ (X⁻ X) = Γ ⊢ Neu (X atom⁻)
 IMetaFn⁻ Γ ⊤ = Unit
 IMetaFn⁻ Γ (A⁻ & B⁻) = IMetaFn⁻ Γ A⁻ × IMetaFn⁻ Γ B⁻
\end{code}

\ignore{
\begin{code}
 open List.Subsets 

 pack : forall {Γ} -> (A : Type⁻) -> IMetaFn⁻ Γ A -> MetaFn⁻ Γ A
 pack (↑ A+) f De⁺ = Properties.WeakenΓ.weaken sS f 
 pack (A+ → B-) f (Dapp c d) = Properties.WeakenΓ.weaken wkn (pack B- (f c) d) 
   where wkn : {Δ2 : Ctx} {Δ1 : Ctx} {Γ : CtxCtx} -> (Δ2 :: Δ1 :: Γ) ⊆SS ((Δ2 ++ Δ1) :: Γ)
         wkn {Δ2} {Δ1} (s0 i) = s0 (iSmany-right Δ2 Δ1 i)
         wkn {Δ2} {Δ1} (sS (s0 i)) = s0 (iSmany Δ1 Δ2 i)
         wkn (sS (sS i)) = sS i
 pack (Π⁻ A+ τ-) f (Ddapp c d) = pack (τ- c) (f c) d
 pack (X⁻ y) f De⁻ = Properties.WeakenΓ.weaken sS f
 pack ⊤ f () 
 pack (_&_ y y') ( f1 , f2 ) (Dfst d) = (pack y f1) d
 pack (_&_ y y') ( f1 , f2 ) (Dsnd d) = (pack y' f2) d
\end{code}
}

These convenient meta-functions suffice to define a negative value:

\begin{code}
 ival⁻ : forall {Γ A} -> IMetaFn⁻ Γ A -> Γ ⊢ RInv (A true⁻)
\end{code}

\ignore{
\begin{code}
 ival⁻ f = Val⁻ (pack _ f)

 weaken : { Γ Γ' : CtxCtx } { J : FocJudg }
            -> Γ ⊆SS Γ' -> Γ ⊢ J -> Γ' ⊢ J
 weaken = WeakenΓ.weaken

module Examples where
 open Derived
\end{code}}

\subsection{Tail}

First, we define a tail function on vectors of length at least one:

\begin{code}
 tailtp = Π⁻ nat (\n -> (vec nat (Csucc n)) → ↑(vec nat n))
 tail : forall {Γ} -> Γ ⊢ RInv (tailtp true⁻)
 tail {Γ} = ival⁻ tail* where
   tail* : IMetaFn⁻ Γ tailtp
   tail* n (Ccons x xs) = rfv xs (Ids {! !})
\end{code}

The negative value is defined by a two-argument meta-function, which
takes a \ttt{nat} pattern \ttt{n} and pattern for \ttt{vec nat (Csucc
n)}.  In the \ttt{Ccons} case, we return the tail under the identity
substitution.  Agda's exhaustiveness checker verifies that the
\ttt{Cnil} case is impossible for a vector this length.

To make the examples more readable, we leave a hole marked by 
\verb|{! !}| or \verb|?| for simple list subset relationships, which are easy but
verbose to fill in; in this case, the obligation is to prove that every
assumption in \ttt{Δ₂} is in \ttt{(Δ₂ ++ Δ₁) :: Γ}.  We would like to
try deploying reflective theorem proving to discharge these obligations
automatically.

\subsection{Append}

Next, we define an append function on vectors.  We require an addition
function on nat patterns:

\begin{code}
 plus* : {K : PKind} 
       -> [] ⊩ nat{K} -> [] ⊩ nat{K} -> [] ⊩ nat{K}
 plus* Czero n = n
 plus* {K} (Csucc m) n = Csucc (plus*{K} m n)

 appendtype = (Π⁻ nat (\n -> Π⁻ nat \m ->
   vec nat n → vec nat m → ↑ (vec nat (plus*{PPos} n m))))
 append : forall {Γ} -> Γ ⊢ RInv (appendtype true⁻)
 append {Γ} = ival⁻ append* where
   append* : IMetaFn⁻ Γ appendtype
   append* Czero m Cnil l2 = rfv l2 σid
   append* (Csucc n) m (Ccons x l1) l2 = 
     case (weaken {! !} (append* n m l1 l2)) of
       \l12 -> rfv (Ccons x l12) (Ids {! !})
\end{code}

The meta-function \ttt{append*} is defined recursively: we are using
induction in Agda to do induction in the object language.  The focusing
syntax makes the evaluation-order explicit in the second case: do the
recursive call, and then compose the result with a continuation that
conses \ttt{x} onto the result.

\subsection{Map}

We define a function that maps a two-argument function across two lists
of the same length:

\begin{code}
 map2type = Π⁻ nat (\n -> (↓ (nat → nat → ↑ nat) → 
   vec nat n → vec nat n → ↑ (vec nat n)))
 map2 : forall {Γ} -> Γ ⊢ RInv (map2type true⁻)
 map2 {Γ} = ival⁻ map2* where
   map2* : IMetaFn⁻ Γ map2type
   map2* Czero Cx⁻ Cnil Cnil = rfv Cnil (σe _)
   map2* (Csucc n) Cx⁻ (Ccons x xs) (Ccons y ys) = 
     case weaken {! !} (map2* n Cx⁻ xs ys) of
      \t ->
        L (sS (sS (sS (s0 i0))))
        (Cont⁻ (Dapp x (Dapp y De⁺)) (Ids {! !}) 
               (Cont⁺ (\h -> rfv (Ccons h t) (Ids {! !}))))
\end{code}

In the second case, we let \ttt{t} be the result of mapping the given
function across the tails of the lists, then we let \ttt{h} be the
result of calling the function on the heads, and finally we cons \ttt{h}
onto \ttt{t}.  Agda's exhaustiveness checker verifies that the nil/cons
and cons/nil cases are impossible because the lists have the same
length.

\subsection{Map2app}

To illustrate the need for proofs of type equality, we implement a
function \ttt{map2app} of type

\begin{code}
 map2apptp = 
  Π⁻ nat (\n -> Π⁻ nat (\m -> 
    ↓ (nat → nat → ↑ nat) 
    → vec nat n → vec nat m 
    → ↑ (vec nat (plus*{PPos} n m))))
\end{code}

Informally, this function is defined as follows:

\begin{verbatim}
map2app n m f l1 l2 = 
  case (append n m l1 l2) of
    app1 => case (append m n l2 l1) of
              app2 => map2 (plus* n m) f app1 app2 
\end{verbatim}

I.e., we map the given function across the results of appending the two
lists in both orders.  However, the second list \ttt{app2} has type
\ttt{vec nat (plus* m n)}, whereas it is expected to have type \ttt{vec
nat (plus* n m)}.  Consequently, it is necessary to prove a subtyping
relationship inductively:

\ignore{
\begin{code}
 plus-0r : forall {K} -> (m : [] ⊩ nat{K}) -> Id (plus*{K} m Czero) m
 plus-0r Czero = Refl 
 plus-0r (Csucc n) = Id.substeq (\ x -> Csucc x) (plus-0r n)

 plus-sr : forall {K} -> (m n : [] ⊩ nat{K}) -> Id (Csucc (plus*{K} m n)) (plus*{K} m (Csucc n))
 plus-sr Czero n = Refl
 plus-sr (Csucc m) n = Id.substeq (\ x -> Csucc x) (plus-sr m n)

 plus-comm : forall {K} -> (m n : [] ⊩ nat{K}) -> Id (plus*{K} m n) (plus*{K} n m)
 plus-comm Czero m     = Id.sym (plus-0r m)
 plus-comm (Csucc m) n = Id.trans (Id.substeq Csucc (plus-comm m n)) (plus-sr n m)
\end{code}
}

\begin{code}
 comm : {A⁺ : Type⁺ Pos} (n m : [] ⊩ nat{PPos}) -> 
  (vec A⁺ (plus*{PPos} m n)) <:⁺ (vec A⁺ (plus*{PPos} n m))
 comm {A⁺} n m = Id.subst (\ x -> (vec A⁺ x) <:⁺ (vec A⁺ (plus*{PPos} n m))) (plus-comm n m) (Subtyping.<:⁺-refl _)

 commext : {A⁺ : Type⁺ Pos} -> (Σ⁺ nat \n -> Σ⁺ nat \m -> (vec A⁺ (plus*{PPos} m n))) <:⁺ (Σ⁺ nat \n -> Σ⁺ nat \m -> (vec A⁺ (plus*{PPos} n m)))
 commext {A⁺} = Sub⁺ f where
   f : ({ Δ1 : Ctx} (c1 : Δ1 ⊩ (Σ⁺ nat \n -> Σ⁺ nat \m -> (vec A⁺ (plus*{PPos} m n)))) -> 
              Σ \ Δ2 -> Σ \(c2 : Δ2 ⊩ (Σ⁺ nat \n -> Σ⁺ nat \m -> (vec A⁺ (plus*{PPos} n m)))) 
                -> EqCPat{Δ1}{Δ2}{Pos}{Pos}{(Σ⁺ nat \n -> Σ⁺ nat \m -> (vec A⁺ (plus*{PPos} m n)))}{(Σ⁺ nat \n -> Σ⁺ nat \m -> (vec A⁺ (plus*{PPos} n m)))} c1 c2 
                   × Δ1 <:Δ Δ2)
   f (Cdpair n (Cdpair m c)) with comm{A⁺} n m 
   ...                          | Sub⁺ f' with f' c
   ...                                       | Δ2 , c2' , eq , lt = 
     Δ2 , (Cdpair n (Cdpair m c2')) , ≡Cdpair (eqcpat-refl _ n) (≡Cdpair (eqcpat-refl _ m) eq) , lt

\end{code}

Then we coerce \ttt{app2} by cutting with the identity coercion induced
by this subtyping proof, and call the result \ttt{app2'}:

\begin{code} 
 map2app : forall {Γ} -> Γ ⊢ RInv (map2apptp true⁻)
 map2app {Γ} = ival⁻ map2app* where
   map2app* : IMetaFn⁻ Γ map2apptp
   map2app* n m Cx⁻ l1 l2 = 
    Cut⁻ append
     (Cont⁻ (Ddapp n (Ddapp m (Dapp l1 (Dapp l2 De⁺)))) 
            (Ids {! !}) (Cont⁺ (\app1 -> 
    Cut⁻ append
     (Cont⁻ (Ddapp m (Ddapp n (Dapp l2 (Dapp l1 De⁺))))
            (Ids {! !}) (Cont⁺ (\app2 ->
       case (Cut⁺ (Val⁺ app2 (Ids {! !})) 
                  (Ident.Ke⁺ (comm {nat} n m))) of
          \app2' -> 
           Cut⁻ map2 
               (Cont⁻ (Ddapp (plus* n m) 
                       (Dapp Cx⁻ 
                        (Dapp app1 (Dapp app2' De⁺))))
                      (Ids ?) Ke)))))))
\end{code}

\subsection{Loop}

To illustrate that our language is compatible with effects such as
non-termination, we write a loop using \ttt{dom}.  The essential idea is
a variation of \ttt{($\lambda$x.x x)($\lambda$x.x x)}:

\begin{verbatim}
loop (Cdom f) = f (Cdom f)
explode = loop (Cdom loop)
\end{verbatim}

This code is represented as follows:

\begin{code}
 loop : forall {Γ} -> Γ ⊢ RInv ((dom → ↑ dom) true⁻)
 loop {Γ} = ival⁻ (\{_} -> loop*) where
   loop* : IMetaFn⁻ Γ (dom → ↑ dom)
   loop* Cdom = L (s0 i0) 
         (Cont⁻ (Dapp Cdom De⁺)
                (σ1 (Vx (s0 i0))) Ke) 

 explode : [] ⊢ Neu (dom true⁺)
 explode = Force.force 
  (Cut⁻ loop (Cont⁻ (Dapp Cdom De⁺) (σ1 loop) Ke))
\end{code}

\noindent 
The function \ttt{Force.force} pattern-matches on the focusing term,
which causes Agda to evaluate it and loop.

\ignore{
\begin{code}
--  Kedom = Force.force (SimpleIdent.Ke⁺ {_} {[]} {dom})
--  Vxdom = Force.force (SimpleIdent.Vx⁻ {[ [ (dom → ↑ dom) true⁻ ] ]} {(dom → ↑ dom)} (s0 i0))

--  Vxdom' : [ [ (dom → ↑ dom) true⁻ ] ] ⊢ RInv ((dom → ↑ dom) true⁻)
--  Vxdom' = Val⁻ f where 
--    f : {Δ : Ctx}{γ : Conc} -> Δ ⊩ ((dom → ↑ dom)) > γ -> (Δ :: [ [ (dom → ↑ dom) true⁻ ] ]) ⊢ Neu γ
--    f (Dapp Cdom De⁺) = L (sS (s0 i0)) (Cont⁻ (Dapp Cdom De⁺) {! !} {! !})
\end{code}}