\ignore{
\begin{code}

{-# OPTIONS --no-positivity-check #-}

open import lib.Prelude
open List.In
open List.InLists
open List.SW
open List using (_++_)  

module foc.posdep.IntuitAttempt1 where

module TypesPats where

 Atom : Set 
 Atom = String
\end{code}}

We add rules for three new types: $\Sigma^\ep$ types; a type \ttt{nat}
representing natural numbers; and a type \ttt{vec A$^\ep$ n},
representing vectors of length \ttt{n} with elements of type
\ttt{A$^\ep$}.  Here \ttt{n} is a closed \ttt{nat} pattern; i.e., it has
type \ttt{[] ⊩ nat}.  

Because types are dependent on patterns, and patterns are classified by
types, we at least need to define the syntax of types and the pattern
judgement as a mutual inductive definition.  

The new types are specified as follows:

\begin{code}
 mutual
  data Type⁺ : Set where
    ----- above constructors plus ... 
    Σ⁺  : (A⁺ : Type⁺) -> ([] ⊩ A⁺ -> Type⁺) -> Type⁺
    nat : Type⁺
    vec : Type⁺ -> [] ⊩ nat -> Type⁺
\end{code}
%
Note the higher-order premise of \ttt{Σ⁺}.  

\ignore{
\begin{code}

  data Type⁻ : Set where
    ----- as before

  data Hyp : Set where
    _true⁻ : Type⁻ -> Hyp
    _atom⁺ : Atom -> Hyp

  Ctx = List Hyp
\end{code}}

Next, we add pattern constructors for these types:  

\begin{code}
  data _⊩_ : List Hyp -> Type⁺ -> Set where
    ----- above constructors plus ... 
    Cdpair : forall {Δ A⁺} {τ⁺ : ([] ⊩ A⁺ -> Type⁺)}
            (c : [] ⊩ A⁺) ->  Δ ⊩ (τ⁺ c) 
            -> Δ ⊩ (Σ⁺ A⁺ τ⁺)
    Czero : [] ⊩ nat
    Csucc : {Δ : Ctx} 
          -> Δ ⊩ nat 
          -> Δ ⊩ nat
    Cnil  : forall {A⁺} 
          -> [] ⊩ vec A⁺ Czero
    Ccons : forall {A⁺ Δ₁ Δ₂}
          -> (n : [] ⊩ nat) -> Δ₁ ⊩ A⁺ -> Δ₂ ⊩ vec A⁺ n
          -> Δ₂ ++ Δ₁ ⊩ vec A⁺ (Csucc n)
\end{code}
%
A pattern for \ttt{(Σ⁺ A⁺ τ⁺)} consists of a closed pattern \ttt{c} for
\ttt{A⁺}, as well as a pattern for \ttt{(τ⁺ c)}---i.e., the type
determined for \ttt{c} by the meta-function \ttt{τ⁺}.  Meta-function
application plays the role that substitution takes in the standard intro
rule for Σ-types.

To illustrate type-level computation, we can define a type \ttt{Σ⁺
n:nat.isero n} that is inhabited only when the first component of the
pair is \ttt{0}.

\begin{code}
 zpair :  Type⁺
 zpair = Σ⁺ nat iszero*
   where iszero* : [] ⊩ nat -> Type⁺
         iszero* Czero     = 1⁺
         iszero* (Csucc n) = 0⁺
\end{code}
%
The body of the Σ⁺-type is defined by pattern-matching on \ttt{nat},
mapping 0 to the unit type, and successor of anything to the void type.
Thus, it will only be possible to give a value for the second component
when the first component is \ttt{Czero}.

\medskip

While this definition captures the kind of dependency we want, it
is not accepted by Agda because it is not strictly positive:
\begin{enumerate} 
\item The types \ttt{Type⁺} and
\ttt{Δ ⊩ A⁺} are defined mutually inductively.  
\item The premise of the
constructor \ttt{Σ⁺} quantifies over patterns, which a negative
occurrence.
\end{enumerate}
%
Thus, it is not clear whether this definition is sensible.  

