\ignore{
\begin{code}

{-# OPTIONS --no-positivity-check #-}

open import lib.Prelude
open List.In
open List.InLists
open List.SW
open List using (_++_)  

module foc.posdep.Intuit where

module TypesPats where
 Atom : Set 
 Atom = String
\end{code}}

\subsubsection{Positive Pattern Data}

It will be useful to use a simple kinding discipline to distinguish the
purely positive types, which can never have negative subcomponents
embedded in them, from the positive types, which can.  We write
\ttt{PPos} for purely positive and \ttt{Pos} for positive, and we allow
dependency only on the patterns of purely positive types.

\begin{code}
 data PKind : Set where
   PPos : PKind
   Pos  : PKind
\end{code}

Now, we define the Agda \ttt{Set}s used to form patterns, with one
datatype for each type.  The constructors are essentially those for the
datatype \ttt{Δ ⊩ A⁺} defined before, but abstracted over the types of
the subpatterns.  Because we have not yet defined the syntax of types,
we use a module parametrized by the Agda \ttt{Set}'s representing them.

\begin{code}
 module CPats (Type⁺ : PKind -> Set) (Type⁻ : Set) where 

  data Hyp : Set where
    _true⁻ : Type⁻ -> Hyp
    _atom⁺ : Atom -> Hyp

  Ctx = List Hyp

  data CPatX⁺ : Atom -> Ctx -> Set where
    Cx⁺ : forall {X} -> CPatX⁺ X [ X atom⁺ ]
  data CPat↓ : Type⁻ -> Ctx -> Set where
    Cx⁻ : forall {A⁻} -> CPat↓ A⁻ [ A⁻ true⁻ ]
  data CPat* (_⊢A⁺ : Ctx -> Set) (_⊢B⁺ : Ctx -> Set) 
     : Ctx -> Set where
    Cpair : forall {Δ₁ Δ₂}
            -> Δ₁ ⊢A⁺ -> Δ₂ ⊢B⁺
            -> CPat* _⊢A⁺ _⊢B⁺ (Δ₂ ++ Δ₁)
  data CPatΣ⁺(_⊢A⁺ : Ctx -> Set)
             (_⊢τ⁺_ : Ctx -> [] ⊢A⁺ -> Set) 
     : Ctx -> Set where
    Cdpair : forall {Δ}
            -> (c : [] ⊢A⁺)  ->  Δ ⊢τ⁺ c 
            -> CPatΣ⁺ _⊢A⁺ _⊢τ⁺_ Δ 
  data CPat1⁺ : Ctx -> Set where
    C<> : CPat1⁺ []
  data CPat0⁺ : Ctx -> Set where
  data CPat+ (_⊢A⁺ : Ctx -> Set) (_⊢B⁺ : Ctx -> Set) 
     : Ctx -> Set where
    Cinl : forall {Δ} -> Δ ⊢A⁺ -> CPat+ _⊢A⁺ _⊢B⁺ Δ
    Cinr : forall {Δ} -> Δ ⊢B⁺ -> CPat+ _⊢A⁺ _⊢B⁺ Δ
  data CPatnat : Ctx -> Set where
    Czero : CPatnat []
    Csucc : forall {Δ} -> CPatnat Δ -> CPatnat Δ
  data CPatvec (_⊢A⁺ : Ctx -> Set) 
     : Ctx -> CPatnat [] -> Set where
    Cnil  : CPatvec _⊢A⁺ [] Czero
    Ccons :  forall {Δ₁ Δ₂} {n : CPatnat []}
            -> Δ₁ ⊢A⁺  ->  CPatvec _⊢A⁺ Δ₂ n
            -> CPatvec _⊢A⁺ (Δ₂ ++ Δ₁) (Csucc n)
  data CPatdom (A⁻ : Type⁻) : Ctx -> Set where
    Cdom : CPatdom A⁻ [ A⁻ true⁻ ]

 open CPats using (_true⁻ ; _atom⁺)
\end{code}

\subsubsection{Types and Patterns}

Next, we define the syntax of types and the positive patterns, using
induction-recursion.  There are a few differences from above.  First,
\ttt{Type⁺} is indexed by kinds.  Second, we add two new types:
\ttt{Π⁻}, whose formation rule is parallel to that for \ttt{Σ⁺}, and
\ttt{dom}, which will represent the recursive type \ttt{μ D. D → D}.
Its pattern rule is:

\[
\infer{\cpat{\ttt{dom} → ↑ \ttt{dom}}{\ttt{dom}}}
      {}
\]


\begin{code}
 mutual
  data Type⁺ : PKind -> Set where
    X⁺  : Atom -> Type⁺ Pos
    ↓   : Type⁻ -> Type⁺ Pos
    1⁺  : {K : PKind} -> Type⁺ K
    _*_ : {K : PKind} -> Type⁺ K -> Type⁺ K -> Type⁺ K
    Σ⁺  : {K : PKind} 
        (A⁺ : Type⁺ PPos) -> ([] ⊩ A⁺ -> Type⁺ K) -> Type⁺ K
    0⁺  : {K : PKind} -> Type⁺ K
    _+_ : {K : PKind} -> Type⁺ K -> Type⁺ K -> Type⁺ K
    nat : {K : PKind} -> Type⁺ K
    vec : {K : PKind} (A+ : Type⁺ K) -> CPatnat [] -> Type⁺ K
    dom : Type⁺ Pos

  data Type⁻ : Set where
    X⁻   : Atom -> Type⁻
    ↑    : Type⁺ Pos -> Type⁻
    _→_ : Type⁺ Pos -> Type⁻ -> Type⁻
    Π⁻   : (A+ : Type⁺ PPos) -> ([] ⊩ A+ -> Type⁻) -> Type⁻
    ⊤   : Type⁻
    _&_  : Type⁻ -> Type⁻ -> Type⁻
\end{code}

\ignore{
\begin{code}
  infixr 10 _→_

  -- modules not allowed in mutual blocks
  -- so we have to make some local defs here
  Hyp = CPats.Hyp Type⁺ Type⁻
  CPatX⁺ = CPats.CPatX⁺ Type⁺ Type⁻
  CPat↓ = CPats.CPat↓ Type⁺ Type⁻
  CPat* = CPats.CPat* Type⁺ Type⁻
  CPatΣ⁺ = CPats.CPatΣ⁺ Type⁺ Type⁻
  CPat1⁺ = CPats.CPat1⁺ Type⁺ Type⁻
  CPat0⁺ = CPats.CPat0⁺ Type⁺ Type⁻
  CPat+ = CPats.CPat+ Type⁺ Type⁻
  CPatnat = CPats.CPatnat Type⁺ Type⁻
  CPatvec = CPats.CPatvec Type⁺ Type⁻
  CPatdom = CPats.CPatdom Type⁺ Type⁻
\end{code}}

The \ttt{Set}s of patterns are defined by instantiating the above
datatypes with the \ttt{Set}s determined by the recursive calls:

\begin{code}
  _⊩_ : {K : PKind} -> List Hyp -> Type⁺ K -> Set
  Δ ⊩ (X⁺ X) = CPatX⁺ X Δ 
  Δ ⊩ (↓ A⁻) = CPat↓ A⁻ Δ
  Δ ⊩ 1⁺     = CPat1⁺ Δ
  Δ ⊩ (A⁺ * B⁺) = 
    CPat* (\Δ₁ -> Δ₁ ⊩ A⁺) (\Δ₂ -> Δ₂ ⊩ B⁺) Δ
  Δ ⊩ (Σ⁺ A⁺ τ+) = 
    CPatΣ⁺ (\Δ -> Δ ⊩ A⁺) (\Δ c -> Δ ⊩ (τ+ c)) Δ
  Δ ⊩ 0⁺ = CPat0⁺ Δ
  Δ ⊩ (A⁺ + B⁺) = 
    CPat+ (\Δ -> Δ ⊩ A⁺) (\Δ -> Δ ⊩ B⁺) Δ
  Δ ⊩ nat = CPatnat Δ
  Δ ⊩ (vec A⁺ n) = CPatvec (\Δ -> Δ ⊩ A⁺) Δ n
  Δ ⊩ dom = CPatdom (dom → ↑ dom) Δ
\end{code}
%

The type \ttt{dom} is the recursive type \ttt{μdom.↓(dom →
↑ dom)}.  The pattern for \ttt{dom} is a base case, with only one
pattern; \ttt{Cdom} is essentially \ttt{(roll x)} for a variable
\ttt{x}. We do \emph{not} define the patterns for \ttt{dom} in terms of
functions from the patterns for \ttt{dom} to the patterns for
\ttt{dom}---the polarity shift caused by the $\cShiftD$
halts the semantic interpretation of patterns.

\ignore{
\begin{code}
 open CPats Type⁺ Type⁻ public hiding (Hyp ; CPatX⁺ ; CPat↓ ; CPat* ; CPatΣ⁺ ; CPat1⁺ ; CPat0⁺ ; CPat+ ; CPatnat ; CPatvec ; CPatdom)
\end{code}}

\subsubsection{Destructor Patterns}

Next, we define the destructor patterns inductively, as before.  The
\ttt{Ddapp} rule is analogous to \ttt{Cdpair}: to use \ttt{Π⁻ A⁺ τ⁻},
give a constructor \ttt{c} for \ttt{A⁺}, and use \ttt{(τ⁻ c)}.

\begin{code}
 data Conc : Set where
   _true⁺ : {K : PKind} -> Type⁺ K  -> Conc
   _atom⁻ : Atom -> Conc

 data _⊩_>_ : Ctx -> Type⁻ -> Conc -> Set where
   De⁻  : forall {X} -> [] ⊩ (X⁻ X) > (X atom⁻)
   De⁺  : {A⁺ : Type⁺ Pos} -> [] ⊩ (↑ A⁺) > (A⁺ true⁺)
   Dapp : forall {Δ₁ Δ₂ B⁻ γ} {A⁺ : Type⁺ Pos}
        -> Δ₁ ⊩ A⁺  ->  Δ₂ ⊩ B⁻ > γ 
        -> (Δ₂ ++ Δ₁) ⊩ ((A⁺ → B⁻)) > γ
   Ddapp : forall {Δ γ} {A⁺ : Type⁺ PPos} 
                  {τ⁻ : ([] ⊩ A⁺ -> Type⁻)} 
         -> (c : [] ⊩ A⁺)  ->  Δ ⊩ (τ⁻ c) > γ 
         -> Δ ⊩ (Π⁻ A⁺ τ⁻) > γ
   Dfst  : forall {Δ A⁻ B⁻ γ}
         -> Δ ⊩ A⁻ > γ -> Δ ⊩ (A⁻ & B⁻) > γ
   Dsnd  : forall {Δ A⁻ B⁻ γ}
         -> Δ ⊩ B⁻ > γ -> Δ ⊩ (A⁻ & B⁻) > γ
\end{code}

\ignore{
\begin{code}
module Focus where
 open TypesPats public
\end{code}}

\subsubsection{Focusing Rules}

The focusing rules are essentially unchanged from the simply-typed case.
The differences are confined to the implicit arguments to the
constructors: every rule that binds a positive type \ttt{C⁺} now also
binds a kind \ttt{K} classifying it.  We present the code in Figure
\ref{fig:focus-agda-dep}.

\begin{figure}
\begin{code}
 CtxCtx : Set
 CtxCtx = List Ctx

 data FocJudg : Set where
   RFoc : {K : PKind} -> Type⁺ K -> FocJudg
   LInv : Conc -> Conc -> FocJudg
   LFoc : Type⁻ -> Conc -> FocJudg
   RInv : Hyp -> FocJudg
   Neu : Conc -> FocJudg
   Asms : Ctx -> FocJudg

 codata _⊢_ :  CtxCtx -> FocJudg -> Set where
   ---- positive values (v+)
   Val⁺ : forall {Γ K Δ} {C⁺ : Type⁺ K}
        -> Δ ⊩ C⁺ -> Γ ⊢ Asms Δ 
        -> Γ ⊢ RFoc C⁺
   ---- positive continuations (k+)
   Ke⁻    : forall {Γ X } 
          -> Γ ⊢ LInv (X atom⁻) (X atom⁻)
   Cont⁺  : forall {Γ K γ} {C⁺ : Type⁺ K}
          -> ({Δ : Ctx} -> Δ ⊩ C⁺ -> Δ :: Γ ⊢ Neu γ) 
          -> Γ ⊢ LInv (C⁺ true⁺) γ
   ---- negative continuations (k-)
   Cont⁻ : forall {Δ C⁻ γ0 γ Γ} 
         -> Δ ⊩ C⁻ > γ0 -> Γ ⊢ Asms Δ -> Γ ⊢ LInv γ0 γ 
         -> Γ ⊢ LFoc C⁻ γ
   ---- negative values (v-)
   Vx⁺ : forall {Γ X} 
       -> (X atom⁺) ∈∈ Γ -> Γ ⊢ RInv (X atom⁺)
   Val⁻ : forall {Γ C⁻} 
        -> ({Δ : Ctx}{γ : Conc} 
             -> Δ ⊩ C⁻ > γ ->  Δ :: Γ ⊢ Neu γ) 
        -> Γ ⊢ RInv (C⁻ true⁻)
   ---- expressions (e)
   R : forall {Γ K} {C⁺ : Type⁺ K}
     -> Γ ⊢ RFoc C⁺ 
     -> Γ ⊢ Neu (C⁺ true⁺)
   L : forall {Γ C⁻ γ} 
     -> ((C⁻ true⁻) ∈∈ Γ) -> Γ ⊢ LFoc C⁻ γ
     -> Γ ⊢ Neu γ
   ---- substitutions (σ)
   Sub  : {Γ : CtxCtx} -> {Δ : Ctx} 
        -> ({α : Hyp} -> α ∈ Δ -> Γ ⊢ RInv α)
        -> Γ ⊢ Asms Δ
\end{code}

\caption{Focusing Rules}
\label{fig:focus-agda-dep}
\end{figure}