#include "util.h"

float
timeval_diff(const struct timeval *start, const struct timeval *end)
{
    suseconds_t r;

    /* Calculate the second difference*/
    r = ((suseconds_t) end->tv_sec - start->tv_sec)* 1000000;

    /* Calculate the microsecond difference */
    if (end->tv_usec > start->tv_usec)
        r += ((suseconds_t) end->tv_usec - start->tv_usec);
    else if (end->tv_usec < start->tv_usec)
        r -= ((suseconds_t) start->tv_usec - end->tv_usec);

    return (float)r/1000000;
}

double
return_time(time_label label)
{
    double MHZ = 2992.745 ;
    
    switch (label) {
    case CYCLES:
	return((double)rdtsc());
	break;

    case SECONDS:
	return(get_cur_time());
	break;

    case CYC_SEC:
	return(rdtsc()/(MHZ*1000000));
	break;
	
    default:
	return(-1);
	break;
    }
}

double 
get_cur_time()
{
  struct timeval tv;

  gettimeofday(&tv, 0);
  return (1.0*(tv.tv_sec + tv.tv_usec/1000000.0));
}
