#include "dot_fts.h"

int
fts(vec<char *> paths, int options, ftsfunc cb)
{
    FTS *ftsp;
    FTSENT *ftsentp;
    
    ftsp = fts_open(paths.base(), options, NULL);
    if (!ftsp) {
        warn("fts_open: %m\n");
        return -1;
    }

    while ((ftsentp = fts_read(ftsp))) {
        (*cb) (ftsentp);
    }
    if (errno) {
        warn("fts_read: %m\n");
        return -1;
    }

    return fts_close(ftsp);
}
