
# 1 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
#define CCEOC_ARGNAME  coordvar
# 1 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
/*
 * Copyright (c) 2005-2006 Carnegie Mellon University and Intel Corporation.
 * All rights reserved.
 * See the file "LICENSE" for licensing terms.
 */

#include "xferPlugin_xdisk.h"

extern opt_matrix mat;
ptr<vec<str> > ignore_str;

struct stat_info
get_shadow_stat(struct item_info ip)
{
    struct stat_info op;

    op.name = ip.name;
    op.s.stsize = ip.s.st_size;
    op.s.statime = ip.s.st_atime;
    op.s.stmtime = ip.s.st_mtime;
    op.s.stctime = ip.s.st_ctime;

    return(op);
}

bool
check_op_in_cache(Db *filesDb, str key, struct item_info s)
{
    ptr <Dbt> d = New refcounted<Dbt >;
    
    if (!get_unique_from_cache(filesDb, key.cstr(), key.len(), d)) {
	//warnx << "check_op_in_cache: MISS for " << key << "\n";
	return false;
    }

    //warnx << "check_op_in_cache: HIT for " << key << "\n";
    
    rpc_bytes<> value;
    value.set((char *)d->get_data(), d->get_size());
    
    op_bdb_info o;
    bytes2xdr(o, value);
    if (o.type != INFO_OP) {
	return false;
    }

    if (s.s.st_mtime > o.time) {
	//warnx << "check_op_in_cache: HITBUTSTALE for " << key << "\n";
	//delete the stale entry
	delete_from_cache(filesDb, key.cstr(), key.len());
	return false;
    }

    //warnx << "check_op_in_cache: HITVALID for " << key << "\n";
    return true;
}

/*
 * This function modifies the input path string to avoid creating
 * lots of str objects.  It stores pointers to the start of each
 * path component in the path_parts vec.
 */

static void
split_path(char *path, vec<char *> *path_parts)
{
    if (*path == '/')
	path_parts->push_back("/");
    
    char *line, *brkt;
    for (line = strtok_r(path, "/", &brkt);  
         line;
	 line = strtok_r(NULL, "/", &brkt)) {
	path_parts->push_back(line);
    }
}

double
dir_match(const char *str1, const char *str2)
{
    vec<char *> *p1 = New vec<char *>;
    vec<char *> *p2 = New vec<char *>;

    char *cp = strdup(str1);
    char *tp = strdup(str2);

    split_path(cp, p1);
    split_path(tp, p2);
    
    double dist = 0;
    int s1 = p1->size();
    int s2 = p2->size();
    int max_len = max(s1, s2);
    vec<char *> *sm;
    vec<char *> *lg;
    if (s1 > s2) {
	sm = p2; lg = p1;
    }
    else {
	sm = p1; lg = p2;
    }

    //leftmost match
    //warnx << "LEFTMOST\n" << debug_sep;
    unsigned int lmatch = 0;
    double ldist = 0;
    for (unsigned int i = 0; i < sm->size(); i++) {
	if (strcmp((*sm)[i], (*lg)[i]) != 0)
	    break;
	else {
	    //warnx << (*sm)[i] << " ";
	    lmatch++;
	}
    }
    //warnx << "\n";
    ldist = ((double)lmatch)/max_len;
    dist = ldist*ldist;
    //fprintf(stderr, "left is %f\n", dist);
    //warnx << debug_sep;
    
    //rightmost match
    //warnx << "RIGHTMOST\n" << debug_sep;
    unsigned int rmatch = 0;
    double rdist = 0;
    unsigned int j = lg->size()-1;
    for (int i = sm->size()-1; i >= 0; i--) {
	if (strcmp((*sm)[i], (*lg)[j]) != 0)
	    break;
	else {
	    //warnx << (*sm)[i] << " " ;
	    rmatch++;
	    j--;
	}
    }
    rdist = ((double)rmatch)/max_len;

    if (rdist > dist)
	dist = rdist;
    //fprintf(stderr, "right is %f and dist %f\n", rdist, dist);
    //warnx << debug_sep;
    
    //if (1) {
    //middle match
    //warnx << "MIDDLEMOST\n" << debug_sep;
    unsigned int mmatch = 0;
    double mdist = 0;
    {
	int *L = new int[(s1+1)*(s2+1)];
	bzero(L, sizeof(int)*(s1+1)*(s2+1));
	int z = 0;
	//str ret = "";
	int len = -1;
	
	for (int i = 0; i < s1; i++) {
	    for (int j = 0; j < s2; j++) {
		if ((*p1)[i] == (*p2)[j]) {
		    
		    L[(i+1)*(s2+1)+j+1] = L[i*(s2+1)+j] + 1;
		    
		    if (L[(i+1)*(s2+1)+j+1] >= z) {
			z = L[(i+1)*(s2+1)+j+1];
			//ret = "";
		    }
		    if (L[(i+1)*(s2+1)+j+1] == z) {
			len = z;
			//warnx << i << "|" << i-z+1 << "|" << len << "\n";
			//for (int k = i-z+1; k < i-z+1+len; k++) {
			//  ret = strbuf() << ret << (*p1)[k];
			//}
		    }
		}
	    }
	}
	
	//warnx << "LCS --> " << ret << "\n";
	
	delete[] L;
	mmatch = z;
    }
    
    mdist = ((double)mmatch)/max_len;
    mdist = mdist*mdist;
    
    if (mdist > dist)
	dist = mdist;
    //    fprintf(stderr, "middle is %f and dist %f\n", mdist, dist);
    //warnx << debug_sep;
    //}

    free(cp);
    free(tp);
    p1->clear();
    p2->clear();
    delete p1;
    delete p2;
    
    return(dist);
}

bool
inline suffix_match(str c, str t, str suf)
{
    char *ptr;
    if ((ptr = strstr(c, suf))) {
	if (!strncasecmp(c, t, (ptr - c.cstr())))
	    return true;
    }
    return false;
}

bool
inline prefix_match(str c, str t, str pre)
{
    char *ptr;
    if ((ptr = strstr(c, pre))) {
	if (!strcasecmp(ptr, t))
	    return true;
    }
    return false; 
}

double
inline fuzzy_name_match(str c, str t, str t_type)
{
    if (c == t) 
	return(1);

    //not an exact name match ..see if backup file match
    if (suffix_match(c, t, "~") ||
	prefix_match(c, t, "#"))
	return(0.7);

    //type match
    char *f = NULL;
    f = strrchr(c, '.');
    str type;
    if (f)
	type = strbuf() << f;
    else
	type = "NONE";
    
    if (type != "NONE" &&  t_type != "NONE" &&
	!strcasecmp(type, t_type))
	//type == t_type) 
	return(0.5);

    return(0.1);
}

double
inline fuzzy_size_match(int c, int t)
{
    if (c == t)
	return(1);

    double perc = abs(t-c)/((double)t);
    if (perc > 0.1)
	return(0.1);

    //0.9 = m(0.01) + c
    //0.5 = m(0.1) + c
    double p = -4.45*perc + 0.95;
    return(p);
}

double
inline time_match(int c, int t)
{
    if (c == t)
	return(1);

    double perc = abs(t-c)/((double)t);
    if (perc > 10)
	return(0.7);
    
    //0.9 = m(0.01) + c;
    //0.7 = m(10) + c;
    double p = -0.02*perc + 0.9;
    return(p);
}

bool
inline check_ignore_str(str op)
{
    for (unsigned int i = 0; i < ignore_str->size(); i++) {
	if (strstr(op.cstr(), (*ignore_str)[i]))
	    return true;
    }

    return false;
}

os_entry *
create_statop(str path, struct item_info s, xferPlugin_xdisk *xp)
{
    str op_name = strbuf() << path << ":" << DISK_STAT;
    
    os_entry *ose = mat.op_store[op_name];
    //this is a new op
    if (!ose) {
	if (check_ignore_str(op_name) ||
	    check_op_in_cache(xp->filesDb, op_name, s))
	    return(NULL);

	//warnx << "Stat op op_name -->" << op_name << "\n";
	
	ose  = New stat_op(op_name, path, s, xp);
	
	if (mode == BFS_WHOLE) 
	    mat.stat_q.insert_head(ose);

	mat.pending_q.insert_tail(ose);
    }
    
    return(ose);
}

os_entry *
create_hashop(str path, struct item_info st, xferPlugin_xdisk *xp)
{
    if (st.s.st_size <= 0) {
	//warnx << "create_hashop:: Nothing useful\n";
	return(NULL);
    }
    str op_name = strbuf() << path << st.name << ":" << DISK_HASH;
    //warnx << "Path is " << path << " " << op_name << "\n";
    
    os_entry *ose = mat.op_store[op_name];
    //this is a new op
    if (!ose) {
	if (check_ignore_str(op_name) ||
	    check_op_in_cache(xp->filesDb, op_name, st))
	    return NULL;
	
	ose  = New hash_op(op_name, path, st, xp);
	
	if (mode == BFS_WHOLE) 
	    mat.hash_q.insert_head(ose);

	mat.pending_q.insert_tail(ose);
    }
    
    return(ose);
}

os_entry *
create_chitop(dot_desc d, ptr<vec<struct offset_info > > oi,
	      int len, xferPlugin_xdisk *xp)
{
    str op_name = strbuf() << d << ":" << DISK_CHIT;
    //warnx << "key is " << d << " " << op_name << "\n";
    
    os_entry *ose = mat.op_store[op_name];
    //this is a new op
    if (!ose) {
	ose  = New chit_op(op_name, d, oi, len, xp);
	mat.pending_q.insert_tail(ose);
    }
    
    return(ose);
}

double
update_cost(double prev, double cur)
{
    double new_val = prev + ALPHA * (cur - prev);
    return(new_val);
}

stat_op::stat_op(str i, str p, struct item_info s,
		 xferPlugin_xdisk *ptr)
{
    id = i;
    
    //mat.add_row(this);

    //opt variables
    op_cost = LOAD_STAT_FACTOR * DIR_STAT_COST;
    DPRINTF(DEBUG_XDISK, "Stat get_cost is %f\n", DIR_STAT_COST);
    sum_p = 0;
    sum_cp = 0;
    cpb = LARGE_COST; //cost per block
    it_num = -1;
    success = 0;
    time = -1;

    type = DISK_STAT;
    path = p;
    stat_buf = s;
    xp = ptr;
        
    dwarn(DEBUG_XDISK) << "stat_op::stat_op: Creating entry for " << p <<
	" " << id << "\n";
}

stat_op::~stat_op()
{
    //warnx << "stat_op::stat_op: Deleting entry for " << id << "\n";
}

# 401 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
class stat_op__perform_op__closure_t : public closure_t { public:   stat_op__perform_op__closure_t (stat_op *_self) : closure_t (false), _self (_self),  _stack (), _args (), _block1 (0), _cb_num_calls1 (0) {}   typedef void  (stat_op::*method_type_t) (ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     case 1: cb1(); break;     default: panic ("unexpected case");     }   }   void cb1 () {     if (-- _cb_num_calls1 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T:415: in function aioh::seek", "callback overcalled!");     }     if (!--_block1)       delaycb (0, 0, wrap (mkref (this), &stat_op__perform_op__closure_t::reenter));   }   void reenter ()   {     ((*_self).*_method)  (mkref (this));   }   struct stack_t {     stack_t () {}      str err;      ptr< vec< struct item_info > > stats;      double now;      double cost;      double prev;   };   struct args_t {     args_t () {}   };   stat_op *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   int _block1;   int _cb_num_calls1;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 401 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
void 
stat_op::perform_op(ptr<closure_t> __cls_g)
{
    
# 404 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  stat_op__perform_op__closure_t *__cls;   ptr<stat_op__perform_op__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<stat_op__perform_op__closure_t> (this);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&stat_op::perform_op);   } else {     __cls =     reinterpret_cast<stat_op__perform_op__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    str &err = __cls->_stack.err;    ptr< vec< struct item_info > > &stats = __cls->_stack.stats;    double &now = __cls->_stack.now;    double &cost = __cls->_stack.cost;    double &prev = __cls->_stack.prev;   switch (__cls->jumpto ()) {   case 1:     goto stat_op__perform_op__label_1;     break;   default:     break;   }
# 410 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"


    now = return_time(SECONDS);
    stats = New refcounted<vec<struct item_info> >;
    
# 414 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  do {     __cls->_block1 = 1;     __cls->set_jumpto (1); 
# 414 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

	xp->perform_stat(path, stats, (++__cls->_block1, ++__cls->_cb_num_calls1, wrap (__block_cb1<TTT(err)>, __cls_r, 1, pointer_set1_t<TTT(err)> (&(err)))));
    
# 416 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
    if (--__cls->_block1)       return;   } while (0);  stat_op__perform_op__label_1:     ;
# 416 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"


    if (err) {
	(*(xp->pending_cb))(err, NULL);
	
# 420 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
return ;
    }
    cost = return_time(SECONDS) - now;
    if (cost < 0) {
	warnx << "Woah, cost is negative\n";
	cost = 0;
    }
    
    prev = DIR_STAT_COST;
    DIR_STAT_COST = update_cost(prev, cost);
    time = cost;
    
    //fprintf(stderr, "Accumulating stat cost %f to prev %f to get %f\n", cost, prev, DIR_STAT_COST);
    
    //add more ops
    for (unsigned int i = 0; i < stats->size(); i++) {
	//warnx << (*stats)[i].name << " " << (*stats)[i].s.st_size << "\n";
	if (S_ISDIR((*stats)[i].s.st_mode)) {
	    str p = strbuf() << path << (*stats)[i].name << "/";
	    create_statop(p, (*stats)[i], xp);
	}
	else {
	    create_hashop(path, (*stats)[i], xp);
	}
    }

    //cache the fact that op is performed
    {
	rpc_bytes<> value;
	op_bdb_info o;
	o.type = INFO_OP;
	o.path = path;
	o.oper = DISK_STAT;
	//item_info --> stat_info
	o.buf = get_shadow_stat(stat_buf);
	double t = get_cur_time();
	o.time = (dot_time) t;
	//fprintf(stderr, "****************%f\n", t);
	//warnx << o.time << "\n";
	xdr2bytes(value, o);
	put_in_cache(xp->filesDb, id.cstr(), id.len(),
		     value.base(), value.size(), true);

	//ptr<Dbt > d = New refcounted<Dbt >;
	//if (get_unique_from_cache(xp->filesDb, id.cstr(), id.len(), d))
	//  warnx << "Everything good\n";
    }
    
    (*(xp->pending_cb))(err, NULL);
# 469 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  return;
# 469 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
}

void
stat_op::get_cost()
{
    op_cost = LOAD_STAT_FACTOR * DIR_STAT_COST;
    DPRINTF(DEBUG_XDISK, "Stat get_cost is %f\n", DIR_STAT_COST);
}

float
stat_op::get_benefit(ht_entry *hte)
{
    double p_t = 0;
    double p = 0;

    if (hte->key == "CACHE_HIT") 
	return (0);
    
    unsigned int size = hte->hints->size();
    ptr<vec<xdisk_hint> > temp = hte->hints;
    for (unsigned int i = 0; i < size; i++) {
	p = dir_match(path, (*temp)[i].target_dir);
	p_t = max(p, p_t);
    }
    DPRINTF(DEBUG_XDISK, "stat_op::get_benefit: %s prob is %.2f\n",path.cstr(), p);

    return(p_t);
}

double
stat_op::get_xfer_cost(ht_entry *hte)
{
    assert(0);
    double p = get_benefit(hte);
    double c = LARGE_COST;
    if (p > 0) 
	c = (ADJ_WT * LOAD_HASH_FACTOR * CHUNK_READ_HASH_COST)/p;
    
    return(c);
}

hash_op::hash_op(str i, str p, struct item_info s, xferPlugin_xdisk *ptr)
{
    id = i;
    
    //mat.add_row(this);

    unsigned int num_chunks = 0;
    num_chunks = s.s.st_size/CHUNK_SIZE;
    if (s.s.st_size % CHUNK_SIZE != 0)
	num_chunks++;
    op_cost = (num_chunks * LOAD_HASH_FACTOR * CHUNK_READ_HASH_COST);
    DPRINTF(DEBUG_XDISK, "Hash get_cost per chunk is %f\n", CHUNK_READ_HASH_COST);
    sum_p = 0;
    sum_cp = 0;
    cpb = LARGE_COST; //cost per block
    it_num = -1;
    success = 0;
    time = -1;

    type = DISK_HASH;
    path = p;
    stat_buf = s;
    xp = ptr;
    
    //warnx << "hash_op::hash_op: Creating entry for " << p <<
    //" name " << stat_buf.name << " size " << stat_buf.s.st_size << " id " << id << "\n";
}

hash_op::~hash_op()
{
    //warnx << "hash_op::hash_op: Deleting entry for " << id << "\n";
}

void
hash_op::get_cost()
{
    unsigned int num_chunks = 0;
    num_chunks = stat_buf.s.st_size/CHUNK_SIZE;
    if (stat_buf.s.st_size % CHUNK_SIZE != 0)
	num_chunks++;
    op_cost = (num_chunks * LOAD_HASH_FACTOR * CHUNK_READ_HASH_COST);

    DPRINTF(DEBUG_XDISK, "Hash get_cost per chunk is %f\n", CHUNK_READ_HASH_COST);
}

float
hash_op::get_benefit(ht_entry *hte)
{
    double p = 0;
    double p_fs = 0;
    double p_ss = 0;
    double p_pc = 0;
    double p_tm = 0;
    double p_sc = 0;
    double p_t = 0;

    if (hte->key == "CACHE_HIT") 
	return (0);
    
    unsigned int size = hte->hints->size();
    ptr<vec<xdisk_hint> > temp = hte->hints;
    
    for (unsigned int i = 0; i < size; i++) {

	xdisk_hint xd = (*temp)[i];
	p_fs = fuzzy_name_match(stat_buf.name, xd.name,
				xd.file_type);
	p_ss = fuzzy_size_match(stat_buf.s.st_size,
				xd.size);
	p_pc = dir_match(path, xd.target_dir);
	p_tm = time_match(stat_buf.s.st_mtime, xd.modtime);
	p_sc = min((unsigned int)(stat_buf.s.st_size), xd.size)/(double)xd.size;
    
	p = p_fs * p_ss * p_pc * p_tm * p_sc;
	    
	p_t = max(p, p_t);
	
	//fprintf(stderr, "hash_op::get_benefit: %s p %f || p_fs %f || p_ss %f || p_pc %f || p_tm %f || p_sc %f\n",
	//id.cstr(), p, p_fs, p_ss, p_pc, p_tm, p_sc);
    }

    //fprintf(stderr, "Total %f\n", p_t);
    
    assert(p <= 1);
    return(p);
}

double
hash_op::get_xfer_cost(ht_entry *hte)
{
    assert(0);
    return(0);
}

# 604 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
class hash_op__perform_op__closure_t : public closure_t { public:   hash_op__perform_op__closure_t (hash_op *_self) : closure_t (false), _self (_self),  _stack (), _args (), _block1 (0), _cb_num_calls1 (0) {}   typedef void  (hash_op::*method_type_t) (ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     case 1: cb1(); break;     default: panic ("unexpected case");     }   }   void cb1 () {     if (-- _cb_num_calls1 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T:621: in function stat_op::perform_op", "callback overcalled!");     }     if (!--_block1)       delaycb (0, 0, wrap (mkref (this), &hash_op__perform_op__closure_t::reenter));   }   void reenter ()   {     ((*_self).*_method)  (mkref (this));   }   struct stack_t {     stack_t () {}      str err;      str file;      double now;      double cost;      double prev;      double per_chunk;      unsigned int num_chunks;   };   struct args_t {     args_t () {}   };   hash_op *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   int _block1;   int _cb_num_calls1;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 604 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
void 
hash_op::perform_op(ptr<closure_t> __cls_g)
{
    
# 607 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  hash_op__perform_op__closure_t *__cls;   ptr<hash_op__perform_op__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<hash_op__perform_op__closure_t> (this);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&hash_op::perform_op);   } else {     __cls =     reinterpret_cast<hash_op__perform_op__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    str &err = __cls->_stack.err;    str &file = __cls->_stack.file;    double &now = __cls->_stack.now;    double &cost = __cls->_stack.cost;    double &prev = __cls->_stack.prev;    double &per_chunk = __cls->_stack.per_chunk;    unsigned int &num_chunks = __cls->_stack.num_chunks;   switch (__cls->jumpto ()) {   case 1:     goto hash_op__perform_op__label_1;     break;   default:     break;   }
# 615 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

        
    file = strbuf() << path << stat_buf.name;

    now = return_time(SECONDS);
    
# 620 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  do {     __cls->_block1 = 1;     __cls->set_jumpto (1); 
# 620 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

	xp->perform_hash(file, (++__cls->_block1, ++__cls->_cb_num_calls1, wrap (__block_cb1<TTT(err)>, __cls_r, 1, pointer_set1_t<TTT(err)> (&(err)))));
    
# 622 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
    if (--__cls->_block1)       return;   } while (0);  hash_op__perform_op__label_1:     ;
# 622 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

    if (err) {
	(*(xp->pending_cb))(err, NULL);
	
# 625 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
return ;
    }
    
    cost = return_time(SECONDS) - now;
    if (cost < 0) {
	warnx << "Woah!  hash_opt::perform_op cost is negative\n";
	cost = 0;
    }
	    
    num_chunks = 0;
    num_chunks = stat_buf.s.st_size/CHUNK_SIZE;
    if (stat_buf.s.st_size % CHUNK_SIZE != 0)
	num_chunks++;
    per_chunk = cost/num_chunks;
    prev = CHUNK_READ_HASH_COST;
    CHUNK_READ_HASH_COST = update_cost(prev, per_chunk);
    time = cost;
    //fprintf(stderr, "Accumulating hash cost %f (%f, %d) with prev %f to get cur %f\n", per_chunk,
    //    cost, num_chunks, prev, CHUNK_READ_HASH_COST);
   
    //cache the fact that op is performed
    {
	rpc_bytes<> value;
	op_bdb_info o;
	o.type = INFO_OP;
	o.path = path;
	o.oper = DISK_HASH;
	o.buf = get_shadow_stat(stat_buf);
	o.time = (unsigned int )get_cur_time();
	xdr2bytes(value, o);
	put_in_cache(xp->filesDb, id.cstr(), id.len(),
		     value.base(), value.size(), true);
    }
    
    (*(xp->pending_cb))(err, NULL);
# 660 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  return;
# 660 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
}

chit_op::chit_op(str i, dot_desc d, ptr<vec<struct offset_info > > oi,
		 int len, xferPlugin_xdisk *ptr)
{
    id = i;
    
    //mat.add_row(this);

    op_cost = CACHE_CHECK_COST;
    sum_p = 0.95;
    sum_cp = 0;
    cpb = LARGE_COST; //cost per block
    it_num = -1;
    success = 0;
    time = -1;

    type = DISK_CHIT;
    desc = d;
    inf = oi;
    length = len;
    xp = ptr;
    
    //warnx << "chit_op::chit_op: Creating entry for " << d <<
    //" and id " << id << " and len " << len << "\n";
}

chit_op::~chit_op()
{
    //warnx << "chit_op::chit_op: Deleting entry for " << id << "\n";
}

void
chit_op::get_cost()
{
    op_cost = CACHE_CHECK_COST;
}

float
chit_op::get_benefit(ht_entry *hte)
{
    if (hte->key != "CACHE_HIT") 
        return (0);
    
    double p = 0;
    
    ds_entry *dse = mat.desc_store[desc];
    if (dse)
        p = 0.95;
    
    return(p);
}

double
chit_op::get_xfer_cost(ht_entry *hte)
{
    return(LOAD_HASH_FACTOR * CHUNK_READ_HASH_COST);
}

# 719 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
class chit_op__perform_op__closure_t : public closure_t { public:   chit_op__perform_op__closure_t (chit_op *_self) : closure_t (false), _self (_self),  _stack (), _args (), _block1 (0), _cb_num_calls1 (0) {}   typedef void  (chit_op::*method_type_t) (ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     case 1: cb1(); break;     default: panic ("unexpected case");     }   }   void cb1 () {     if (-- _cb_num_calls1 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T:736: in function hash_op::perform_op", "callback overcalled!");     }     if (!--_block1)       delaycb (0, 0, wrap (mkref (this), &chit_op__perform_op__closure_t::reenter));   }   void reenter ()   {     ((*_self).*_method)  (mkref (this));   }   struct stack_t {     stack_t () {}      str err;      unsigned int i;      double now;      double prev;   };   struct args_t {     args_t () {}   };   chit_op *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   int _block1;   int _cb_num_calls1;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 719 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
void 
chit_op::perform_op(ptr<closure_t> __cls_g)
{
    
# 722 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  chit_op__perform_op__closure_t *__cls;   ptr<chit_op__perform_op__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<chit_op__perform_op__closure_t> (this);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&chit_op::perform_op);   } else {     __cls =     reinterpret_cast<chit_op__perform_op__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    str &err = __cls->_stack.err;    unsigned int &i = __cls->_stack.i;    double &now = __cls->_stack.now;    double &prev = __cls->_stack.prev;   switch (__cls->jumpto ()) {   case 1:     goto chit_op__perform_op__label_1;     break;   default:     break;   }
# 727 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"


    dwarn(DEBUG_OPT) << "Came to read\n";
    
    now = return_time(SECONDS);
    for (i = 0; i < inf->size(); i++) {
	dwarn(DEBUG_OPT) << "Performing offset read\n";
	
# 734 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  do {     __cls->_block1 = 1;     __cls->set_jumpto (1); 
# 734 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

	    xp->perform_offset_read((*inf)[i].path, (*inf)[i].offset,
				    length, (++__cls->_block1, ++__cls->_cb_num_calls1, wrap (__block_cb1<TTT(err)>, __cls_r, 1, pointer_set1_t<TTT(err)> (&(err)))));
	
# 737 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
    if (--__cls->_block1)       return;   } while (0);  chit_op__perform_op__label_1:     ;
# 737 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

	if (!err)
	    break;
    }

    if (!err) {
	now = return_time(SECONDS) - now;
	if (now < 0) {
	    warnx << "Woah! Cost is negative\n";
	    now = 0;
	}
	prev = CHUNK_READ_HASH_COST;
	CHUNK_READ_HASH_COST = update_cost(prev, now);
	time = now;
    }
    else {
       warnx << " Err in cache hit " << err << "\n";
    }

    dwarn(DEBUG_OPT) << "Calling back\n";
    
    (*(xp->pending_cb))(err, NULL);
# 759 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  return;
# 759 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
}


/*ops*/

xferPlugin_xdisk::xferPlugin_xdisk(gtcd *_m, xferPlugin *next_xp)
    : m(_m), xp(next_xp)
{
    assert(m);
    if (next_xp)
	fatal << __PRETTY_FUNCTION__ << " next_xp is not NULL\n"
	      << "Make sure that this storage plugin comes last\n";

    str aiodpath = AIOD_PATH;
    warn << "aiodpath is " << aiodpath << "\n";
    aiod_ptr = New aiod (1, 0x10000, 0x10000, false, aiodpath);

    cp = New chunkerPlugin_default(this);

    ignore_str = New refcounted<vec<str> >;

    //cache setup
    dbenv = new DbEnv(0);
    dbenv->set_errpfx("Xdisk Transfer Plugin");
    dbenv->set_cachesize(0, XDISK_CACHE_SIZE, 0);

    char *home = getenv("DOT_CACHE_HOME");
    char db_path[PATH_MAX];
    char cache_path[PATH_MAX];
    struct stat sb;

    db_path[0] = '\0';
    strcat(db_path, "/tmp");
    if (home) {
        strcat(db_path, "/");
        strcat(db_path, home);
    }

    //ignore this path in computation
    str t = strbuf() << db_path << "/.dot/";
    ignore_str->push_back(t);
        
    strcat(cache_path, db_path);
    strcat(cache_path, "/.dot/dcache");
    strcat(db_path, "/.dot/db");

    if (-1 == stat(db_path, &sb)) {
        // Does not exist
        warn("Unable to find %s, attempting to create\n", db_path);
        db_path[0] = '\0';
        strcat(db_path, "/tmp");
        if (home) {
            strcat(db_path, "/");
            strcat(db_path, home);
            mkdir(db_path, S_IRWXU);
        }
	strcat(db_path, "/.dot");
	mkdir(db_path, S_IRWXU);
        strcat(db_path, "/db");
        // Can ignore errors from this mkdir for now as the dir might
        // exist
        mkdir(db_path, S_IRWXU);
    }
    else if (!S_ISDIR(sb.st_mode)) {
        fatal("%s is not a directory\n", db_path);
    }
    
    (void)dbenv->set_data_dir(db_path);
    
    dbenv->open(db_path, 
		DB_CREATE | DB_INIT_MPOOL | DB_PRIVATE, 0);

    filesDb = new Db(dbenv, 0);
    filesDb->set_pagesize(32*1024);
    if (filesDb->set_flags(0|DB_DUP) < 0) {
	warn << "Error setting flags\n";
    }
    if (filesDb->open(NULL,
     		  "xdisklist.db",
		  NULL,
		  DB_HASH,
		  DB_CREATE,
		      0) < 0) {
	warn << "Error opening\n";
    }
}

//can't use BLOCK in the functions below since the get_descriptors 
// and the get_chunks calls in xferPlugin_gtc etc call back multiple times
// and TAME thinks that the function is overcalled.

# 850 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
class xferPlugin_xdisk__get_descriptors__closure_t : public closure_t { public:   xferPlugin_xdisk__get_descriptors__closure_t (xferPlugin_xdisk *_self,  ref< dot_oid_md > oid,  ref< vec< oid_hint > > hints,  descriptors_cb cb) : closure_t (false), _self (_self),  _stack (oid, hints, cb), _args (oid, hints, cb) {}   typedef void  (xferPlugin_xdisk::*method_type_t) ( ref< dot_oid_md > ,  ref< vec< oid_hint > > ,  descriptors_cb , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     default: panic ("unexpected case");     }   }   void reenter ()   {     ((*_self).*_method)  (_args.oid, _args.hints, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( ref< dot_oid_md > oid,  ref< vec< oid_hint > > hints,  descriptors_cb cb) {}   };   struct args_t {     args_t ( ref< dot_oid_md > oid,  ref< vec< oid_hint > > hints,  descriptors_cb cb) : oid (oid), hints (hints), cb (cb) {}      ref< dot_oid_md > oid;      ref< vec< oid_hint > > hints;      descriptors_cb cb;   };   xferPlugin_xdisk *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 850 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
void 
xferPlugin_xdisk::get_descriptors( ref< dot_oid_md > __tame_oid,  ref< vec< oid_hint > > __tame_hints,  descriptors_cb __tame_cb, ptr<closure_t> __cls_g)
{
# 852 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  xferPlugin_xdisk__get_descriptors__closure_t *__cls;   ptr<xferPlugin_xdisk__get_descriptors__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<xferPlugin_xdisk__get_descriptors__closure_t> (this, __tame_oid, __tame_hints, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&xferPlugin_xdisk::get_descriptors);   } else {     __cls =     reinterpret_cast<xferPlugin_xdisk__get_descriptors__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    ref< dot_oid_md > &oid = __cls->_args.oid;    ref< vec< oid_hint > > &hints = __cls->_args.hints;    descriptors_cb &cb = __cls->_args.cb;    use_reference (oid);     use_reference (hints);     use_reference (cb);    switch (__cls->jumpto ()) {   default:     break;   }
# 852 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

    //warnx << "xferPlugin_xdisk::get_descriptors: called\n";
    
    //check bdbcache
    {
	ptr<Dbt > d = New refcounted<Dbt >;

	str key = strbuf() << "INFO_OID_DESC:" << oid->id;
	if (!get_unique_from_cache(filesDb, key.cstr(), key.len(), d)) {
	    (*cb)("Not a cache hit", NULL, true);
	    
# 862 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
return ;
	}

	warnx << "xferPlugin_xdisk::get_descriptors: CACHEHIT\n";
	
	rpc_bytes<> value;
	value.set((char *)d->get_data(), d->get_size());
    
	oid_desc_bdb_info o;
	bytes2xdr(o, value);
	if (o.type != INFO_OID_DESC) {
	    (*cb)("Not a cache hit", NULL, true);
	    
# 874 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
return ;
	}

	ptr< vec<dot_descriptor> > descptr = New refcounted<vec<dot_descriptor> >;
	descptr->setsize(o.descriptors.size());
	for (unsigned int i = 0; i < o.descriptors.size(); i++) {
	    (*descptr)[i] = o.descriptors[i];
	}

	(*cb)(NULL, descptr, true);
	
# 884 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
return ;
    }
    
    (*cb)("Not a cache hit", NULL, true);
# 888 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  return;
# 888 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
}

# 890 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
class xferPlugin_xdisk__get_chunk__closure_t : public closure_t { public:   xferPlugin_xdisk__get_chunk__closure_t (xferPlugin_xdisk *_self,  ref< dot_descriptor > d,  ref< vec< oid_hint > > hints,  chunk_cb cb) : closure_t (false), _self (_self),  _stack (d, hints, cb), _args (d, hints, cb) {}   typedef void  (xferPlugin_xdisk::*method_type_t) ( ref< dot_descriptor > ,  ref< vec< oid_hint > > ,  chunk_cb , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     default: panic ("unexpected case");     }   }   void reenter ()   {     ((*_self).*_method)  (_args.d, _args.hints, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( ref< dot_descriptor > d,  ref< vec< oid_hint > > hints,  chunk_cb cb) {}   };   struct args_t {     args_t ( ref< dot_descriptor > d,  ref< vec< oid_hint > > hints,  chunk_cb cb) : d (d), hints (hints), cb (cb) {}      ref< dot_descriptor > d;      ref< vec< oid_hint > > hints;      chunk_cb cb;   };   xferPlugin_xdisk *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 890 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
void 
xferPlugin_xdisk::get_chunk( ref< dot_descriptor > __tame_d,  ref< vec< oid_hint > > __tame_hints,  chunk_cb __tame_cb, ptr<closure_t> __cls_g)
{
# 893 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  xferPlugin_xdisk__get_chunk__closure_t *__cls;   ptr<xferPlugin_xdisk__get_chunk__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<xferPlugin_xdisk__get_chunk__closure_t> (this, __tame_d, __tame_hints, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&xferPlugin_xdisk::get_chunk);   } else {     __cls =     reinterpret_cast<xferPlugin_xdisk__get_chunk__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    ref< dot_descriptor > &d = __cls->_args.d;    ref< vec< oid_hint > > &hints = __cls->_args.hints;    chunk_cb &cb = __cls->_args.cb;    use_reference (d);     use_reference (hints);     use_reference (cb);    switch (__cls->jumpto ()) {   default:     break;   }
# 893 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

    fatal << "xferPlugin_xdisk::get_chunk: called\n";
# 895 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  return;
# 895 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
}

# 897 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
class xferPlugin_xdisk__get_chunks__closure_t : public closure_t { public:   xferPlugin_xdisk__get_chunks__closure_t (xferPlugin_xdisk *_self,  ref< vec< dot_descriptor > > dv,  ref< hv_vec > hints,  chunk_cb cb) : closure_t (false), _self (_self),  _stack (dv, hints, cb), _args (dv, hints, cb) {}   typedef void  (xferPlugin_xdisk::*method_type_t) ( ref< vec< dot_descriptor > > ,  ref< hv_vec > ,  chunk_cb , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     default: panic ("unexpected case");     }   }   void reenter ()   {     ((*_self).*_method)  (_args.dv, _args.hints, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( ref< vec< dot_descriptor > > dv,  ref< hv_vec > hints,  chunk_cb cb) {}   };   struct args_t {     args_t ( ref< vec< dot_descriptor > > dv,  ref< hv_vec > hints,  chunk_cb cb) : dv (dv), hints (hints), cb (cb) {}      ref< vec< dot_descriptor > > dv;      ref< hv_vec > hints;      chunk_cb cb;   };   xferPlugin_xdisk *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 897 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
void 
xferPlugin_xdisk::get_chunks( ref< vec< dot_descriptor > > __tame_dv,  ref< hv_vec > __tame_hints,  chunk_cb __tame_cb, ptr<closure_t> __cls_g)
{
# 900 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  xferPlugin_xdisk__get_chunks__closure_t *__cls;   ptr<xferPlugin_xdisk__get_chunks__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<xferPlugin_xdisk__get_chunks__closure_t> (this, __tame_dv, __tame_hints, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&xferPlugin_xdisk::get_chunks);   } else {     __cls =     reinterpret_cast<xferPlugin_xdisk__get_chunks__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    ref< vec< dot_descriptor > > &dv = __cls->_args.dv;    ref< hv_vec > &hints = __cls->_args.hints;    chunk_cb &cb = __cls->_args.cb;    use_reference (dv);     use_reference (hints);     use_reference (cb);    switch (__cls->jumpto ()) {   default:     break;   }
# 900 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

    //warn << "xferPlugin_xdisk::get_chunks: called\n";
    
    hint_res res;
    if (parse_hint((*(*hints)[0])[0].name, "intern", &res) < 0) {
	warn << "xferPlugin_xdisk::get_chunks: Not internal hint\n";
	(*cb)("No hint", NULL);
    }
    
    pending_cb = cb;
    
    os_entry *ose = mat.op_store[res.hint2];
    ose->perform_op();
# 913 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  return;
# 913 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
}

void 
xferPlugin_xdisk::cancel_chunk(ref<dot_descriptor> d)
{
    warn << "xferPlugin_xdisk::cancel_chunk: called\n";
}

void 
xferPlugin_xdisk::cancel_chunks(ref< vec<dot_descriptor> > dv)
{
    warn << "xferPlugin_xdisk::cancel_chunks: called\n";
}

void 
xferPlugin_xdisk::get_default_hint(oid_hint *hint)
{
    fatal << "xferPlugin_xdisk::get_default_hint: called\n";
}

void 
xferPlugin_xdisk::notify_descriptors(ref<dot_oid_md> oid, ptr<vec<dot_descriptor> > descs)
{
    //warnx << "xferPlugin_xdisk::notify_descriptors: called\n";
}

void 
xferPlugin_xdisk::update_hints(ref< vec<dot_descriptor> > dv, ref<hv_vec > hints)
{
    warn << "xferPlugin_xdisk::update_hints: called\n";
}

# 945 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
class xferPlugin_xdisk__get_bitmap__closure_t : public closure_t { public:   xferPlugin_xdisk__get_bitmap__closure_t (xferPlugin_xdisk *_self,  ref< dot_oid_md > oid,  ref< vec< oid_hint > > hints,  bitmap_cb cb) : closure_t (false), _self (_self),  _stack (oid, hints, cb), _args (oid, hints, cb) {}   typedef void  (xferPlugin_xdisk::*method_type_t) ( ref< dot_oid_md > ,  ref< vec< oid_hint > > ,  bitmap_cb , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     default: panic ("unexpected case");     }   }   void reenter ()   {     ((*_self).*_method)  (_args.oid, _args.hints, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( ref< dot_oid_md > oid,  ref< vec< oid_hint > > hints,  bitmap_cb cb) {}   };   struct args_t {     args_t ( ref< dot_oid_md > oid,  ref< vec< oid_hint > > hints,  bitmap_cb cb) : oid (oid), hints (hints), cb (cb) {}      ref< dot_oid_md > oid;      ref< vec< oid_hint > > hints;      bitmap_cb cb;   };   xferPlugin_xdisk *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 945 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
void 
xferPlugin_xdisk::get_bitmap( ref< dot_oid_md > __tame_oid,  ref< vec< oid_hint > > __tame_hints,  bitmap_cb __tame_cb, ptr<closure_t> __cls_g)
{
# 947 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  xferPlugin_xdisk__get_bitmap__closure_t *__cls;   ptr<xferPlugin_xdisk__get_bitmap__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<xferPlugin_xdisk__get_bitmap__closure_t> (this, __tame_oid, __tame_hints, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&xferPlugin_xdisk::get_bitmap);   } else {     __cls =     reinterpret_cast<xferPlugin_xdisk__get_bitmap__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    ref< dot_oid_md > &oid = __cls->_args.oid;    ref< vec< oid_hint > > &hints = __cls->_args.hints;    bitmap_cb &cb = __cls->_args.cb;    use_reference (oid);     use_reference (hints);     use_reference (cb);    switch (__cls->jumpto ()) {   default:     break;   }
# 947 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

    warn << "xferPlugin_xdisk::get_bitmap: called\n";
# 949 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  return;
# 949 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
}

/***************optimizer interface*****************/
void
xferPlugin_xdisk::extract_stat_ops(str path)
{
    //warnx << "xferPlugin_xdisk::extract_stat_ops: Extracting " << path << "\n";
    char *ref = (char *) path.cstr();
    char *ptr = ref;
    ptr = strstr(ptr, NEW_ROOT);
    bool nrt = false;

    if (ptr == ref) {
	//warnx << "Path " << path << " starts with " << NEW_ROOT << "\n";
	nrt = true;
	ref = ref + NEW_ROOT.len() - 1;
	ptr = ref;
    }
    
    while (1) {
	ptr = strstr(ptr, "/");
	if (!ptr) break;
	str p = str(ref, (ptr - ref + 1));
	ptr++;

	struct item_info i;
	stat(p, &(i.s));
	i.name = "";

	if (nrt) 
	    p = strbuf() << NEW_ROOT << p;
	
	//clean the path
	str newname = "";
	char *ptr1 = strdup(p);
	bool lastsl = false;
	if (*ptr1 == '/')
	    newname = strbuf() << "/";
	if (*(ptr1+p.len()-1) == '/')
	    lastsl = true;

	char *line, *brkt;
    	//1. remove two consec slashes
	for (line = strtok_r(ptr1, "/", &brkt);  
         line; line = strtok_r(NULL, "/", &brkt)) {
	    str a(line, strlen(line));
	    if (newname == "/" || newname == "")
		newname = strbuf() << newname << a;
	    else
		newname = strbuf() << newname << "/" << a ;
	}

	if (lastsl) 
	    newname = strbuf() << newname << "/";
	if (newname == "//")
	    newname = "/";

	free(ptr1);
	
	create_statop(newname, i, this);
    }
}

void
extract_ignore_str(str ignore)
{
    for (unsigned int i = 0; i < ignore_str->size(); i++) {
	if ((*ignore_str)[i] == ignore)
	    return;
    }

    ignore_str->push_back(ignore);
}

void
xferPlugin_xdisk::extract_chit_ops(ref< vec<dot_descriptor> > dv)
{
    //warnx << "xferPlugin_xdisk::extract_chit_ops: called\n";
    
    for (unsigned int i = 0; i < dv->size(); i++) {
	ptr <Dbt> d = New refcounted<Dbt >;
	str key = strbuf() << "INFO_CID:" << (*dv)[i].id;
	if (!get_unique_from_cache(filesDb, key.cstr(),
				   key.len(), d)) 
	    continue;
	
	//warnx << "xferPlugin_xdisk::extract_chit_ops cache hit :) "
	//    << (*dv)[i].id << "\n";
	
	ptr<vec<struct offset_info > > oi = New refcounted<vec<struct offset_info > >;
	cid_bdb_info c;
	rpc_bytes<> value;
	value.set((char *)d->get_data(), d->get_size());
	bytes2xdr(c, value);
	if (c.type != INFO_CID)
	    continue;
	    
	oi->push_back(c.info);
       
	if ((*dv)[i].id != c.desc.id)
	    fatal << "Something wrong here!!\n";
	
	create_chitop((*dv)[i].id, oi, c.desc.length, this);
    }
}

void
xferPlugin_xdisk::extract_chit_op(dot_descriptor dv, bool *ret)
{
    //dwarn(DEBUG_OPT) << "xferPlugin_xdisk::extract_chit_ops: called\n";

    ptr <Dbt> d = New refcounted<Dbt >;
    str key = strbuf() << "INFO_CID:" << dv.id;
    
    if (!get_unique_from_cache(filesDb, key.cstr(), key.len(), d)) {
	*ret = false;
	return;
    }
    
    dwarn(DEBUG_OPT) << "xferPlugin_xdisk::extract_chit_ops cache hit :) "
		      << dv.id << "\n";
    
    ptr<vec<struct offset_info > > oi = New refcounted<vec<struct offset_info > >;
    cid_bdb_info c;
    rpc_bytes<> value;
    value.set((char *)d->get_data(), d->get_size());
    bytes2xdr(c, value);
    
    if (c.type != INFO_CID) {
	dwarn(DEBUG_OPT) << "Info is " << c.type << " " << INFO_CID << "\n";
	*ret = false;
	return;
    }
	
    dwarn(DEBUG_OPT) << "Info is " << c.info.path << " and " <<
	c.info.offset << "\n";
    
    oi->push_back(c.info);
    
    if (oi->size() <= 0) {
	dwarn(DEBUG_OPT) << "No info although HIT\n";
	*ret = false;
	return;
    }
    
    if (dv.id != c.desc.id)
	fatal << "Something wrong here!!\n";
    
    create_chitop(dv.id, oi, c.desc.length, this);
    *ret = true;
    return;
}


void
xferPlugin_xdisk::update_table(str key, ptr<vec<dot_descriptor > > dv)
{
    //warnx << debug_sep << "xferPlugin_xdisk::update_table called\n";

    if (key) {
	ht_entry *hte = mat.hint_store[key];
	if (!hte)
	    fatal << "What happened to hints\n";
	
	/* 1. extract
	   disk hints from unique hint object to insert new operations */
	unsigned int hsize =  hte->oidhint->size();
	for (unsigned int j = 0; j < hsize; j++) {
	    hint_res res;
	    if (parse_hint((*(hte->oidhint))[j].name, "xdisk", &res) < 0) {
		//warnx << "xferPlugin_xdisk::update_table: " << i << ":"
		//    << j << " Not xdisk hint\n";
		continue;
	    }
	    hte->hints->push_back(res.hint1);
	    
	    /*extract ignore_strings*/
	    extract_ignore_str(res.hint1.ignore_str);
	    if (res.hint1.ignore_path != "NONE")
		extract_ignore_str(res.hint1.ignore_path);
	}
	
	for (unsigned int j = 0; j < hsize; j++) {
	    hint_res res;
	    if (parse_hint((*(hte->oidhint))[j].name, "xdisk", &res) < 0) {
		//warnx << "xferPlugin_xdisk::update_table: " << i << ":"
		//   << j << " Not xdisk hint\n";
		continue;
	    }
	    /*extract target directory and its various levels
	      to make stat ops out of it*/
	    extract_stat_ops(res.hint1.target_dir);
	}
    }

    if (dv)
	extract_chit_ops(dv);
    //warnx << debug_sep;
}


# 1150 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
class xferPlugin_xdisk__perform_offset_read__closure_t : public closure_t { public:   xferPlugin_xdisk__perform_offset_read__closure_t (xferPlugin_xdisk *_self,  str path,  int offset,  int len,  cbs cb) : closure_t (false), _self (_self),  _stack (path, offset, len, cb), _args (path, offset, len, cb), _block1 (0), _block2 (0), _block3 (0), _block4 (0), _cb_num_calls1 (0), _cb_num_calls2 (0), _cb_num_calls3 (0), _cb_num_calls4 (0) {}   typedef void  (xferPlugin_xdisk::*method_type_t) ( str ,  int ,  int ,  cbs , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     case 1: cb1(); break;     case 2: cb2(); break;     case 3: cb3(); break;     case 4: cb4(); break;     default: panic ("unexpected case");     }   }   void cb1 () {     if (-- _cb_num_calls1 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T:1173: in function xferPlugin_xdisk::get_bitmap", "callback overcalled!");     }     if (!--_block1)       delaycb (0, 0, wrap (mkref (this), &xferPlugin_xdisk__perform_offset_read__closure_t::reenter));   }   void cb2 () {     if (-- _cb_num_calls2 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T:1184: in function xferPlugin_xdisk::get_bitmap", "callback overcalled!");     }     if (!--_block2)       delaycb (0, 0, wrap (mkref (this), &xferPlugin_xdisk__perform_offset_read__closure_t::reenter));   }   void cb3 () {     if (-- _cb_num_calls3 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T:1202: in function xferPlugin_xdisk::get_bitmap", "callback overcalled!");     }     if (!--_block3)       delaycb (0, 0, wrap (mkref (this), &xferPlugin_xdisk__perform_offset_read__closure_t::reenter));   }   void cb4 () {     if (-- _cb_num_calls4 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T:1212: in function xferPlugin_xdisk::get_bitmap", "callback overcalled!");     }     if (!--_block4)       delaycb (0, 0, wrap (mkref (this), &xferPlugin_xdisk__perform_offset_read__closure_t::reenter));   }   void reenter ()   {     ((*_self).*_method)  (_args.path, _args.offset, _args.len, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( str path,  int offset,  int len,  cbs cb) {}      str err;      bool async;      ptr< ioh > handle;      ptr< suio > new_one;      int remain;      int ret;      ptr< desc_result > res;      ptr< dot_descriptor > new_dd;   };   struct args_t {     args_t ( str path,  int offset,  int len,  cbs cb) : path (path), offset (offset), len (len), cb (cb) {}      str path;      int offset;      int len;      cbs cb;   };   xferPlugin_xdisk *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   int _block1;   int _block2;   int _block3;   int _block4;   int _cb_num_calls1;   int _cb_num_calls2;   int _cb_num_calls3;   int _cb_num_calls4;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 1150 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
void 
xferPlugin_xdisk::perform_offset_read( str __tame_path,  int __tame_offset,  int __tame_len,  cbs __tame_cb, ptr<closure_t> __cls_g)
{
    
# 1153 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  xferPlugin_xdisk__perform_offset_read__closure_t *__cls;   ptr<xferPlugin_xdisk__perform_offset_read__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<xferPlugin_xdisk__perform_offset_read__closure_t> (this, __tame_path, __tame_offset, __tame_len, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&xferPlugin_xdisk::perform_offset_read);   } else {     __cls =     reinterpret_cast<xferPlugin_xdisk__perform_offset_read__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    str &err = __cls->_stack.err;    bool &async = __cls->_stack.async;    ptr< ioh > &handle = __cls->_stack.handle;    ptr< suio > &new_one = __cls->_stack.new_one;    int &remain = __cls->_stack.remain;    int &ret = __cls->_stack.ret;    ptr< desc_result > &res = __cls->_stack.res;    ptr< dot_descriptor > &new_dd = __cls->_stack.new_dd;    str &path = __cls->_args.path;    int &offset = __cls->_args.offset;    int &len = __cls->_args.len;    cbs &cb = __cls->_args.cb;    use_reference (path);     use_reference (offset);     use_reference (len);     use_reference (cb);    switch (__cls->jumpto ()) {   case 1:     goto xferPlugin_xdisk__perform_offset_read__label_1;     break;   case 2:     goto xferPlugin_xdisk__perform_offset_read__label_2;     break;   case 3:     goto xferPlugin_xdisk__perform_offset_read__label_3;     break;   case 4:     goto xferPlugin_xdisk__perform_offset_read__label_4;     break;   default:     break;   }
# 1162 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"


    async = true;
    //async = false;

    if (async)
	handle = New refcounted<aioh >(aiod_ptr);
    else
	handle = New refcounted<sioh >;

    
# 1172 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  do {     __cls->_block1 = 1;     __cls->set_jumpto (1); 
# 1172 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

	handle->open(path, O_RDONLY, (++__cls->_block1, ++__cls->_cb_num_calls1, wrap (__block_cb1<TTT(err)>, __cls_r, 1, pointer_set1_t<TTT(err)> (&(err)))));
    
# 1174 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
    if (--__cls->_block1)       return;   } while (0);  xferPlugin_xdisk__perform_offset_read__label_1:     ;
# 1174 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"


    dwarn(DEBUG_OPT) << "Performing offset open " << path << "\n";
    
    if (err) {
	(*cb)(err);
	
# 1180 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
return ;
    }
    
    
# 1183 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  do {     __cls->_block2 = 1;     __cls->set_jumpto (2); 
# 1183 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

	handle->seek(offset, (++__cls->_block2, ++__cls->_cb_num_calls2, wrap (__block_cb1<TTT(err)>, __cls_r, 2, pointer_set1_t<TTT(err)> (&(err)))));
    
# 1185 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
    if (--__cls->_block2)       return;   } while (0);  xferPlugin_xdisk__perform_offset_read__label_2:     ;
# 1185 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"


    dwarn(DEBUG_OPT) << "Performing offset seek\n";

    if (err) {
	(*cb)(err);
	
# 1191 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
return ;
    }
    
    dwarn(DEBUG_OPT) << "xferPlugin_xdisk::perform_offset_read: asking to read " << path 
                      << " " << offset << "\n";

    new_one = New refcounted<suio>;
    remain = len;
    while (1) {
	
	
# 1201 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  do {     __cls->_block3 = 1;     __cls->set_jumpto (3); 
# 1201 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

	    handle->read(new_one, remain, (++__cls->_block3, ++__cls->_cb_num_calls3, wrap (__block_cb1<TTT(ret)>, __cls_r, 3, pointer_set1_t<TTT(ret)> (&(ret)))));
	
# 1203 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
    if (--__cls->_block3)       return;   } while (0);  xferPlugin_xdisk__perform_offset_read__label_3:     ;
# 1203 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

	
	if (ret == remain || ret < 0)
            break;
        else
            remain = remain - ret;
    } 

    
# 1211 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  do {     __cls->_block4 = 1;     __cls->set_jumpto (4); 
# 1211 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

	 handle->close((++__cls->_block4, ++__cls->_cb_num_calls4, wrap (__block_cb1<TTT(err)>, __cls_r, 4, pointer_set1_t<TTT(err)> (&(err)))));
     
# 1213 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
    if (--__cls->_block4)       return;   } while (0);  xferPlugin_xdisk__perform_offset_read__label_4:     ;
# 1213 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"



    dwarn(DEBUG_OPT) << "Performing offset finished read\n";
    
    if (err) {
	(*cb)(err);
	
# 1220 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
return ;
    }
    
    //check for hash
    unsigned char digest[EVP_MAX_MD_SIZE];
    EVP_MD_CTX desc_hash;
    unsigned int diglen;

    EVP_MD_CTX_init(&desc_hash);
    EVP_DigestInit(&desc_hash, EVP_sha1());

    for (const iovec *i = new_one->iov(); i < new_one->iovlim(); i++) {
	EVP_DigestUpdate(&desc_hash, i->iov_base, i->iov_len);
    }

    EVP_DigestFinal(&desc_hash, digest, &diglen);
    dot_desc chunkname;
    chunkname.set((char *)digest, diglen);
    
    res = NULL;

    ds_entry *dse = mat.desc_store[chunkname];
    if (dse) { // && dse->status != DELETED) {
	dwarn(DEBUG_OPT) << "Got a hit ....prepare to transfer "
			 << chunkname << "\n";
	//would like to send the original descriptor came to us
	new_dd = New refcounted<dot_descriptor>(dse->dd);
	res = New refcounted<desc_result> (new_dd, new_one, false);
    }

    if (res){
	(*pending_cb)(NULL, res);
	(*cb)(NULL);
    }
    else {
	warnx << "***Wasted caching " << chunkname << "\n";
        (*cb)("Hash didnt match");
    }
# 1258 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  return;
# 1258 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
}

# 1260 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
class xferPlugin_xdisk__perform_hash__closure_t : public closure_t { public:   xferPlugin_xdisk__perform_hash__closure_t (xferPlugin_xdisk *_self,  str path,  cbs cb) : closure_t (false), _self (_self),  _stack (path, cb), _args (path, cb), _block1 (0), _cb_num_calls1 (0), _cb_num_calls2 (0) {}   typedef void  (xferPlugin_xdisk::*method_type_t) ( str ,  cbs , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     case 1: cb1(); break;     case 2: cb2(); break;     default: panic ("unexpected case");     }   }   void cb1 () {     if (-- _cb_num_calls1 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T:1271: in function xferPlugin_xdisk::perform_offset_read", "callback overcalled!");     }     if (!--_block1)       delaycb (0, 0, wrap (mkref (this), &xferPlugin_xdisk__perform_hash__closure_t::reenter));   }   void cb2 () {     if (-- _cb_num_calls2 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T:1272: in function xferPlugin_xdisk::perform_offset_read", "callback overcalled!");     }     if (!--_block1)       delaycb (0, 0, wrap (mkref (this), &xferPlugin_xdisk__perform_hash__closure_t::reenter));   }   void reenter ()   {     ((*_self).*_method)  (_args.path, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( str path,  cbs cb) {}      str err;      ptr< dot_oid_md > oid;   };   struct args_t {     args_t ( str path,  cbs cb) : path (path), cb (cb) {}      str path;      cbs cb;   };   xferPlugin_xdisk *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   int _block1;   int _cb_num_calls1;   int _cb_num_calls2;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 1260 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
void 
xferPlugin_xdisk::perform_hash( str __tame_path,  cbs __tame_cb, ptr<closure_t> __cls_g)
{
    
# 1263 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  xferPlugin_xdisk__perform_hash__closure_t *__cls;   ptr<xferPlugin_xdisk__perform_hash__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<xferPlugin_xdisk__perform_hash__closure_t> (this, __tame_path, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&xferPlugin_xdisk::perform_hash);   } else {     __cls =     reinterpret_cast<xferPlugin_xdisk__perform_hash__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    str &err = __cls->_stack.err;    ptr< dot_oid_md > &oid = __cls->_stack.oid;    str &path = __cls->_args.path;    cbs &cb = __cls->_args.cb;    use_reference (path);     use_reference (cb);    switch (__cls->jumpto ()) {   case 1:     goto xferPlugin_xdisk__perform_hash__label_1;     break;   default:     break;   }
# 1266 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"


    //warn << "Performing chunking of " << path <<"\n";

    
# 1270 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  do {     __cls->_block1 = 1;     __cls->set_jumpto (1); 
# 1270 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

	//get_hash(path, false, (++__cls->_block1, ++__cls->_cb_num_calls1, wrap (__block_cb2<TTT(err), TTT( oid)>, __cls_r, 1, pointer_set2_t<TTT(err), TTT( oid)> (&(err), &( oid)))));
	get_hash(path, true, (++__cls->_block1, ++__cls->_cb_num_calls2, wrap (__block_cb2<TTT(err), TTT( oid)>, __cls_r, 2, pointer_set2_t<TTT(err), TTT( oid)> (&(err), &( oid)))));
    
# 1273 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
    if (--__cls->_block1)       return;   } while (0);  xferPlugin_xdisk__perform_hash__label_1:     ;
# 1273 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"


    if (err) {
	(*cb)(err);
	
# 1277 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
return ;
    }
    
    //cache oid->info mapping
    //dont want it
    if (0) {
	rpc_bytes<> value;
	oid_bdb_info o;
	o.type = INFO_OID;
	o.oid = *(oid);
	o.info.path = path;
	o.info.fd = -1;
	o.info.offset = -1;
	xdr2bytes(value, o);
	dwarn(DEBUG_OPT) << "Putting oid info\n";
	put_in_cache(filesDb, oid->id.base(), oid->id.size(),
		     value.base(), value.size(), false);
    }
    
    (*cb)(NULL);
# 1297 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  return;
# 1297 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
}

# 1299 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
class xferPlugin_xdisk__get_hash__closure_t : public closure_t { public:   xferPlugin_xdisk__get_hash__closure_t (xferPlugin_xdisk *_self,  str path,  bool async,  commit_cb cb) : closure_t (false), _self (_self),  _stack (path, async, cb), _args (path, async, cb), _block1 (0), _block2 (0), _block3 (0), _cb_num_calls1 (0), _cb_num_calls2 (0), _cb_num_calls3 (0) {}   typedef void  (xferPlugin_xdisk::*method_type_t) ( str ,  bool ,  commit_cb , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     case 1: cb1(); break;     case 2: cb2(); break;     case 3: cb3(); break;     default: panic ("unexpected case");     }   }   void cb1 () {     if (-- _cb_num_calls1 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T:1318: in function xferPlugin_xdisk::perform_hash", "callback overcalled!");     }     if (!--_block1)       delaycb (0, 0, wrap (mkref (this), &xferPlugin_xdisk__get_hash__closure_t::reenter));   }   void cb2 () {     if (-- _cb_num_calls2 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T:1343: in function xferPlugin_xdisk::perform_hash", "callback overcalled!");     }     if (!--_block2)       delaycb (0, 0, wrap (mkref (this), &xferPlugin_xdisk__get_hash__closure_t::reenter));   }   void cb3 () {     if (-- _cb_num_calls3 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T:1353: in function xferPlugin_xdisk::perform_hash", "callback overcalled!");     }     if (!--_block3)       delaycb (0, 0, wrap (mkref (this), &xferPlugin_xdisk__get_hash__closure_t::reenter));   }   void reenter ()   {     ((*_self).*_method)  (_args.path, _args.async, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( str path,  bool async,  commit_cb cb) {}      ptr< ioh > handle;      ptr< vec< ptr< suio > > > io_in;      ptr< suio > new_one;      int rc;      str err;      ptr< metadata_entry > mde;   };   struct args_t {     args_t ( str path,  bool async,  commit_cb cb) : path (path), async (async), cb (cb) {}      str path;      bool async;      commit_cb cb;   };   xferPlugin_xdisk *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   int _block1;   int _block2;   int _block3;   int _cb_num_calls1;   int _cb_num_calls2;   int _cb_num_calls3;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 1299 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
void 
xferPlugin_xdisk::get_hash( str __tame_path,  bool __tame_async,  commit_cb __tame_cb, ptr<closure_t> __cls_g)
{
    
# 1302 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  xferPlugin_xdisk__get_hash__closure_t *__cls;   ptr<xferPlugin_xdisk__get_hash__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<xferPlugin_xdisk__get_hash__closure_t> (this, __tame_path, __tame_async, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&xferPlugin_xdisk::get_hash);   } else {     __cls =     reinterpret_cast<xferPlugin_xdisk__get_hash__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    ptr< ioh > &handle = __cls->_stack.handle;    ptr< vec< ptr< suio > > > &io_in = __cls->_stack.io_in;    ptr< suio > &new_one = __cls->_stack.new_one;    int &rc = __cls->_stack.rc;    str &err = __cls->_stack.err;    ptr< metadata_entry > &mde = __cls->_stack.mde;    str &path = __cls->_args.path;    bool &async = __cls->_args.async;    commit_cb &cb = __cls->_args.cb;    use_reference (path);     use_reference (async);     use_reference (cb);    switch (__cls->jumpto ()) {   case 1:     goto xferPlugin_xdisk__get_hash__label_1;     break;   case 2:     goto xferPlugin_xdisk__get_hash__label_2;     break;   case 3:     goto xferPlugin_xdisk__get_hash__label_3;     break;   default:     break;   }
# 1310 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

    
    if (async)
	handle = New refcounted<aioh >(aiod_ptr);
    else
	handle = New refcounted<sioh >;

    
# 1317 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  do {     __cls->_block1 = 1;     __cls->set_jumpto (1); 
# 1317 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

	handle->open(path, O_RDONLY, (++__cls->_block1, ++__cls->_cb_num_calls1, wrap (__block_cb1<TTT(err)>, __cls_r, 1, pointer_set1_t<TTT(err)> (&(err)))));
    
# 1319 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
    if (--__cls->_block1)       return;   } while (0);  xferPlugin_xdisk__get_hash__label_1:     ;
# 1319 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"


    if (err) {
	(*cb)(err, NULL);
	
# 1323 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
return ;
    }

    mde = New refcounted<metadata_entry>;
    mde->module = "LOCAL";
    mde->key = strbuf() << path << ":-1";
        
    cp->init(&handle->sid, mde);
    //buffer between producer and consumer
    io_in = New refcounted<vec<ptr<suio> > >; 

    //warnx << "xferPlugin_xdisk::get_hash: file opened\n";
    
    while (1) {

	new_one = New refcounted<suio>;

	//warnx << "xferPlugin_xdisk::get_hash: asking to read\n";
	
	
# 1342 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  do {     __cls->_block2 = 1;     __cls->set_jumpto (2); 
# 1342 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

	    handle->read(new_one, AIOD_READ_SIZE, (++__cls->_block2, ++__cls->_cb_num_calls2, wrap (__block_cb1<TTT(rc)>, __cls_r, 2, pointer_set1_t<TTT(rc)> (&(rc)))));
	
# 1344 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
    if (--__cls->_block2)       return;   } while (0);  xferPlugin_xdisk__get_hash__label_2:     ;
# 1344 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

	
	if (rc == -1) {
	    str s = strbuf() << "Could not read from input file descriptor\n";
	    (*cb)(s, NULL);
	    
# 1349 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
return ;
	}
	else if (rc == 0) {
	    
# 1352 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  do {     __cls->_block3 = 1;     __cls->set_jumpto (3); 
# 1352 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

		handle->close((++__cls->_block3, ++__cls->_cb_num_calls3, wrap (__block_cb1<TTT(err)>, __cls_r, 3, pointer_set1_t<TTT(err)> (&(err)))));
	    
# 1354 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
    if (--__cls->_block3)       return;   } while (0);  xferPlugin_xdisk__get_hash__label_3:     ;
# 1354 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

	    //warnx << "xferPlugin_xdisk::get_hash: done reading\n";
	    get_hash_done(handle, cb);
	    
# 1357 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
return ;
	}
	else {
	    //warnx << "xferPlugin_xdisk::get_hash: reading new chunk\n";
	    if (io_in->size() <= 0) { //signal the consumer
		io_in->push_back(new_one);
		signal_chunker(handle, io_in, cb);
	    }
	    else
		io_in->push_back(new_one);
	}
    }
# 1369 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  return;
# 1369 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
}

void
xferPlugin_xdisk::signal_chunker(ptr<ioh > handle, ptr<vec<ptr<suio> > > io_in, commit_cb cb)
{
    //warnx << "xferPlugin_xdisk::signal_chunker: signaling chunker\n";
    delaycb(0, 0, wrap(this, &xferPlugin_xdisk::perform_chunk, handle, io_in, cb));
}

//not TAMED because delaycb above cant wrap a TAMED function
void
xferPlugin_xdisk::perform_chunk(ptr<ioh > handle, ptr<vec<ptr<suio> > > io_in, commit_cb cb)
{
    char inbuf[AIOD_READ_SIZE];
    ptr<suio> new_one = (*io_in)[0];
    int nbytes = new_one->resid();
    int rc;

    //warnx << "xferPlugin_xdisk::perform_chunk: chunking\n";
    rc = new_one->copyout(inbuf, nbytes);
    assert(rc == nbytes);
    new_one->rembytes(rc);
    handle->pending++;
    cp->put_object(handle->sid, inbuf, nbytes,
		   wrap(this, &xferPlugin_xdisk::perform_chunk_cb, handle, io_in, cb));
}

void
xferPlugin_xdisk::perform_chunk_cb(ptr<ioh > handle, ptr<vec<ptr<suio> > > io_in,
				   commit_cb cb, str s)
{
    if (s) {
	warn << "Message from put_chunk is " << s << " \n";
	return;
    }

    //warnx << "xferPlugin_xdisk::perform_chunk_cb: chunked\n";
    
    io_in->pop_front();
    handle->pending--;
    
    if (io_in->size() <= 0) 
	get_hash_done(handle, cb);
    else
	perform_chunk(handle, io_in, cb);
}

# 1416 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
class xferPlugin_xdisk__get_hash_done__closure_t : public closure_t { public:   xferPlugin_xdisk__get_hash_done__closure_t (xferPlugin_xdisk *_self,  ptr< ioh > handle,  commit_cb cb) : closure_t (false), _self (_self),  _stack (handle, cb), _args (handle, cb), _block1 (0), _cb_num_calls1 (0) {}   typedef void  (xferPlugin_xdisk::*method_type_t) ( ptr< ioh > ,  commit_cb , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     case 1: cb1(); break;     default: panic ("unexpected case");     }   }   void cb1 () {     if (-- _cb_num_calls1 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T:1429: in function xferPlugin_xdisk::get_hash", "callback overcalled!");     }     if (!--_block1)       delaycb (0, 0, wrap (mkref (this), &xferPlugin_xdisk__get_hash_done__closure_t::reenter));   }   void reenter ()   {     ((*_self).*_method)  (_args.handle, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( ptr< ioh > handle,  commit_cb cb) {}      str s;      ptr< dot_oid_md > oid;   };   struct args_t {     args_t ( ptr< ioh > handle,  commit_cb cb) : handle (handle), cb (cb) {}      ptr< ioh > handle;      commit_cb cb;   };   xferPlugin_xdisk *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   int _block1;   int _cb_num_calls1;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 1416 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
void 
xferPlugin_xdisk::get_hash_done( ptr< ioh > __tame_handle,  commit_cb __tame_cb, ptr<closure_t> __cls_g)
{
    
# 1419 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  xferPlugin_xdisk__get_hash_done__closure_t *__cls;   ptr<xferPlugin_xdisk__get_hash_done__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<xferPlugin_xdisk__get_hash_done__closure_t> (this, __tame_handle, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&xferPlugin_xdisk::get_hash_done);   } else {     __cls =     reinterpret_cast<xferPlugin_xdisk__get_hash_done__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    str &s = __cls->_stack.s;    ptr< dot_oid_md > &oid = __cls->_stack.oid;    ptr< ioh > &handle = __cls->_args.handle;    commit_cb &cb = __cls->_args.cb;    use_reference (handle);     use_reference (cb);    switch (__cls->jumpto ()) {   case 1:     goto xferPlugin_xdisk__get_hash_done__label_1;     break;   default:     break;   }
# 1422 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

    
    if (handle->fd == -1 && handle->pending <= 0) {

	//warnx << "xferPlugin_xdisk::get_hash_done: to commit\n";
	
	
# 1428 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  do {     __cls->_block1 = 1;     __cls->set_jumpto (1); 
# 1428 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

	    cp->commit_object(handle->sid, (++__cls->_block1, ++__cls->_cb_num_calls1, wrap (__block_cb2<TTT(s), TTT( oid)>, __cls_r, 1, pointer_set2_t<TTT(s), TTT( oid)> (&(s), &( oid)))));
	
# 1430 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
    if (--__cls->_block1)       return;   } while (0);  xferPlugin_xdisk__get_hash_done__label_1:     ;
# 1430 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

	    
	if (s) {
	    warn << "Error in put_commit - " << s << "\n";
	    (*cb)(s, NULL);
	    
# 1435 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
return ;
	} 
	
	//warn << "Plugin says that the oid is " << oid->id << "\n";
	//for (size_t i = 0; i < oid->md.list.size(); i++)
	//  warn << "  " << oid->md.list[i].module << "."
	// << oid->md.list[i].key << " = "
	// << oid->md.list[i].val << "\n";
	
	(*cb)(NULL, oid);
    }
# 1446 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  return;
# 1446 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
}

# 1448 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
class xferPlugin_xdisk__perform_stat__closure_t : public closure_t { public:   xferPlugin_xdisk__perform_stat__closure_t (xferPlugin_xdisk *_self,  str path,  ptr< vec< struct item_info > > stats,  cbs cb) : closure_t (false), _self (_self),  _stack (path, stats, cb), _args (path, stats, cb), _block1 (0), _block2 (0), _cb_num_calls1 (0), _cb_num_calls2 (0), _cb_num_calls3 (0) {}   typedef void  (xferPlugin_xdisk::*method_type_t) ( str ,  ptr< vec< struct item_info > > ,  cbs , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     case 1: cb1(); break;     case 2: cb2(); break;     case 3: cb3(); break;     default: panic ("unexpected case");     }   }   void cb1 () {     if (-- _cb_num_calls1 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T:1460: in function xferPlugin_xdisk::get_hash_done", "callback overcalled!");     }     if (!--_block1)       delaycb (0, 0, wrap (mkref (this), &xferPlugin_xdisk__perform_stat__closure_t::reenter));   }   void cb2 () {     if (-- _cb_num_calls2 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T:1461: in function xferPlugin_xdisk::get_hash_done", "callback overcalled!");     }     if (!--_block1)       delaycb (0, 0, wrap (mkref (this), &xferPlugin_xdisk__perform_stat__closure_t::reenter));   }   void cb3 () {     if (-- _cb_num_calls3 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T:1481: in function xferPlugin_xdisk::get_hash_done", "callback overcalled!");     }     if (!--_block2)       delaycb (0, 0, wrap (mkref (this), &xferPlugin_xdisk__perform_stat__closure_t::reenter));   }   void reenter ()   {     ((*_self).*_method)  (_args.path, _args.stats, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( str path,  ptr< vec< struct item_info > > stats,  cbs cb) {}      str err;      ptr< vec< str > > entries;   };   struct args_t {     args_t ( str path,  ptr< vec< struct item_info > > stats,  cbs cb) : path (path), stats (stats), cb (cb) {}      str path;      ptr< vec< struct item_info > > stats;      cbs cb;   };   xferPlugin_xdisk *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   int _block1;   int _block2;   int _cb_num_calls1;   int _cb_num_calls2;   int _cb_num_calls3;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 1448 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
void 
xferPlugin_xdisk::perform_stat( str __tame_path,  ptr< vec< struct item_info > > __tame_stats,  cbs __tame_cb, ptr<closure_t> __cls_g)
{
    
# 1451 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  xferPlugin_xdisk__perform_stat__closure_t *__cls;   ptr<xferPlugin_xdisk__perform_stat__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<xferPlugin_xdisk__perform_stat__closure_t> (this, __tame_path, __tame_stats, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&xferPlugin_xdisk::perform_stat);   } else {     __cls =     reinterpret_cast<xferPlugin_xdisk__perform_stat__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    str &err = __cls->_stack.err;    ptr< vec< str > > &entries = __cls->_stack.entries;    str &path = __cls->_args.path;    ptr< vec< struct item_info > > &stats = __cls->_args.stats;    cbs &cb = __cls->_args.cb;    use_reference (path);     use_reference (stats);     use_reference (cb);    switch (__cls->jumpto ()) {   case 1:     goto xferPlugin_xdisk__perform_stat__label_1;     break;   case 2:     goto xferPlugin_xdisk__perform_stat__label_2;     break;   default:     break;   }
# 1454 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"


    //warnx << "perform_stat called\n";
    
    entries = New refcounted<vec<str> >;
    
# 1459 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  do {     __cls->_block1 = 1;     __cls->set_jumpto (1); 
# 1459 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

        //get_list(path, entries, false, (++__cls->_block1, ++__cls->_cb_num_calls1, wrap (__block_cb1<TTT(err)>, __cls_r, 1, pointer_set1_t<TTT(err)> (&(err)))));
	get_list(path, entries, true, (++__cls->_block1, ++__cls->_cb_num_calls2, wrap (__block_cb1<TTT(err)>, __cls_r, 2, pointer_set1_t<TTT(err)> (&(err)))));
    
# 1462 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
    if (--__cls->_block1)       return;   } while (0);  xferPlugin_xdisk__perform_stat__label_1:     ;
# 1462 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"


    if (err) {
	(*cb)(err);
	
# 1466 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
return ;
    }
    
    //warnx << "get_list came back\n";
    //for (unsigned int i = 0; i < entries->size(); i++) {
    //warnx << (*entries)[i] << "\n";
    //}

    for (unsigned int i = 0; i < entries->size(); i++) {
	struct item_info item;
	item.name = (*entries)[i];
	stats->push_back(item);
    }
    
    
# 1480 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  do {     __cls->_block2 = 1;     __cls->set_jumpto (2); 
# 1480 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

	get_stats(path, stats, true, (++__cls->_block2, ++__cls->_cb_num_calls3, wrap (__block_cb1<TTT(err)>, __cls_r, 3, pointer_set1_t<TTT(err)> (&(err)))));
    
# 1482 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
    if (--__cls->_block2)       return;   } while (0);  xferPlugin_xdisk__perform_stat__label_2:     ;
# 1482 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"


    if (err) {
	(*cb)(err);
	
# 1486 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
return ;
    }
    //warnx << "get_stats came back for " << path << "\n";
    //cache the list in a cache
    //for (unsigned int i = 0; i < stats->size(); i++) {
    //	warnx << (*stats)[i].name << " " << (*stats)[i].s.st_size << "\n";
    //}

    //return
    if (err)
        (*cb)(err);
    else
        (*cb)(NULL);
# 1499 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  return;
# 1499 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
}

# 1501 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
class xferPlugin_xdisk__get_list__closure_t : public closure_t { public:   xferPlugin_xdisk__get_list__closure_t (xferPlugin_xdisk *_self,  str path,  ptr< vec< str > > res,  bool async,  cbs cb) : closure_t (false), _self (_self),  _stack (path, res, async, cb), _args (path, res, async, cb), _block1 (0), _block2 (0), _block3 (0), _cb_num_calls1 (0), _cb_num_calls2 (0), _cb_num_calls3 (0) {}   typedef void  (xferPlugin_xdisk::*method_type_t) ( str ,  ptr< vec< str > > ,  bool ,  cbs , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     case 1: cb1(); break;     case 2: cb2(); break;     case 3: cb3(); break;     default: panic ("unexpected case");     }   }   void cb1 () {     if (-- _cb_num_calls1 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T:1518: in function xferPlugin_xdisk::perform_stat", "callback overcalled!");     }     if (!--_block1)       delaycb (0, 0, wrap (mkref (this), &xferPlugin_xdisk__get_list__closure_t::reenter));   }   void cb2 () {     if (-- _cb_num_calls2 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T:1529: in function xferPlugin_xdisk::perform_stat", "callback overcalled!");     }     if (!--_block2)       delaycb (0, 0, wrap (mkref (this), &xferPlugin_xdisk__get_list__closure_t::reenter));   }   void cb3 () {     if (-- _cb_num_calls3 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T:1546: in function xferPlugin_xdisk::perform_stat", "callback overcalled!");     }     if (!--_block3)       delaycb (0, 0, wrap (mkref (this), &xferPlugin_xdisk__get_list__closure_t::reenter));   }   void reenter ()   {     ((*_self).*_method)  (_args.path, _args.res, _args.async, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( str path,  ptr< vec< str > > res,  bool async,  cbs cb) {}      ptr< ioh > handle;      str err;      bool rem;      struct dirent entry;      str name;   };   struct args_t {     args_t ( str path,  ptr< vec< str > > res,  bool async,  cbs cb) : path (path), res (res), async (async), cb (cb) {}      str path;      ptr< vec< str > > res;      bool async;      cbs cb;   };   xferPlugin_xdisk *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   int _block1;   int _block2;   int _block3;   int _cb_num_calls1;   int _cb_num_calls2;   int _cb_num_calls3;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 1501 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
void 
xferPlugin_xdisk::get_list( str __tame_path,  ptr< vec< str > > __tame_res,  bool __tame_async,  cbs __tame_cb, ptr<closure_t> __cls_g)
{
    
# 1504 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  xferPlugin_xdisk__get_list__closure_t *__cls;   ptr<xferPlugin_xdisk__get_list__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<xferPlugin_xdisk__get_list__closure_t> (this, __tame_path, __tame_res, __tame_async, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&xferPlugin_xdisk::get_list);   } else {     __cls =     reinterpret_cast<xferPlugin_xdisk__get_list__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    ptr< ioh > &handle = __cls->_stack.handle;    str &err = __cls->_stack.err;    bool &rem = __cls->_stack.rem;    struct dirent &entry = __cls->_stack.entry;    str &name = __cls->_stack.name;    str &path = __cls->_args.path;    ptr< vec< str > > &res = __cls->_args.res;    bool &async = __cls->_args.async;    cbs &cb = __cls->_args.cb;    use_reference (path);     use_reference (res);     use_reference (async);     use_reference (cb);    switch (__cls->jumpto ()) {   case 1:     goto xferPlugin_xdisk__get_list__label_1;     break;   case 2:     goto xferPlugin_xdisk__get_list__label_2;     break;   case 3:     goto xferPlugin_xdisk__get_list__label_3;     break;   default:     break;   }
# 1510 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

    
    if (async)
	handle = New refcounted<aioh >(aiod_ptr);
    else
	handle = New refcounted<sioh >;
    
    
# 1517 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  do {     __cls->_block1 = 1;     __cls->set_jumpto (1); 
# 1517 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

	handle->opendir(path, (++__cls->_block1, ++__cls->_cb_num_calls1, wrap (__block_cb1<TTT(err)>, __cls_r, 1, pointer_set1_t<TTT(err)> (&(err)))));
    
# 1519 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
    if (--__cls->_block1)       return;   } while (0);  xferPlugin_xdisk__get_list__label_1:     ;
# 1519 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"


    if (err) {
	(*cb)(err);
	
# 1523 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
return ;
    }

    rem = true;
    while (rem) {
	
# 1528 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  do {     __cls->_block2 = 1;     __cls->set_jumpto (2); 
# 1528 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

	    handle->readdir(&entry, (++__cls->_block2, ++__cls->_cb_num_calls2, wrap (__block_cb2<TTT(rem), TTT( err)>, __cls_r, 2, pointer_set2_t<TTT(rem), TTT( err)> (&(rem), &( err)))));
	
# 1530 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
    if (--__cls->_block2)       return;   } while (0);  xferPlugin_xdisk__get_list__label_2:     ;
# 1530 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

	
	if (err) {
	    (*cb)(err);
	    
# 1534 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
return ;
	}
	else if (rem) {
	    name = strbuf() << entry.d_name;
	    //ignore "." and ".."
	    if (name != "." &&
		name != "..")
		res->push_back(name);
	}
    }

    
# 1545 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  do {     __cls->_block3 = 1;     __cls->set_jumpto (3); 
# 1545 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

	handle->closedir((++__cls->_block3, ++__cls->_cb_num_calls3, wrap (__block_cb1<TTT(err)>, __cls_r, 3, pointer_set1_t<TTT(err)> (&(err)))));
    
# 1547 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
    if (--__cls->_block3)       return;   } while (0);  xferPlugin_xdisk__get_list__label_3:     ;
# 1547 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

    
    if (err)
        (*cb)(err);
    else
	(*cb)(NULL);
# 1553 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  return;
# 1553 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
}

# 1555 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
class xferPlugin_xdisk__get_stats__closure_t : public closure_t { public:   xferPlugin_xdisk__get_stats__closure_t (xferPlugin_xdisk *_self,  str path,  ptr< vec< struct item_info > > res,  bool async,  cbs cb) : closure_t (false), _self (_self),  _stack (path, res, async, cb), _args (path, res, async, cb), _block1 (0), _cb_num_calls1 (0) {}   typedef void  (xferPlugin_xdisk::*method_type_t) ( str ,  ptr< vec< struct item_info > > ,  bool ,  cbs , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     case 1: cb1(); break;     default: panic ("unexpected case");     }   }   void cb1 () {     if (-- _cb_num_calls1 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T:1575: in function xferPlugin_xdisk::get_list", "callback overcalled!");     }     if (!--_block1)       delaycb (0, 0, wrap (mkref (this), &xferPlugin_xdisk__get_stats__closure_t::reenter));   }   void reenter ()   {     ((*_self).*_method)  (_args.path, _args.res, _args.async, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( str path,  ptr< vec< struct item_info > > res,  bool async,  cbs cb) {}      ptr< ioh > handle;      str err;      bool err_flag;      str name;   };   struct args_t {     args_t ( str path,  ptr< vec< struct item_info > > res,  bool async,  cbs cb) : path (path), res (res), async (async), cb (cb) {}      str path;      ptr< vec< struct item_info > > res;      bool async;      cbs cb;   };   xferPlugin_xdisk *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   int _block1;   int _cb_num_calls1;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 1555 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
void 
xferPlugin_xdisk::get_stats( str __tame_path,  ptr< vec< struct item_info > > __tame_res,  bool __tame_async,  cbs __tame_cb, ptr<closure_t> __cls_g)
{
    
# 1558 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  xferPlugin_xdisk__get_stats__closure_t *__cls;   ptr<xferPlugin_xdisk__get_stats__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<xferPlugin_xdisk__get_stats__closure_t> (this, __tame_path, __tame_res, __tame_async, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&xferPlugin_xdisk::get_stats);   } else {     __cls =     reinterpret_cast<xferPlugin_xdisk__get_stats__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    ptr< ioh > &handle = __cls->_stack.handle;    str &err = __cls->_stack.err;    bool &err_flag = __cls->_stack.err_flag;    str &name = __cls->_stack.name;    str &path = __cls->_args.path;    ptr< vec< struct item_info > > &res = __cls->_args.res;    bool &async = __cls->_args.async;    cbs &cb = __cls->_args.cb;    use_reference (path);     use_reference (res);     use_reference (async);     use_reference (cb);    switch (__cls->jumpto ()) {   case 1:     goto xferPlugin_xdisk__get_stats__label_1;     break;   default:     break;   }
# 1563 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

    
    if (async)
	handle = New refcounted<aioh >(aiod_ptr);
    else
	handle = New refcounted<sioh >;

    err_flag = false;
    
    
# 1572 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  do {     __cls->_block1 = 1;     __cls->set_jumpto (1); 
# 1572 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

	for (unsigned int i = 0; i < res->size(); i++) {
	    name = strbuf() << path << "/" << (*res)[i].name;
	    handle->stat(name, &((*res)[i].s), (++__cls->_block1, ++__cls->_cb_num_calls1, wrap (__block_cb1<TTT(err)>, __cls_r, 1, pointer_set1_t<TTT(err)> (&(err)))));
	    if (err && !err_flag)
		err_flag = true;
	}
    
# 1579 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
    if (--__cls->_block1)       return;   } while (0);  xferPlugin_xdisk__get_stats__label_1:     ;
# 1579 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

    
    //return
    if (err_flag)
        (*cb)("Error in Statting");
    else
	(*cb)(NULL);
# 1586 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  return;
# 1586 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
}

/*************************************/
/* Storage plugin interface */

struct xid_cache_entry {
    const dot_sId id;
    ref<vec<dot_descriptor> > dv;
    EVP_MD_CTX hash;

    ihash_entry<xid_cache_entry> hlink;

    xid_cache_entry (const dot_sId id);
    ~xid_cache_entry ();
};

static ihash<const dot_sId, xid_cache_entry, &xid_cache_entry::id, 
	     &xid_cache_entry::hlink> tempCache;


xid_cache_entry::xid_cache_entry(const dot_sId sid)
    : id(sid), dv(New refcounted<vec<dot_descriptor> >)
{
    tempCache.insert(this);

    EVP_MD_CTX_init(&hash);
    EVP_DigestInit(&hash, EVP_sha1());
}

xid_cache_entry::~xid_cache_entry()
{
    tempCache.remove(this);
}

bool
xferPlugin_xdisk::init(dot_sId id)
{
    //warn << "xferPlugin_xdisk::init called\n";
    
    xid_cache_entry *sce = tempCache[id];
    if (sce) {
        warn("xferPlugin_xdisk received duplicate ID: %d\n", id);
        return false;
    }
    sce = New xid_cache_entry(id);
    return true;
}

void
xferPlugin_xdisk::put_chunk(dot_sId id, ref<dot_descriptor> d,
                              const char *buf, int len, cbs cb, ptr<closure_t>)
{
    xid_cache_entry *sce = tempCache[id];
    ptr<vec<unsigned int> > iv;
    ptr<desc_result> res = NULL;
    ptr<dot_descriptor> new_dd;
     
    if (!sce) {
        (*cb)("Incorrect transfer ID");
        return;
    }

    // Hash for whole object
    EVP_DigestUpdate(&sce->hash, buf, len);

    //caching cid -> file mapping
    {
	struct offset_info info;
	extract_offset_info(d, &info);
	cid_bdb_info c;
	c.type = INFO_CID;
	c.desc = (*d);
	c.info = info;

	dwarn(DEBUG_OPT) << "Info is " << c.info.path << " and " <<
	    c.info.offset << "\n";
	
	rpc_bytes<> value;
	xdr2bytes(value, c);
	dwarn(DEBUG_OPT) << "Putting in cache " << d->id << "\n";
	str key = strbuf() << "INFO_CID:" << d->id;
	put_in_cache(filesDb, key.cstr(), key.len(),
		     value.base(), value.size(), true);
	//put_in_cache(filesDb, d->id.base(), d->id.size(),
    }

    ds_entry *dse = mat.desc_store[d->id];
    if (dse) { // && dse->status != DELETED) {
	dwarn(DEBUG_XDISK) << "Got a hit ....prepare to transfer " << d->id << "\n";
	ptr<suio> data = New refcounted<suio>;
	data->copy(buf, len);
	//would like to send the original descriptor came to us
	new_dd = New refcounted<dot_descriptor>(dse->dd);
	res = New refcounted<desc_result> (new_dd, data, false);
    }
    
    sce->dv->push_back(*d);

    if (res)
	(*pending_cb)(NULL, res);
    
    (*cb)(NULL);
}

void
xferPlugin_xdisk::commit_object(dot_sId id, commit_cb cb, ptr<closure_t>) 
{
    xid_cache_entry *sce = tempCache[id];
    if (!sce) {
        (*cb)("Incorrect transfer ID", NULL);
        return;
    }

    unsigned int diglen;
    unsigned char digest[EVP_MAX_MD_SIZE];
    EVP_DigestFinal(&sce->hash, digest, &diglen);
    dot_oid oo;
    oo.set((char *)digest, diglen);

    ptr<dot_oid_md> oid = New refcounted<dot_oid_md> ();
    oid->id = oo;
    //warn << "xferPlugin_xdisk::commit_object OID is " << oid->id << "\n";
   
    //cache oid->descs mapping
    {
	rpc_bytes<> value;
	oid_desc_bdb_info od;
	od.type = INFO_OID_DESC;
	od.oid = (*oid);
	od.descriptors.setsize(sce->dv->size());
	for (unsigned int i = 0; i < sce->dv->size(); i++) {
	    od.descriptors[i] = (*(sce->dv))[i];
	}
	xdr2bytes(value, od);
	dwarn(DEBUG_OPT) << "Putting desc\n";
	str key = strbuf() << "INFO_OID_DESC:" << oid->id;
	put_in_cache(filesDb, key.cstr(), key.len(),
		     value.base(), value.size(), true);
	//put_in_cache(filesDb, oid->id.base(), oid->id.size(),
	//value.base(), value.size(), false);
    } 

    delete sce;
    (*cb)(NULL, oid);
}

/*************************************/
# 1733 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
class sioh__opendir__closure_t : public closure_t { public:   sioh__opendir__closure_t (sioh *_self,  str path,  cbs cb) : closure_t (false), _self (_self),  _stack (path, cb), _args (path, cb), _block1 (0), _cb_num_calls1 (0) {}   typedef void  (sioh::*method_type_t) ( str ,  cbs , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     case 1: cb1(); break;     default: panic ("unexpected case");     }   }   void cb1 () {     if (-- _cb_num_calls1 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T:1736: in function xferPlugin_xdisk::get_stats", "callback overcalled!");     }     if (!--_block1)       delaycb (0, 0, wrap (mkref (this), &sioh__opendir__closure_t::reenter));   }   void reenter ()   {     ((*_self).*_method)  (_args.path, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( str path,  cbs cb) {}   };   struct args_t {     args_t ( str path,  cbs cb) : path (path), cb (cb) {}      str path;      cbs cb;   };   sioh *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   int _block1;   int _cb_num_calls1;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 1733 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
void 
sioh::opendir( str __tame_path,  cbs __tame_cb, ptr<closure_t> __cls_g)
{
# 1735 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  sioh__opendir__closure_t *__cls;   ptr<sioh__opendir__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<sioh__opendir__closure_t> (this, __tame_path, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&sioh::opendir);   } else {     __cls =     reinterpret_cast<sioh__opendir__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    str &path = __cls->_args.path;    cbs &cb = __cls->_args.cb;    use_reference (path);     use_reference (cb);    switch (__cls->jumpto ()) {   case 1:     goto sioh__opendir__label_1;     break;   default:     break;   }
# 1735 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

    
# 1736 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  do {     __cls->_block1 = 1;     __cls->set_jumpto (1); 
# 1736 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
 delaycb(0, 0, (++__cls->_block1, ++__cls->_cb_num_calls1, wrap (__block_cb0, __cls_r, 1))); 
# 1736 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
    if (--__cls->_block1)       return;   } while (0);  sioh__opendir__label_1:     ;
# 1736 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

    
    fp = ::opendir(path);
    
    //warn << "opendir successful\n";
    
    if (!fp)
	(*cb)("Problem in opening directory");
    else
	(*cb)(NULL);
# 1746 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  return;
# 1746 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
}

# 1748 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
class sioh__readdir__closure_t : public closure_t { public:   sioh__readdir__closure_t (sioh *_self,  struct dirent *res,  cb_bool cb) : closure_t (false), _self (_self),  _stack (res, cb), _args (res, cb), _block1 (0), _cb_num_calls1 (0) {}   typedef void  (sioh::*method_type_t) ( struct dirent *,  cb_bool , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     case 1: cb1(); break;     default: panic ("unexpected case");     }   }   void cb1 () {     if (-- _cb_num_calls1 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T:1751: in function sioh::opendir", "callback overcalled!");     }     if (!--_block1)       delaycb (0, 0, wrap (mkref (this), &sioh__readdir__closure_t::reenter));   }   void reenter ()   {     ((*_self).*_method)  (_args.res, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( struct dirent *res,  cb_bool cb) {}   };   struct args_t {     args_t ( struct dirent *res,  cb_bool cb) : res (res), cb (cb) {}      struct dirent *res;      cb_bool cb;   };   sioh *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   int _block1;   int _cb_num_calls1;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 1748 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
void 
sioh::readdir( struct dirent *__tame_res,  cb_bool __tame_cb, ptr<closure_t> __cls_g)
{
# 1750 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  sioh__readdir__closure_t *__cls;   ptr<sioh__readdir__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<sioh__readdir__closure_t> (this, __tame_res, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&sioh::readdir);   } else {     __cls =     reinterpret_cast<sioh__readdir__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    struct dirent *&res = __cls->_args.res;    cb_bool &cb = __cls->_args.cb;    use_reference (res);     use_reference (cb);    switch (__cls->jumpto ()) {   case 1:     goto sioh__readdir__label_1;     break;   default:     break;   }
# 1750 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

    
# 1751 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  do {     __cls->_block1 = 1;     __cls->set_jumpto (1); 
# 1751 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
 delaycb(0, 0, (++__cls->_block1, ++__cls->_cb_num_calls1, wrap (__block_cb0, __cls_r, 1))); 
# 1751 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
    if (--__cls->_block1)       return;   } while (0);  sioh__readdir__label_1:     ;
# 1751 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

    
    dirent *dp = ::readdir(fp);
    
    if (dp) {
	memcpy(res, dp, sizeof(dirent)); 
	(*cb)(true, NULL);
    }
    else
	(*cb)(false, NULL);
# 1761 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  return;
# 1761 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
}

# 1763 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
class sioh__closedir__closure_t : public closure_t { public:   sioh__closedir__closure_t (sioh *_self,  cbs cb) : closure_t (false), _self (_self),  _stack (cb), _args (cb), _block1 (0), _cb_num_calls1 (0) {}   typedef void  (sioh::*method_type_t) ( cbs , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     case 1: cb1(); break;     default: panic ("unexpected case");     }   }   void cb1 () {     if (-- _cb_num_calls1 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T:1766: in function sioh::readdir", "callback overcalled!");     }     if (!--_block1)       delaycb (0, 0, wrap (mkref (this), &sioh__closedir__closure_t::reenter));   }   void reenter ()   {     ((*_self).*_method)  (_args.cb, mkref (this));   }   struct stack_t {     stack_t ( cbs cb) {}   };   struct args_t {     args_t ( cbs cb) : cb (cb) {}      cbs cb;   };   sioh *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   int _block1;   int _cb_num_calls1;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 1763 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
void 
sioh::closedir( cbs __tame_cb, ptr<closure_t> __cls_g)
{
# 1765 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  sioh__closedir__closure_t *__cls;   ptr<sioh__closedir__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<sioh__closedir__closure_t> (this, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&sioh::closedir);   } else {     __cls =     reinterpret_cast<sioh__closedir__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    cbs &cb = __cls->_args.cb;    use_reference (cb);    switch (__cls->jumpto ()) {   case 1:     goto sioh__closedir__label_1;     break;   default:     break;   }
# 1765 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

    
# 1766 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  do {     __cls->_block1 = 1;     __cls->set_jumpto (1); 
# 1766 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
 delaycb(0, 0, (++__cls->_block1, ++__cls->_cb_num_calls1, wrap (__block_cb0, __cls_r, 1))); 
# 1766 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
    if (--__cls->_block1)       return;   } while (0);  sioh__closedir__label_1:     ;
# 1766 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

    
    ::closedir(fp);
    (*cb)(NULL);
# 1770 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  return;
# 1770 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
}

# 1772 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
class sioh__stat__closure_t : public closure_t { public:   sioh__stat__closure_t (sioh *_self,  str name,  struct stat *res,  cbs cb) : closure_t (false), _self (_self),  _stack (name, res, cb), _args (name, res, cb), _block1 (0), _cb_num_calls1 (0) {}   typedef void  (sioh::*method_type_t) ( str ,  struct stat *,  cbs , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     case 1: cb1(); break;     default: panic ("unexpected case");     }   }   void cb1 () {     if (-- _cb_num_calls1 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T:1775: in function sioh::closedir", "callback overcalled!");     }     if (!--_block1)       delaycb (0, 0, wrap (mkref (this), &sioh__stat__closure_t::reenter));   }   void reenter ()   {     ((*_self).*_method)  (_args.name, _args.res, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( str name,  struct stat *res,  cbs cb) {}   };   struct args_t {     args_t ( str name,  struct stat *res,  cbs cb) : name (name), res (res), cb (cb) {}      str name;      struct stat *res;      cbs cb;   };   sioh *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   int _block1;   int _cb_num_calls1;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 1772 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
void 
sioh::stat( str __tame_name,  struct stat *__tame_res,  cbs __tame_cb, ptr<closure_t> __cls_g)
{
# 1774 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  sioh__stat__closure_t *__cls;   ptr<sioh__stat__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<sioh__stat__closure_t> (this, __tame_name, __tame_res, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&sioh::stat);   } else {     __cls =     reinterpret_cast<sioh__stat__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    str &name = __cls->_args.name;    struct stat *&res = __cls->_args.res;    cbs &cb = __cls->_args.cb;    use_reference (name);     use_reference (res);     use_reference (cb);    switch (__cls->jumpto ()) {   case 1:     goto sioh__stat__label_1;     break;   default:     break;   }
# 1774 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

    
# 1775 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  do {     __cls->_block1 = 1;     __cls->set_jumpto (1); 
# 1775 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
 delaycb(0, 0, (++__cls->_block1, ++__cls->_cb_num_calls1, wrap (__block_cb0, __cls_r, 1))); 
# 1775 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
    if (--__cls->_block1)       return;   } while (0);  sioh__stat__label_1:     ;
# 1775 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"


    //warn << "Statting " << name << "\n";
    
    struct stat s;
    ::stat(name, &s);
    
    //warn << "stat successful\n";
    
    memcpy(res, &s, sizeof(struct stat));
    (*cb)(NULL);
# 1786 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  return;
# 1786 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
}

# 1788 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
class sioh__open__closure_t : public closure_t { public:   sioh__open__closure_t (sioh *_self,  str path,  mode_t mode,  cbs cb) : closure_t (false), _self (_self),  _stack (path, mode, cb), _args (path, mode, cb), _block1 (0), _cb_num_calls1 (0) {}   typedef void  (sioh::*method_type_t) ( str ,  mode_t ,  cbs , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     case 1: cb1(); break;     default: panic ("unexpected case");     }   }   void cb1 () {     if (-- _cb_num_calls1 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T:1791: in function sioh::stat", "callback overcalled!");     }     if (!--_block1)       delaycb (0, 0, wrap (mkref (this), &sioh__open__closure_t::reenter));   }   void reenter ()   {     ((*_self).*_method)  (_args.path, _args.mode, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( str path,  mode_t mode,  cbs cb) {}   };   struct args_t {     args_t ( str path,  mode_t mode,  cbs cb) : path (path), mode (mode), cb (cb) {}      str path;      mode_t mode;      cbs cb;   };   sioh *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   int _block1;   int _cb_num_calls1;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 1788 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
void 
sioh::open( str __tame_path,  mode_t __tame_mode,  cbs __tame_cb, ptr<closure_t> __cls_g)
{
# 1790 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  sioh__open__closure_t *__cls;   ptr<sioh__open__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<sioh__open__closure_t> (this, __tame_path, __tame_mode, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&sioh::open);   } else {     __cls =     reinterpret_cast<sioh__open__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    str &path = __cls->_args.path;    mode_t &mode = __cls->_args.mode;    cbs &cb = __cls->_args.cb;    use_reference (path);     use_reference (mode);     use_reference (cb);    switch (__cls->jumpto ()) {   case 1:     goto sioh__open__label_1;     break;   default:     break;   }
# 1790 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

    
# 1791 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  do {     __cls->_block1 = 1;     __cls->set_jumpto (1); 
# 1791 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
 delaycb(0, 0, (++__cls->_block1, ++__cls->_cb_num_calls1, wrap (__block_cb0, __cls_r, 1))); 
# 1791 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
    if (--__cls->_block1)       return;   } while (0);  sioh__open__label_1:     ;
# 1791 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

    
    fd = ::open(path, mode);
    
    if (fd == -1)
	(*cb)("Problem in opening file");
    else
	(*cb)(NULL);
# 1799 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  return;
# 1799 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
}

# 1801 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
class sioh__read__closure_t : public closure_t { public:   sioh__read__closure_t (sioh *_self,  ptr< suio > io_in,  int size,  cb_int cb) : closure_t (false), _self (_self),  _stack (io_in, size, cb), _args (io_in, size, cb), _block1 (0), _block2 (0), _cb_num_calls1 (0), _cb_num_calls2 (0) {}   typedef void  (sioh::*method_type_t) ( ptr< suio > ,  int ,  cb_int , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     case 1: cb1(); break;     case 2: cb2(); break;     default: panic ("unexpected case");     }   }   void cb1 () {     if (-- _cb_num_calls1 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T:1804: in function sioh::open", "callback overcalled!");     }     if (!--_block1)       delaycb (0, 0, wrap (mkref (this), &sioh__read__closure_t::reenter));   }   void cb2 () {     if (-- _cb_num_calls2 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T:1807: in function sioh::open", "callback overcalled!");     }     if (!--_block2)       delaycb (0, 0, wrap (mkref (this), &sioh__read__closure_t::reenter));   }   void reenter ()   {     ((*_self).*_method)  (_args.io_in, _args.size, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( ptr< suio > io_in,  int size,  cb_int cb) {}   };   struct args_t {     args_t ( ptr< suio > io_in,  int size,  cb_int cb) : io_in (io_in), size (size), cb (cb) {}      ptr< suio > io_in;      int size;      cb_int cb;   };   sioh *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   int _block1;   int _block2;   int _cb_num_calls1;   int _cb_num_calls2;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 1801 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
void 
sioh::read( ptr< suio > __tame_io_in,  int __tame_size,  cb_int __tame_cb, ptr<closure_t> __cls_g)
{
# 1803 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  sioh__read__closure_t *__cls;   ptr<sioh__read__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<sioh__read__closure_t> (this, __tame_io_in, __tame_size, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&sioh::read);   } else {     __cls =     reinterpret_cast<sioh__read__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    ptr< suio > &io_in = __cls->_args.io_in;    int &size = __cls->_args.size;    cb_int &cb = __cls->_args.cb;    use_reference (io_in);     use_reference (size);     use_reference (cb);    switch (__cls->jumpto ()) {   case 1:     goto sioh__read__label_1;     break;   case 2:     goto sioh__read__label_2;     break;   default:     break;   }
# 1803 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

    
# 1804 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  do {     __cls->_block1 = 1;     __cls->set_jumpto (1); 
# 1804 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
 delaycb(0, 0, (++__cls->_block1, ++__cls->_cb_num_calls1, wrap (__block_cb0, __cls_r, 1))); 
# 1804 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
    if (--__cls->_block1)       return;   } while (0);  sioh__read__label_1:     ;
# 1804 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

    
    
# 1806 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  do {     __cls->_block2 = 1;     __cls->set_jumpto (2); 
# 1806 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

	fdcb(fd, selread, (++__cls->_block2, ++__cls->_cb_num_calls2, wrap (__block_cb0, __cls_r, 2)));
    
# 1808 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
    if (--__cls->_block2)       return;   } while (0);  sioh__read__label_2:     ;
# 1808 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

    fdcb(fd, selread, NULL);
    int rc = io_in->input(fd, size);
    (*cb)(rc);
# 1812 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  return;
# 1812 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
}

# 1814 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
class sioh__close__closure_t : public closure_t { public:   sioh__close__closure_t (sioh *_self,  cbs cb) : closure_t (false), _self (_self),  _stack (cb), _args (cb), _block1 (0), _cb_num_calls1 (0) {}   typedef void  (sioh::*method_type_t) ( cbs , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     case 1: cb1(); break;     default: panic ("unexpected case");     }   }   void cb1 () {     if (-- _cb_num_calls1 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T:1817: in function sioh::read", "callback overcalled!");     }     if (!--_block1)       delaycb (0, 0, wrap (mkref (this), &sioh__close__closure_t::reenter));   }   void reenter ()   {     ((*_self).*_method)  (_args.cb, mkref (this));   }   struct stack_t {     stack_t ( cbs cb) {}   };   struct args_t {     args_t ( cbs cb) : cb (cb) {}      cbs cb;   };   sioh *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   int _block1;   int _cb_num_calls1;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 1814 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
void 
sioh::close( cbs __tame_cb, ptr<closure_t> __cls_g)
{
# 1816 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  sioh__close__closure_t *__cls;   ptr<sioh__close__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<sioh__close__closure_t> (this, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&sioh::close);   } else {     __cls =     reinterpret_cast<sioh__close__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    cbs &cb = __cls->_args.cb;    use_reference (cb);    switch (__cls->jumpto ()) {   case 1:     goto sioh__close__label_1;     break;   default:     break;   }
# 1816 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

    
# 1817 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  do {     __cls->_block1 = 1;     __cls->set_jumpto (1); 
# 1817 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
 delaycb(0, 0, (++__cls->_block1, ++__cls->_cb_num_calls1, wrap (__block_cb0, __cls_r, 1))); 
# 1817 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
    if (--__cls->_block1)       return;   } while (0);  sioh__close__label_1:     ;
# 1817 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

    
    fdcb(fd, selread, NULL);
    ::close(fd);
    fd = -1;

    (*cb)(NULL);
# 1824 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  return;
# 1824 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
}

# 1826 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
class sioh__seek__closure_t : public closure_t { public:   sioh__seek__closure_t (sioh *_self,  int offset,  cbs cb) : closure_t (false), _self (_self),  _stack (offset, cb), _args (offset, cb), _block1 (0), _cb_num_calls1 (0) {}   typedef void  (sioh::*method_type_t) ( int ,  cbs , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     case 1: cb1(); break;     default: panic ("unexpected case");     }   }   void cb1 () {     if (-- _cb_num_calls1 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T:1829: in function sioh::close", "callback overcalled!");     }     if (!--_block1)       delaycb (0, 0, wrap (mkref (this), &sioh__seek__closure_t::reenter));   }   void reenter ()   {     ((*_self).*_method)  (_args.offset, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( int offset,  cbs cb) {}   };   struct args_t {     args_t ( int offset,  cbs cb) : offset (offset), cb (cb) {}      int offset;      cbs cb;   };   sioh *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   int _block1;   int _cb_num_calls1;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 1826 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
void 
sioh::seek( int __tame_offset,  cbs __tame_cb, ptr<closure_t> __cls_g)
{
# 1828 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  sioh__seek__closure_t *__cls;   ptr<sioh__seek__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<sioh__seek__closure_t> (this, __tame_offset, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&sioh::seek);   } else {     __cls =     reinterpret_cast<sioh__seek__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    int &offset = __cls->_args.offset;    cbs &cb = __cls->_args.cb;    use_reference (offset);     use_reference (cb);    switch (__cls->jumpto ()) {   case 1:     goto sioh__seek__label_1;     break;   default:     break;   }
# 1828 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

    
# 1829 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  do {     __cls->_block1 = 1;     __cls->set_jumpto (1); 
# 1829 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
 delaycb(0, 0, (++__cls->_block1, ++__cls->_cb_num_calls1, wrap (__block_cb0, __cls_r, 1))); 
# 1829 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
    if (--__cls->_block1)       return;   } while (0);  sioh__seek__label_1:     ;
# 1829 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

    
    if (lseek(fd, offset, SEEK_SET) != offset) {
        (*cb)("Seek failed\n");
    }
    
    (*cb)(NULL);
# 1836 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  return;
# 1836 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
}

# 1838 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
class aioh__opendir__closure_t : public closure_t { public:   aioh__opendir__closure_t (aioh *_self,  str path,  cbs cb) : closure_t (false), _self (_self),  _stack (path, cb), _args (path, cb), _block1 (0), _block2 (0), _cb_num_calls1 (0), _cb_num_calls2 (0) {}   typedef void  (aioh::*method_type_t) ( str ,  cbs , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     case 1: cb1(); break;     case 2: cb2(); break;     default: panic ("unexpected case");     }   }   void cb1 () {     if (-- _cb_num_calls1 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T:1849: in function sioh::seek", "callback overcalled!");     }     if (!--_block1)       delaycb (0, 0, wrap (mkref (this), &aioh__opendir__closure_t::reenter));   }   void cb2 () {     if (-- _cb_num_calls2 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T:1855: in function sioh::seek", "callback overcalled!");     }     if (!--_block2)       delaycb (0, 0, wrap (mkref (this), &aioh__opendir__closure_t::reenter));   }   void reenter ()   {     ((*_self).*_method)  (_args.path, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( str path,  cbs cb) {}      int err;   };   struct args_t {     args_t ( str path,  cbs cb) : path (path), cb (cb) {}      str path;      cbs cb;   };   aioh *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   int _block1;   int _block2;   int _cb_num_calls1;   int _cb_num_calls2;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 1838 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
void 
aioh::opendir( str __tame_path,  cbs __tame_cb, ptr<closure_t> __cls_g)
{
    
# 1841 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  aioh__opendir__closure_t *__cls;   ptr<aioh__opendir__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<aioh__opendir__closure_t> (this, __tame_path, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&aioh::opendir);   } else {     __cls =     reinterpret_cast<aioh__opendir__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    int &err = __cls->_stack.err;    str &path = __cls->_args.path;    cbs &cb = __cls->_args.cb;    use_reference (path);     use_reference (cb);    switch (__cls->jumpto ()) {   case 1:     goto aioh__opendir__label_1;     break;   case 2:     goto aioh__opendir__label_2;     break;   default:     break;   }
# 1843 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

    
    buf = a->bufalloc(sizeof(dirent));
    if (!buf) {
	//warn << "buf not there\n";
	
# 1848 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  do {     __cls->_block1 = 1;     __cls->set_jumpto (1); 
# 1848 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

	    a->bufwait((++__cls->_block1, ++__cls->_cb_num_calls1, wrap (__block_cb0, __cls_r, 1)));
	
# 1850 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
    if (--__cls->_block1)       return;   } while (0);  aioh__opendir__label_1:     ;
# 1850 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

	buf = a->bufalloc(sizeof(dirent));
    }
    
    
# 1854 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  do {     __cls->_block2 = 1;     __cls->set_jumpto (2); 
# 1854 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

	a->opendir(path, (++__cls->_block2, ++__cls->_cb_num_calls2, wrap (__block_cb2<TTT(fh), TTT( err)>, __cls_r, 2, pointer_set2_t<TTT(fh), TTT( err)> (&(fh), &( err)))));
    
# 1856 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
    if (--__cls->_block2)       return;   } while (0);  aioh__opendir__label_2:     ;
# 1856 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

    
    if (!fh) {
	warn("opendir: %s\n", strerror(err));
	(*cb)("Problem in opening directory");
    }
    else {
	//warn << "Opendir successful\n";
	(*cb)(NULL);
    }
# 1866 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  return;
# 1866 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
}

# 1868 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
class aioh__readdir__closure_t : public closure_t { public:   aioh__readdir__closure_t (aioh *_self,  struct dirent *res,  cb_bool cb) : closure_t (false), _self (_self),  _stack (res, cb), _args (res, cb), _block1 (0), _cb_num_calls1 (0) {}   typedef void  (aioh::*method_type_t) ( struct dirent *,  cb_bool , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     case 1: cb1(); break;     default: panic ("unexpected case");     }   }   void cb1 () {     if (-- _cb_num_calls1 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T:1878: in function aioh::opendir", "callback overcalled!");     }     if (!--_block1)       delaycb (0, 0, wrap (mkref (this), &aioh__readdir__closure_t::reenter));   }   void reenter ()   {     ((*_self).*_method)  (_args.res, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( struct dirent *res,  cb_bool cb) {}      ssize_t len;      int err;      dirent *dp;   };   struct args_t {     args_t ( struct dirent *res,  cb_bool cb) : res (res), cb (cb) {}      struct dirent *res;      cb_bool cb;   };   aioh *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   int _block1;   int _cb_num_calls1;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 1868 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
void 
aioh::readdir( struct dirent *__tame_res,  cb_bool __tame_cb, ptr<closure_t> __cls_g)
{
    
# 1871 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  aioh__readdir__closure_t *__cls;   ptr<aioh__readdir__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<aioh__readdir__closure_t> (this, __tame_res, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&aioh::readdir);   } else {     __cls =     reinterpret_cast<aioh__readdir__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    ssize_t &len = __cls->_stack.len;    int &err = __cls->_stack.err;    dirent *&dp = __cls->_stack.dp;    struct dirent *&res = __cls->_args.res;    cb_bool &cb = __cls->_args.cb;    use_reference (res);     use_reference (cb);    switch (__cls->jumpto ()) {   case 1:     goto aioh__readdir__label_1;     break;   default:     break;   }
# 1875 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

    
    
# 1877 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  do {     __cls->_block1 = 1;     __cls->set_jumpto (1); 
# 1877 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

	fh->readdir(buf, (++__cls->_block1, ++__cls->_cb_num_calls1, wrap (__block_cb3<TTT(buf), TTT( len), TTT( err)>, __cls_r, 1, pointer_set3_t<TTT(buf), TTT( len), TTT( err)> (&(buf), &( len), &( err)))));
    
# 1879 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
    if (--__cls->_block1)       return;   } while (0);  aioh__readdir__label_1:     ;
# 1879 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

    
    if (err) {
	warn("readdir %s\n", strerror (err));
	(*cb)(false, "Problem in reading");
    }
    else {
	//warn << "Readdir successful\n";
	if (len == 0) {
	    (*cb)(false, NULL);
	}
	else {
	    dp = (dirent *) buf->base();
	    memcpy(res, dp, sizeof(dirent)); 
	    //warn << "Entry --> " << dp->d_name << "\n";
	    (*cb)(true, NULL);
	}
    }
# 1897 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  return;
# 1897 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
}

# 1899 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
class aioh__closedir__closure_t : public closure_t { public:   aioh__closedir__closure_t (aioh *_self,  cbs cb) : closure_t (false), _self (_self),  _stack (cb), _args (cb), _block1 (0), _cb_num_calls1 (0) {}   typedef void  (aioh::*method_type_t) ( cbs , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     case 1: cb1(); break;     default: panic ("unexpected case");     }   }   void cb1 () {     if (-- _cb_num_calls1 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T:1907: in function aioh::readdir", "callback overcalled!");     }     if (!--_block1)       delaycb (0, 0, wrap (mkref (this), &aioh__closedir__closure_t::reenter));   }   void reenter ()   {     ((*_self).*_method)  (_args.cb, mkref (this));   }   struct stack_t {     stack_t ( cbs cb) {}      int err;   };   struct args_t {     args_t ( cbs cb) : cb (cb) {}      cbs cb;   };   aioh *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   int _block1;   int _cb_num_calls1;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 1899 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
void 
aioh::closedir( cbs __tame_cb, ptr<closure_t> __cls_g)
{
    
# 1902 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  aioh__closedir__closure_t *__cls;   ptr<aioh__closedir__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<aioh__closedir__closure_t> (this, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&aioh::closedir);   } else {     __cls =     reinterpret_cast<aioh__closedir__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    int &err = __cls->_stack.err;    cbs &cb = __cls->_args.cb;    use_reference (cb);    switch (__cls->jumpto ()) {   case 1:     goto aioh__closedir__label_1;     break;   default:     break;   }
# 1904 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"


    
# 1906 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  do {     __cls->_block1 = 1;     __cls->set_jumpto (1); 
# 1906 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

	fh->closedir((++__cls->_block1, ++__cls->_cb_num_calls1, wrap (__block_cb1<TTT(err)>, __cls_r, 1, pointer_set1_t<TTT(err)> (&(err)))));
    
# 1908 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
    if (--__cls->_block1)       return;   } while (0);  aioh__closedir__label_1:     ;
# 1908 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"


    if (err) {
	warn("close %s\n", strerror (err));
	(*cb)("Problem in closing directory");
    }
    else {
	//warn << "Close successful\n";
	(*cb)(NULL);
    }
# 1918 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  return;
# 1918 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
}

# 1920 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
class aioh__stat__closure_t : public closure_t { public:   aioh__stat__closure_t (aioh *_self,  str name,  struct stat *res,  cbs cb) : closure_t (false), _self (_self),  _stack (name, res, cb), _args (name, res, cb), _block1 (0), _cb_num_calls1 (0) {}   typedef void  (aioh::*method_type_t) ( str ,  struct stat *,  cbs , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     case 1: cb1(); break;     default: panic ("unexpected case");     }   }   void cb1 () {     if (-- _cb_num_calls1 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T:1931: in function aioh::closedir", "callback overcalled!");     }     if (!--_block1)       delaycb (0, 0, wrap (mkref (this), &aioh__stat__closure_t::reenter));   }   void reenter ()   {     ((*_self).*_method)  (_args.name, _args.res, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( str name,  struct stat *res,  cbs cb) {}      int err;      struct stat *s;   };   struct args_t {     args_t ( str name,  struct stat *res,  cbs cb) : name (name), res (res), cb (cb) {}      str name;      struct stat *res;      cbs cb;   };   aioh *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   int _block1;   int _cb_num_calls1;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 1920 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
void 
aioh::stat( str __tame_name,  struct stat *__tame_res,  cbs __tame_cb, ptr<closure_t> __cls_g)
{
    
# 1923 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  aioh__stat__closure_t *__cls;   ptr<aioh__stat__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<aioh__stat__closure_t> (this, __tame_name, __tame_res, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&aioh::stat);   } else {     __cls =     reinterpret_cast<aioh__stat__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    int &err = __cls->_stack.err;    struct stat *&s = __cls->_stack.s;    str &name = __cls->_args.name;    struct stat *&res = __cls->_args.res;    cbs &cb = __cls->_args.cb;    use_reference (name);     use_reference (res);     use_reference (cb);    switch (__cls->jumpto ()) {   case 1:     goto aioh__stat__label_1;     break;   default:     break;   }
# 1926 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"


    //warn << "Statting " << name << "\n";
    
    
# 1930 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  do {     __cls->_block1 = 1;     __cls->set_jumpto (1); 
# 1930 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

	a->stat(name, (++__cls->_block1, ++__cls->_cb_num_calls1, wrap (__block_cb2<TTT(s), TTT( err)>, __cls_r, 1, pointer_set2_t<TTT(s), TTT( err)> (&(s), &( err)))));
    
# 1932 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
    if (--__cls->_block1)       return;   } while (0);  aioh__stat__label_1:     ;
# 1932 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"


    if (err)
	(*cb)("async stat failed");
    else {
	//warn << "stat successful\n";
	memcpy(res, s, sizeof(struct stat));
	(*cb)(NULL);
    }
# 1941 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  return;
# 1941 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
}

# 1943 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
class aioh__open__closure_t : public closure_t { public:   aioh__open__closure_t (aioh *_self,  str path,  mode_t mode,  cbs cb) : closure_t (false), _self (_self),  _stack (path, mode, cb), _args (path, mode, cb), _block1 (0), _cb_num_calls1 (0) {}   typedef void  (aioh::*method_type_t) ( str ,  mode_t ,  cbs , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     case 1: cb1(); break;     default: panic ("unexpected case");     }   }   void cb1 () {     if (-- _cb_num_calls1 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T:1951: in function aioh::stat", "callback overcalled!");     }     if (!--_block1)       delaycb (0, 0, wrap (mkref (this), &aioh__open__closure_t::reenter));   }   void reenter ()   {     ((*_self).*_method)  (_args.path, _args.mode, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( str path,  mode_t mode,  cbs cb) {}      int err;   };   struct args_t {     args_t ( str path,  mode_t mode,  cbs cb) : path (path), mode (mode), cb (cb) {}      str path;      mode_t mode;      cbs cb;   };   aioh *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   int _block1;   int _cb_num_calls1;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 1943 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
void 
aioh::open( str __tame_path,  mode_t __tame_mode,  cbs __tame_cb, ptr<closure_t> __cls_g)
{
    
# 1946 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  aioh__open__closure_t *__cls;   ptr<aioh__open__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<aioh__open__closure_t> (this, __tame_path, __tame_mode, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&aioh::open);   } else {     __cls =     reinterpret_cast<aioh__open__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    int &err = __cls->_stack.err;    str &path = __cls->_args.path;    mode_t &mode = __cls->_args.mode;    cbs &cb = __cls->_args.cb;    use_reference (path);     use_reference (mode);     use_reference (cb);    switch (__cls->jumpto ()) {   case 1:     goto aioh__open__label_1;     break;   default:     break;   }
# 1948 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

     
    
# 1950 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  do {     __cls->_block1 = 1;     __cls->set_jumpto (1); 
# 1950 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

	a->open(path, mode, 066, (++__cls->_block1, ++__cls->_cb_num_calls1, wrap (__block_cb2<TTT(fh), TTT( err)>, __cls_r, 1, pointer_set2_t<TTT(fh), TTT( err)> (&(fh), &( err)))));
    
# 1952 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
    if (--__cls->_block1)       return;   } while (0);  aioh__open__label_1:     ;
# 1952 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

    
    if (!fh) {
	fd = -1;
	warn("open: %s\n", strerror(err));
	(*cb)("Problem in opening file");
    }
    else {
	fd = 1; //success
	(*cb)(NULL);
    }
# 1963 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  return;
# 1963 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
}

# 1965 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
class aioh__read__closure_t : public closure_t { public:   aioh__read__closure_t (aioh *_self,  ptr< suio > io_in,  int size,  cb_int cb) : closure_t (false), _self (_self),  _stack (io_in, size, cb), _args (io_in, size, cb), _block1 (0), _block2 (0), _cb_num_calls1 (0), _cb_num_calls2 (0) {}   typedef void  (aioh::*method_type_t) ( ptr< suio > ,  int ,  cb_int , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     case 1: cb1(); break;     case 2: cb2(); break;     default: panic ("unexpected case");     }   }   void cb1 () {     if (-- _cb_num_calls1 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T:1978: in function aioh::open", "callback overcalled!");     }     if (!--_block1)       delaycb (0, 0, wrap (mkref (this), &aioh__read__closure_t::reenter));   }   void cb2 () {     if (-- _cb_num_calls2 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T:1986: in function aioh::open", "callback overcalled!");     }     if (!--_block2)       delaycb (0, 0, wrap (mkref (this), &aioh__read__closure_t::reenter));   }   void reenter ()   {     ((*_self).*_method)  (_args.io_in, _args.size, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( ptr< suio > io_in,  int size,  cb_int cb) {}      ssize_t len;      int err;   };   struct args_t {     args_t ( ptr< suio > io_in,  int size,  cb_int cb) : io_in (io_in), size (size), cb (cb) {}      ptr< suio > io_in;      int size;      cb_int cb;   };   aioh *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   int _block1;   int _block2;   int _cb_num_calls1;   int _cb_num_calls2;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 1965 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
void 
aioh::read( ptr< suio > __tame_io_in,  int __tame_size,  cb_int __tame_cb, ptr<closure_t> __cls_g)
{
    
# 1968 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  aioh__read__closure_t *__cls;   ptr<aioh__read__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<aioh__read__closure_t> (this, __tame_io_in, __tame_size, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&aioh::read);   } else {     __cls =     reinterpret_cast<aioh__read__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    ssize_t &len = __cls->_stack.len;    int &err = __cls->_stack.err;    ptr< suio > &io_in = __cls->_args.io_in;    int &size = __cls->_args.size;    cb_int &cb = __cls->_args.cb;    use_reference (io_in);     use_reference (size);     use_reference (cb);    switch (__cls->jumpto ()) {   case 1:     goto aioh__read__label_1;     break;   case 2:     goto aioh__read__label_2;     break;   default:     break;   }
# 1971 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"


    buf = NULL;
    buf = a->bufalloc(size);
    if (!buf) {
	warnx << "aioh::read waiting on buf\n";
	
# 1977 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  do {     __cls->_block1 = 1;     __cls->set_jumpto (1); 
# 1977 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

	    a->bufwait((++__cls->_block1, ++__cls->_cb_num_calls1, wrap (__block_cb0, __cls_r, 1)));
	
# 1979 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
    if (--__cls->_block1)       return;   } while (0);  aioh__read__label_1:     ;
# 1979 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

	buf = a->bufalloc(size);
    }

    //warnx << "aioh::read Got buf\n";
    
    
# 1985 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  do {     __cls->_block2 = 1;     __cls->set_jumpto (2); 
# 1985 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

	fh->read(pos, buf, (++__cls->_block2, ++__cls->_cb_num_calls2, wrap (__block_cb3<TTT(buf), TTT( len), TTT( err)>, __cls_r, 2, pointer_set3_t<TTT(buf), TTT( len), TTT( err)> (&(buf), &( len), &( err)))));
    
# 1987 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
    if (--__cls->_block2)       return;   } while (0);  aioh__read__label_2:     ;
# 1987 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

    
    if (err) {
	warn("readdir %s\n", strerror (err));
	(*cb)(-1);
    }
    else {
	pos += len;
	io_in->copy(buf->base(), len);
	(*cb)(len);
    }
# 1998 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  return;
# 1998 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
}

# 2000 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
class aioh__close__closure_t : public closure_t { public:   aioh__close__closure_t (aioh *_self,  cbs cb) : closure_t (false), _self (_self),  _stack (cb), _args (cb), _block1 (0), _cb_num_calls1 (0) {}   typedef void  (aioh::*method_type_t) ( cbs , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     case 1: cb1(); break;     default: panic ("unexpected case");     }   }   void cb1 () {     if (-- _cb_num_calls1 < 0 ) {       tame_error ("/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T:2008: in function aioh::read", "callback overcalled!");     }     if (!--_block1)       delaycb (0, 0, wrap (mkref (this), &aioh__close__closure_t::reenter));   }   void reenter ()   {     ((*_self).*_method)  (_args.cb, mkref (this));   }   struct stack_t {     stack_t ( cbs cb) {}      int err;   };   struct args_t {     args_t ( cbs cb) : cb (cb) {}      cbs cb;   };   aioh *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   int _block1;   int _cb_num_calls1;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 2000 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
void 
aioh::close( cbs __tame_cb, ptr<closure_t> __cls_g)
{
    
# 2003 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  aioh__close__closure_t *__cls;   ptr<aioh__close__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<aioh__close__closure_t> (this, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&aioh::close);   } else {     __cls =     reinterpret_cast<aioh__close__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    int &err = __cls->_stack.err;    cbs &cb = __cls->_args.cb;    use_reference (cb);    switch (__cls->jumpto ()) {   case 1:     goto aioh__close__label_1;     break;   default:     break;   }
# 2005 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"


    
# 2007 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  do {     __cls->_block1 = 1;     __cls->set_jumpto (1); 
# 2007 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

	fh->close((++__cls->_block1, ++__cls->_cb_num_calls1, wrap (__block_cb1<TTT(err)>, __cls_r, 1, pointer_set1_t<TTT(err)> (&(err)))));
    
# 2009 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
    if (--__cls->_block1)       return;   } while (0);  aioh__close__label_1:     ;
# 2009 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"


    fd = -1;
    
    if (err) {
	warn("close %s\n", strerror (err));
	(*cb)("Problem in closing file");
    }
    else {
	(*cb)(NULL);
    }
# 2020 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  return;
# 2020 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
}

# 2022 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
class aioh__seek__closure_t : public closure_t { public:   aioh__seek__closure_t (aioh *_self,  int offset,  cbs cb) : closure_t (false), _self (_self),  _stack (offset, cb), _args (offset, cb) {}   typedef void  (aioh::*method_type_t) ( int ,  cbs , ptr<closure_t>);   void set_method_pointer (method_type_t m) { _method = m; }   void block_cb_switch (int i) {     switch (i) {     default: panic ("unexpected case");     }   }   void reenter ()   {     ((*_self).*_method)  (_args.offset, _args.cb, mkref (this));   }   struct stack_t {     stack_t ( int offset,  cbs cb) {}   };   struct args_t {     args_t ( int offset,  cbs cb) : offset (offset), cb (cb) {}      int offset;      cbs cb;   };   aioh *_self;   stack_t _stack;   args_t _args;   method_type_t _method;   bool is_onstack (const void *p) const   {     return (static_cast<const void *> (&_stack) <= p &&             static_cast<const void *> (&_stack + 1) > p);   } }; 
# 2022 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
void 
aioh::seek( int __tame_offset,  cbs __tame_cb, ptr<closure_t> __cls_g)
{
# 2024 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  aioh__seek__closure_t *__cls;   ptr<aioh__seek__closure_t > __cls_r;   if (!__cls_g) {     start_join_group_collection ();     __cls_r = New refcounted<aioh__seek__closure_t> (this, __tame_offset, __tame_cb);     __cls_r->collect_join_groups ();     __cls = __cls_r;     __cls_g = __cls_r;     __cls->set_method_pointer (&aioh::seek);   } else {     __cls =     reinterpret_cast<aioh__seek__closure_t *> (static_cast<closure_t *> (__cls_g));     __cls_r = mkref (__cls);   }    int &offset = __cls->_args.offset;    cbs &cb = __cls->_args.cb;    use_reference (offset);     use_reference (cb);    switch (__cls->jumpto ()) {   default:     break;   }
# 2024 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"

    pos = offset;
    (*cb)(NULL);
# 2027 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
  return;
# 2027 "/Users/dga/Documents/dot/src/trunk/gtcd/xfer/xferPlugin_xdisk.T"
}

/* TODO
1. aiod->finalize in destructor

2. the deal with updatetime right now statcache gets update from list cache
i could use stat errors to invalidate caches
update time business

3. tamed version for perform_hash that doesnt compile

//   while (1) {
	
// 	BLOCK {
// 	    fdcb(in_fd, selread, @());
// 	}
	
//        	rc = io_in.input(in_fd, CHUNK_SIZE);
// 	if (rc == -1) {
// 	    (*cb)("Could not read from input file descriptor\n");
// 	    return;
// 	}
// 	else if (rc == 0) {
// 	    fdcb(in_fd, selread, NULL);
// 	    break;
// 	}
// 	else {
// 	    nbytes = io_in.resid();
// 	    rc = io_in.copyout(inbuf, nbytes);
// 	    assert(rc == nbytes);
// 	    io_in.rembytes(rc);

	    
// 	    BLOCK {
// 		m->cp->put_object(id, inbuf, nbytes, @(err));
// 	    }
// 	}
//     }

//     BLOCK {
// 	m->cp->commit_object(id, @(err, oid));
//     }

4. list and stat on a file and not on dir

5. when chunks are shared across files - dicey

6. update_table --> for already existing descriptors if
xdisk hints are repeated, then they are inserted again

broekn BFS--> not putting in cache ops
*/
